/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.notificacoes;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoClasse;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoGrupo;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoNivel;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoStatus;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoStatusProcesso;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoSubClasse;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.NotificacaoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Cadastros das Notifica\u00e7\u00f5es", name="notifica\u00e7\u00f5es")
@RequestMapping(value={"/api/notificacoes/cadastros"})
public class CadastrosNotificacoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosNotificacoesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private NotificacaoService notificacaoService;

    @GetMapping(value={"/{empresa}/grupos"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<NotificacaoGrupo>> findGrupos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findGrupos()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List grupos = this.notificacaoService.findGrupos(emp.getId(), search);
            return ResponseEntity.ok().body((Object)grupos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findGrupos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/grupos/{idGrupo}"})
    @Operation(summary="Busca o grupo de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoGrupo> getGrupoById(@PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getGrupoById({},{})", (Object)usuario.getLogin(), (Object)idGrupo);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getGrupoById(idGrupo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/grupos"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoGrupo> saveGrupo(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoGrupo grupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoGrupo grupoDB = this.notificacaoService.saveGrupo(grupo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)grupoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/grupo/{idGrupo}"})
    @Operation(summary="Deleta o grupo de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteGrupo(@PathVariable(name="idGrupo") Integer idGrupo) throws BusinessException {
        try {
            logger.debug("deleteGrupo({})", (Object)idGrupo);
            return new ResponseEntity((Object)this.notificacaoService.deleteGrupo(idGrupo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/niveis"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<NotificacaoNivel>> findNiveis(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findNiveis()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List niveis = this.notificacaoService.findNiveis(emp.getId(), search);
            return ResponseEntity.ok().body((Object)niveis);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findNiveis", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/niveis/{idNivel}"})
    @Operation(summary="Busca o n\u00edvel de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoNivel> getNivelById(@PathVariable(name="idNivel") Integer idNivel, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getNivelById({},{})", (Object)usuario.getLogin(), (Object)idNivel);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getNivelById(idNivel));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getNivelById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/niveis"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoNivel> saveNivel(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoNivel nivel, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoNivel nivelDB = this.notificacaoService.saveNivel(nivel, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)nivelDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/nivel/{idNivel}"})
    @Operation(summary="Deleta o n\u00edvel de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteNivel(@PathVariable(name="idNivel") Integer idNivel) throws BusinessException {
        try {
            logger.debug("deleteNivel({})", (Object)idNivel);
            return new ResponseEntity((Object)this.notificacaoService.deleteNivel(idNivel), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteNivel", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/status"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<NotificacaoStatus>> findStatus(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findStatus()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List status = this.notificacaoService.findStatus(emp.getId(), search);
            return ResponseEntity.ok().body((Object)status);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findGrupos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/status/{idStatus}"})
    @Operation(summary="Busca o status de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoStatus> getStatusById(@PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getStatusById({},{})", (Object)usuario.getLogin(), (Object)idStatus);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getStatusById(idStatus));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/status"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoStatus> saveStatus(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoStatus status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoStatus statusDB = this.notificacaoService.saveStatus(status, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)statusDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/status/{idStatus}"})
    @Operation(summary="Deleta o status de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteStatus(@PathVariable(name="idStatus") Integer idStatus) throws BusinessException {
        try {
            logger.debug("deleteCiclo({})", (Object)idStatus);
            return new ResponseEntity((Object)this.notificacaoService.deleteStatus(idStatus), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/classes"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<NotificacaoClasse>> findClasses(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findClasses()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List classes = this.notificacaoService.findNotificacoesClasse(emp.getId(), search);
            return ResponseEntity.ok().body((Object)classes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findClasses", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/classes/{idClasse}"})
    @Operation(summary="Busca a classe de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoClasse> getClasseById(@PathVariable(name="idClasse") Integer idClasse, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getClasseById({},{})", (Object)usuario.getLogin(), (Object)idClasse);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getNotificacaoClasseById(idClasse));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getClasseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/classes"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoClasse> saveClasse(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoClasse classe, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoClasse classeDB = this.notificacaoService.saveNotificacaoClasse(classe, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)classeDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/classe/{idClasse}"})
    @Operation(summary="Deleta a classe de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteClasse(@PathVariable(name="idClasse") Integer idClasse) throws BusinessException {
        try {
            logger.debug("deleteClasse({})", (Object)idClasse);
            return new ResponseEntity((Object)this.notificacaoService.deleteNotificacaoClasse(idClasse), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/subClasses"})
    @Operation(summary="Busca as Subclasses de Notifica\u00e7\u00e3o.")
    public ResponseEntity<List<NotificacaoSubClasse>> findSubClasses(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findSubClasses()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List subclasses = this.notificacaoService.findNotificacoesSubclasse(emp.getId(), search);
            return ResponseEntity.ok().body((Object)subclasses);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findSubClasses", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/subClasses/{idSubClasse}"})
    @Operation(summary="Busca a sub-classe de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoSubClasse> getSubClasseById(@PathVariable(name="idSubClasse") Integer idSubClasse, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getSubClasseById({},{})", (Object)usuario.getLogin(), (Object)idSubClasse);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getNotificacaoSubclasseById(idSubClasse));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getSubClasseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/subClasses"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoSubClasse> saveSubClasse(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoSubClasse subClasse, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoSubClasse subClasseDB = this.notificacaoService.saveNotificacaoSubclasse(subClasse, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)subClasseDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/subClasse/{idSubClasse}"})
    @Operation(summary="Deleta a sub-classe de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteSubclasse(@PathVariable(name="idSubClasse") Integer idSubClasse) throws BusinessException {
        try {
            logger.debug("deleteCiclo({})", (Object)idSubClasse);
            return new ResponseEntity((Object)this.notificacaoService.deleteNotificacaoSubclasse(idSubClasse), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/statusDoProcesso"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<NotificacaoStatusProcesso>> findStatusDoProcesso(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findStatusDoProcesso()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (empresa == null) {
                throw new BusinessException("Empresa n\u00e3o foi informada.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException(String.format("Empresa '%s' n\u00e3o foi encontrada.", empresa));
            }
            List statusdoprocesso = this.notificacaoService.findNotificacoesStatusProcesso(emp.getId(), search);
            return ResponseEntity.ok().body((Object)statusdoprocesso);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusDoProcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/statusDoProcesso/{idStatusDoProcesso}"})
    @Operation(summary="Busca o status do processo de notifica\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<NotificacaoStatusProcesso> getStatusDoProcessoById(@PathVariable(name="idStatusDoProcesso") Integer idStatusDoProcesso, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getStatusDoProcessoById({},{})", (Object)usuario.getLogin(), (Object)idStatusDoProcesso);
            return ResponseEntity.ok().body((Object)this.notificacaoService.getNotificacaoStatusProcessoById(idStatusDoProcesso));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusDoProcessoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/statusDoProcesso"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<NotificacaoStatusProcesso> saveStatusDoProcesso(@PathVariable(name="empresa") String empresa, @RequestBody NotificacaoStatusProcesso statusDoProcesso, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            NotificacaoStatusProcesso statusDoProcessoDB = this.notificacaoService.saveNotificacaoStatusProcesso(statusDoProcesso, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)statusDoProcessoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/statusDoProcesso/{idStatusDoProcesso}"})
    @Operation(summary="Deleta o status do processo de notifica\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteStatusProcesso(@PathVariable(name="idStatusDoProcesso") Integer idStatusDoProcesso) throws BusinessException {
        try {
            logger.debug("deleteCiclo({})", (Object)idStatusDoProcesso);
            return new ResponseEntity((Object)this.notificacaoService.deleteNotificacaoStatusProcesso(idStatusDoProcesso), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

