/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.correspondencias;

import br.com.oti.gesconsys.beans.correspondencia.ModeloAssinatura;
import br.com.oti.gesconsys.beans.correspondencia.ModeloMinuta;
import br.com.oti.gesconsys.beans.correspondencia.ModeloNumeracao;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para cadastros correspond\u00eancias", name="correspondencias")
@RequestMapping(value={"/api/cadastros/crp"})
public class CadastrosCorrespondenciasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosCorrespondenciasRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/modelosMinuta"})
    @Operation(summary="Busca os modelos de minuta conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<List<ModeloMinuta>> findModelosMinuta(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="idArea", required=false) Integer idArea, @RequestParam(name="idEntidade", required=false) Integer idEntidade) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("API findModelosMinuta (empresa={}, idArea={} idEntidade={})...", new Object[]{empresa, idArea, idEntidade});
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List minutas = this.correspondenciaService.findModelosMinuta(emp.getId(), idArea, idEntidade);
            return new ResponseEntity((Object)minutas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findModelosMinuta.findModelosMinuta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findModelosMinuta", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/modelosMinuta"})
    @Operation(summary="Salva os modelos de minuta de correspond\u00eancia")
    public ResponseEntity<ModeloMinuta> saveModeloMinuta(@PathVariable(name="empresa") String empresa, @RequestBody ModeloMinuta modelos, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveModeloMinuta({}, {})", (Object)empresa, (Object)modelos);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.correspondenciaService.saveModeloMinuta(modelos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveModeloMinuta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idModeloMinuta}/modelosMinuta"})
    @Operation(summary="Busca o modelo de minuta conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<ModeloMinuta> getModeloMinutaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloMinuta") Integer idModeloMinuta) {
        logger.debug("API getModeloMinutaById (idModeloMinuta={}, {}", (Object)empresa, (Object)idModeloMinuta);
        try {
            ModeloMinuta modelos = this.correspondenciaService.getModeloById(idModeloMinuta);
            return new ResponseEntity((Object)modelos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getModeloMinutaById.getModeloMinutaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getModeloMinutaById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idModeloMinuta}/modelosMinuta"})
    @Operation(summary="Deleta o modelo de minuta de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteModeloMinuta(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloMinuta") Integer idModeloMinuta, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteModeloMinuta({}, {})", (Object)empresa, (Object)idModeloMinuta);
            this.correspondenciaService.deleteModeloMinuta(idModeloMinuta);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteModeloMinuta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/modelosAssinatura"})
    @Operation(summary="Busca os modelos de assinatura conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<List<ModeloAssinatura>> findModeloAssinatura(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("API findModeloAssinatura (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List modelos = this.correspondenciaService.findModelosAssinatura(emp.getId());
            return new ResponseEntity((Object)modelos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findModeloAssinatura.findModeloAssinatura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findModeloAssinatura", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/modelosAssinatura"})
    @Operation(summary="Salva os modelos de assinatura de correspond\u00eancia")
    public ResponseEntity<ModeloAssinatura> saveModeloAssinatura(@PathVariable(name="empresa") String empresa, @RequestBody ModeloAssinatura modelos, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveModeloAssinatura({}, {})", (Object)empresa, (Object)modelos);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.correspondenciaService.saveModeloAssinatura(modelos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveModeloAssinatura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idModeloAssinatura}/modelosAssinatura"})
    @Operation(summary="Busca o modelo de assinatura conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<ModeloAssinatura> getModeloAssinaturaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloAssinatura") Integer idModeloAssinatura) {
        logger.debug("API getModeloAssinaturaById (idModeloAssinatura={}, {}", (Object)empresa, (Object)idModeloAssinatura);
        try {
            ModeloAssinatura modelos = this.correspondenciaService.getModeloAssinaturaById(idModeloAssinatura);
            return new ResponseEntity((Object)modelos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getModeloAssinaturaById.getModeloAssinaturaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getModeloAssinaturaById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idModeloAssinatura}/modelosAssinatura"})
    @Operation(summary="Deleta o modelo de assinatura de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteModeloAssinatura(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloAssinatura") Integer idModeloAssinatura, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteModeloAssinatura({}, {})", (Object)empresa, (Object)idModeloAssinatura);
            this.correspondenciaService.deleteModeloAssinatura(idModeloAssinatura);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteModeloAssinatura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/modelosNumeracao"})
    @Operation(summary="Busca os modelos de numera\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<List<ModeloNumeracao>> findModelosNumeracao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="idArea", required=false) Integer idArea, @RequestParam(name="idEntidade", required=false) Integer idEntidade) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("{} - API findModelosNumeracao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List modelos = this.correspondenciaService.findModelosNumeracao(emp.getId(), idArea, idEntidade);
            return new ResponseEntity((Object)modelos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findModelosNumeracao.findModelosNumeracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findModelosNumeracao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/modelosNumeracao"})
    @Operation(summary="Salva os modelos de numera\u00e7\u00e3o de correspond\u00eancia")
    public ResponseEntity<ModeloNumeracao> saveModelosNumeracao(@PathVariable(name="empresa") String empresa, @RequestBody ModeloNumeracao modelos, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveModelosNumeracao({}, {})", new Object[]{usuario, empresa, modelos});
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.correspondenciaService.saveModeloNumeracao(modelos, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveModelosNumeracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idModeloNumeracao}/modelosNumeracao"})
    @Operation(summary="Busca o modelo de numera\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<ModeloNumeracao> getModeloNumeracaoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloNumeracao") Integer idModeloNumeracao) {
        logger.debug("API getModeloNumeracaoById (idModeloNumeracao={}, {}", (Object)empresa, (Object)idModeloNumeracao);
        try {
            ModeloNumeracao modelos = this.correspondenciaService.getModeloNumeracaoById(idModeloNumeracao);
            return new ResponseEntity((Object)modelos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getModeloAssinaturaById.getModeloNumeracaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getModeloNumeracaoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idModeloNumeracao}/modelosNumeracao"})
    @Operation(summary="Deleta o modelo de numera\u00e7\u00e3o de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteModeloNumeracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModeloNumeracao") Integer idModeloNumeracao, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteModeloNumeracao({}, {})", (Object)empresa, (Object)idModeloNumeracao);
            this.correspondenciaService.deleteModeloNumeracao(idModeloNumeracao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteModeloNumeracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/{idObrigacao}/obrigacoes/{sequencia}"})
    @Operation(summary="Deleta a refer\u00eancia de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteObrigacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idObrigacao") Integer idObrigacao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteObrigacao({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            this.correspondenciaService.deleteObrigacao(emp.getId(), idCorrespondencia, idObrigacao, sequencia, usr.getId());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

