/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.core;

import br.com.oti.gesconsys.beans.core.BloqueioModulo;
import br.com.oti.gesconsys.beans.core.DicionarioPropertyVO;
import br.com.oti.gesconsys.beans.core.DicionarioVO;
import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.IntegracaoExterna;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services Gerais, relacionados as estruturas base do sistema", name="core")
@RequestMapping(value={"/api/core"})
public class CoreRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CoreRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/dicionarios/{modulo}"})
    @Operation(summary="Retorna o dicion\u00e1rio do m\u00f3dulo informado")
    public ResponseEntity<List<DicionarioVO>> findDicionarios(@PathVariable(name="modulo") String modulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findDicionarios({},{})", (Object)usuario.getLogin(), (Object)modulo);
            TipoModulo tipoModulo = TipoModulo.fromSigla((String)modulo);
            List dicionario = this.coreService.loadDicionario(tipoModulo);
            return ResponseEntity.ok().body((Object)dicionario);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDicionarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/dicionarios/{modulo}/{entidade}"})
    @Operation(summary="Retorna o dicion\u00e1rio do m\u00f3dulo informado")
    public ResponseEntity<Collection<DicionarioPropertyVO>> findEntidadeDicionario(@PathVariable(name="modulo") String modulo, @PathVariable(name="entidade") String entidade, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findEntidadeDicionario({},{}, {})", new Object[]{usuario.getLogin(), modulo, entidade});
            if (entidade == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Entidade n\u00e3o foi informada.");
            }
            TipoModulo tipoModulo = TipoModulo.fromSigla((String)modulo);
            Map dicionario = this.coreService.loadEntidadeDicionario(tipoModulo, entidade);
            if (dicionario == null || dicionario.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("N\u00e3o h\u00e1 dicion\u00e1rio para o m\u00f3dulo '%s' e entidade '%s'", modulo, entidade));
            }
            return ResponseEntity.ok().body(dicionario.values());
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDicionarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/refCodes/{empresa}"})
    public ResponseEntity<List<RefCode>> findRefCodes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("findRefCodes({})", (Object)empresa);
        try {
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            List refCodesAll = this.coreService.findRefCodes(empresa, searchTxt);
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            ArrayList<RefCode> refCodes = new ArrayList<RefCode>();
            for (RefCode refBase : refCodesAll) {
                try {
                    TipoRefCode tipoRef = TipoRefCode.fromString((String)refBase.getRefName());
                    if (tipoRef.getRestrito().booleanValue()) {
                        if (!perfil.isAdministradorFlag().booleanValue() && request.getHeader("X-FROM-MICROSERVICE") == null) {
                            continue;
                        }
                    } else {
                        logger.debug("Usuario Admin, LIBERANDO informa\u00e7\u00f5es Restritas...");
                    }
                }
                catch (IllegalArgumentException iaeExc) {
                    continue;
                }
                if (refBase.getRefName().toLowerCase().contains("password") || refBase.getRefName().toLowerCase().contains("senha")) continue;
                refCodes.add(refBase);
            }
            return new ResponseEntity(refCodes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRefCodes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/refCodes/globals"})
    public ResponseEntity<List<RefCode>> findAllRefCodes(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("findAllRefCodes()");
        try {
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            List refCodesAll = this.coreService.findGlobalRefCodes(searchTxt);
            Boolean admin = perfil.isAdministradorFlag();
            if (!admin.booleanValue()) {
                for (RefCode ref : refCodesAll) {
                    if (!ref.getRefName().equals(TipoRefCode.SCHEDULER_USUARIO_API.getRefName()) || ref.getRefValue() == null || !ref.getRefValue().equalsIgnoreCase(user.getLogin())) continue;
                    admin = true;
                    break;
                }
            }
            ArrayList<RefCode> refCodes = new ArrayList<RefCode>();
            for (RefCode refBase : refCodesAll) {
                try {
                    TipoRefCode tipoRef = TipoRefCode.fromString((String)refBase.getRefName());
                    if (tipoRef.getRestrito().booleanValue()) {
                        if (!perfil.isAdministradorFlag().booleanValue() && request.getHeader("X-FROM-MICROSERVICE") == null) {
                            continue;
                        }
                    } else {
                        logger.debug("Usuario Admin, LIBERANDO informa\u00e7\u00f5es Restritas...");
                    }
                }
                catch (IllegalArgumentException iaeExc) {
                    continue;
                }
                if (refBase.getRefName().toLowerCase().contains("password") || refBase.getRefName().toLowerCase().contains("senha")) continue;
                refCodes.add(refBase);
            }
            return new ResponseEntity(refCodes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAllRefCodes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/refCodes/{empresa}"})
    @Operation(summary="Persiste os dados da RefCode enviado")
    public ResponseEntity<RefCode> saveRefCode(@PathVariable(name="empresa") String empresa, @RequestBody RefCode refCode, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            if (refCode.getIdEmpresa() == null) {
                Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
                refCode.setIdEmpresa(emp.getId());
            }
            return new ResponseEntity((Object)this.coreService.saveRefCode(refCode.getIdEmpresa(), refCode.getRefName(), refCode.getValue()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRefCode", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/refCodes/{empresa}/all"})
    @Operation(summary="Persiste os dados da RefCode enviado")
    public ResponseEntity<List<RefCode>> saveRefCodes(@PathVariable(name="empresa") String empresa, @RequestBody List<RefCode> refCodes, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.error("{} - saveRefCodes()", (Object)usuario.getLogin());
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            refCodes = this.coreService.saveRefCodes(emp.getId(), refCodes);
            return new ResponseEntity((Object)refCodes, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRefCodes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/logomarcas/upload"})
    @ResponseBody
    public ResponseEntity<String> uploadLogomarca(@RequestParam(name="file") MultipartFile file, HttpServletRequest request) {
        String defPath;
        logger.debug("Iniciando Upload...");
        String empresa = null;
        Map formData = request.getParameterMap();
        if (formData.containsKey("empresa")) {
            empresa = ((String[])formData.get("empresa"))[0];
        }
        if ((defPath = this.coreService.getRepoPath(empresa)) == null || defPath.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Reposit\u00f3rio n\u00e3o foi informado.");
        }
        Path logoPath = Paths.get(defPath, empresa, "logomarca");
        File logoPathDir = new File(logoPath.toString());
        if (!logoPathDir.exists() && !logoPathDir.mkdirs()) {
            return null;
        }
        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        try {
            InputStream in = file.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            this.writeFile(bytes, Paths.get(defPath, empresa, "logomarca", "logomarca." + extension).toString());
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
            return null;
        }
        return new ResponseEntity((Object)"OK", (HttpStatusCode)HttpStatus.CREATED);
    }

    private void writeFile(byte[] content, String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileOutputStream fop = new FileOutputStream(file);){
            fop.write(content);
            fop.flush();
            fop.close();
        }
    }

    @GetMapping(value={"/refCodes/empresaAutenticacao"})
    public ResponseEntity<Object> getEmpresaAutenticacao(HttpServletRequest request) {
        logger.debug("getEmpresaAutenticacao");
        try {
            Object emp = null;
            return new ResponseEntity(this.coreService.getRefValueByName(emp != null ? emp.getId() : null, TipoRefCode.INFRA_EMPRESA_AUTENTICACAO), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEmpresaAutenticacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/refCodes/gruposRegistro"})
    @Operation(summary="Retorna os grupos do usu\u00e1rio, em formato de Lista Par chave=valor")
    public ResponseEntity<List<KeyValue>> getGrupoRegistro(HttpServletRequest request) {
        logger.debug("getGrupoRegistro");
        try {
            ArrayList<KeyValue> gruposLst = new ArrayList<KeyValue>();
            String gruposTxt = (String)this.coreService.getRefValueByName(null, TipoRefCode.GERAL_PERFIL_PADRAO_USUARIO);
            if (gruposTxt != null) {
                String[] gruposRaw;
                for (String grupo : gruposRaw = gruposTxt.split(";")) {
                    String[] keyVal = grupo.split("=");
                    if (keyVal == null || keyVal.length != 2) continue;
                    gruposLst.add(new KeyValue((Object)keyVal[0], keyVal[1]));
                }
            }
            return new ResponseEntity(gruposLst, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoRegistro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/bloqueios/{empresa}/{idModulo}"})
    @Operation(summary="Retorna os bloqueios do m\u00f3dulo informado")
    public ResponseEntity<BloqueioModulo> getBloqueio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModulo") Integer idModulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getBloqueio({},{})", (Object)usuario.getLogin(), (Object)idModulo);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            BloqueioModulo bloqueio = this.coreService.getBloqueioById(emp.getId(), idModulo);
            return ResponseEntity.ok().body((Object)bloqueio);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getBloqueio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/bloqueios/{empresa}"})
    public ResponseEntity<BloqueioModulo> registerBloqueio(@RequestBody BloqueioModulo bloqueio, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.coreService.saveBloqueio(bloqueio, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveBloqueio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/bloqueios/{empresa}/{idModulo}/{sessionId}"})
    public ResponseEntity<BloqueioModulo> updateBloqueio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModulo") Integer idModulo, @PathVariable(name="sessionId") String sessionId, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.coreService.updateBloqueio(emp.getId(), idModulo, sessionId), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveBloqueio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/bloqueios/{empresa}/{idModulo}"})
    public ResponseEntity<Boolean> deleteBloqueio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idModulo") Integer idModulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.coreService.deleteBloqueio(emp.getId(), idModulo), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveBloqueio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/integracoes/{empresa}/{modulo}/{apiIntegracao}"})
    @Operation(summary="Retorna os bloqueios do m\u00f3dulo informado")
    public ResponseEntity<List<IntegracaoExterna>> findIntegracoesExternasApi(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findIntegracoesExternasApi({},{})", (Object)usuario.getLogin(), (Object)modulo);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List integracoes = this.coreService.findIntegracoesExternas(emp.getId(), TipoModulo.fromSigla((String)modulo), TipoRefCode.API_INTEGRACAO_EXTERNA);
            return ResponseEntity.ok().body((Object)integracoes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findIntegracoesExternasApi", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/modulos/{empresa}"})
    @Operation(summary="Retorna os m\u00f3dulos ativos da empresa")
    public List<String> findModulosAtivos(@PathVariable String empresa) {
        ArrayList<String> modulosAtivos = new ArrayList<String>();
        String rawModulos = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_MODULOS_ATIVOS);
        if (rawModulos != null && !rawModulos.isEmpty()) {
            for (String rawMod : rawModulos.split(";")) {
                TipoModulo modulo = TipoModulo.fromSigla((String)rawMod);
                if (modulo == null) continue;
                modulosAtivos.add(modulo.getSigla());
            }
        }
        return modulosAtivos;
    }
}

