/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.geral.Entidade;
import br.com.oti.gesconsys.beans.relacoes.RegistroInformacao;
import br.com.oti.gesconsys.beans.relacoes.RegistroInformacaoAnexo;
import br.com.oti.gesconsys.beans.relacoes.RegistroInformacaoParticipante;
import br.com.oti.gesconsys.beans.relacoes.RegistroReuniao;
import br.com.oti.gesconsys.beans.relacoes.RegistroReuniaoAnexo;
import br.com.oti.gesconsys.beans.relacoes.RegistroReuniaoPK;
import br.com.oti.gesconsys.beans.relacoes.RegistroReuniaoParticipante;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.RelacaoInstitucionalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Rela\u00e7\u00f5es Institucionais", name="relacoes-institucionais")
@RequestMapping(value={"/api/relacoesInstitucionais"})
public class RelacoesInstitucionaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RelacoesInstitucionaisRestServices.class);
    private static DateTimeFormatter sdfDataReq = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelacaoInstitucionalService relacaoInstitucionalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/reunioes/{empresa}"})
    @Operation(summary="Lista as Reuni\u00f5es Agendadas/Registradas, de acordo com os filtros (datInicial, datFinal)")
    public ResponseEntity<List<RegistroReuniao>> searchReunioes(@PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="empresas", required=false) List<Integer> empresas, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findReunioes (empresa={},datInicial={},datFinal={})...", new Object[]{empresa, request.getParameter("datInicial"), request.getParameter("datFinal")});
        LocalDate datInicial = null;
        LocalDate datFinal = null;
        ArrayList<Integer> entidades = null;
        try {
            Integer idResponsavel;
            Integer status;
            Integer idArea;
            List reunioes;
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (empresas == null || empresas.isEmpty()) {
                empresas = new ArrayList<Integer>();
            }
            empresas.add(emp.getId());
            String parmVal = request.getParameter("datInicial");
            if (parmVal != null) {
                datInicial = LocalDate.parse(parmVal, sdfDataReq);
            }
            if ((parmVal = request.getParameter("datFinal")) != null) {
                datFinal = LocalDate.parse(parmVal, sdfDataReq);
            }
            if ((parmVal = request.getParameter("entidades")) != null && !parmVal.isEmpty()) {
                entidades = new ArrayList<Integer>();
                for (String entidade : parmVal.split(",")) {
                    entidades.add(Integer.valueOf(entidade.trim()));
                }
            }
            if (search == null || search.isEmpty()) {
                search = null;
            }
            if ((reunioes = this.relacaoInstitucionalService.findRegistrosReunioes(search, empresas, idArea = null, entidades, status = null, datInicial, datFinal, idResponsavel = null)) != null) {
                logger.debug("reunioes.size={}", (Object)reunioes.size());
                for (RegistroReuniao reu : reunioes) {
                    Usuario usrAgenda;
                    Entidade entidade;
                    EmpresaArea area = reu.getArea();
                    if (area != null) {
                        area.setResponsavel(null);
                        area.setSubstituto(null);
                        area.setIdUsuarioUpd(null);
                        area.setIdUsuarioIns(null);
                        area.setDatHorCadastro(null);
                        area.setDatHorAlteracao(null);
                    }
                    reu.setEmpresa(null);
                    reu.setIdUsuarioUpd(null);
                    reu.setDatHorCadastro(null);
                    reu.setIdUsuarioIns(null);
                    reu.setDatHorAlteracao(null);
                    reu.setIdUsuarioUpd(null);
                    Usuario usrReuni = reu.getUsuario();
                    if (usrReuni != null) {
                        usrReuni.setGrupos(null);
                        usrReuni.setDatHorCadastro(null);
                        usrReuni.setIdUsuarioIns(null);
                        usrReuni.setIdUsuarioUpd(null);
                        usrReuni.setDatHorAlteracao(null);
                        usrReuni.setDatHorUltimoLogin(null);
                        usrReuni.setSessionUUID(null);
                    }
                    if ((entidade = reu.getEntidade()) != null) {
                        entidade.setDatHorAlteracao(null);
                        entidade.setIdUsuarioIns(null);
                        entidade.setDatHorCadastro(null);
                        entidade.setIdUsuarioUpd(null);
                    }
                    if ((usrAgenda = reu.getUsuarioAgendamento()) == null) continue;
                    usrAgenda.setGrupos(null);
                    usrAgenda.setDatHorCadastro(null);
                    usrAgenda.setIdUsuarioIns(null);
                    usrAgenda.setIdUsuarioUpd(null);
                    usrAgenda.setDatHorAlteracao(null);
                    usrAgenda.setDatHorUltimoLogin(null);
                    usrAgenda.setSessionUUID(null);
                }
            }
            return new ResponseEntity((Object)reunioes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.searchReunioes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.searchReunioes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/reunioes/{empresa}/{idRegistro}/anexos"})
    @Operation(summary="Lista os anexos do registro de reuni\u00e3o")
    public ResponseEntity<List<RegistroReuniaoAnexo>> findAnexos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={}, idRegistro={})...", (Object)empresa, (Object)idRegistro);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List anexos = this.relacaoInstitucionalService.findAnexosReuniao(emp.getId(), idRegistro);
            for (RegistroReuniaoAnexo anx : anexos) {
                anx.setIdUsuarioIns(null);
                anx.setDatHorCadastro(null);
                anx.getAnexo().setUsuario(null);
                anx.getAnexo().setDatHorUpload(null);
                anx.getAnexo().setErroGed(null);
                anx.getAnexo().setNroErrosGed(null);
            }
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findReunioes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findReunioes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/reunioes/{idRegistro}"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva os anexos do registro de reuni\u00e3o")
    public ResponseEntity<List<RegistroReuniaoAnexo>> saveAnexosReuniao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            List anexos = (List)mapper.readValue(((String[])formData.get("anexos"))[0], (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("saveAnexosReuniao.count ({}))", (Object)anexos);
            if (anexos != null) {
                for (RegistroReuniaoAnexo anexo : anexos) {
                    this.internalSaveAnexoReuniao(empresaDB.getId(), idRegistro, anexo, usuario.getLogin(), request);
                }
            }
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveAnexosReuniao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JsmExc.saveAnesaveAnexosReuniaoxosPleito", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    private RegistroReuniaoAnexo internalSaveAnexoReuniao(Integer idEmpresa, Integer idRegistro, RegistroReuniaoAnexo anexo, String usuario, HttpServletRequest request) {
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario);
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        Map filesMap = multipartReq.getFileMap();
        RegistroReuniaoAnexo anexoDB = anexo;
        if (filesMap != null && !filesMap.isEmpty()) {
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName={}", (Object)fileName);
                    if (anexo.getAnexo() != null && !fileName.equals(anexo.getAnexo().getNome())) continue;
                    Anexo anexoGed = this.gedService.createAnexo(idEmpresa, TipoModulo.RELACOES_INSTITUCIONAIS.getSigla(), "Reuni\u00f5es", fileName, "Anexos", null, fileReq, user.getId(), LocalDateTime.now());
                    anexo.getId().setIdEmpresa(idEmpresa);
                    anexo.getId().setIdRegistro(idRegistro);
                    anexo.setIdAnexo(anexoGed.getId().getIdAnexo());
                    anexo.setAnexo(anexoGed);
                    anexoDB = this.relacaoInstitucionalService.saveAnexoReuniao(anexo, user.getId());
                }
            }
        }
        return anexoDB;
    }

    @DeleteMapping(value={"/reunioes/{empresa}/{idRegistro}/{sequencia}/anexos"})
    @Operation(summary="Exclui o anexo da reuni\u00e3o Agendada/Realizada")
    public ResponseEntity<Boolean> deleteReuniaoAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteReuniao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.relacaoInstitucionalService.deleteAnexoReuniao(emp.getId(), idRegistro, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteReuniaoAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteReuniaoAnexo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/informacoes/{idRegistro}"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva os anexos do registro de reuni\u00e3o")
    public ResponseEntity<List<RegistroInformacaoAnexo>> saveAnexosInformacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            List anexos = (List)mapper.readValue(((String[])formData.get("anexos"))[0], (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("saveAnexosInformacao.count ({}))", (Object)anexos);
            if (anexos != null) {
                for (RegistroInformacaoAnexo anexo : anexos) {
                    this.internalSaveAnexoInformacao(empresaDB.getId(), idRegistro, anexo, usuario.getLogin(), request);
                }
            }
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveAnexosInformacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JsmExc.saveAnexosInformacao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    private RegistroInformacaoAnexo internalSaveAnexoInformacao(Integer idEmpresa, Integer idInformacao, RegistroInformacaoAnexo anexo, String usuario, HttpServletRequest request) {
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        Map filesMap = multipartReq.getFileMap();
        RegistroInformacaoAnexo anexoDB = anexo;
        if (filesMap != null && !filesMap.isEmpty()) {
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName={}", (Object)fileName);
                    if (anexo.getAnexo() != null && !fileName.equals(anexo.getAnexo().getNome())) continue;
                    Anexo anexoGed = this.gedService.createAnexo(idEmpresa, TipoModulo.RELACOES_INSTITUCIONAIS.getSigla(), "Informa\u00e7\u00f5es", fileName, "Anexos", null, fileReq, user.getId(), LocalDateTime.now());
                    anexo.setIdEmpresa(idEmpresa);
                    anexo.getId().setIdInformacao(idInformacao);
                    anexo.setIdAnexo(anexoGed.getId().getIdAnexo());
                    anexo.setAnexo(anexoGed);
                    anexoDB = this.relacaoInstitucionalService.saveAnexoInformacao(anexo, user.getId());
                }
            }
        }
        return anexoDB;
    }

    @DeleteMapping(value={"/informacoes/{idInformacao}/{sequencia}/anexos"})
    @Operation(summary="Exclui o anexo da reuni\u00e3o Agendada/Realizada")
    public ResponseEntity<Boolean> deleteInformacaoAnexo(@PathVariable(name="idInformacao") Integer idInformacao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteInformacaoAnexo ()...");
        try {
            this.relacaoInstitucionalService.deleteAnexoInformacao(idInformacao, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteInformacaoAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteInformacaoAnexo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/reunioes/{empresa}/{idRegistro}"})
    @Operation(summary="Carrega os dados da Reuni\u00e3o Agendada/Realizada")
    public ResponseEntity<RegistroReuniao> getReuniao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getReuniao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            RegistroReuniao reuniao = this.relacaoInstitucionalService.getRegistroReuniaoById(emp.getId(), idRegistro);
            return new ResponseEntity((Object)reuniao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getReuniao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getReuniao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/reunioes/{empresa}"})
    @Operation(summary="Registra/Salva a Reuni\u00e3o Agendada/Realizada")
    public ResponseEntity<RegistroReuniao> saveReuniao(@PathVariable(name="empresa") String empresa, @RequestBody RegistroReuniao registro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getReuniao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (registro == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados do registro n\u00e3o foram informados.");
            }
            if (registro.getId() == null) {
                registro.setId(new RegistroReuniaoPK());
            }
            registro.getId().setIdEmpresa(emp.getId());
            RegistroReuniao reuniao = this.relacaoInstitucionalService.saveRegistroReuniao(registro, usuario.getLogin());
            return new ResponseEntity((Object)reuniao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveReuniao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.saveReuniao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/reunioes/{empresa}/{idRegistro}"})
    @Operation(summary="Exclui a Reuni\u00e3o Agendada/Realizada")
    public ResponseEntity<Boolean> deleteReuniao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteReuniao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.relacaoInstitucionalService.deleteRegistroReuniao(emp.getId(), idRegistro);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteReuniao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteReuniao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/informacoes/{empresa}"})
    @Operation(summary="Lista as Informa\u00e7\u00f5es registradas, de acordo com os filtros (datInicial, datFinal)")
    public ResponseEntity<List<RegistroInformacao>> searchInformacoes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API searchInformacoes (empresa={},datInicial={},datFinal={})...", new Object[]{empresa, request.getParameter("datInicial"), request.getParameter("datFinal")});
        LocalDate datInicial = null;
        LocalDate datFinal = null;
        ArrayList<Integer> entidades = null;
        try {
            Integer idResponsavel;
            Integer status;
            Integer idArea;
            String searchContent;
            List informacoes;
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            empresas.add(emp.getId());
            String parmVal = request.getParameter("datInicial");
            if (parmVal != null) {
                datInicial = LocalDate.parse(parmVal, sdfDataReq);
            }
            if ((parmVal = request.getParameter("datFinal")) != null) {
                datFinal = LocalDate.parse(parmVal, sdfDataReq);
            }
            if ((parmVal = request.getParameter("entidades")) != null && !parmVal.isEmpty()) {
                entidades = new ArrayList<Integer>();
                for (String entidade : parmVal.split(",")) {
                    entidades.add(Integer.valueOf(entidade.trim()));
                }
            }
            if ((informacoes = this.relacaoInstitucionalService.findRegistrosInformacoes(searchContent = null, empresas, idArea = null, entidades, status = null, datInicial, datFinal, idResponsavel = null)) != null) {
                logger.debug("informacoes.size={}", (Object)informacoes.size());
                for (RegistroInformacao reu : informacoes) {
                    Entidade entidade;
                    EmpresaArea area = reu.getArea();
                    if (area != null) {
                        area.setResponsavel(null);
                        area.setSubstituto(null);
                        area.setIdUsuarioUpd(null);
                        area.setIdUsuarioIns(null);
                        area.setDatHorCadastro(null);
                        area.setDatHorAlteracao(null);
                    }
                    reu.setEmpresa(null);
                    reu.setIdUsuarioUpd(null);
                    reu.setDatHorCadastro(null);
                    reu.setIdUsuarioIns(null);
                    reu.setDatHorAlteracao(null);
                    reu.setIdUsuarioUpd(null);
                    Usuario usrReuni = reu.getUsuario();
                    if (usrReuni != null) {
                        usrReuni.setGrupos(null);
                        usrReuni.setDatHorCadastro(null);
                        usrReuni.setIdUsuarioIns(null);
                        usrReuni.setIdUsuarioUpd(null);
                        usrReuni.setDatHorAlteracao(null);
                        usrReuni.setDatHorUltimoLogin(null);
                        usrReuni.setSessionUUID(null);
                    }
                    if ((entidade = reu.getEntidade()) == null) continue;
                    entidade.setDatHorAlteracao(null);
                    entidade.setIdUsuarioIns(null);
                    entidade.setDatHorCadastro(null);
                    entidade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)informacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.searchInformacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.searchInformacoes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/informacoes/{empresa}/{idInformacao}/anexos"})
    @Operation(summary="Lista os anexos do registro de informa\u00e7\u00e3o")
    public ResponseEntity<List<RegistroInformacaoAnexo>> findAnexosInformacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idInformacao") Integer idInformacao) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findAnexosInformacao (empresa={}, idRegistro={})...", (Object)empresa, (Object)idInformacao);
        try {
            List anexos = this.relacaoInstitucionalService.findAnexosInformacao(idInformacao);
            for (RegistroInformacaoAnexo anx : anexos) {
                anx.setIdUsuarioIns(null);
                anx.setDatHorCadastro(null);
                anx.getAnexo().setUsuario(null);
                anx.getAnexo().setDatHorUpload(null);
                anx.getAnexo().setErroGed(null);
                anx.getAnexo().setNroErrosGed(null);
            }
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosInformacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findAnexosInformacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/informacoes/{empresa}/{idRegistro}"})
    @Operation(summary="Carrega os dados da Informa\u00e7\u00e3o realizada")
    public ResponseEntity<RegistroInformacao> getInformacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getInformacao (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            RegistroInformacao informacao = this.relacaoInstitucionalService.getRegistroInformacaoById(idRegistro);
            return new ResponseEntity((Object)informacao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getInformacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getInformacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/informacoes/{siglaEmpresa}"})
    @Operation(summary="Registra/Salva a Informa\u00e7\u00e3o realizada")
    public ResponseEntity<RegistroInformacao> saveInformacao(@PathVariable(name="siglaEmpresa") String empresa, @RequestBody RegistroInformacao registro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API saveInformacao(empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (registro == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados do registro n\u00e3o foram informados.");
            }
            registro.setIdEmpresa(emp.getId());
            RegistroInformacao reuniao = this.relacaoInstitucionalService.saveRegistroInformacao(registro, usuario.getLogin());
            return new ResponseEntity((Object)reuniao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveInformacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.saveInformacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/informacoes/{empresa}/{idRegistro}"})
    @Operation(summary="Exclui a Informa\u00e7\u00e3o realizada")
    public ResponseEntity<Boolean> deleteInformacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteInformacao(empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.relacaoInstitucionalService.deleteRegistroInformacao(idRegistro);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteInformacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteInformacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/registros/{idRegistro}/participantes"})
    @Operation(summary="Carrega os dados do registro de participantes.")
    public ResponseEntity<List<RegistroReuniaoParticipante>> findRegistrosParticipantes(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findRegistrosParticipantes (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List registro = this.relacaoInstitucionalService.findParticipantesReuniao(emp.getId(), idRegistro);
            return new ResponseEntity((Object)registro, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRegistrosParticipantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findRegistrosParticipantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/registros/participantes"})
    @Operation(summary="Registra/Salva o registro de participantes realizada")
    public ResponseEntity<RegistroReuniaoParticipante> saveRegistroParticipante(@RequestBody RegistroReuniaoParticipante registro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("API saveRegistroParticipante()");
        try {
            if (registro == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados do registro n\u00e3o foram informados.");
            }
            RegistroReuniaoParticipante reuniao = this.relacaoInstitucionalService.saveParticipanteReuniao(registro, usr.getId());
            return new ResponseEntity((Object)reuniao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRegistroParticipante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.saveRegistroParticipante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/registros/{idRegistro}/{sequencia}/participantes"})
    @Operation(summary="Exclui a Informa\u00e7\u00e3o realizada")
    public ResponseEntity<Boolean> deleteRegistroParticipante(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRegistro") Integer idRegistro, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteRegistroParticipante(empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.relacaoInstitucionalService.deleteParticipanteReuniao(emp.getId(), idRegistro, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRegistroParticipante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteRegistroParticipante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/informacoes/{idRegistro}/participantes"})
    @Operation(summary="Carrega os dados da informa\u00e7\u00e3o de participantes.")
    public ResponseEntity<List<RegistroInformacaoParticipante>> findInformacoesParticipantes(@PathVariable(name="idRegistro") Integer idRegistro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findInformacoesParticipantes ()");
        try {
            List registro = this.relacaoInstitucionalService.findParticipantesInformacao(idRegistro);
            return new ResponseEntity((Object)registro, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findInformacoesParticipantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findInformacoesParticipantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/informacoes/participantes"})
    @Operation(summary="Registra/Salva as informa\u00e7\u00f5es de participantes realizada")
    public ResponseEntity<RegistroInformacaoParticipante> saveInformacaoParticipante(@RequestBody RegistroInformacaoParticipante registro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("API saveInformacaoParticipante()");
        try {
            if (registro == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados do registro n\u00e3o foram informados.");
            }
            RegistroInformacaoParticipante reuniao = this.relacaoInstitucionalService.saveParticipanteInformacao(registro, usr.getId());
            return new ResponseEntity((Object)reuniao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveInformacaoParticipante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.saveInformacaoParticipante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/informacoes/{idRegistro}/{sequencia}/participantes"})
    @Operation(summary="Exclui o registro da informa\u00e7\u00e3o de participante realizada")
    public ResponseEntity<Boolean> deleteInformacaoParticipante(@PathVariable(name="idRegistro") Integer idRegistro, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API deleteRegistroParticipante()");
        try {
            this.relacaoInstitucionalService.deleteParticipanteInformacao(idRegistro, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteInformacaoParticipante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.deleteInformacaoParticipante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

