/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Infra - Ping", name="infra-ping")
@RequestMapping(value={"/api/ping"})
public class PingRestServices {
    private static Logger logger = LoggerFactory.getLogger(PingRestServices.class);

    @GetMapping(produces={"application/json"})
    @Operation(summary="Retorna status do Ping, com a data/hora do servidor em execu\u00e7\u00e3o")
    public ResponseEntity<String> echo() {
        logger.debug("Executando API echo...");
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> serverMap = new HashMap<String, String>();
            DateTimeFormatter dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            serverMap.put("serverTime", dateFmt.format(LocalDateTime.now()));
            String jsonData = mapper.writeValueAsString(serverMap);
            return new ResponseEntity((Object)jsonData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (JsonProcessingException jspExc) {
            logger.error("jspExc", (Object)jspExc.getMessage());
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }
}

