/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.spring.security.CustomAuthenticationProvider;
import br.com.oti.gesconsys.spring.security.CustomRestAuthenticationFailureHandler;
import br.com.oti.gesconsys.spring.security.JWTAuthenticationFilter;
import br.com.oti.gesconsys.spring.security.JwtLoginFilter;
import br.com.oti.gesconsys.spring.security.RestAuthenticationEntryPoint;
import br.com.oti.gesconsys.spring.security.SimpleAuthenticationFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
@ComponentScan(value={"br.com.oti.gesconsys"})
public class SecurityConfig {
    @Autowired
    private AuthenticationSuccessHandler authSuccessHandler;
    @Autowired
    private CustomAuthenticationProvider customAuthProvider;
    @Autowired
    private RestAuthenticationEntryPoint restAuthenticationEntryPoint;
    @Autowired
    private CustomRestAuthenticationFailureHandler restAuthenticationFailureHandler;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @Bean
    AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.customAuthProvider);
    }

    public SimpleAuthenticationFilter authenticationFilter() throws Exception {
        SimpleAuthenticationFilter filter = new SimpleAuthenticationFilter();
        filter.setAuthenticationSuccessHandler(this.authSuccessHandler);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.restAuthenticationFailureHandler);
        return filter;
    }

    private static CorsConfigurationSource corsConfigSource() {
        CorsConfiguration corsConfig = new CorsConfiguration();
        corsConfig.setAllowedOriginPatterns(List.of("*"));
        corsConfig.setAllowedMethods(List.of("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"));
        corsConfig.setAllowedHeaders(List.of("Authorization", "Cache-Control", "Content-Type"));
        corsConfig.setExposedHeaders(List.of("Authorization"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfig);
        return source;
    }

    @Bean
    SecurityFilterChain apiFilterChain(HttpSecurity http) throws Exception {
        String[] allowedList = new String[]{"/api/ping", "/api/assinaturas/**", "/api/downloads/**", "/api/core/refCodes/empresaAutenticacao", "/api/empresas/all", "/api/reset/**", "/api/register/**", "/api/ambiental/analises/**", "/sso/**", "/viewFile/**", "/swagger-resources/**", "/swagger-ui/**", "/swagger-ui.html", "/v3/api-docs/**", "/webjars/**", "/mapsKmlData/**", "/register/**", "/reset/**", "/forwardUrl/**", "/captcha", "/saml/**", "/sso/***", "/login/saml2/sso/**", "/actuator", "/api/racs/exportaPdfExterno/**"};
        http.securityMatcher(new String[]{"/api/**"}).csrf(csrfCfg -> csrfCfg.disable()).cors(corsCfg -> corsCfg.configurationSource(SecurityConfig.corsConfigSource())).addFilterBefore((Filter)this.authenticationFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new JwtLoginFilter(this.authenticationManager((AuthenticationConfiguration)http.getSharedObject(AuthenticationConfiguration.class)), this.cadastroService, this.coreService, this.segurancaService), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new JWTAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).sessionManagement(sessionCfg -> sessionCfg.sessionFixation(sessionFix -> sessionFix.none())).exceptionHandling(excCfg -> excCfg.authenticationEntryPoint((AuthenticationEntryPoint)this.restAuthenticationEntryPoint)).authorizeHttpRequests(httpCfg -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpCfg.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll().requestMatchers(allowedList)).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/mapas/{empresa}/mapsKmlData"})).permitAll().anyRequest()).authenticated());
        return (SecurityFilterChain)http.build();
    }
}

