/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.servlets;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@WebServlet(value={"/mapsKmlData"})
public class MapsKmlDataServlet
extends HttpServlet {
    private static final long serialVersionUID = -4341107674050454439L;
    private static Logger logger = LoggerFactory.getLogger(MapsKmlDataServlet.class);
    @Autowired
    private CoreService coreService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug("Generating KMZ data...");
        String empresa = request.getParameter("empresa");
        String param = request.getParameter("idDemanda");
        Integer idDemanda = null;
        if (param != null) {
            idDemanda = Integer.valueOf(param);
        }
        logger.debug("Downloading MapsData(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        if (empresa == null || empresa.isEmpty()) {
            response.sendError(400, "Empresa n\u00e3o informada.");
            return;
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                response.sendError(400, "Empresa n\u00e3o encontrada.");
                return;
            }
            String kmlData = null;
            response.setContentLength(kmlData.length());
            response.setContentType("application/vnd.google-earth.kml+xml");
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            ServletOutputStream responseStream = response.getOutputStream();
            responseStream.write(kmlData.getBytes());
            responseStream.close();
            responseStream.flush();
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            response.sendError(400, bizExc.getMessage());
        }
    }
}

