/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.services;

import br.com.oti.gesconsys.beans.geo.MapaCoordenada;
import br.com.oti.gesconsys.beans.geo.MapaCoordenadaItem;
import br.com.oti.gesconsys.beans.geo.MapaCoordenadaItemPK;
import br.com.oti.gesconsys.beans.geo.MapaCoordenadaPK;
import br.com.oti.gesconsys.business.dao.geo.MapaCoordenadaDAO;
import br.com.oti.gesconsys.business.dao.geo.MapaCoordenadaItemDAO;
import br.com.oti.gesconsys.services.MapasService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Service
public class MapasServiceImpl
implements MapasService {
    private static Logger logger = LoggerFactory.getLogger(MapasService.class);
    @Autowired
    private MapaCoordenadaDAO mapaCoordenadaDAO;
    @Autowired
    private MapaCoordenadaItemDAO mapaCoordenadaItemDAO;

    public MapaCoordenada createKmlMap(String extensaoDoArquivo, String nome, String titulo, Integer idUsuario, Integer idEmpresa, MultipartFile file) throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        byte[] buffer = new byte[1024];
        if (extensaoDoArquivo.equalsIgnoreCase("KMZ")) {
            MapaCoordenadaPK mapaImportacaoPK = new MapaCoordenadaPK();
            mapaImportacaoPK.setIdEmpresa(idEmpresa);
            MapaCoordenada mapaImportacao = new MapaCoordenada();
            mapaImportacao.setId(mapaImportacaoPK);
            mapaImportacao.setIdUsuarioIns(idUsuario);
            mapaImportacao.setDatHorCadastro(LocalDateTime.now());
            mapaImportacao.setTitulo(titulo);
            MapaCoordenada mapaDB = (MapaCoordenada)this.mapaCoordenadaDAO.save((Object)mapaImportacao);
            String fileName = file.getOriginalFilename();
            logger.debug("Upload original.fileName={}", (Object)fileName);
            ZipInputStream zis = new ZipInputStream(file.getInputStream());
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File destFile = new File(tmpDir, zipEntry.getName());
                if (zipEntry.getName().toLowerCase().contains("kml")) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(destFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    List<String> kmlLines = Files.readAllLines(destFile.toPath());
                    StringBuilder kmlContent = new StringBuilder();
                    for (String line : kmlLines) {
                        kmlContent.append(line.trim());
                    }
                    if (nome == null || nome.isEmpty()) {
                        nome = fileName;
                    }
                    MapaCoordenadaItemPK mapaItemPK = new MapaCoordenadaItemPK();
                    mapaItemPK.setIdEmpresa(idEmpresa);
                    MapaCoordenadaItem mapaKml = new MapaCoordenadaItem();
                    mapaKml.setId(mapaItemPK);
                    mapaKml.setIdMapaCoordenada(mapaDB.getId().getIdMapaCoordenada());
                    mapaKml.setIdUsuarioIns(idUsuario);
                    mapaKml.setDatHorCadastro(LocalDateTime.now());
                    mapaKml.setKmlData(kmlContent.toString());
                    this.mapaCoordenadaItemDAO.save((Object)mapaKml);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.close();
            return mapaDB;
        }
        if (extensaoDoArquivo.equalsIgnoreCase("KML")) {
            MapaCoordenadaPK mapaImportacaoPK = new MapaCoordenadaPK();
            mapaImportacaoPK.setIdEmpresa(idEmpresa);
            MapaCoordenada mapaImportacao = new MapaCoordenada();
            mapaImportacao.setId(mapaImportacaoPK);
            mapaImportacao.setIdUsuarioIns(idUsuario);
            mapaImportacao.setDatHorCadastro(LocalDateTime.now());
            mapaImportacao.setTitulo(titulo);
            MapaCoordenada mapaDB = (MapaCoordenada)this.mapaCoordenadaDAO.save((Object)mapaImportacao);
            String fileName = file.getOriginalFilename();
            logger.debug("Upload original.fileName={}", (Object)fileName);
            File destFile = Files.createTempFile("kml-", "-" + file.getOriginalFilename(), new FileAttribute[0]).toFile();
            destFile.deleteOnExit();
            try (InputStream in = file.getInputStream();
                 FileOutputStream out = new FileOutputStream(destFile);){
                int len;
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            List<String> kmlLines = Files.readAllLines(destFile.toPath());
            StringBuilder kmlContent = new StringBuilder();
            for (String line : kmlLines) {
                kmlContent.append(line.trim());
            }
            MapaCoordenadaItemPK mapaItemPK = new MapaCoordenadaItemPK();
            mapaItemPK.setIdEmpresa(idEmpresa);
            MapaCoordenadaItem mapaKml = new MapaCoordenadaItem();
            mapaKml.setId(mapaItemPK);
            mapaKml.setIdMapaCoordenada(mapaDB.getId().getIdMapaCoordenada());
            mapaKml.setIdUsuarioIns(idUsuario);
            mapaKml.setDatHorCadastro(LocalDateTime.now());
            mapaKml.setKmlData(kmlContent.toString());
            this.mapaCoordenadaItemDAO.save((Object)mapaKml);
            return mapaDB;
        }
        return null;
    }

    public List<MapaCoordenadaItem> findKmlsByKmzIds(Integer idEmpresa, List<Integer> idsKmz) {
        List items = this.mapaCoordenadaItemDAO.findKmlsByKmzIds(idEmpresa, idsKmz);
        if (items == null || items.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Identificador de importa\u00e7\u00e3o inv\u00e1lido.");
        }
        return items;
    }

    public List<MapaCoordenada> getImportacoes(Integer idEmpresa) {
        List importacoes = this.mapaCoordenadaDAO.findImportacoesByEmpresa(idEmpresa);
        if (importacoes == null || importacoes.isEmpty()) {
            return List.of();
        }
        return importacoes;
    }
}

