/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.ambiental.beans.analise.FiltroAnalise;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoDescarte;
import br.com.oti.gesconsys.ambiental.beans.descarte.FiltroDescarte;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geo.MapaCoordenada;
import br.com.oti.gesconsys.beans.geo.MapaCoordenadaItem;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.CoordenadaMapaVO;
import br.com.oti.gesconsys.beans.shared.Obra;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AnaliseAmbientalService;
import br.com.oti.gesconsys.business.services.AreaApoioService;
import br.com.oti.gesconsys.business.services.AutorizacaoDescarteService;
import br.com.oti.gesconsys.business.services.AutorizacaoIntervencaoService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CheckListService;
import br.com.oti.gesconsys.business.services.InspecaoAmbientalService;
import br.com.oti.gesconsys.business.services.PontoControleService;
import br.com.oti.gesconsys.business.services.RacService;
import br.com.oti.gesconsys.business.services.UTMConverter;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.services.MapasService;
import br.com.oti.gesconsys.utils.Coordenada;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RestController
@Tag(description="REST Services para Mapas", name="shared")
@RequestMapping(value={"/api/mapas"})
public class MapasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(MapasRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private RacService racService;
    @Autowired
    private InspecaoAmbientalService inspecaoAmbientalService;
    @Autowired
    private PontoControleService pontoControleService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    private AreaApoioService areaApoioService;
    @Autowired
    private AnaliseAmbientalService analiseAmbientalService;
    @Autowired
    private AutorizacaoIntervencaoService autorizacaoIntervencaoService;
    @Autowired
    private AutorizacaoDescarteService autorizacaoDescarteService;
    @Autowired
    private MapasService mapasService;

    @PostMapping(path={"/{empresa}/kmlData"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria nova 'importa\u00e7\u00e3o' por meio de um arquivo KML/KMZ")
    public ResponseEntity<MapaCoordenada> createKmlMap(@PathVariable String empresa, MultipartFile file, HttpServletRequest request) throws BusinessException {
        try {
            if (file == null || file.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nenhum arquivo foi passado.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
            }
            logger.debug("createKmlMap({})", (Object)empresa);
            Map formData = request.getParameterMap();
            String nomeDoArquivo = file.getOriginalFilename();
            logger.debug("Upload original.nomeDoArquivo={}", (Object)nomeDoArquivo);
            String extensaoDoArquivo = this.getFileExtension(nomeDoArquivo);
            String titulo = null;
            if (formData.containsKey("titulo")) {
                titulo = ((String[])formData.get("titulo"))[0];
            }
            if (titulo == null || titulo.equals("")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio passar um t\u00edtulo para criar uma importa\u00e7\u00e3o.");
            }
            MapaCoordenada importacao = this.mapasService.createKmlMap(extensaoDoArquivo, nomeDoArquivo, titulo, usuario.getId(), emp.getId(), file);
            return new ResponseEntity((Object)importacao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @GetMapping(value={"/{empresa}/{modulo}"})
    @Operation(summary="Retorna o mapa conforme Modulo e item")
    public ResponseEntity<List<CoordenadaMapaVO>> fillMapa(@PathVariable String empresa, @PathVariable String modulo, @RequestParam List<String> items, HttpServletRequest request) {
        logger.debug("FillMapa(emp={}, mld={}, ite={})...", new Object[]{empresa, modulo, items});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            ArrayList<String> empresas = new ArrayList<String>();
            String[] empresasArray = request.getParameterValues("empresas");
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresas.add(emp);
                }
            } else {
                empresas.add(empresa);
            }
            List mapa = this.fillCoordenadas(empresas, modulo, items, request);
            if (mapa.isEmpty() || mapa == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Nenhuma informa\u00e7\u00e3o encontrada.");
            }
            return ResponseEntity.ok().body((Object)mapa);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/mapsKmlData"})
    @Operation(summary="Retorna um arquivo KMZ com conte\u00fado conforme id da importa\u00e7\u00e3o (ou importa\u00e7\u00f5es) e id da empresa")
    public ResponseEntity<byte[]> fillKmlMap(@PathVariable String empresa, @RequestParam List<Integer> ids) throws BusinessException {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ids == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o foi encontrado nenhum ID como par\u00e2metro");
            }
            List kmlDataObject = this.mapasService.findKmlsByKmzIds(emp.getId(), ids);
            if (kmlDataObject.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nenhuma importa\u00e7\u00e3o foi encontrada");
            }
            try {
                byte[] kmzBytes = this.buildKmlStructure(kmlDataObject, null);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"map.kmz\""})).contentType(MediaType.parseMediaType((String)"application/vnd.google-earth.kmz")).body((Object)kmzBytes);
            }
            catch (Exception e) {
                logger.error("Error generating KMZ file", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao gerar arquivo KMZ");
            }
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/kmzData/{modulo}/{item}"})
    @Operation(summary="Baixa o KMZ do Mapa")
    public ResponseEntity<byte[]> retrieveKmlInOldFormat(@PathVariable String empresa, @PathVariable String modulo, @PathVariable String item, HttpServletRequest request) {
        String kmlFileContent = this.makeKmlAtivos(empresa, modulo, item.lines().toList(), request);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=\"mapaKmz.kmz\"");
        headers.add("Content-Type", "application/vnd.google-earth.kmz");
        byte[] bytes = this.renderAsKmz(kmlFileContent, "mapa.kml");
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(path={"/{empresa}/downloadMapa/{modulo}"})
    @Operation(summary="Baixa em KMZ as informa\u00e7\u00f5es do Mapa exibido na tela do usu\u00e1rio (tanto importacoes quanto fichas/items)")
    public ResponseEntity downloadMapa(@PathVariable String empresa, @PathVariable String modulo, @RequestParam(required=false) List<String> items, @RequestParam(required=false) List<Integer> ids, HttpServletRequest request) throws ParserConfigurationException, IOException, TransformerException {
        Empresa emp = null;
        if (empresa != null) {
            emp = this.coreService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        List kmlDataObject = null;
        String kmlDataString = null;
        if (ids != null) {
            kmlDataObject = this.mapasService.findKmlsByKmzIds(emp.getId(), ids);
        }
        if (items != null) {
            kmlDataString = this.makeKmlAtivos(empresa, modulo, items, request);
        }
        byte[] bytes = this.buildKmlStructure(kmlDataObject, kmlDataString);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"map.kmz\""})).contentType(MediaType.parseMediaType((String)"application/vnd.google-earth.kmz")).body((Object)bytes);
    }

    @GetMapping(value={"/{empresa}/importacoes"})
    @Operation(summary="Exibe as importa\u00e7\u00f5es de KMZ/KML feitas no sistema")
    public ResponseEntity<List<MapaCoordenada>> getImportacoes(@PathVariable String empresa, HttpServletRequest request) {
        try {
            logger.debug("MapasRestServices.getImportacoes iniciando getImportacoes na emp={}", (Object)empresa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
            }
            List importacoes = this.mapasService.getImportacoes(emp.getId());
            return ResponseEntity.ok((Object)importacoes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] renderAsKmz(String kmlFileContent, String zipEntryName) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipStream = new ZipOutputStream(outStream);
        try {
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            zipStream.putNextEntry(zipEntry);
            zipStream.write(kmlFileContent.getBytes());
        }
        catch (IOException e) {
            logger.error("Error while zipping kml file content : " + e.getMessage());
        }
        finally {
            try {
                zipStream.closeEntry();
                zipStream.close();
            }
            catch (IOException e) {
                logger.error("Error while closing zipped stream : " + e.getMessage());
            }
        }
        return outStream.toByteArray();
    }

    private List<CoordenadaMapaVO> fillCoordenadas(List<String> empresas, String modulo, List<String> items, HttpServletRequest request) {
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        List empresasDB = this.coreService.findEmpresas(null, null);
        ArrayList<Integer> empresasInt = new ArrayList<Integer>();
        block6: for (Empresa empDB : empresasDB) {
            for (String emp : empresas) {
                if (!emp.equals(empDB.getSigla())) continue;
                empresasInt.add(empDB.getId());
                continue block6;
            }
        }
        if (modulo.equals(TipoModulo.MEIO_AMBIENTE.getSigla())) {
            coordenadas.addAll(this.fillCoordenadasAmbientais(empresasInt, modulo, items, request));
        } else if (modulo.equals(TipoModulo.CADASTROS.getSigla())) {
            for (String item : items) {
                if (!item.equalsIgnoreCase("OBRA")) continue;
                Integer tipoObra = null;
                Integer obra = null;
                ArrayList<String> statusObra = null;
                String parm = request.getParameter("tipoObra");
                if (parm != null) {
                    tipoObra = Integer.valueOf(parm);
                }
                if ((parm = request.getParameter("obra")) != null) {
                    obra = Integer.valueOf(parm);
                }
                if ((parm = request.getParameter("status")) != null) {
                    statusObra = new ArrayList<String>();
                    statusObra.add(parm);
                }
                Object northern = null;
                List obras = this.cadastroService.findObras((Integer)empresasInt.get(0), null, null, null, tipoObra, statusObra, null);
                for (Obra obr : obras) {
                    Double coordY;
                    Double coordX;
                    Integer zonaNbr;
                    if (obr.getCoordenadaNorte() == null || obr.getCoordenadaLeste() == null) continue;
                    Coordenada latLng = null;
                    Coordenada latLngFim = null;
                    if (obr.getZonaGeografica() != null && !obr.getZonaGeografica().isEmpty()) {
                        try {
                            zonaNbr = Integer.valueOf(obr.getZonaGeografica().replaceAll("[A-Za-z]", ""));
                            coordX = Double.valueOf(obr.getCoordenadaLeste().replaceAll("[A-Za-z]", ""));
                            coordY = Double.valueOf(obr.getCoordenadaNorte().replaceAll("[A-Za-z]", ""));
                            latLng = UTMConverter.convertToLatLng((double)coordX, (double)coordY, (int)zonaNbr, (boolean)true);
                            if (latLng == null) {
                                continue;
                            }
                        }
                        catch (NumberFormatException nmfExc) {
                            latLng = null;
                        }
                        catch (RuntimeException runExc) {
                            latLng = null;
                        }
                    }
                    if (latLng == null) continue;
                    if (obr.getZonaGeograficaFinal() != null && !obr.getZonaGeograficaFinal().isEmpty() && obr.getCoordenadaNorteFinal() != null && obr.getCoordenadaLesteFinal() != null) {
                        try {
                            zonaNbr = Integer.valueOf(obr.getZonaGeograficaFinal().replaceAll("[A-Za-z]", ""));
                            coordX = Double.valueOf(obr.getCoordenadaLesteFinal().replaceAll("[A-Za-z]", ""));
                            coordY = Double.valueOf(obr.getCoordenadaNorteFinal().replaceAll("[A-Za-z]", ""));
                            latLngFim = UTMConverter.convertToLatLng((double)coordX, (double)coordY, (int)zonaNbr, (boolean)true);
                        }
                        catch (NumberFormatException nmfExc) {
                            latLngFim = null;
                        }
                        catch (RuntimeException runExc) {
                            latLng = null;
                        }
                    }
                    CoordenadaMapaVO itemMapa = new CoordenadaMapaVO(obr.getDescricao(), item, latLng.getLatitude(), latLng.getLongitude(), latLngFim != null ? latLngFim.getLatitude() : null, latLngFim != null ? latLngFim.getLongitude() : null);
                    Map infoMap = itemMapa.getInformacao();
                    infoMap.put("idObra", obr.getId());
                    if (obr.getTipoObra() != null) {
                        infoMap.put("tipo", obr.getTipoObra().getDescricao());
                    }
                    infoMap.put("datInicial", obr.getDatInicial());
                    infoMap.put("datFinal", obr.getDatFinal());
                    infoMap.put("status", obr.getStatus());
                    coordenadas.add(itemMapa);
                    coordenadas.add(itemMapa);
                }
            }
        }
        return coordenadas;
    }

    private List<CoordenadaMapaVO> fillCoordenadasAmbientais(List<Integer> empresasInt, String modulo, List<String> items, HttpServletRequest request) {
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        if (items == null || items.isEmpty()) {
            return coordenadas;
        }
        for (String item : items) {
            Map infoMap;
            CoordenadaMapaVO itemMapa;
            Map infoMap2;
            CoordenadaMapaVO itemMapa2;
            Object analise2;
            boolean joinAnexos;
            boolean joinItens;
            Map infoMap3;
            CoordenadaMapaVO itemMapa3;
            boolean joinOcorrencias;
            boolean joinAnexos2;
            if ((item = item.toUpperCase()).contains("RAC")) {
                FiltroRac filtroRac = new FiltroRac();
                filtroRac.getConcessionaria().addAll(empresasInt);
                joinAnexos2 = false;
                joinOcorrencias = false;
                Page racs = this.racService.findRacs(filtroRac, 1, 10000, null, null, Boolean.valueOf(false), Boolean.valueOf(joinAnexos2), Boolean.valueOf(joinOcorrencias));
                for (Rac rac : racs.getContent()) {
                    itemMapa3 = new CoordenadaMapaVO(rac.getDescricao(), "RAC", rac.getLatitude(), rac.getLongitude(), null, null);
                    infoMap3 = itemMapa3.getInformacao();
                    infoMap3.put("tipoFicha", "RAC");
                    infoMap3.put("idRac", rac.getId().getIdRac());
                    infoMap3.put("nroRac", rac.getNumero());
                    infoMap3.put("datInspecao", rac.getDatInspecao());
                    infoMap3.put("observacao", rac.getObservacao());
                    infoMap3.put("prazo", rac.getPrazo());
                    infoMap3.put("prorrogacao", rac.getPrazoProrrogado());
                    infoMap3.put("prazoFinal", rac.getDatHorPrazoFinal());
                    infoMap3.put("status", rac.getStatus());
                    infoMap3.put("ultimaFicha", rac.getFichaAtual());
                    coordenadas.add(itemMapa3);
                }
            }
            if (item.contains("ANAMB")) {
                FiltroAnalise filtroAnalise = new FiltroAnalise();
                filtroAnalise.getConcessionaria().addAll(empresasInt);
                joinItens = false;
                joinAnexos = false;
                Page analises = this.analiseAmbientalService.findAnalises(filtroAnalise, 1, 1000, null, null, Boolean.valueOf(joinItens), Boolean.valueOf(joinAnexos));
                for (Object analise2 : analises) {
                    itemMapa3 = new CoordenadaMapaVO(analise2.getDescricao(), "ANAMB", analise2.getLatitude(), analise2.getLongitude(), null, null);
                    infoMap3 = itemMapa3.getInformacao();
                    infoMap3.put("tipoFicha", "ANAMB");
                    infoMap3.put("idAnalise", analise2.getId().getIdAnalise());
                    infoMap3.put("nroAnalise", analise2.getNumero());
                    infoMap3.put("datInspecao", analise2.getDatInspecao());
                    coordenadas.add(itemMapa3);
                }
            }
            if (item.contains("DEPOS")) {
                FiltroAreaApoio filtroAreaApoio = new FiltroAreaApoio();
                filtroAreaApoio.getConcessionaria().addAll(empresasInt);
                joinAnexos2 = false;
                joinOcorrencias = false;
                boolean joinSituacoes = false;
                Page areas = this.areaApoioService.findAreasApoio(filtroAreaApoio, 1, 1000, null, null, Boolean.valueOf(joinAnexos2), Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinSituacoes));
                analise2 = areas.iterator();
                while (analise2.hasNext()) {
                    AreaApoio area = (AreaApoio)analise2.next();
                    itemMapa2 = new CoordenadaMapaVO(null, "ANAMB", area.getLatitude(), area.getLongitude(), null, null);
                    infoMap2 = itemMapa2.getInformacao();
                    infoMap2.put("tipoFicha", "DEPOS");
                    infoMap2.put("idArea", area.getId().getIdDeposito());
                    infoMap2.put("nroArea", area.getNumero());
                    infoMap2.put("datInspecao", area.getDatInspecao());
                    infoMap2.put("observacao", area.getObservacao());
                    coordenadas.add(itemMapa2);
                }
            }
            if (item.contains("AUINT")) {
                FiltroIntervencao filtroIntervencao = new FiltroIntervencao();
                filtroIntervencao.getConcessionaria().addAll(empresasInt);
                joinItens = false;
                joinOcorrencias = false;
                boolean joinFlorestais = false;
                Page intervencoes = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroIntervencao, 1, 10000, null, null, Boolean.valueOf(joinItens), Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinFlorestais));
                analise2 = intervencoes.iterator();
                while (analise2.hasNext()) {
                    AutorizacaoIntervencao interv = (AutorizacaoIntervencao)analise2.next();
                    itemMapa2 = new CoordenadaMapaVO(interv.getDescricao(), "AUINT", interv.getLatitude(), interv.getLongitude(), null, null);
                    infoMap2 = itemMapa2.getInformacao();
                    infoMap2.put("tipoFicha", "AUINT");
                    infoMap2.put("idArea", interv.getId().getIdIntervencao());
                    infoMap2.put("nroArea", interv.getNumero());
                    infoMap2.put("datInspecao", interv.getDatInspecao());
                    infoMap2.put("observacao", interv.getObservacao());
                    coordenadas.add(itemMapa2);
                }
            }
            if (item.contains("AURAP")) {
                FiltroDescarte filtroDescarte = new FiltroDescarte();
                filtroDescarte.getConcessionaria().addAll(empresasInt);
                boolean joinOcorrencias2 = false;
                joinAnexos = false;
                Page descartes = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtroDescarte, 1, 10000, null, null, Boolean.valueOf(joinOcorrencias2), Boolean.valueOf(joinAnexos));
                for (AutorizacaoDescarte descarte : descartes) {
                    itemMapa3 = new CoordenadaMapaVO(descarte.getDescricao(), "AURAP", descarte.getLatitude(), descarte.getLongitude(), null, null);
                    infoMap3 = itemMapa3.getInformacao();
                    infoMap3.put("tipoFicha", "AURAP");
                    infoMap3.put("idArea", descarte.getId().getIdAutorizacao());
                    infoMap3.put("nroArea", descarte.getNumero());
                    infoMap3.put("datInspecao", descarte.getDatInspecao());
                    infoMap3.put("observacao", descarte.getObservacao());
                    coordenadas.add(itemMapa3);
                }
            }
            if (item.contains("PTC")) {
                FiltroPontoControle filtroPtc = new FiltroPontoControle();
                filtroPtc.getConcessionaria().add(empresasInt.get(0));
                Page pontosControle = this.pontoControleService.findPontosControle(filtroPtc, 1, 10000, null, null);
                for (PontoControle ponto : pontosControle) {
                    if (ponto.getLatitude() == null || ponto.getLongitude() == null) continue;
                    itemMapa = new CoordenadaMapaVO(ponto.getDescricao(), "PONTO_CONTROLE", ponto.getLatitude(), ponto.getLongitude(), null, null);
                    infoMap = itemMapa.getInformacao();
                    infoMap.put("tipoFicha", "PTC");
                    infoMap.put("idPonto", ponto.getId());
                    if (ponto.getTipo() != null) {
                        infoMap.put("tipo", ponto.getTipo().getDescricao());
                    }
                    if (ponto.getObra() != null) {
                        infoMap.put("obra", ponto.getObra().getDescricao());
                    }
                    if (ponto.getRodovia() != null) {
                        infoMap.put("rodovia", ponto.getRodovia().getDescricao());
                    }
                    infoMap.put("status", ponto.getStatus());
                    coordenadas.add(itemMapa);
                }
            }
            if (item.contains("INSPE")) {
                FiltroInspecao filtroInsp = new FiltroInspecao();
                filtroInsp.getConcessionaria().addAll(empresasInt);
                boolean joinFlorestal = false;
                boolean joinAnexos3 = false;
                Page inspecoes = this.inspecaoAmbientalService.findInspecoes(filtroInsp, 1, 10000, null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(joinFlorestal), Boolean.valueOf(joinAnexos3));
                for (InspecaoAmbiental inspecao : inspecoes.getContent()) {
                    itemMapa3 = new CoordenadaMapaVO(inspecao.getDescricao(), "INSPECAO", inspecao.getLatitude(), inspecao.getLongitude(), null, null);
                    infoMap3 = itemMapa3.getInformacao();
                    infoMap3.put("tipoFicha", "INSPECAO");
                    infoMap3.put("idInspecao", inspecao.getId().getIdInspecao());
                    infoMap3.put("nroInspecao", inspecao.getNumero());
                    infoMap3.put("datInspecao", inspecao.getDatInspecao());
                    infoMap3.put("observacao", inspecao.getDescricao());
                    infoMap3.put("prazo", inspecao.getPrazo());
                    infoMap3.put("prazoFinal", inspecao.getDatHorPrazoFinal());
                    infoMap3.put("status", inspecao.getStatus());
                    infoMap3.put("ultimaFicha", inspecao.getFichaAtual());
                    coordenadas.add(itemMapa3);
                }
            }
            if (!item.contains("CHKLST")) continue;
            FiltroChecklist filtroCheck = new FiltroChecklist();
            filtroCheck.getConcessionaria().addAll(empresasInt);
            Page checklists = this.checkListService.findCheckLists(filtroCheck, 1, 10000, null, null);
            for (CheckList row : checklists.getContent()) {
                itemMapa = new CoordenadaMapaVO(row.getDescricao(), "CHECKLIST", row.getLatitude(), row.getLongitude(), null, null);
                infoMap = itemMapa.getInformacao();
                infoMap.put("tipoFicha", "CHECKLIST");
                infoMap.put("idChecklist", row.getId().getIdCheckList());
                infoMap.put("nroChecklist", row.getNumero());
                infoMap.put("inpecao", row.getDatInspecao());
                infoMap.put("observacao", row.getDescricao());
                infoMap.put("status", row.getStatus());
                coordenadas.add(itemMapa);
            }
        }
        return coordenadas;
    }

    private byte[] buildKmlStructure(List<MapaCoordenadaItem> kmlDataObject, String kmlDataString) throws ParserConfigurationException, TransformerException, IOException {
        String kmlContent;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document combinedDoc = docBuilder.newDocument();
        Element kmlElement = combinedDoc.createElementNS("http://www.opengis.net/kml/2.2", "kml");
        combinedDoc.appendChild(kmlElement);
        Element documentElement = combinedDoc.createElementNS("http://www.opengis.net/kml/2.2", "Document");
        kmlElement.appendChild(documentElement);
        Element nameElement = combinedDoc.createElementNS("http://www.opengis.net/kml/2.2", "name");
        nameElement.setTextContent("KML Combinado");
        documentElement.appendChild(nameElement);
        if (kmlDataObject != null && !kmlDataObject.isEmpty() && kmlDataString == null) {
            for (MapaCoordenadaItem kml : kmlDataObject) {
                kmlContent = kml.getKmlData();
                this.mergeKmlData(kmlContent, documentElement, combinedDoc);
            }
        }
        if (kmlDataString != null && (kmlDataObject == null || kmlDataObject.isEmpty())) {
            this.mergeKmlData(kmlDataString, documentElement, combinedDoc);
        }
        if (kmlDataString != null && kmlDataObject != null) {
            for (MapaCoordenadaItem kml : kmlDataObject) {
                kmlContent = kml.getKmlData();
                this.mergeKmlData(kmlContent, documentElement, combinedDoc);
            }
            this.mergeKmlData(kmlDataString, documentElement, combinedDoc);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        DOMSource source = new DOMSource(combinedDoc);
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        String combinedKmlContent = writer.toString();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        ZipEntry entry = new ZipEntry("doc.kml");
        zos.putNextEntry(entry);
        byte[] kmlBytes = combinedKmlContent.getBytes(StandardCharsets.UTF_8);
        zos.write(kmlBytes);
        zos.closeEntry();
        zos.finish();
        return baos.toByteArray();
    }

    private void mergeKmlData(String kmlContent, Element targetDocumentElement, Document targetDoc) {
        try {
            if (kmlContent.contains("xsi:schemaLocation") && !kmlContent.contains("xmlns:xsi=")) {
                kmlContent = kmlContent.replace("<Document", "<Document xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document sourceDoc = builder.parse(new ByteArrayInputStream(kmlContent.getBytes(StandardCharsets.UTF_8)));
            Element sourceRootElement = sourceDoc.getDocumentElement();
            NodeList sourceDocumentElements = sourceDoc.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Document");
            Node containerPai = sourceDocumentElements.getLength() > 0 ? sourceDocumentElements.item(0) : sourceRootElement;
            NodeList childNodes = containerPai.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName;
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1 || (nodeName = node.getLocalName()).equals("kml") || nodeName.equals("Document")) continue;
                Node importedNode = targetDoc.importNode(node, true);
                targetDocumentElement.appendChild(importedNode);
            }
        }
        catch (Exception e) {
            logger.error("Error merging KML content", (Throwable)e);
        }
    }

    private String makeKmlAtivos(String empresa, String modulo, List<String> items, HttpServletRequest request) {
        StringBuilder outKml = new StringBuilder();
        ArrayList<String> listaDeItemsValidos = new ArrayList<String>(List.of("RAC", "ANAMB", "DEPOS", "AUINT", "AURAP", "PTC", "INSPE", "CHKLST"));
        if (items != null) {
            for (String item : items) {
                if (listaDeItemsValidos.contains(item)) continue;
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Item passado como par\u00e2metro \u00e9 inv\u00e1lido.");
            }
        }
        outKml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        outKml.append("<kml xmlns=\"http://www.opengis.net/kml/2.2\">");
        outKml.append("<Document>");
        logger.debug("makeKmlAtivos(emp={}, mld={}, ite={})...", (Object)empresa, (Object)modulo);
        ArrayList<String> empresas = new ArrayList<String>();
        String[] empresasArray = request.getParameterValues("empresas");
        if (empresasArray != null && empresasArray.length > 0) {
            for (String emp : empresasArray) {
                empresas.add(emp);
            }
        } else {
            empresas.add(empresa);
        }
        List coordenadas = this.fillCoordenadas(empresas, modulo, items, request);
        for (CoordenadaMapaVO coordenada : coordenadas) {
            if (coordenada.getLatitude() == null || coordenada.getLongitude() == null) continue;
            outKml.append("<Placemark>");
            outKml.append("<name>").append(coordenada.getDescricao()).append("</name>");
            outKml.append("<Point>");
            outKml.append("<coordinates>");
            outKml.append(coordenada.getLongitude()).append(",").append(coordenada.getLatitude()).append(",0");
            outKml.append("</coordinates>");
            outKml.append("</Point>");
            outKml.append("</Placemark>");
        }
        outKml.append("</Document>");
        outKml.append("</kml>");
        return outKml.toString();
    }

    String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex >= 0) {
            return filename.substring(dotIndex + 1);
        }
        return "";
    }
}

