/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.TipoAuditoria;
import br.com.oti.gesconsys.beans.seguranca.UsuarioAuditoria;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para seguran\u00e7a", name="segurancas")
@RequestMapping(value={"/api/seguranca"})
public class SegurancasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(SegurancasRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/grupos"})
    @Operation(summary="Lista os grupos de acesso;")
    @ResponseBody
    public ResponseEntity<List<GrupoAcessoUsuario>> findGruposAcesso(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando SegurancasRestServices GET gruposUsuario...");
        try {
            UsuarioPerfil perfil;
            String search = null;
            String modulo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("modulo") != null) {
                modulo = request.getParameter("modulo");
            }
            if (!((perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId())) == null || perfil.isAdministradorFlag().booleanValue() || modulo != null && (modulo.equals(TipoModulo.AMBIENTAL.getSigla()) || modulo.equals(TipoModulo.MEIO_AMBIENTE.getSigla())))) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            List result = this.segurancaService.findGruposAcessoUsuarios(search, modulo);
            for (GrupoAcessoUsuario grp : result) {
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/grupos/{idGrupo}"})
    @Operation(summary="Lista os grupos de acesso;")
    @ResponseBody
    public ResponseEntity<GrupoAcessoUsuario> getGrupoAcessoById(@PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando SegurancasRestServices GET grupoUsuario...");
        try {
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            GrupoAcessoUsuario result = this.segurancaService.getGrupoAcessoUsuarioById(idGrupo);
            result.setDatHorCadastro(null);
            result.setIdUsuarioIns(null);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoAcessoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getGrupoAcessoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/grupos"})
    @Operation(summary="Salva os grupos de acesso a partir de seu payload")
    public ResponseEntity<GrupoAcessoUsuario> saveGrupoAcesso(@RequestBody GrupoAcessoUsuario grupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveGrupoAcesso({})", (Object)grupo);
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.segurancaService.saveGrupoAcessoUsuario(grupo, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/grupos/{idGrupo}"})
    @Operation(summary="Deleta o grupo de acesso de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteGrupoAcesso(@PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteGrupoAcesso({})", (Object)idGrupo);
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            this.segurancaService.deleteGrupoAcessoUsuario(idGrupo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupoAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/auditorias"})
    @Operation(summary="Lista as auditorias de acesso;")
    @ResponseBody
    public ResponseEntity<List<UsuarioAuditoria>> findAuditorias(@PathVariable(name="empresa") String empresa, @RequestParam(name="dataInicial", required=false) Date dataInicial, @RequestParam(name="dataFinal", required=false) Date dataFinal, @RequestParam(name="nomeUsuario", required=false) String nomeUsuario, @RequestParam(name="tipoEvento", required=false) Integer tipoEvento, @RequestParam(name="tipoAuditoria", required=false) TipoAuditoria tipoAuditoria, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando SegurancasRestServices GET auditorias...");
        try {
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            List result = this.segurancaService.findAuditoria(emp.getId(), search, dataInicial, dataFinal, usr.getId(), nomeUsuario, tipoAuditoria, tipoEvento);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAuditorias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.findAuditorias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/auditoria"})
    @Operation(summary="Salva as auditorias a partir de seu payload")
    public ResponseEntity<UsuarioAuditoria> saveAuditoria(@RequestBody UsuarioAuditoria auditoria, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveAuditoria({})", (Object)auditoria);
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.segurancaService.registraAuditoria(auditoria.getIdEmpresa(), auditoria.getDescricao(), usr.getId(), auditoria.getTipo(), request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/grupos/{idGrupo}/usuarios"})
    @Operation(summary="Lista os usu\u00e1rios de acordo com o grupo de acesso")
    @ResponseBody
    public ResponseEntity<List<PublicUser>> findUsuariosByGrupo(@PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando SegurancasRestsServices GET usuariosGrupo...");
        try {
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usr.getId());
            if (perfil != null && !perfil.isAdministradorFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o possui autoriza\u00e7\u00e3o.");
            }
            ArrayList<PublicUser> result = new ArrayList<PublicUser>();
            List usuariosGruposDB = this.segurancaService.findUsuariosByGrupo(idGrupo);
            for (UsuarioGrupo grp : usuariosGruposDB) {
                PublicUser pbUser = new PublicUser(grp.getUsuario());
                result.add(pbUser);
            }
            return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findUsuariosByGrupo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.findUsuariosByGrupo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

