/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.scheduler;

import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.TipoStatusEmail;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.FichaAmbientalService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.dao.geral.CidadeDAO;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.server.helpers.EmailDiarioLicencaHelper;
import br.com.oti.gesconsys.server.helpers.EmailDiarioUsuarioHelper;
import br.com.oti.gesconsys.server.helpers.SenderMailHelper;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/schedulers"})
public class SchedulersRestServices
extends BaseRestService {
    private static Logger LOG = LoggerFactory.getLogger(SchedulersRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private FichaAmbientalService fichaAmbientalService;
    @Autowired
    EmpresaDAO empresaDAO;
    @Autowired
    CidadeDAO cidadeDAO;
    @Autowired
    EmailDiarioLicencaHelper dailyLicencaHelper;
    @Autowired
    EmailDiarioUsuarioHelper dailyUserHelper;
    @Autowired
    SenderMailHelper mailHelper;
    @Autowired
    LicencaService licencaService;

    @PostMapping(value={"/bloqueios/{untilTime}"})
    @Operation(summary="Remove os bloqueios antigos. Por default, com inatividade nos \u00faltimos 90 segundos.")
    public ResponseEntity<Boolean> deleteBloqueiosAntigos(@PathVariable Long untilTime) {
        try {
            return new ResponseEntity((Object)this.coreService.deleteBloqueiosAntigos(Instant.ofEpochMilli(untilTime).atZone(ZoneId.systemDefault()).toLocalDateTime()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.deleteBloqueiosAntigos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/emails"})
    @Operation(summary="Lista os \u00faltimos e-mails pendentes de processamento/envio. Por default, lista os \u00faltimos 25 e-mails")
    private ResponseEntity<List<Email>> findEmails() {
        try {
            List rows = this.coreService.findEmails(null, null, null, null, TipoStatusEmail.PENDENTE, Integer.valueOf(25), null);
            return new ResponseEntity((Object)rows, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findEmails", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/mails"})
    @Operation(summary="Envia os emails pendentes ou em cache.")
    public ResponseEntity<Boolean> sendMails(HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.mailHelper.sendMails(usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.sendMails", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/racs/prazos"})
    @Operation(summary="Calcula e Atualiza os prazos das Fichas Ambientais (RAC, Inspecao, ...)")
    public ResponseEntity<Boolean> updatePrazosFichas() {
        try {
            return new ResponseEntity((Object)this.fichaAmbientalService.updatePrazosFichas(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.updatePrazoRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/licencas/prazos"})
    @Operation(summary="Calcula e informa quando uma licen\u00e7a ambiental tiver expirada ou quase expirada")
    public ResponseEntity<Boolean> updateLicencasPrazos() {
        try {
            return new ResponseEntity((Object)this.licencaService.updateRenovacaoLicencas(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.updatePrazoRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/mails/cached"})
    @Operation(summary="Reavalia emails com status == cache, e os coloca em fila novamente...")
    public ResponseEntity<Boolean> cleanupCachedMail() {
        try {
            return new ResponseEntity((Object)this.coreService.cleanupCachedMail(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.cleanupCachedMail", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/core/sessions"})
    @Operation(summary="Limpa as sess\u00f5es ativas h\u00e1 mais de X minutos (Padr\u00e3o: 30 minutos)")
    public ResponseEntity<Boolean> cleanupOpenSessions() {
        try {
            return new ResponseEntity((Object)this.coreService.cleanupOpenSessions(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.cleanupCachedMail", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/mails/daily/licencas"})
    @Operation(summary="Gera os emails di\u00e1rios das licen\u00e7as...")
    public ResponseEntity<Boolean> generateDailyMailLicencas() {
        try {
            return new ResponseEntity((Object)this.dailyLicencaHelper.execute(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.generateDailyMailLicencas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/mails/daily/usuarios/equipes/registros"})
    @Operation(summary="Gera os e-mails di\u00e1rios dos registros de novos usu\u00e1rios em equipes x contratos")
    public ResponseEntity<Boolean> generateDailyMailRegistroUsuariosEquipes() {
        try {
            return new ResponseEntity((Object)this.dailyUserHelper.execute(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.generateDailyMailRegistroUsuariosEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

