/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.core;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.PoderConcedente;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Fornecedor;
import br.com.oti.gesconsys.beans.shared.Tema;
import br.com.oti.gesconsys.beans.shared.TipoDocumento;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services Cadastros, relacionados as estruturas de tabelas do sistema", name="cadastros")
@RequestMapping(value={"/api/cadastros"})
public class CadastrosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/poderesConcedentes"})
    @Operation(summary="Lista os Poderes Concedentes cadastrados .")
    public ResponseEntity<List<PoderConcedente>> findPoderesConcedentes(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            Object tipoAtivo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("{} - findPoderesConcedentes({}, {})", new Object[]{usuario.getLogin(), search, tipoAtivo});
            List rows = this.cadastroService.findPoderConcedente(search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPoderesConcedentes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/poderesConcedentes/{idPoderConcedente}"})
    @Operation(summary="Busca o poder concedente conforme seu ID.")
    public ResponseEntity<PoderConcedente> getPoderConcedenteById(@PathVariable(name="idPoderConcedente") Integer idPoderConcedente, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getPoderConcedenteById({})", (Object)usuario.getLogin(), (Object)idPoderConcedente);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getPoderConcedenteById(idPoderConcedente));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCategoriaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/poderesConcedentes"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do Poder Concedente.")
    public ResponseEntity<PoderConcedente> savePoderConcedente(@RequestBody PoderConcedente poderConcedente, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PoderConcedente poderDB = this.cadastroService.savePoderConcedente(poderConcedente, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)poderDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePoderConcedente", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/poderesConcedentes/{idPoderConcedente}"})
    @Operation(summary="Deleta o poder concedente de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePoderConcedente(@PathVariable(name="idPoderConcedente") Integer idPoderConcedente, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deletePoderConcedente({})", (Object)usuario.getLogin(), (Object)idPoderConcedente);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deletePoderConcedente(idPoderConcedente);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePoderConcedente", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/temas"})
    @Operation(summary="Lista os temas cadastrados .")
    public ResponseEntity<List<Tema>> findTemas(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("{} - findTemas({})", (Object)usuario.getLogin(), (Object)search);
            List rows = this.cadastroService.findTemas(search, null);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTemas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/temas/{idTema}"})
    @Operation(summary="Busca o tema conforme seu identificador.")
    public ResponseEntity<Tema> getTemaById(@PathVariable(name="idTema") Integer idTema, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getTemaById({})", (Object)usuario.getLogin(), (Object)idTema);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getTemaById(idTema));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTemaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/temas"})
    @Operation(summary="Salva o tema relacionado.")
    public ResponseEntity<Tema> saveTema(@RequestBody Tema tema, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Tema temaDB = this.cadastroService.saveTema(tema, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)temaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTema", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/temas/{idTema}"})
    @Operation(summary="Deleta o tema de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTema(@PathVariable(name="idTema") Integer idTema, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteTema({})", (Object)usuario.getLogin(), (Object)idTema);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deleteTema(idTema);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTema", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposDocumentos/{empresa}"})
    @Operation(summary="Lista os tipos de documentos cadastrados .")
    public ResponseEntity<List<TipoDocumento>> findTiposDocumentos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("{} - findTiposDocumentos({}, {})", new Object[]{usuario.getLogin(), empresa, search});
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List rows = this.cadastroService.findTiposDocumentos(emp.getId(), search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposDocumentos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposDocumentos/{empresa}/{idTipoDocumento}"})
    @Operation(summary="Busca o Tipo de documento conforme seu identificador.")
    public ResponseEntity<TipoDocumento> getTipoDocumentoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDocumento") Integer idTipoDocumento, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getTipoDocumentoById({}, {})", new Object[]{usuario.getLogin(), empresa, idTipoDocumento});
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            return ResponseEntity.ok().body((Object)this.cadastroService.getTipoDocumentoById(emp.getId(), idTipoDocumento));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoDocumentoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tiposDocumentos/{empresa}"})
    @Operation(summary="Salva o Tipo de documento relacionado.")
    public ResponseEntity<TipoDocumento> saveTipoDocumento(@PathVariable(name="empresa") String empresa, @RequestBody TipoDocumento tipoDocto, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            TipoDocumento tipoDB = this.cadastroService.saveTipoDocumento(tipoDocto, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)tipoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tiposDocumentos/{empresa}/{idTipoDocumento}"})
    @Operation(summary="Deleta o tema de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoDocumento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDocumento") Integer idTipoDocumento, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteTipoDocumento({}, {})", (Object)empresa, (Object)idTipoDocumento);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.cadastroService.deleteTipoDocumento(emp.getId(), idTipoDocumento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores"})
    @Operation(summary="Lista os fornecedores cadastrados.")
    public ResponseEntity<List<Fornecedor>> findFornecedores(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} -  findFornecedores({})...", (Object)usuario.getLogin(), (Object)empresa);
            String search = null;
            String modulo = null;
            if (request.getParameter("modulo") != null) {
                modulo = request.getParameter("modulo");
            }
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List rows = this.cadastroService.findFornecedores(search, modulo);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFornecedores", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores/{idFornecedor}"})
    @Operation(summary="Busca o fornecedor conforme seu ID.")
    public ResponseEntity<Fornecedor> getFornecedorById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFornecedor") Integer idFornecedor) {
        try {
            logger.debug("getFornecedorById({}, {})", (Object)empresa, (Object)idFornecedor);
            return ResponseEntity.ok().body((Object)this.cadastroService.getFornecedorById(idFornecedor));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFornecedorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fornecedores"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do fornecedor.")
    public ResponseEntity<Fornecedor> saveFornecedor(@PathVariable(name="empresa") String empresa, @RequestBody Fornecedor fornecedor, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
            }
            Fornecedor fornecedorDB = this.cadastroService.saveFornecedor(fornecedor, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)fornecedorDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFornecedor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/fornecedores/{idFornecedor}"})
    @Operation(summary="Deleta o fornecedor conforme seu ID.")
    public ResponseEntity<Boolean> deleteFornecedor(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFornecedor") Integer idFornecedor, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteFornecedor({}, {})", (Object)empresa, (Object)idFornecedor);
            this.cadastroService.deleteFornecedor(idFornecedor);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFornecedor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

