/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.racom;

import br.com.oti.gesconsys.ambiental.beans.racom.FiltroRacom;
import br.com.oti.gesconsys.ambiental.beans.racom.Racom;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomAnexo;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomCausa;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomCorrecao;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomHistorico;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomPK;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomPlanoAcao;
import br.com.oti.gesconsys.ambiental.beans.racom.RacomRac;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.RacomService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para racoms", name="ambiental")
@RequestMapping(value={"/api/racoms"})
public class RacomsRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RacomsRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private RacomService racomService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna os RACOMS dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<List<Racom>> findRacoms(@PathVariable String empresa, @RequestBody FiltroRacom filtroRacom) {
        try {
            logger.debug("Iniciando findRacoms...");
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroRacom == null) {
                filtroRacom = new FiltroRacom();
            }
            if (filtroRacom.getConcessionaria() == null || filtroRacom.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroRacom.setConcessionaria(empList);
            }
            List racoms = this.racomService.findRacoms(filtroRacom);
            for (Racom racom : racoms) {
                if (racom.getTipoRacom() == null) continue;
                racom.setTipoRacom(null);
            }
            return new ResponseEntity((Object)racoms, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacoms", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}"})
    @Operation(summary="Carrega o RACOM de acordo com seu identificador")
    public ResponseEntity<Racom> getRacom(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            Racom racom = this.racomService.getRacomById(emp.getId(), idRacom);
            racom.setTipoRacom(null);
            return new ResponseEntity((Object)racom, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRacomById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra o RACOM")
    public ResponseEntity<Racom> registrarRacom(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String racsTxt;
            String planosAcaoTxt;
            String anexosTxt;
            String correcoesTxt;
            String causasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            Racom racom = (Racom)mapper.readValue(((String[])formData.get("racom"))[0], Racom.class);
            if (racom.getId() == null) {
                racom.setId(new RacomPK());
            }
            logger.debug("registrarRacom ({}))", (Object)racom);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (racom.getId().getIdEmpresa() == null) {
                    racom.getId().setIdEmpresa(emp.getId());
                }
            }
            List causas = null;
            if (formData.containsKey("causas") && !(causasTxt = ((String[])formData.get("causas"))[0]).isEmpty()) {
                causas = (List)mapper.readValue(causasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List correcoes = null;
            if (formData.containsKey("correcoes") && !(correcoesTxt = ((String[])formData.get("correcoes"))[0]).isEmpty()) {
                correcoes = (List)mapper.readValue(correcoesTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && !(anexosTxt = ((String[])formData.get("anexos"))[0]).isEmpty()) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List planosAcao = null;
            if (formData.containsKey("planosAcao") && !(planosAcaoTxt = ((String[])formData.get("planosAcao"))[0]).isEmpty()) {
                planosAcao = (List)mapper.readValue(planosAcaoTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List racs = null;
            if (formData.containsKey("racs") && !(racsTxt = ((String[])formData.get("racs"))[0]).isEmpty()) {
                racs = (List)mapper.readValue(racsTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            Racom racomDb = this.racomService.registrarRacom(racom, causas, planosAcao, correcoes, racs, usuario.getLogin());
            if (anexos != null) {
                for (RacomAnexo anexo : anexos) {
                    this.internalSaveAnexo(racomDb.getId().getIdEmpresa(), racomDb.getId().getIdRacom(), anexo, usuario.getLogin(), request);
                }
            }
            return new ResponseEntity((Object)racomDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarRacom", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarRacom", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}"})
    @Operation(summary="Exclui o RACOM atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteRacom(@PathVariable String empresa, @PathVariable Integer idRacom, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteRac({}, {})", (Object)empresa, (Object)idRacom);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deleteRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idRacom}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<RacomAnexo> createAnexoRacom(@PathVariable String empresa, @PathVariable Integer idRacom, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexo({},{})", (Object)empresa, (Object)idRacom);
            Map formData = request.getParameterMap();
            RacomAnexo anexo = new RacomAnexo();
            if (formData.containsKey("comentario")) {
                anexo.setComentario(((String[])formData.get("comentario"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomAnexo response = this.internalSaveAnexo(emp.getId(), idRacom, anexo, usuario.getLogin(), request);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private RacomAnexo internalSaveAnexo(Integer idEmpresa, Integer idRacom, RacomAnexo anexoRacom, String usuario, HttpServletRequest request) {
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        Map filesMap = multipartReq.getFileMap();
        if (filesMap != null && !filesMap.isEmpty()) {
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            for (String fileReqName : filesMap.keySet()) {
                MultipartFile file = multipartReq.getFile(fileReqName);
                logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                Anexo anexoGed = this.gedService.createAnexo(idEmpresa, TipoModulo.MEIO_AMBIENTE.getSigla(), "RACOM", file.getOriginalFilename(), "Anexos", null, file, user.getId(), LocalDateTime.now());
                anexoRacom.getId().setIdEmpresa(idEmpresa);
                anexoRacom.setIdAnexo(anexoGed.getId().getIdAnexo());
                anexoRacom.setAnexo(anexoGed);
            }
        }
        RacomAnexo anexoRacomDB = this.racomService.saveAnexoRacom(idEmpresa, idRacom, anexoRacom, usuario);
        return anexoRacomDB;
    }

    @GetMapping(value={"/{empresa}/{idRacom}/anexos"})
    @Operation(summary="Lista os anexos presentes no RACOM")
    public ResponseEntity<List<RacomAnexo>> findAnexosRacom(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findAnexosRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo do RACOM a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoRacom(@PathVariable String empresa, @PathVariable Integer idRacom, @PathVariable Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idRacom, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deleteAnexoRacom(emp.getId(), idRacom, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}/correcoes"})
    @Operation(summary="Lista as corre\u00e7\u00f5es presentes no RACOM")
    public ResponseEntity<List<RacomCorrecao>> findCorrecoesRacom(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findCorrecoesRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCorrecoesRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRacom}/correcoes"})
    @Operation(summary="Salva a corre\u00e7\u00e3o, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacomCorrecao> updateCorrecao(@PathVariable String empresa, @PathVariable Integer idRacom, @RequestBody RacomCorrecao correcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateCorrecao({},{})", (Object)idRacom, (Object)correcao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomCorrecao response = this.racomService.saveCorrecaoRacom(emp.getId(), idRacom, correcao, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}/correcoes/{seqCorrecao}"})
    @Operation(summary="Exclui a corre\u00e7\u00e3o do RACOM a partir de seu identificador")
    public ResponseEntity<Boolean> deleteCorrecao(@PathVariable String empresa, @PathVariable Integer idRacom, @PathVariable Integer seqCorrecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteCorrecao({}, {}, {})", new Object[]{empresa, idRacom, seqCorrecao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deleteCorrecaoRacom(emp.getId(), idRacom, seqCorrecao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados no RACOM")
    public ResponseEntity<List<RacomHistorico>> findHistoricosRac(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idRacom);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findHistoricosRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/logs"})
    @Operation(summary="Lista os hist\u00f3ricos registrados no RAC por intervalo")
    public ResponseEntity<List<RacomHistorico>> findLogsRac(@PathVariable String empresa, @RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal) {
        try {
            logger.debug("findLogsRac({})", (Object)empresa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findHistoricosRacomByIntervalo(emp.getId(), dataInicial, dataFinal), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRacom}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico do RACOM de acordo com o payload informado")
    public ResponseEntity<RacomHistorico> createHistoricoRac(@PathVariable String empresa, @PathVariable Integer idRacom, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistorico({},{})", (Object)empresa, (Object)idRacom);
            Map formData = request.getParameterMap();
            RacomHistorico anexo = new RacomHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomHistorico response = this.racomService.saveHistoricoRacom(emp.getId(), idRacom, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}/causas"})
    @Operation(summary="Lista as causas presentes no RACOM")
    public ResponseEntity<List<RacomCausa>> findCausasRacom(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findCausasRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCausasRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRacom}/causas"})
    @Operation(summary="Salva a causa, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacomCausa> updateCausa(@PathVariable String empresa, @PathVariable Integer idRacom, @RequestBody RacomCausa causa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateCausa({},{})", (Object)idRacom, (Object)causa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomCausa response = this.racomService.saveCausaRacom(emp.getId(), idRacom, causa, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCausa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}/causas/{seqCorrecao}"})
    @Operation(summary="Exclui a causa do RACOM a partir de seu identificador")
    public ResponseEntity<Boolean> deleteCausa(@PathVariable String empresa, @PathVariable Integer idRacom, @PathVariable Integer seqCorrecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteCausa({}, {}, {})", new Object[]{empresa, idRacom, seqCorrecao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deleteCausaRacom(emp.getId(), idRacom, seqCorrecao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCausa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}/planos"})
    @Operation(summary="Lista os planos de a\u00e7\u00e3o presentes no RACOM")
    public ResponseEntity<List<RacomPlanoAcao>> findPlanosAcao(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.findPlanosAcaoRacom(emp.getId(), idRacom), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanosAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRacom}/planos"})
    @Operation(summary="Salva o plano de a\u00e7\u00e3o, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacomPlanoAcao> updatePlano(@PathVariable String empresa, @PathVariable Integer idRacom, @RequestBody RacomPlanoAcao plano, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updatePlano({},{})", (Object)idRacom, (Object)plano);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomPlanoAcao response = this.racomService.savePlanosAcaoRacom(emp.getId(), idRacom, plano, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updatePlanoA\u00e7\u00e3o", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}/planos/{seqPlano}"})
    @Operation(summary="Exclui o plano de a\u00e7\u00e3o do RACOM a partir de seu identificador")
    public ResponseEntity<Boolean> deletePlanoAcaoRacom(@PathVariable String empresa, @PathVariable Integer idRacom, @PathVariable Integer seqPlano, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePlanoAcao({}, {}, {})", new Object[]{empresa, idRacom, seqPlano});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deletePlanosAcaoRacom(emp.getId(), idRacom, seqPlano, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAcaoRacom", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRacom}/racs"})
    @Operation(summary="Lista as racs presentes no RACOM")
    public ResponseEntity<List<RacomRac>> findRacs(@PathVariable String empresa, @PathVariable Integer idRacom) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List racoms = this.racomService.findRacsByRacom(emp.getId(), idRacom);
            for (RacomRac rac : racoms) {
                rac.getRac().setAnexos(null);
                rac.getRac().setCorrecoes(null);
                rac.getRac().setCidade(null);
                rac.getRac().setCoordenadorObra(null);
                rac.getRac().setEmpresa(null);
                rac.getRac().setSupervisorAmbiental(null);
                rac.getRac().setObra(null);
                rac.getRac().setDatHorAlteracao(null);
                rac.getRac().setDatHorCadastro(null);
                rac.getRac().setIdUsuarioIns(null);
                rac.getRac().setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)racoms, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRacom}/racs"})
    @Operation(summary="Salva a rac, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacomRac> updateRac(@PathVariable String empresa, @PathVariable Integer idRacom, @RequestBody RacomRac rac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateRac({},{})", (Object)idRacom, (Object)rac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacomRac response = this.racomService.saveRacomRac(emp.getId(), idRacom, rac, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRacom}/racs/{idRac}"})
    @Operation(summary="Exclui a rac do RACOM a partir de seu identificador")
    public ResponseEntity<Boolean> deleteRac(@PathVariable String empresa, @PathVariable Integer idRacom, @PathVariable Integer idRac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteRac({}, {}, {})", new Object[]{empresa, idRacom, idRac});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racomService.deleteRacomRac(emp.getId(), idRacom, idRac, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

