/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.RequisitoLegal;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para requisitos legais", name="ambiental")
@RequestMapping(value={"/api/requisitosLegais"})
public class RequisitosLegaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RequisitosLegaisRestServices.class);
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista os Requisitos Legais")
    public ResponseEntity<List<RequisitoLegal>> findRequisitosLegais(@PathVariable String empresa, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findRequisitosLegais...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findRequisitosLegais(searchTxt, null), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRequisitosLegais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/{idRequisito}"})
    @Operation(summary="Carrega o Requisito Legal pelo seu Identificador")
    public ResponseEntity<RequisitoLegal> getRequisitoLegal(@PathVariable String empresa, @PathVariable Integer idRequisito) {
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getRequisitoLegalById(idRequisito), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRequisitoLegal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva o Requisito Legal")
    public ResponseEntity<RequisitoLegal> saveRequisitoLegal(@PathVariable String empresa, @RequestBody RequisitoLegal requisitoLegal, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveRequisitoLegal ({}))", (Object)requisitoLegal);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveRequisitoLegal(requisitoLegal, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRequisitoLegal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRequisito}"})
    @Operation(summary="Exclui o Requisito Legal atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteRequisitoLegal(@PathVariable String empresa, @PathVariable Integer idRequisito) throws BusinessException {
        logger.debug("deleteRequisitoLegal({})", (Object)idRequisito);
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteRequisitoLegal(idRequisito), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRequisitoLegal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

