/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaLicenca;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Gravidade;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.PostRacExpiradasRequestVO;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.RacAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacAprovacao;
import br.com.oti.gesconsys.ambiental.beans.rac.RacCorrecao;
import br.com.oti.gesconsys.ambiental.beans.rac.RacEvento;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFicha;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFichaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFichaPK;
import br.com.oti.gesconsys.ambiental.beans.rac.RacHistorico;
import br.com.oti.gesconsys.ambiental.beans.rac.RacOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.RacOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.rac.RacPK;
import br.com.oti.gesconsys.ambiental.beans.rac.RacRequisitoLegal;
import br.com.oti.gesconsys.ambiental.beans.rac.RacRequisitoPK;
import br.com.oti.gesconsys.ambiental.beans.rac.RegraOuro;
import br.com.oti.gesconsys.ambiental.beans.rac.RequisitoLegal;
import br.com.oti.gesconsys.ambiental.beans.rac.ResumoLogRacVO;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.ambiental.beans.rac.UpdateFichaAmbientalVO;
import br.com.oti.gesconsys.ambiental.dao.rac.GravidadeDAO;
import br.com.oti.gesconsys.beans.core.FiltroDinamico;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailConteudo;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoStatusEmail;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.licencas.LicencaObraVO;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.shared.Obra;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.helpers.HashUtil;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.CheckListService;
import br.com.oti.gesconsys.business.services.FichaAmbientalService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.RacService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.dao.core.EmailDAO;
import br.com.oti.gesconsys.dao.core.RefCodeDAO;
import br.com.oti.gesconsys.dao.seguranca.UsuarioDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.beans.TipoStatusGed;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasRacsPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRacExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRacPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para racs", name="ambiental")
@RequestMapping(value={"/api/racs"})
public class RacsRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(RacsRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RacService racService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private FichaAmbientalService fichaAmbientalService;
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    private RelatorioRacExcel relatorioRacExcel;
    @Autowired
    private RelatorioRacPdf relatorioRacPdf;
    @Autowired
    private RelatorioMultiplasRacsPdf relatorioMultiplasRacPdf;
    @Autowired
    private GravidadeDAO gravidadeDAO;
    @Autowired
    private EmailDAO emailDAO;
    @Autowired
    private UsuarioDAO usuarioDAO;
    @Autowired
    private RefCodeDAO refCodeDAO;

    @PostMapping(value={"/{empresa}/filtros"})
    @Operation(summary="Retorna os RAC dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<Page<Rac>> findRacs(@PathVariable String empresa, @RequestBody FiltroRac filtroRac, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = false;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - findRacs ({}, pg={},sz={},fld={},desc={})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroRac == null) {
                filtroRac = new FiltroRac();
            }
            if (filtroRac.getConcessionaria() == null || filtroRac.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroRac.setConcessionaria(empList);
            }
            boolean joinAnexos = true;
            if (request.getParameter("anexos") != null) {
                joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
            }
            boolean joinOcorrencias = false;
            boolean fetch = true;
            Page racs = this.racService.findRacs(filtroRac, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(fetch), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias));
            for (Rac rac : racs.getContent()) {
                RacEvento evtRac = rac.getEvento();
                if (evtRac != null) {
                    evtRac.setRac(null);
                }
                Empresa empRac = rac.getEmpresa();
                if (rac.getEmpresa() != null) {
                    empRac = new Empresa();
                    empRac.setId(rac.getEmpresa().getId());
                    empRac.setSigla(rac.getEmpresa().getSigla());
                    empRac.setRazaoSocial(rac.getEmpresa().getRazaoSocial());
                    empRac.setNomeFantasia(rac.getEmpresa().getNomeFantasia());
                    rac.setEmpresa(empRac);
                }
                if (rac.getGravidade() != null) {
                    Gravidade gvd = rac.getGravidade();
                    gvd.setDatHorCadastro(null);
                    gvd.setIdUsuarioIns(null);
                    gvd.setDatHorAlteracao(null);
                    gvd.setIdUsuarioUpd(null);
                }
                if (rac.getRodovia() != null) {
                    Rodovia rdv = rac.getRodovia();
                    rdv.setEmpresa(null);
                    rac.setRodovia(rdv);
                }
                if (rac.getObra() != null) {
                    Obra obr = rac.getObra();
                    obr.setDatHorCadastro(null);
                    obr.setIdUsuarioIns(null);
                    obr.setDatHorAlteracao(null);
                    obr.setIdUsuarioUpd(null);
                }
                if (rac.getAnexos() != null) {
                    for (RacAnexo anx : rac.getAnexos()) {
                        anx.setRac(null);
                        anx.setUsuario(null);
                    }
                }
                if (rac.getFichaAtual() != null) {
                    rac.getFichaAtual().setRac(null);
                }
                if (rac.getFichasRac() != null) {
                    for (RacFicha ficha : rac.getFichasRac()) {
                        ficha.setRac(null);
                        ficha.setCorrecoes(null);
                    }
                }
                if (rac.getFichasRacAnexo() != null) {
                    for (RacFichaAnexo fichaAnx : rac.getFichasRacAnexo()) {
                        fichaAnx.setRac(null);
                        fichaAnx.setUsuario(null);
                    }
                }
                if (rac.getOcorrencias() == null) continue;
                for (RacOcorrencia ocorr : rac.getOcorrencias()) {
                    ocorr.setRac(null);
                    ocorr.setUsuario(null);
                }
            }
            return new ResponseEntity((Object)racs, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}"})
    @Operation(summary="Carrega o RAC de acordo com seu identificador")
    public ResponseEntity<Rac> getRac(@PathVariable String empresa, @PathVariable Integer idRac, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getRac ({}, {})...", new Object[]{usuario.getLogin(), empresa, idRac});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            Rac rac = this.racService.getRacById(empresa, idRac);
            rac.getRodovia().setIdUsuarioIns(null);
            rac.getRodovia().setDatHorAlteracao(null);
            rac.getRodovia().setDatHorCadastro(null);
            rac.getRodovia().setEmpresa(null);
            rac.getRodovia().setIdUsuarioIns(null);
            rac.getRodovia().setIdUsuarioUpd(null);
            rac.getCoordenadorObra().setDatHorAlteracao(null);
            rac.getCoordenadorObra().setDatHorCadastro(null);
            rac.getCoordenadorObra().setDatHorUltimoLogin(null);
            rac.getCoordenadorObra().setGrupos(null);
            rac.getCoordenadorObra().setIdPoderConcedente(null);
            rac.getCoordenadorObra().setIdUsuarioIns(null);
            rac.getCoordenadorObra().setIdUsuarioUpd(null);
            rac.getCoordenadorObra().setSessionUUID(null);
            rac.getEquipeAmbiental().setDatHorAlteracao(null);
            rac.getEquipeAmbiental().setDatHorCadastro(null);
            rac.getEquipeAmbiental().setIdEmpresa(null);
            rac.getEquipeAmbiental().setIdUsuarioIns(null);
            rac.getEquipeAmbiental().setIdUsuarioUpd(null);
            rac.getEquipeConcessao().setDatHorAlteracao(null);
            rac.getEquipeConcessao().setDatHorCadastro(null);
            rac.getEquipeConcessao().setIdEmpresa(null);
            rac.getEquipeConcessao().setIdUsuarioIns(null);
            rac.getEquipeConcessao().setIdUsuarioUpd(null);
            rac.getEquipeEmpreiteira().setDatHorAlteracao(null);
            rac.getEquipeEmpreiteira().setDatHorCadastro(null);
            rac.getEquipeEmpreiteira().setIdEmpresa(null);
            rac.getEquipeEmpreiteira().setIdUsuarioIns(null);
            rac.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            RacEvento evtRac = rac.getEvento();
            if (evtRac != null) {
                evtRac.setRac(null);
            }
            return new ResponseEntity((Object)rac, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRacById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra o RAC")
    public ResponseEntity<Rac> registrarRac(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            String licencasTxt;
            String anexosTxt;
            String regrasOuroTxt;
            String correcoesTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Rac rac = (Rac)mapper.readValue(((String[])formData.get("rac"))[0], Rac.class);
            if (rac.getId() == null) {
                rac.setId(new RacPK());
            }
            logger.debug("registrarRac ({}))", (Object)rac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (rac.getId().getIdEmpresa() == null) {
                    rac.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && !(ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).isEmpty()) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List correcoes = null;
            if (formData.containsKey("correcoes") && !(correcoesTxt = ((String[])formData.get("correcoes"))[0]).isEmpty()) {
                correcoes = (List)mapper.readValue(correcoesTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List regrasOuro = null;
            if (formData.containsKey("regrasOuro") && !(regrasOuroTxt = ((String[])formData.get("regrasOuro"))[0]).isEmpty()) {
                regrasOuro = (List)mapper.readValue(regrasOuroTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && !(anexosTxt = ((String[])formData.get("anexos"))[0]).isEmpty()) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            LicencaObraVO licencas = null;
            if (formData.containsKey("licencas") && !(licencasTxt = ((String[])formData.get("licencas"))[0]).isEmpty()) {
                licencas = (LicencaObraVO)mapper.readValue(licencasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            formData.forEach((key, value) -> {
                System.out.println("Chave: " + key);
                for (String item : value) {
                    System.out.println("Valor: " + item);
                }
            });
            Integer idSupervisorAmbiental = null;
            if (rac.getIdSupervisorAmbiental() != null) {
                idSupervisorAmbiental = rac.getIdSupervisorAmbiental();
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            Rac racDb = this.racService.registrarRac(empresa, rac, ocorrencias, correcoes, regrasOuro, anexos, licencas, idSupervisorAmbiental, usuario.getLogin(), filesMap);
            List requisitosLegaisLst = null;
            if (formData.containsKey("requisitosLegais")) {
                String requisitosLegaisTxt = ((String[])formData.get("requisitosLegais"))[0];
                if (!requisitosLegaisTxt.isEmpty()) {
                    requisitosLegaisLst = (List)mapper.readValue(requisitosLegaisTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (requisitosLegaisLst != null && !requisitosLegaisLst.isEmpty()) {
                    for (RacRequisitoLegal req : requisitosLegaisLst) {
                        this.racService.saveRequisitoLegalRac(empresa, racDb.getId().getIdRac(), req, usr.getLogin());
                    }
                }
            }
            return new ResponseEntity((Object)racDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarRac", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarRac", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}"})
    @Operation(summary="Exclui o RAC atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteRac(@PathVariable String empresa, @PathVariable Integer idRac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteRac({}, {})", (Object)empresa, (Object)idRac);
        try {
            return new ResponseEntity((Object)this.racService.deleteRac(empresa, idRac, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idRac}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<RacAnexo>> createAnexoRac(@PathVariable String empresa, @PathVariable Integer idRac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexoRac({}, {})", (Object)empresa, (Object)idRac);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<RacAnexo> anexos = new ArrayList<RacAnexo>();
            for (MultipartFile file : filesMap) {
                RacAnexo anexo = new RacAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexo.setFichaOrigem("RAC");
                anexos.add(anexo);
            }
            List response = this.racService.createAnexoRac(empresa, idRac, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/anexos"})
    @Operation(summary="Lista os anexos presentes no RAC")
    public ResponseEntity<List<RacAnexo>> findAnexosRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.findAnexosRac(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo do RAC a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idRac, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.deleteAnexoRac(emp.getId(), idRac, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRac}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacOcorrencia> updateOcorrenciaRac(@PathVariable String empresa, @PathVariable Integer idRac, @RequestBody RacOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrencia({},{})", (Object)idRac, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdRac() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            RacOcorrencia response = this.racService.saveOcorrenciaRac(empresa, idRac, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo do RAC a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer idOcorrencia, @PathVariable Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrencia({}, {}, {}, {})", new Object[]{empresa, idRac, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.deleteOcorrenciaRac(emp.getId(), idRac, idOcorrencia, idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/correcoes"})
    @Operation(summary="Lista as corre\u00e7\u00f5es presentes no RAC")
    public ResponseEntity<List<RacCorrecao>> findCorrecoesRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.findCorrecoesRac(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCorrecoesRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRac}/correcoes"})
    @Operation(summary="Salva a corre\u00e7\u00e3o, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<RacCorrecao> updateCorrecao(@PathVariable String empresa, @PathVariable Integer idRac, @RequestBody RacCorrecao correcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateCorrecao({},{})", (Object)idRac, (Object)correcao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacCorrecao response = this.racService.saveCorrecaoRac(empresa, idRac, correcao, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}/correcoes/{seqCorrecao}"})
    @Operation(summary="Exclui o anexo do RAC a partir de seu identificador")
    public ResponseEntity<Boolean> deleteCorrecao(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqCorrecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteCorrecao({}, {}, {})", new Object[]{empresa, idRac, seqCorrecao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.deleteCorrecaoRac(emp.getId(), idRac, seqCorrecao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas ao RAC")
    public ResponseEntity<Map<String, Object>> findOcorrenciasRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.cadastroAmbientalService.findOcorrencias(null, null);
            List racOcorrencias = this.racService.findOcorrenciasRac(emp.getId(), idRac);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<RacOcorrenciaPK> soluAssocList = new ArrayList<RacOcorrenciaPK>();
            for (RacOcorrencia racOcorre : racOcorrencias) {
                if (!mapSoluOcorre.containsKey(racOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(racOcorre.getId().getIdOcorrencia(), racOcorre.getOcorrencia());
                }
                soluAssocList.add(racOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idRac}/fichas"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a ficha do RAC")
    public ResponseEntity<RacFicha> registrarFichaRac(@PathVariable String empresa, @PathVariable Integer idRac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("ficha")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Informa\u00e7\u00e3o da ficha n\u00e3o dispon\u00edvel.");
            }
            RacFicha ficha = (RacFicha)mapper.readValue(((String[])formData.get("ficha"))[0], RacFicha.class);
            if (ficha.getId() == null) {
                ficha.setId(new RacFichaPK());
            }
            if (ficha.getId().getIdRac() == null) {
                ficha.getId().setIdRac(idRac);
            }
            logger.debug("registrarFichaRac ({}))", (Object)ficha);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (ficha.getId().getIdEmpresa() == null) {
                    ficha.getId().setIdEmpresa(emp.getId());
                }
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List correcoes = ficha.getCorrecoes();
            if (anexos != null) {
                for (RacFichaAnexo anexo : anexos) {
                    if (anexo.getAnexo() != null && anexo.getAnexo().getNome() != null) continue;
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Anexo da ficha '%s' inv\u00e1lido, verifique estrutura.", anexo.getComentario()));
                }
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            RacFicha fichaDb = this.racService.registrarFichaRac(empresa, ficha, usuario.getLogin(), correcoes, anexos, filesMap);
            return new ResponseEntity((Object)fichaDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarRac", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarRac", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/fichas"})
    @Operation(summary="Lista as fichas presentes no RAC")
    public ResponseEntity<List<RacFicha>> findFichasRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.findFichasRac(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFichasRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/fichas/{seqFicha}"})
    @Operation(summary="Carrega a fichas selecionada do RAC")
    public ResponseEntity<RacFicha> getFichaRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqFicha) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacFicha ficha = this.racService.getFichaRacById(emp.getId(), idRac, seqFicha);
            return new ResponseEntity((Object)ficha, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFichaRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}/fichas/{seqFicha}"})
    @Operation(summary="Exclui a ficha do RAC atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteFichaRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteFichaRac({}, {}, {})", new Object[]{empresa, idRac, seqFicha});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.deleteFichaRac(emp.getId(), idRac, seqFicha, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFichaRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/fichas/{seqFicha}/anexos"})
    @Operation(summary="Lista os anexos presentes na ficha da RAC")
    public ResponseEntity<List<RacFichaAnexo>> findAnexosFichaRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqFicha) {
        try {
            logger.debug("findAnexosFichaRac({}, {}, {})", new Object[]{empresa, idRac, seqFicha});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List anexos = this.racService.findAnexosFichaRac(emp.getId(), idRac, seqFicha);
            logger.debug("anexos.size=> {}", (Object)anexos.size());
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idFicha}/{seqFicha}/fichas/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<RacFichaAnexo>> createAnexoFichaRac(@PathVariable String empresa, @PathVariable Integer idFicha, @PathVariable Integer seqFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexo({},{})", (Object)empresa, (Object)idFicha);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<RacFichaAnexo> anexos = new ArrayList<RacFichaAnexo>();
            for (MultipartFile file : filesMap) {
                RacFichaAnexo anexo = new RacFichaAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.racService.createAnexoFichaRac(emp.getId(), idFicha, seqFicha, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRac}/fichas/{seqFicha}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Ficha do RAC a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoFichaRac(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer seqFicha, @PathVariable Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexoFichaRac({},{},{},{})", new Object[]{empresa, idRac, seqFicha, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.deleteAnexoFichaRac(emp.getId(), idRac, seqFicha, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoFichaRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados no RAC")
    public ResponseEntity<List<RacHistorico>> findHistoricosRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idRac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.racService.findHistoricosRac(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/logs"})
    @Operation(summary="Lista o Resumo dos Logs da RAC, registrados por intervalo")
    public ResponseEntity<ResumoLogRacVO> findLogsRac(@PathVariable String empresa, @RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal) {
        try {
            logger.debug("findLogsRac({})", (Object)empresa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List historicos = this.racService.findHistoricosRacByIntervalo(empresa, dataInicial, dataFinal);
            List racs = this.racService.findUltimasRacs(empresa, Integer.valueOf(5));
            return new ResponseEntity((Object)new ResumoLogRacVO(historicos, racs), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLogsRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRac}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico do RAC de acordo com o payload informado")
    public ResponseEntity<RacHistorico> createHistoricoRac(@PathVariable String empresa, @PathVariable Integer idRac, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistorico({},{})", (Object)empresa, (Object)idRac);
            Map formData = request.getParameterMap();
            String descricao = null;
            if (formData.containsKey("descricao")) {
                descricao = ((String[])formData.get("descricao"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            RacHistorico response = this.racService.createHistoricoRac(emp.getId(), idRac, descricao, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRac}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da RAC (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar RAC, Reabrir RAC)")
    public ResponseEntity<RacEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            RacEvento evento;
            logger.debug("executeEvento({},{},{})", new Object[]{empresa, idRac, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer ordemAprovacao = null;
            if (request.getParameter("ordemAprovacao") != null) {
                try {
                    ordemAprovacao = Integer.valueOf(request.getParameter("ordemAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    ordemAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.racService.enviarAprovacaoRac(empresa, idRac, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.racService.aprovarRac(empresa, idRac, ordemAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.racService.reprovarRac(empresa, idRac, ordemAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.racService.encerrarRac(empresa, idRac, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.racService.finalizarRac(empresa, idRac, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.racService.naoFinalizarRac(empresa, idRac, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.racService.reabrirRac(empresa, idRac, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.racService.cancelarRac(empresa, idRac, usuario.getLogin(), descricao, perfilReprovar);
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            evento.setRac(null);
            return new ResponseEntity((Object)evento, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download da rac em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable String empresa, @RequestBody FiltroRac filtroRac) {
        logger.debug("Exportando excel, rac (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroRac == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtroRac.getConcessionaria() == null || filtroRac.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtroRac.setConcessionaria(empList);
        }
        try {
            boolean joinAnexos = false;
            boolean joinOcorrencias = true;
            Page racs = this.racService.findRacs(filtroRac, 1, 5000, null, null, Boolean.valueOf(false), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias));
            StreamingResponseBody responseBody = response -> response.write(this.relatorioRacExcel.executeXLS(racs.getContent(), filtroRac.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"racs.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados no RAC")
    public ResponseEntity<List<RacAprovacao>> findAprovacoesRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idRac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.racService.findAprovacoesRac(emp.getId(), idRac);
            return new ResponseEntity((Object)aprovacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoesRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idRac}/exportacaoPdf"})
    @Operation(summary="Efetua o download da rac em PDF")
    public ResponseEntity<StreamingResponseBody> exportaRacPdf(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idRac) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Exportando rac em pdf (emp={}, rac={})...", new Object[]{usuario.getLogin(), empresa, idRac});
        try {
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Rac rac = this.racService.getRacById(empresa, idRac);
            if (rac == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Rac n\u00e3o encontrada.");
            }
            StreamingResponseBody responseBody = response -> {
                String tipoMapa = request.getParameter("tipoMapa");
                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                byte[] mapaGoogle = this.getMapaEstatico(rac.getLatitude(), rac.getLongitude(), tipoMapa);
                response.write(this.relatorioRacPdf.executePdf(emp.getId(), rac, mapaGoogle, false, usuario.getLogin()));
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"rac.pdf\""})).contentType(MediaType.APPLICATION_PDF).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/exportaPdfExterno/{hash}"})
    @Operation(summary="Efetua o download da rac em PDF via link em email")
    public ResponseEntity<StreamingResponseBody> exportaRacPdfLinkEmail(@PathVariable String hash) {
        String[] decodedHash = HashUtil.unhashValues((String)hash);
        String siglaEmpresa = decodedHash[0];
        int idUsuario = Integer.parseInt(decodedHash[1]);
        int idRac = Integer.parseInt(decodedHash[2]);
        logger.debug(" Exportando rac em pdf via link email, (emp={}, rac={})...", (Object)siglaEmpresa, (Object)idRac);
        try {
            if (siglaEmpresa == null || siglaEmpresa.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(siglaEmpresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Rac rac = this.racService.getRacById(siglaEmpresa, Integer.valueOf(idRac));
            if (rac == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Rac n\u00e3o encontrada.");
            }
            Usuario usuario = this.segurancaService.getUsuarioById(Integer.valueOf(idUsuario));
            StreamingResponseBody responseBody = response -> {
                byte[] mapaGoogle = this.getMapaEstatico(rac.getLatitude(), rac.getLongitude(), "satellite");
                this.racService.createHistoricoRac(emp.getId(), Integer.valueOf(idRac), "RAC visualizada via email", usuario.getLogin());
                response.write(this.relatorioRacPdf.executePdf(emp.getId(), rac, mapaGoogle, false, usuario.getLogin()));
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"rac.pdf\""})).contentType(MediaType.APPLICATION_PDF).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacoes/racs"})
    @Operation(summary="Efetua o download da racs em PDF integrado")
    public ResponseEntity<StreamingResponseBody> exportaRacPdf(HttpServletRequest request, @PathVariable String empresa, @RequestBody UpdateFichaAmbientalVO racVO) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        int racsSize = racVO != null ? racVO.getIds().size() : 0;
        logger.debug("{} - Exportando RACS em pdf (emp={}, racs={})...", new Object[]{usuario.getLogin(), empresa, racsSize});
        try {
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            FiltroRac filtro = new FiltroRac();
            filtro.getConcessionaria().add(emp.getId());
            filtro.setIds(racVO.getIds());
            boolean joinAnexos = true;
            if (request.getParameter("anexos") != null) {
                joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
            }
            boolean joinOcorrencias = false;
            boolean fetch = true;
            Page racs = this.racService.findRacs(filtro, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(fetch), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias));
            if (racs == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Rac n\u00e3o encontrada.");
            }
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            HashMap mapas = new HashMap();
            logger.debug("Carregando Mapas das RACS...");
            logger.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
            StreamingResponseBody responseBody = response -> response.write(this.relatorioMultiplasRacPdf.executePdf(emp.getId(), racs.getContent(), false, usuario.getLogin()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"racs.pdf\""})).contentType(MediaType.APPLICATION_PDF).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude, longitude), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @GetMapping(value={"/{empresa}/{idRac}/requisitosLegais"})
    @Operation(summary="Lista os requisitos legais associados ao RAC")
    public ResponseEntity<Map<String, Object>> findRequisitosLegaisRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List requisitosBase = this.cadastroAmbientalService.findRequisitosLegais(null, null);
            List racRequisitos = this.racService.findRequisitosLegaisRac(emp.getId(), idRac);
            HashMap<Integer, RequisitoLegal> mapRequisito = new HashMap<Integer, RequisitoLegal>();
            ArrayList<RequisitoLegal> associados = new ArrayList<RequisitoLegal>();
            ArrayList<RacRequisitoPK> requiAssocList = new ArrayList<RacRequisitoPK>();
            for (RacRequisitoLegal itemReq : racRequisitos) {
                if (!mapRequisito.containsKey(itemReq.getId().getIdRequisito())) {
                    mapRequisito.put(itemReq.getId().getIdRequisito(), itemReq.getRequisito());
                }
                requiAssocList.add(itemReq.getId());
            }
            for (int idxReq = 0; idxReq < requisitosBase.size(); ++idxReq) {
                RequisitoLegal base = (RequisitoLegal)requisitosBase.get(idxReq);
                if (!mapRequisito.containsKey(base.getId())) continue;
                requisitosBase.remove(idxReq);
                idxReq = 0;
            }
            for (Integer idOcorre : mapRequisito.keySet()) {
                associados.add((RequisitoLegal)mapRequisito.get(idOcorre));
            }
            HashMap<String, List> mapReqData = new HashMap<String, List>();
            mapReqData.put("associados", associados);
            mapReqData.put("disponiveis", requisitosBase);
            return new ResponseEntity(mapReqData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRequisitosLegaisRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/regrasOuro"})
    @Operation(summary="Lista as regras de ouro")
    public ResponseEntity<List<RegraOuro>> findRegrasOuro(HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findRegrasOuro ({}))", (Object)usuario.getLogin());
            List regras = this.cadastroAmbientalService.findRegrasOuro(null, null);
            return new ResponseEntity((Object)regras, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRegrasOuro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/mobile/filtro"})
    @Operation(summary="Retorna todas RAC dispon\u00edveis, de acordo com a empresa e filtro definido")
    public ResponseEntity<Page<Rac>> findRacsMobile(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = false;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - findRacsMobile ({}, pg={},sz={},fld={},desc={})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            FiltroRac filtroRac = new FiltroRac();
            Page racs = this.racService.findRacsMobile(filtroRac, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), empresa, Boolean.valueOf(false));
            if (racs != null && !racs.isEmpty()) {
                for (Rac rac : racs) {
                    RacEvento evtRac = rac.getEvento();
                    if (evtRac != null) {
                        evtRac.setRac(null);
                        evtRac.setUsuario(null);
                    }
                    Empresa empRac = rac.getEmpresa();
                    if (rac.getEmpresa() != null) {
                        empRac = new Empresa();
                        empRac.setId(rac.getEmpresa().getId());
                        empRac.setSigla(rac.getEmpresa().getSigla());
                        empRac.setRazaoSocial(rac.getEmpresa().getRazaoSocial());
                        empRac.setNomeFantasia(rac.getEmpresa().getNomeFantasia());
                        rac.setEmpresa(empRac);
                    }
                    if (rac.getRodovia() != null) {
                        Rodovia rdv = rac.getRodovia();
                        rdv.setEmpresa(null);
                        rac.setRodovia(rdv);
                    }
                    rac.setFichaAtual(null);
                    if (rac.getFichasRac() != null) {
                        for (RacFicha ficha : rac.getFichasRac()) {
                            ficha.setRac(null);
                            ficha.setUsuario(null);
                        }
                    }
                    if (rac.getOcorrencias() != null) {
                        for (RacOcorrencia ocorr : rac.getOcorrencias()) {
                            ocorr.setRac(null);
                            ocorr.setUsuario(null);
                        }
                    }
                    if (rac.getCorrecoes() != null) {
                        for (RacCorrecao corr : rac.getCorrecoes()) {
                            corr.setRac(null);
                            corr.setUsuario(null);
                        }
                    }
                    if (rac.getRegrasOuro() != null) {
                        for (RacCorrecao corr : rac.getRegrasOuro()) {
                        }
                    }
                    if (rac.getAnexos() != null) {
                        for (RacAnexo anx : rac.getAnexos()) {
                            anx.setRac(null);
                            anx.setUsuario(null);
                            if (anx.getAnexo() == null) continue;
                            anx.getAnexo().setDescricao(null);
                            anx.getAnexo().setHierarquia(null);
                            anx.getAnexo().setRepoPath(null);
                            anx.getAnexo().setIdProprietario(null);
                            anx.getAnexo().setStatusGed(null);
                            anx.getAnexo().setDatHorUpload(null);
                            anx.getAnexo().setUsuario(null);
                        }
                    }
                    if (rac.getFichasRacAnexo() == null) continue;
                    for (RacFichaAnexo anxFicha : rac.getFichasRacAnexo()) {
                        anxFicha.setRac(null);
                        anxFicha.setUsuario(null);
                        if (anxFicha.getAnexo() == null) continue;
                        anxFicha.getAnexo().setDescricao(null);
                        anxFicha.getAnexo().setHierarquia(null);
                        anxFicha.getAnexo().setRepoPath(null);
                        anxFicha.getAnexo().setStatusGed(null);
                        anxFicha.getAnexo().setDatHorUpload(null);
                        anxFicha.getAnexo().setIdProprietario(null);
                        anxFicha.getAnexo().setUsuario(null);
                    }
                }
            }
            return new ResponseEntity((Object)racs, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/mobile/anexos-old"})
    @Operation(summary="Lista os arquivos compactados gerados, com tamanho de 500mb ou conforme tamanho definido via par\u00e2metro.")
    public ResponseEntity<List<String>> findRacsAnexosMobileOld(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findRacsAnexosMobile ({})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            String pathLeitura = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_PATH_LEITURA);
            if (pathLeitura == null || pathLeitura.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Reposit\u00f3rio leitura n\u00e3o foi informado, imposs\u00edvel prosseguir.");
            }
            ArrayList<String> zipFiles = new ArrayList<String>();
            List anexosRacs = this.gedService.findAnexosByModulo(emp.getId(), TipoModulo.MEIO_AMBIENTE, "RAC", null, null);
            int bufferSize = 0;
            int seqImg = 0;
            ZipOutputStream zipStream = null;
            for (Anexo anexo : anexosRacs) {
                if (anexo.getStatusGed() != null && anexo.getStatusGed().equals(TipoStatusGed.PROCESSADO.getCode()) && anexo.getStatusGed().equals(TipoStatusGed.PENDENTE.getCode())) continue;
                try {
                    int length;
                    InputStream fis = this.gedService.getStreamByUUID(emp.getId(), anexo.getUuid(), null);
                    if (fis == null) {
                        logger.error("Arquivo n\u00e3o encontrado ('{}').", (Object)anexo.getNome());
                        continue;
                    }
                    BufferedImage originalImg = ImageIO.read(fis);
                    fis.close();
                    boolean landscape = originalImg.getWidth() < originalImg.getHeight();
                    String targetPath = this.gedService.extractPath(pathLeitura, anexo, Boolean.valueOf(true));
                    File targetFile = new File(targetPath);
                    String extensao = anexo.getExtensao().toLowerCase();
                    if (extensao.equals("jpg") && !extensao.equals("png")) {
                        extensao = "jpg";
                    }
                    long sizeMb = 0L;
                    if (targetFile.exists()) {
                        byte[] bytes = Files.readAllBytes(Paths.get(targetPath, new String[0]));
                        sizeMb = (long)bytes.length / 0x100000L;
                    } else {
                        ByteArrayOutputStream baos;
                        boolean written = targetFile.mkdirs();
                        if (!written) {
                            logger.error("Erro criando diret\u00f3rios. Verifique permiss\u00f5es.");
                            continue;
                        }
                        BufferedImage scaledImg = landscape ? this.getScaledImage(originalImg, 768, 1024) : this.getScaledImage(originalImg, 1024, 768);
                        written = ImageIO.write((RenderedImage)scaledImg, extensao, baos = new ByteArrayOutputStream());
                        if (!written) {
                            logger.error("Erro gravando arquivo. Verifique permiss\u00f5es.");
                            continue;
                        }
                        byte[] bytes = baos.toByteArray();
                        baos.close();
                        sizeMb = (long)bytes.length / 0x100000L;
                    }
                    if (bufferSize == 0 || bufferSize > 250) {
                        String zipFileName = String.format("/tmp/anexos-racs-%s-%03d.zip", emp.getSigla().toLowerCase(), ++seqImg);
                        FileOutputStream fos = new FileOutputStream(zipFileName);
                        zipStream = new ZipOutputStream(fos);
                    }
                    bufferSize = (int)((long)bufferSize + sizeMb);
                    ZipEntry zipEntry = new ZipEntry(targetPath);
                    zipStream.putNextEntry(zipEntry);
                    fis = new FileInputStream(targetFile);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipStream.write(bytes, 0, length);
                    }
                    zipStream.closeEntry();
                    fis.close();
                }
                catch (IOException ioExc) {
                    logger.error("IOExc read getFile", (Throwable)ioExc);
                }
            }
            zipFiles.add(String.format("anexos-racs-%s-001.zip", emp.getSigla().toLowerCase()));
            return new ResponseEntity(zipFiles, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private BufferedImage getScaledImage(BufferedImage image, int width, int height) throws IOException {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        return bilinearScaleOp.filter(image, new BufferedImage(width, height, image.getType()));
    }

    @PostMapping(path={"/{empresa}/{idRac}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo/Anexo Ficha da RAC")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable String empresa, @PathVariable Integer idRac, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idRac});
            this.racService.saveComentarioAnexoRac(empresa, idRac, anexoFicha.getSeqAnexo(), anexoFicha.getSeqFicha(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idRac}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable String empresa, @PathVariable Integer idRac, @PathVariable Integer idAnexo, @PathVariable Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idRac, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna os RAC dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<Page<Rac>> findRacs(@PathVariable String empresa, @RequestBody List<FiltroDinamico> filtroRac, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = false;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - findRacs ({}, pg={},sz={},fld={},desc={})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ArrayList<Integer> empList = new ArrayList<Integer>();
            for (FiltroDinamico filtro : filtroRac) {
                if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                    empList.add(emp.getId());
                    filtro.setConcessionaria(empList);
                }
                filtro.setConcessionaria(null);
            }
            boolean joinAnexos = true;
            if (request.getParameter("anexos") != null) {
                joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
            }
            boolean joinOcorrencias = false;
            boolean fetch = true;
            Page racs = this.fichaAmbientalService.findFichasByFilter(empList, "RAC", filtroRac, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(fetch), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias), null);
            for (Object item : racs.getContent()) {
                Rac rac = (Rac)item;
                RacEvento evtRac = rac.getEvento();
                if (evtRac != null) {
                    evtRac.setRac(null);
                }
                Empresa empRac = rac.getEmpresa();
                if (rac.getEmpresa() != null) {
                    empRac = new Empresa();
                    empRac.setId(rac.getEmpresa().getId());
                    empRac.setSigla(rac.getEmpresa().getSigla());
                    empRac.setRazaoSocial(rac.getEmpresa().getRazaoSocial());
                    empRac.setNomeFantasia(rac.getEmpresa().getNomeFantasia());
                    rac.setEmpresa(empRac);
                }
                if (rac.getGravidade() != null) {
                    Gravidade gvd = rac.getGravidade();
                    gvd.setDatHorCadastro(null);
                    gvd.setIdUsuarioIns(null);
                    gvd.setDatHorAlteracao(null);
                    gvd.setIdUsuarioUpd(null);
                }
                if (rac.getRodovia() != null) {
                    Rodovia rdv = rac.getRodovia();
                    rdv.setEmpresa(null);
                    rac.setRodovia(rdv);
                }
                if (rac.getObra() != null) {
                    Obra obr = rac.getObra();
                    obr.setDatHorCadastro(null);
                    obr.setIdUsuarioIns(null);
                    obr.setDatHorAlteracao(null);
                    obr.setIdUsuarioUpd(null);
                }
                if (rac.getAnexos() != null) {
                    for (RacAnexo anx : rac.getAnexos()) {
                        anx.setRac(null);
                        anx.setUsuario(null);
                    }
                }
                if (rac.getFichaAtual() != null) {
                    rac.getFichaAtual().setRac(null);
                }
                if (rac.getFichasRac() != null) {
                    for (RacFicha ficha : rac.getFichasRac()) {
                        ficha.setRac(null);
                        ficha.setCorrecoes(null);
                    }
                }
                if (rac.getFichasRacAnexo() != null) {
                    for (RacFichaAnexo fichaAnx : rac.getFichasRacAnexo()) {
                        fichaAnx.setRac(null);
                        fichaAnx.setUsuario(null);
                    }
                }
                if (rac.getOcorrencias() == null) continue;
                for (RacOcorrencia ocorr : rac.getOcorrencias()) {
                    ocorr.setRac(null);
                    ocorr.setUsuario(null);
                }
            }
            return new ResponseEntity((Object)racs, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/multiplas"})
    @Operation(summary="Efetua o download da RAC em Excel")
    public void multiUpdate(@PathVariable String empresa, @RequestBody UpdateFichaAmbientalVO racs) {
        logger.debug("Iniciando multiUpdate(emp={}, {})...", (Object)empresa, (Object)racs);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            this.racService.updateMultiRacs(emp.getId(), racs);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/licencas"})
    @Operation(summary="Lista as licen\u00e7as registradas no RAC")
    public ResponseEntity<List<FichaLicenca>> findFichasLicencaByRac(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            logger.debug("findFichasLicencaByRac({},{})", (Object)empresa, (Object)idRac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            return new ResponseEntity((Object)this.licencaService.findFichasLicencaByFicha(emp.getId(), idRac, "RAC"), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFichasLicencaByRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/checklistItems"})
    @Operation(summary="Lista as licen\u00e7as registradas no RAC")
    public ResponseEntity<Set<CheckListItem>> findCheckListItemsByRacId(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            logger.debug("findCheckListItemsByRacId({},{})", (Object)empresa, (Object)idRac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            return new ResponseEntity((Object)this.checkListService.findCheckListItemsByRacId(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCheckListItemsByRacId", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idRac}/checklist"})
    @Operation(summary="Lista as licen\u00e7as registradas no RAC")
    public ResponseEntity<CheckList> findCheckListByRacId(@PathVariable String empresa, @PathVariable Integer idRac) {
        try {
            logger.debug("findCheckListByRacId({},{})", (Object)empresa, (Object)idRac);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            return new ResponseEntity((Object)this.checkListService.findCheckListByRacId(emp.getId(), idRac), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCheckListByRacId", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/{idFicha}/licencas"})
    @Operation(summary="Atualiza a Licen\u00e7a, atualizando de acordo com o payload informado")
    public ResponseEntity<Void> updateLicenca(@PathVariable String empresa, @PathVariable Integer idFicha, @RequestBody LicencaObraVO licencasVO, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (idFicha == null) {
            throw new BusinessException("Identificador da ficha \u00e9 inv\u00e1lido.");
        }
        try {
            logger.debug("updateLicenca({}, {})", (Object)empresa, (Object)licencasVO);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            this.licencaService.updateFichaLicenca(emp.getId(), licencasVO, idFicha, usuario.getId());
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idFicha}/licencas/{idLicenca}"})
    @Operation(summary="Deleta uma Licen\u00e7a dentro de RAC")
    public ResponseEntity<Void> deleteLicenca(@PathVariable String empresa, @PathVariable Integer idFicha, @PathVariable Integer idLicenca, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (idFicha == null) {
            throw new BusinessException("Identificador da ficha \u00e9 inv\u00e1lido.");
        }
        try {
            logger.debug("deleteLicenca({}, {}, {})", new Object[]{empresa, idFicha, idLicenca});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            this.licencaService.deleteFichaLicenca(emp.getId(), idFicha, idLicenca, usuario.getId());
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/expiradas"})
    @Operation(summary="Gera os emails para grupos de usu\u00e1rios seletos com RAC de Gravidade alta que ir\u00e1 expirar em 5 dias")
    public ResponseEntity<Void> executeRacGravidadeAltaExpiradaTask(HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Iniciando processo de gerar e-mails para RACs de Gravidade Alta EXPIRADAS");
            List gravidadeAltaIdsLst = this.gravidadeDAO.getGravidadesAltaIds();
            for (Integer gravidadeAltaId : gravidadeAltaIdsLst) {
                HashSet<Integer> racEmpresasIds = new HashSet<Integer>();
                LocalDateTime expiraEm5Dias = LocalDateTime.of(LocalDate.from(LocalDateTime.now()), LocalTime.MIDNIGHT).plusDays(5L);
                List racsExpiradasLst = this.racService.findByIdGravidade(gravidadeAltaId, expiraEm5Dias);
                logger.debug("Encontradas {} RACs expiradas para gravidade {}", (Object)racsExpiradasLst.size(), (Object)gravidadeAltaId);
                for (Rac rac2 : racsExpiradasLst) {
                    Integer idEmpresa = rac2.getId().getIdEmpresa();
                    if (this.coreService.getRefValueByName(idEmpresa, TipoRefCode.MEIO_AMBIENTE_GRUPOS_RAC_GRAVIDADE_EXPIRADA) == null) continue;
                    racEmpresasIds.add(idEmpresa);
                }
                ObjectMapper mapper = new ObjectMapper();
                for (Integer idEmpresaAdicionada : racEmpresasIds) {
                    List<Rac> racsPorEmpresa = racsExpiradasLst.stream().filter(rac -> rac.getEmpresa().getId().equals(idEmpresaAdicionada)).toList();
                    if (racsPorEmpresa.isEmpty()) continue;
                    logger.debug("Processando {} RACs expiradas para empresa {}", (Object)racsPorEmpresa.size(), (Object)idEmpresaAdicionada);
                    for (Rac rac3 : racsPorEmpresa) {
                        Object gruposRaw = this.coreService.getRefValueByName(rac3.getId().getIdEmpresa(), TipoRefCode.MEIO_AMBIENTE_GRUPOS_RAC_GRAVIDADE_EXPIRADA);
                        if (gruposRaw == null) {
                            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Grupo n\u00e3o encontrado ou n\u00e3o informado.");
                        }
                        try {
                            List gruposLst = (List)mapper.readValue(gruposRaw.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                            List usuariosId = gruposLst.stream().flatMap(grupoId -> this.segurancaService.getUsuariosIdByUsuarioGrupo(grupoId).stream()).toList();
                            HashMap<String, Object> tplData = new HashMap<String, Object>();
                            tplData.put("rac", rac3);
                            String webAppCtx = this.coreService.getGlobalRefValueByName(TipoRefCode.URL_WEBAPP_CONTEXT).toString();
                            if (webAppCtx == null || webAppCtx.toString().isEmpty()) {
                                throw new BusinessException("Application Context URL n\u00e3o informada.");
                            }
                            String externalLink = webAppCtx + "/#/ambiental/fichas/rac/" + rac3.getId().getIdRac() + "?src=email&idEmpresa=" + rac3.getId().getIdEmpresa();
                            tplData.put("externalLink", externalLink);
                            Email email = new Email();
                            email.setChaveAcesso(rac3.getId().getIdRac() + ":" + System.currentTimeMillis());
                            email.getId().setIdEmpresa(rac3.getEmpresa().getId());
                            email.setOrigem(TipoModulo.MEIO_AMBIENTE.getSigla());
                            email.setAssunto("RAC de Gravidade Alta EXPIRADA");
                            email.setStatus(TipoStatusEmail.PENDENTE.getCode());
                            Email emailDb = this.emailDAO.save(email);
                            logger.debug("Email criado com ID {} para empresa {}", (Object)emailDb.getId().getIdEmail(), (Object)emailDb.getId().getIdEmpresa());
                            ArrayList<EmailDestinatario> destinatarios = new ArrayList<EmailDestinatario>(usuariosId.stream().map(id -> {
                                EmailDestinatario emailDestinatario = new EmailDestinatario();
                                emailDestinatario.getId().setIdEmail(emailDb.getId().getIdEmail());
                                emailDestinatario.getId().setIdEmpresa(emailDb.getId().getIdEmpresa());
                                emailDestinatario.getId().setIdUsuarioDestino(id);
                                emailDestinatario.setTipo("TO");
                                return this.emailDAO.saveDestinatario(emailDestinatario);
                            }).toList());
                            emailDb.setDestinatarios(destinatarios);
                            String emailContent = this.coreService.processTemplate(rac3.getEmpresa().getId(), "racGravidadeAlta.tpl", tplData);
                            EmailConteudo emailConteudo = new EmailConteudo();
                            emailConteudo.getId().setIdEmail(emailDb.getId().getIdEmail());
                            emailConteudo.getId().setIdEmpresa(emailDb.getId().getIdEmpresa());
                            emailConteudo.setConteudo(emailContent);
                            EmailConteudo emailConteudoDB = this.emailDAO.saveEmailConteudo(emailConteudo);
                            emailDb.setCorpoEmail(emailConteudoDB);
                            this.emailDAO.save(emailDb);
                            logger.debug("Email salvo com sucesso para empresa {}", (Object)emailDb.getId().getIdEmpresa());
                        }
                        catch (JsonProcessingException jspExc) {
                            logger.error("Erro processando configura\u00e7\u00e3o de grupos para empresa {}: {}", new Object[]{rac3.getId().getIdEmpresa(), gruposRaw, jspExc});
                        }
                    }
                }
            }
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/expiradas/{empresa}/grupos"})
    @Operation(summary="Salva quais grupos receber\u00e3o os emails RAC de Gravidade alta que ir\u00e3o expirar em 5 dias")
    public ResponseEntity<List<GrupoAcessoUsuario>> updateRacExpiradaGrupos(@PathVariable String empresa, @RequestBody PostRacExpiradasRequestVO vo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Empresa emp = null;
        if (empresa != null && (emp = this.coreService.getEmpresaBySigla(empresa)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Integer idEmpresa = emp.getId();
        return ResponseEntity.ok().body((Object)this.racService.postRacExpiradaGrupos(vo, idEmpresa));
    }

    @GetMapping(value={"/expiradas/{empresa}/grupos"})
    @Operation(summary="Lista os grupos que est\u00e3o definidos para receber os e-mails de RAC Gravidade ALTA na RefCode")
    public ResponseEntity<List<GrupoAcessoUsuario>> getRacExpiradaGrupos(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Empresa emp = null;
        if (empresa != null && (emp = this.coreService.getEmpresaBySigla(empresa)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Integer idEmpresa = emp.getId();
        return ResponseEntity.ok().body((Object)this.racService.getRacExpiradaGrupos(idEmpresa));
    }
}

