/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaEvento;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFlorestal;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencaoPK;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoHistorico;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.beans.core.FiltroDinamico;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AutorizacaoIntervencaoService;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.FichaAmbientalService;
import br.com.oti.gesconsys.business.services.InspecaoAmbientalService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAutorizacaoIntervencaoExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAutorizacaoIntervencaoPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para Autoriza\u00e7\u00f5es de Interven\u00e7\u00f5es", name="ambiental")
@RequestMapping(value={"/api/autorizacoesIntervencao"})
public class AutorizacoesIntervencaoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AutorizacoesIntervencaoRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private InspecaoAmbientalService inspecaoAmbientalService;
    @Autowired
    private FichaAmbientalService fichaAmbientalService;
    @Autowired
    private AutorizacaoIntervencaoService autorizacaoIntervencaoService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelatorioAutorizacaoIntervencaoPdf relatorioAutorizacaoIntervencaoPdf;
    @Autowired
    private RelatorioAutorizacaoIntervencaoExcel relatorioAutorizacaoIntervencaoExcel;

    @PostMapping(value={"/{empresa}/filtros"})
    @Operation(summary="Retorna as autoriza\u00e7\u00f5es dispon\u00edveis, de acordo com os filtros informados")
    public ResponseEntity<Page<AutorizacaoIntervencao>> findAutorizacoesIntervencao(@PathVariable String empresa, @RequestBody FiltroIntervencao filtroIntervencao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = true;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - Iniciando findAuttorizacoesIntervencao({}, {}, {}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroIntervencao == null) {
                filtroIntervencao = new FiltroIntervencao();
            }
            if (filtroIntervencao.getConcessionaria() == null || filtroIntervencao.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroIntervencao.setConcessionaria(empList);
            }
            Page intervencoes = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroIntervencao, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            for (AutorizacaoIntervencao intervencao : intervencoes) {
                Set ocorrencias;
                List anexos;
                if (intervencao.getRodovia() != null) {
                    Rodovia rdv = intervencao.getRodovia();
                    rdv.setEmpresa(null);
                    intervencao.setRodovia(rdv);
                }
                if (intervencao.getSupervisorAmbiental() != null) {
                    Usuario supe = intervencao.getSupervisorAmbiental();
                    supe.setGrupos(null);
                }
                if (intervencao.getCoordenadorObra() != null) {
                    Usuario coamb = intervencao.getCoordenadorObra();
                    coamb.setGrupos(null);
                }
                Empresa empInt = intervencao.getEmpresa();
                if (emp != null) {
                    Empresa empPayload = new Empresa();
                    empPayload.setId(empInt.getId());
                    empPayload.setSigla(empInt.getSigla());
                    empPayload.setRazaoSocial(empInt.getRazaoSocial());
                    empPayload.setNomeFantasia(empInt.getNomeFantasia());
                    intervencao.setEmpresa(empPayload);
                }
                if ((anexos = intervencao.getAnexos()) != null) {
                    for (IntervencaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrencias = intervencao.getOcorrencias()) == null) continue;
                for (IntervencaoOcorrencia oco : ocorrencias) {
                    oco.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)intervencoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAutorizacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Carrega a Autoriza\u00e7\u00e3o para Interven\u00e7\u00e3o de acordo com seu identificador")
    public ResponseEntity<AutorizacaoIntervencao> getAutorizacaoIntervencao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AutorizacaoIntervencao autoriz = this.autorizacaoIntervencaoService.getAutorizacaoIntervencaoById(emp.getId(), idAutorizacao);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setDatHorAlteracao(null);
            autoriz.getRodovia().setDatHorCadastro(null);
            autoriz.getRodovia().setEmpresa(null);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setDatHorAlteracao(null);
            autoriz.getCoordenadorObra().setDatHorCadastro(null);
            autoriz.getCoordenadorObra().setDatHorUltimoLogin(null);
            autoriz.getCoordenadorObra().setGrupos(null);
            autoriz.getCoordenadorObra().setIdPoderConcedente(null);
            autoriz.getCoordenadorObra().setIdUsuarioIns(null);
            autoriz.getCoordenadorObra().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setSessionUUID(null);
            autoriz.getEquipeAmbiental().setDatHorAlteracao(null);
            autoriz.getEquipeAmbiental().setDatHorCadastro(null);
            autoriz.getEquipeAmbiental().setIdEmpresa(null);
            autoriz.getEquipeAmbiental().setIdUsuarioIns(null);
            autoriz.getEquipeAmbiental().setIdUsuarioUpd(null);
            autoriz.getEquipeConcessao().setDatHorAlteracao(null);
            autoriz.getEquipeConcessao().setDatHorCadastro(null);
            autoriz.getEquipeConcessao().setIdEmpresa(null);
            autoriz.getEquipeConcessao().setIdUsuarioIns(null);
            autoriz.getEquipeConcessao().setIdUsuarioUpd(null);
            autoriz.getEquipeEmpreiteira().setDatHorAlteracao(null);
            autoriz.getEquipeEmpreiteira().setDatHorCadastro(null);
            autoriz.getEquipeEmpreiteira().setIdEmpresa(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioIns(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            return new ResponseEntity((Object)autoriz, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAutorizacaoIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<AutorizacaoIntervencao> registrarAutorizacaoIntervencao(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            AutorizacaoIntervencao autoriz = (AutorizacaoIntervencao)mapper.readValue(((String[])formData.get("autorizacao"))[0], AutorizacaoIntervencao.class);
            if (autoriz.getId() == null) {
                autoriz.setId(new AutorizacaoIntervencaoPK());
            }
            logger.debug("registrarInspecao ({}))", (Object)autoriz);
            if (empresa != null) {
                Empresa emp = this.coreService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (autoriz.getId().getIdEmpresa() == null) {
                    autoriz.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && (ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).length() > 0) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            AutorizacaoIntervencao autorizDb = this.autorizacaoIntervencaoService.registrarAutorizacaoIntervencao(autoriz, ocorrencias, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)autorizDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarInspecao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarInspecao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Exclui a Inspe\u00e7\u00e3o atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) throws BusinessException {
        logger.debug("deleteInspecao({}, {})", (Object)empresa, (Object)idAutorizacao);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoIntervencaoService.deleteAutorizacaoIntervencao(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<IntervencaoAnexo>> createAnexoIntervencao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexoIntervencao({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<IntervencaoAnexo> anexos = new ArrayList<IntervencaoAnexo>();
            for (MultipartFile file : filesMap) {
                IntervencaoAnexo anexo = new IntervencaoAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.autorizacaoIntervencaoService.createAnexoIntervencao(emp.getId(), idAutorizacao, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/anexos"})
    @Operation(summary="Lista os anexos presentes na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<IntervencaoAnexo>> findAnexosInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoIntervencaoService.findAnexosAutorizacaoIntervencao(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo/Anexo Ficha da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idAutorizacao});
            this.autorizacaoIntervencaoService.saveComentarioAnexoIntervencao(empresa, idAutorizacao, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idAutorizacao, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Inspe\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idAutorizacao, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoIntervencaoService.deleteAnexoAutorizacaoIntervencao(emp.getId(), idAutorizacao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<IntervencaoOcorrencia> updateOcorrenciaInspecao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @RequestBody IntervencaoOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrenciaInspecao({},{})", (Object)idAutorizacao, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdEmpresa() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            IntervencaoOcorrencia response = this.autorizacaoIntervencaoService.saveOcorrenciaAutorizacaoFicha(emp.getId(), idAutorizacao, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas ao sAutoriza\u00e7\u00e3o Interven\u00e7\u00e3o")
    public ResponseEntity<Map<String, Object>> findOcorrenciasAutorizacaoIntervencao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.cadastroAmbientalService.findOcorrencias(null, null);
            List depositosOcorrencias = this.autorizacaoIntervencaoService.findOcorrenciasAutorizacaoIntervencao(emp.getId(), idAutorizacao);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<IntervencaoOcorrenciaPK> soluAssocList = new ArrayList<IntervencaoOcorrenciaPK>();
            for (IntervencaoOcorrencia interOcorre : depositosOcorrencias) {
                if (!mapSoluOcorre.containsKey(interOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(interOcorre.getId().getIdOcorrencia(), interOcorre.getOcorrencia());
                }
                soluAssocList.add(interOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasDeposito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo da Inspe\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaInspecao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable Integer idOcorrencia, @PathVariable Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrencia({}, {}, {}, {})", new Object[]{empresa, idAutorizacao, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.inspecaoAmbientalService.deleteOcorrenciaInspecao(emp.getId(), idAutorizacao, idOcorrencia, idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<IntervencaoHistorico>> findHistoricosInspecao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoIntervencaoService.findHistoricosAutorizacaoIntervencao(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da Inspe\u00e7\u00e3o de acordo com o payload informado")
    public ResponseEntity<IntervencaoHistorico> createHistoricoInspecao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistorico({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            IntervencaoHistorico anexo = new IntervencaoHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            IntervencaoHistorico response = this.autorizacaoIntervencaoService.saveHistoricoAutorizacaoIntervencao(emp.getId(), idAutorizacao, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idAutorizacaoIntervencao}"})
    @Operation(summary="Efetua o download da Autoriza\u00e7\u00e3o de Interven\u00e7\u00e3o em PDF")
    public ResponseEntity<byte[]> exportaAutorizacaoIntervencaoPdf(@PathVariable String empresa, @PathVariable Integer idAutorizacaoIntervencao, HttpServletRequest request) {
        logger.debug("Exportando PDF, Autoriza\u00e7\u00e3o (emp={}, {})...", (Object)empresa, (Object)idAutorizacaoIntervencao);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            byte[] bytes;
            AutorizacaoIntervencao autorizacao = this.autorizacaoIntervencaoService.getAutorizacaoIntervencaoById(emp.getId(), idAutorizacaoIntervencao);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (autorizacao.getLatitude() != null && autorizacao.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(autorizacao.getLatitude(), autorizacao.getLongitude(), tipoMapa);
            }
            if ((bytes = this.relatorioAutorizacaoIntervencaoPdf.executePDF(emp.getId(), autorizacao, mapaGoogle, false)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"autorizacao-intervencao.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude, longitude), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download de Autoriza\u00e7\u00f5es para Interven\u00e7\u00e3o em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable String empresa, @RequestBody FiltroIntervencao filtroIntervencao, HttpServletRequest request) {
        logger.debug("Exportando excel, autoriza\u00e7\u00f5es interven\u00e7\u00e3o (emp={})...", (Object)empresa);
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroIntervencao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtroIntervencao.getConcessionaria() == null || filtroIntervencao.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtroIntervencao.setConcessionaria(empList);
        }
        try {
            Page autorizacoesIntervencao = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroIntervencao, 1, 5000, null, null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            StreamingResponseBody responseBody = response -> response.write(this.relatorioAutorizacaoIntervencaoExcel.executeXLS(autorizacoesIntervencao.getContent(), filtroIntervencao.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"autoriza\u00e7\u00e3o-interven\u00e7\u00e3o.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da Autoriza\u00e7\u00e3o Interven\u00e7\u00e3o (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar, Reabrir)")
    public ResponseEntity<FichaEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            FichaEvento evento;
            logger.debug("executeEvento({},{},{})", new Object[]{empresa, idAutorizacao, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer ordemAprovacao = null;
            if (request.getParameter("ordemAprovacao") != null) {
                try {
                    ordemAprovacao = Integer.valueOf(request.getParameter("ordemAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    ordemAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.autorizacaoIntervencaoService.enviarAprovacaoAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.autorizacaoIntervencaoService.aprovarAutorizacaoIntervencao(empresa, idAutorizacao, ordemAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.autorizacaoIntervencaoService.reprovarAutorizacaoIntervencao(empresa, idAutorizacao, ordemAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.autorizacaoIntervencaoService.encerrarAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.autorizacaoIntervencaoService.finalizarAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.autorizacaoIntervencaoService.naoFinalizarAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.autorizacaoIntervencaoService.reabrirAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.autorizacaoIntervencaoService.cancelarAutorizacaoIntervencao(empresa, idAutorizacao, usuario.getLogin(), perfilReprovar);
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados na Autoriza\u00e7\u00e3o de Interven\u00e7\u00e3o")
    public ResponseEntity<List<FichaAprovacao>> findAprovacoes(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.fichaAmbientalService.findAprovacoesById(emp.getId(), idAutorizacao, "ASV");
            return new ResponseEntity((Object)aprovacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as autoriza\u00e7\u00f5es dispon\u00edveis, de acordo com os filtros informados")
    public ResponseEntity<Page<AutorizacaoIntervencao>> findAutorizacoesIntervencao(@PathVariable String empresa, @RequestBody List<FiltroDinamico> filtroIntervencao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = true;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - Iniciando findAuttorizacoesIntervencao({}, {}, {}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ArrayList<Integer> empList = new ArrayList<Integer>();
            for (FiltroDinamico filtro : filtroIntervencao) {
                if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                    empList.add(emp.getId());
                    filtro.setConcessionaria(empList);
                }
                filtro.setConcessionaria(null);
            }
            Page intervencoes = this.fichaAmbientalService.findFichasByFilter(empList, "ASV", filtroIntervencao, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null);
            for (Object item : intervencoes) {
                Set ocorrencias;
                List anexos;
                AutorizacaoIntervencao intervencao = (AutorizacaoIntervencao)item;
                if (intervencao.getRodovia() != null) {
                    Rodovia rdv = intervencao.getRodovia();
                    rdv.setEmpresa(null);
                    intervencao.setRodovia(rdv);
                }
                if (intervencao.getSupervisorAmbiental() != null) {
                    Usuario supe = intervencao.getSupervisorAmbiental();
                    supe.setGrupos(null);
                }
                if (intervencao.getCoordenadorObra() != null) {
                    Usuario coamb = intervencao.getCoordenadorObra();
                    coamb.setGrupos(null);
                }
                Empresa empInt = intervencao.getEmpresa();
                if (emp != null) {
                    Empresa empPayload = new Empresa();
                    empPayload.setId(empInt.getId());
                    empPayload.setSigla(empInt.getSigla());
                    empPayload.setRazaoSocial(empInt.getRazaoSocial());
                    empPayload.setNomeFantasia(empInt.getNomeFantasia());
                    intervencao.setEmpresa(empPayload);
                }
                if ((anexos = intervencao.getAnexos()) != null) {
                    for (IntervencaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrencias = intervencao.getOcorrencias()) == null) continue;
                for (IntervencaoOcorrencia oco : ocorrencias) {
                    oco.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)intervencoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAutorizacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/inspecoesFlorestais"})
    @Operation(summary="Lista as inspe\u00e7\u00f5es florestais associadas a autoria\u00e7\u00e3o interven\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoFlorestal>> findInspecoesFlorestais(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List florestais = this.fichaAmbientalService.findInspecoesFlorestaisAutorizacao(emp.getId(), idAutorizacao, null);
            return new ResponseEntity((Object)florestais, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findInspecoesFlorestais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

