/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoDescarte;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoDescartePK;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoHistorico;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.descarte.FiltroDescarte;
import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaEvento;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.beans.core.FiltroDinamico;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AutorizacaoDescarteService;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.FichaAmbientalService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para Autoriza\u00e7\u00f5es Rap", name="ambiental")
@RequestMapping(value={"/api/autorizacoesRap"})
public class AutorizacoesDescartesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AutorizacoesDescartesRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private AutorizacaoDescarteService autorizacaoDescarteService;
    @Autowired
    private FichaAmbientalService fichaAmbientalService;
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelatorioRetiradaMaterialPdf relatorioRetiradaMaterialPdf;
    @Autowired
    private RelatorioRetiradaMaterialExcel relatorioRetiradaMaterialExcel;

    @PostMapping(value={"/{empresa}/filtros"})
    @Operation(summary="Retorna as autoriza\u00e7\u00f5es dispon\u00edveis, de acordo com os filtros informados")
    public ResponseEntity<Page<AutorizacaoDescarte>> findAutorizacaoDescarte(@PathVariable String empresa, @RequestBody FiltroDescarte filtroDescarte, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = true;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - Iniciando findAutorizaoDescarte({}, {}, {}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroDescarte == null) {
                filtroDescarte = new FiltroDescarte();
            }
            if (filtroDescarte.getConcessionaria() == null || filtroDescarte.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroDescarte.setConcessionaria(empList);
            }
            Page autorizacoes = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtroDescarte, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true));
            for (AutorizacaoDescarte autorizacao : autorizacoes) {
                Set ocorrencias;
                List anexos;
                if (autorizacao.getRodovia() != null) {
                    Rodovia rdv = autorizacao.getRodovia();
                    rdv.setEmpresa(null);
                    autorizacao.setRodovia(rdv);
                }
                if (autorizacao.getSupervisorAmbiental() != null) {
                    Usuario supe = autorizacao.getSupervisorAmbiental();
                    supe.setGrupos(null);
                }
                if (autorizacao.getCoordenadorObra() != null) {
                    Usuario coamb = autorizacao.getCoordenadorObra();
                    coamb.setGrupos(null);
                }
                Empresa empAut = autorizacao.getEmpresa();
                if (emp != null) {
                    Empresa empPayload = new Empresa();
                    empPayload.setId(empAut.getId());
                    empPayload.setSigla(empAut.getSigla());
                    empPayload.setRazaoSocial(empAut.getRazaoSocial());
                    empPayload.setNomeFantasia(empAut.getNomeFantasia());
                    autorizacao.setEmpresa(empPayload);
                }
                if ((anexos = autorizacao.getAnexos()) != null) {
                    for (AutorizacaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrencias = autorizacao.getOcorrencias()) == null) continue;
                for (AutorizacaoOcorrencia oco : ocorrencias) {
                    oco.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)autorizacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAutorizacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Carrega a Autoriza\u00e7\u00e3o de acordo com seu identificador")
    public ResponseEntity<AutorizacaoDescarte> getAutorizacaoDescarte(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AutorizacaoDescarte autoriz = this.autorizacaoDescarteService.getAutorizacaoDescarteById(emp.getId(), idAutorizacao);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setDatHorAlteracao(null);
            autoriz.getRodovia().setDatHorCadastro(null);
            autoriz.getRodovia().setEmpresa(null);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setDatHorAlteracao(null);
            autoriz.getCoordenadorObra().setDatHorCadastro(null);
            autoriz.getCoordenadorObra().setDatHorUltimoLogin(null);
            autoriz.getCoordenadorObra().setGrupos(null);
            autoriz.getCoordenadorObra().setIdPoderConcedente(null);
            autoriz.getCoordenadorObra().setIdUsuarioIns(null);
            autoriz.getCoordenadorObra().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setSessionUUID(null);
            autoriz.getEquipeAmbiental().setDatHorAlteracao(null);
            autoriz.getEquipeAmbiental().setDatHorCadastro(null);
            autoriz.getEquipeAmbiental().setIdEmpresa(null);
            autoriz.getEquipeAmbiental().setIdUsuarioIns(null);
            autoriz.getEquipeAmbiental().setIdUsuarioUpd(null);
            autoriz.getEquipeConcessao().setDatHorAlteracao(null);
            autoriz.getEquipeConcessao().setDatHorCadastro(null);
            autoriz.getEquipeConcessao().setIdEmpresa(null);
            autoriz.getEquipeConcessao().setIdUsuarioIns(null);
            autoriz.getEquipeConcessao().setIdUsuarioUpd(null);
            autoriz.getEquipeEmpreiteira().setDatHorAlteracao(null);
            autoriz.getEquipeEmpreiteira().setDatHorCadastro(null);
            autoriz.getEquipeEmpreiteira().setIdEmpresa(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioIns(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            return new ResponseEntity((Object)autoriz, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAutorizacaoIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a Autoriza\u00e7\u00e3o RAP")
    public ResponseEntity<AutorizacaoDescarte> registrarAutorizacao(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            AutorizacaoDescarte autoriz = (AutorizacaoDescarte)mapper.readValue(((String[])formData.get("autorizacao"))[0], AutorizacaoDescarte.class);
            if (autoriz.getId() == null) {
                autoriz.setId(new AutorizacaoDescartePK());
            }
            logger.debug("registrarAutorizacao({}))", (Object)autoriz);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (autoriz.getId().getIdEmpresa() == null) {
                    autoriz.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && (ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).length() > 0) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            AutorizacaoDescarte autorizDb = this.autorizacaoDescarteService.registrarAutorizacaoDescarte(autoriz, ocorrencias, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)autorizDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarAutorizacao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarAutorizacao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Exclui a Autoriza\u00e7\u00e3o RAP atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) throws BusinessException {
        logger.debug("deleteAutorizacao({}, {})", (Object)empresa, (Object)idAutorizacao);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoDescarteService.deleteAutorizacaoDescarte(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<AutorizacaoAnexo>> createAnexoAutorizacaoDescarte(@PathVariable String empresa, @PathVariable Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexoAutorizacaoDescarte({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<AutorizacaoAnexo> anexos = new ArrayList<AutorizacaoAnexo>();
            for (MultipartFile file : filesMap) {
                AutorizacaoAnexo anexo = new AutorizacaoAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.autorizacaoDescarteService.createAnexoAutorizacaoDescarte(emp.getId(), idAutorizacao, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/anexos"})
    @Operation(summary="Lista os anexos presentes na Autoriza\u00e7\u00e3o")
    public ResponseEntity<List<AutorizacaoAnexo>> findAnexosAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoDescarteService.findAnexosAutorizacaoDescarte(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable Integer idAnexo, @PathVariable Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idAutorizacao, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Autoriza\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idAutorizacao, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoDescarteService.deleteAnexoAutorizacaoDescarte(emp.getId(), idAutorizacao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacaoRap}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas ao Deposito")
    public ResponseEntity<Map<String, Object>> findOcorrenciasDeposito(@PathVariable String empresa, @PathVariable Integer idAutorizacaoRap) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.cadastroAmbientalService.findOcorrencias(null, null);
            List AutorizacoesDescarteOcorrencias = this.autorizacaoDescarteService.findOcorrenciasAutorizacaoDescarte(emp.getId(), idAutorizacaoRap);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<AutorizacaoOcorrenciaPK> soluAssocList = new ArrayList<AutorizacaoOcorrenciaPK>();
            for (AutorizacaoOcorrencia rapOcorre : AutorizacoesDescarteOcorrencias) {
                if (!mapSoluOcorre.containsKey(rapOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(rapOcorre.getId().getIdOcorrencia(), rapOcorre.getOcorrencia());
                }
                soluAssocList.add(rapOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasDeposito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<IntervencaoOcorrencia> updateOcorrenciaAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @RequestBody IntervencaoOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrenciaAutorizacao({},{})", (Object)idAutorizacao, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdEmpresa() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            IntervencaoOcorrencia response = this.autorizacaoDescarteService.saveOcorrenciaAutorizacaoFicha(emp.getId(), idAutorizacao, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrenciaAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo da Autoriza\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable Integer idOcorrencia, @PathVariable Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrenciaAutorizacao({}, {}, {}, {})", new Object[]{empresa, idAutorizacao, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoDescarteService.deleteOcorrenciaAutorizacaoDescarte(emp.getId(), idAutorizacao, idOcorrencia, idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrenciaAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na Autoriza\u00e7\u00e3o")
    public ResponseEntity<List<AutorizacaoHistorico>> findHistoricosAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.autorizacaoDescarteService.findHistoricosAutorizacaoDescarte(emp.getId(), idAutorizacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da Autoriza\u00e7\u00e3o de acordo com o payload informado")
    public ResponseEntity<AutorizacaoHistorico> createHistoricoAutorizacao(@PathVariable String empresa, @PathVariable Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistoricoAutorizacao({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            AutorizacaoHistorico anexo = new AutorizacaoHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AutorizacaoHistorico response = this.autorizacaoDescarteService.saveHistoricoAutorizacaoDescarte(emp.getId(), idAutorizacao, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistoricoAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idAutorizacaoRap}"})
    @Operation(summary="Efetua o download da Autoriza\u00e7\u00e3o de Interven\u00e7\u00e3o em PDF")
    public ResponseEntity<byte[]> exportaAutorizacaoDescartePdf(@PathVariable String empresa, @PathVariable Integer idAutorizacaoRap, HttpServletRequest request) {
        logger.debug("Exportando PDF, Autoriza\u00e7\u00e3o (emp={}, {})...", (Object)empresa, (Object)idAutorizacaoRap);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            byte[] bytes;
            AutorizacaoDescarte autorizacao = this.autorizacaoDescarteService.getAutorizacaoDescarteById(emp.getId(), idAutorizacaoRap);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (autorizacao.getLatitude() != null && autorizacao.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(autorizacao.getLatitude(), autorizacao.getLongitude(), tipoMapa);
            }
            if ((bytes = this.relatorioRetiradaMaterialPdf.executePDF(emp.getId(), autorizacao, mapaGoogle, false)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"autorizacao-intervencao.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude, longitude), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download de Autoriza\u00e7\u00f5es Descarte e/ou Retirada de Material em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable String empresa, @RequestBody FiltroDescarte filtro, HttpServletRequest request) {
        logger.debug("Exportando excel, autoriza\u00e7\u00f5es descarte/retirada de material (emp={})...", (Object)empresa);
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtro == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtro.setConcessionaria(empList);
        }
        try {
            Page autorizacoes = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtro, 1, 5000, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
            StreamingResponseBody responseBody = response -> response.write(this.relatorioRetiradaMaterialExcel.executeXLS(autorizacoes.getContent(), filtro.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"autoriza\u00e7\u00e3o-retirada-descarte.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idDescarte}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo de Autoriza\u00e7\u00e3o de Descarte")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable String empresa, @PathVariable Integer idDescarte, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idDescarte});
            this.autorizacaoDescarteService.saveComentarioAnexoDescarte(empresa, idDescarte, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados na Autoriza\u00e7\u00e3o de Descarte/Retirada")
    public ResponseEntity<List<FichaAprovacao>> findAprovacoes(@PathVariable String empresa, @PathVariable Integer idAutorizacao) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.fichaAmbientalService.findAprovacoesById(emp.getId(), idAutorizacao, "ADR");
            return new ResponseEntity((Object)aprovacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da Autoriza\u00e7\u00e3o de Descarte/Retirada (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar, Reabrir)")
    public ResponseEntity<FichaEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            FichaEvento evento;
            logger.debug("executeEvento({},{},{})", new Object[]{empresa, idAutorizacao, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer ordemAprovacao = null;
            if (request.getParameter("ordemAprovacao") != null) {
                try {
                    ordemAprovacao = Integer.valueOf(request.getParameter("ordemAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    ordemAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.autorizacaoDescarteService.enviarAprovacaoAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.autorizacaoDescarteService.aprovarAutorizacaoDescarte(empresa, idAutorizacao, ordemAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.autorizacaoDescarteService.reprovarAutorizacaoDescarte(empresa, idAutorizacao, ordemAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.autorizacaoDescarteService.encerrarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.autorizacaoDescarteService.finalizarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.autorizacaoDescarteService.naoFinalizarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.autorizacaoDescarteService.reabrirAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.autorizacaoDescarteService.cancelarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateExecuteEventoAutorizacaoDescarteRetirada", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as autoriza\u00e7\u00f5es dispon\u00edveis, de acordo com os filtros informados")
    public ResponseEntity<Page<AutorizacaoDescarte>> findAutorizacaoDescarte(@PathVariable String empresa, @RequestBody List<FiltroDinamico> filtroAutorizacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = true;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - Iniciando findAutorizaoDescarte({}, {}, {}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ArrayList<Integer> empList = new ArrayList<Integer>();
            for (FiltroDinamico filtro : filtroAutorizacao) {
                if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                    empList.add(emp.getId());
                    filtro.setConcessionaria(empList);
                }
                filtro.setConcessionaria(null);
            }
            Page autorizacoes = this.fichaAmbientalService.findFichasByFilter(empList, "ADS", filtroAutorizacao, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null);
            for (Object item : autorizacoes) {
                Set ocorrencias;
                List anexos;
                AutorizacaoDescarte autorizacao = (AutorizacaoDescarte)item;
                if (autorizacao.getRodovia() != null) {
                    Rodovia rdv = autorizacao.getRodovia();
                    rdv.setEmpresa(null);
                    autorizacao.setRodovia(rdv);
                }
                if (autorizacao.getSupervisorAmbiental() != null) {
                    Usuario supe = autorizacao.getSupervisorAmbiental();
                    supe.setGrupos(null);
                }
                if (autorizacao.getCoordenadorObra() != null) {
                    Usuario coamb = autorizacao.getCoordenadorObra();
                    coamb.setGrupos(null);
                }
                Empresa empAut = autorizacao.getEmpresa();
                if (emp != null) {
                    Empresa empPayload = new Empresa();
                    empPayload.setId(empAut.getId());
                    empPayload.setSigla(empAut.getSigla());
                    empPayload.setRazaoSocial(empAut.getRazaoSocial());
                    empPayload.setNomeFantasia(empAut.getNomeFantasia());
                    autorizacao.setEmpresa(empPayload);
                }
                if ((anexos = autorizacao.getAnexos()) != null) {
                    for (AutorizacaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrencias = autorizacao.getOcorrencias()) == null) continue;
                for (AutorizacaoOcorrencia oco : ocorrencias) {
                    oco.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)autorizacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAutorizacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

