/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.fichas;

import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFlorestal;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.ProcessoImportacao;
import br.com.oti.gesconsys.business.helper.ImportacaoFlorestalHelper;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Inspe\u00e7\u00f5es Florestais", name="ambiental")
@RequestMapping(value={"/api/inspecoesFlorestais"})
public class InspecoesFlorestaisRestServices
extends BaseRestService {
    private static Logger LOG = LoggerFactory.getLogger(InspecoesFlorestaisRestServices.class);
    @Autowired
    private ImportacaoFlorestalHelper importacaoHelper;

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/importacoes"})
    @Operation(summary="Processa a importa\u00e7\u00e3o de itens arb\u00f3reos da Inspe\u00e7\u00e3o Florestal.")
    @ResponseBody
    public ResponseEntity<ProcessoImportacao<InspecaoFlorestal>> executeProcessamento(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        LOG.debug("{} - Iniciando importa\u00e7\u00e3o, empresa={}", (Object)usuario.getLogin(), (Object)empresa);
        try {
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                List files = multipartReq.getFiles(uploadedName);
                for (MultipartFile file : files) {
                    try {
                        Map metadata = this.importacaoHelper.preProcess(file.getInputStream());
                        List colunas = (List)metadata.get("colunasPlanilhas");
                        ProcessoImportacao processo = this.importacaoHelper.executeImportacao(empresa, usuario.getLogin(), file.getInputStream(), Integer.valueOf(1), colunas);
                        return new ResponseEntity((Object)processo, (HttpStatusCode)HttpStatus.CREATED);
                    }
                    catch (IOException e) {
                        LOG.error("Arquivo '{}', erro de estrutura de importa\u00e7\u00e3o.", (Object)file.getOriginalFilename());
                    }
                    catch (NullPointerException n) {
                        LOG.error("Arquivo '{}', erro de estrutura de importa\u00e7\u00e3o.", (Object)file.getOriginalFilename());
                        throw new NullPointerException("Erro na importa\u00e7\u00e3o de planilha florestal. Por favor, verifique o modelo.");
                    }
                }
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_MODIFIED, "Nada foi processado.");
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.executeProcessamento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

