/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.cadastros;

import br.com.oti.gesconsys.ambiental.beans.cadastros.AreaEspecialmenteProtegida;
import br.com.oti.gesconsys.ambiental.beans.cadastros.ElementoArboreo;
import br.com.oti.gesconsys.ambiental.beans.cadastros.GrauRisco;
import br.com.oti.gesconsys.ambiental.beans.cadastros.ImpactoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.cadastros.MaterialApoio;
import br.com.oti.gesconsys.ambiental.beans.cadastros.OcorrenciaFlorestal;
import br.com.oti.gesconsys.ambiental.beans.cadastros.OrgaoAprovador;
import br.com.oti.gesconsys.ambiental.beans.cadastros.ParecerAutorizativo;
import br.com.oti.gesconsys.ambiental.beans.cadastros.StatusAprovacaoAgencia;
import br.com.oti.gesconsys.ambiental.beans.cadastros.StatusAprovacaoUso;
import br.com.oti.gesconsys.ambiental.beans.cadastros.TipoRequisitoLegal;
import br.com.oti.gesconsys.ambiental.beans.cadastros.TipoStatusUtilizacao;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.licencas.LicencaObra;
import br.com.oti.gesconsys.beans.licencas.LicencaObraVO;
import br.com.oti.gesconsys.beans.licencas.PlanoAcaoCondicionante;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.CaraterCondicionante;
import br.com.oti.gesconsys.beans.shared.Condicionante;
import br.com.oti.gesconsys.beans.shared.PrioridadePlanoAcao;
import br.com.oti.gesconsys.beans.shared.StatusCondicionante;
import br.com.oti.gesconsys.beans.shared.StatusLicenca;
import br.com.oti.gesconsys.beans.shared.StatusPlanoAcao;
import br.com.oti.gesconsys.beans.shared.TipoPlanoAcao;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para ambiental", name="ambiental")
@RequestMapping(value={"/api/cadastros/amb"})
public class CadastrosAmbientaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosAmbientaisRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CoreService coreService;

    @GetMapping(value={"/statusLicenca"})
    @Operation(summary="Consulta os status das licen\u00e7as de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<StatusLicenca>> findStatusLicenca(HttpServletRequest request) {
        logger.debug("Executando searchStatusLicenca");
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List status = this.licencaService.findStatus(search);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findStatusLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/statusLicenca/{idStatusLicenca}"})
    @Operation(summary="Exibe o status de licen\u00e7a para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<StatusLicenca> getStatusLicenca(HttpServletRequest request, @PathVariable(name="idStatusLicenca") Integer idStatusLicenca) {
        logger.debug("Executando getStatusLicenca");
        try {
            StatusLicenca status = this.licencaService.getStatusById(idStatusLicenca);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getStatusLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/statusLicenca"})
    @Operation(summary="Salva o status de licen\u00e7a")
    public ResponseEntity<StatusLicenca> saveStatusLicenca(@RequestBody StatusLicenca statusLicenca, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveStatusLicenca ({}))", (Object)usuario.getLogin(), (Object)statusLicenca);
            return new ResponseEntity((Object)this.licencaService.saveStatus(statusLicenca, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/statusLicenca/{idStatus}"})
    @Operation(summary="Exclui o status da licen\u00e7a atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteStatusLicenca(@PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteStatusLicenca({})", (Object)idStatus);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteStatus(idStatus), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/licencasObras/{idLicenca}"})
    @Operation(summary="Consulta as obras das licen\u00e7as de acordo com a licenca")
    public ResponseEntity<List<LicencaObra>> findObrasLicenca(HttpServletRequest request, @PathVariable Integer idLicenca) {
        logger.debug("Executando findObrasLicenca");
        try {
            List obra = this.licencaService.findObrasByLicenca(idLicenca);
            return new ResponseEntity((Object)obra, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObrasLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findObrasLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"licencasObras/{empresa}/{idObra}"})
    @Operation(summary="Consulta as licen\u00e7as de acordo com a obra")
    public ResponseEntity<List<LicencaObra>> findLicencaByObra(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idObra) {
        logger.debug("Executando findLicencaByObra");
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            empresas.add(emp.getId());
            List obra = this.licencaService.findLicencasByObra(idObra, empresas);
            return new ResponseEntity((Object)obra, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLicencaByObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findLicencaByObra", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/licencasObras/{idLicenca}/{seqObra}"})
    @Operation(summary="Exibe a obra de licen\u00e7a para edi\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<LicencaObra> getObraLicenca(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer seqObra, @PathVariable Integer idLicenca) {
        logger.debug("Executando getObraLicenca");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            LicencaObra obra = this.licencaService.getLicencaObraById(idLicenca, seqObra, empresaDB.getId());
            return new ResponseEntity((Object)obra, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getObraLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getObraLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"{empresa}/licencasObras"})
    @Operation(summary="Salva a obra de licen\u00e7a")
    public ResponseEntity<Boolean> saveLicencaObra(@PathVariable String empresa, @RequestBody LicencaObraVO licencaObra, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveLicencaObra ({}))", (Object)licencaObra);
            return new ResponseEntity((Object)this.licencaService.saveLicencaObra(licencaObra, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveLicencaObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/licencasObras/{idLicenca}/{seqLicenca}"})
    @Operation(summary="Exclui a licen\u00e7a da  obra atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteObraLicenca(@PathVariable String empresa, @PathVariable Integer seqLicenca, @PathVariable Integer idLicenca, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteObraLicenca({})", (Object)seqLicenca);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.licencaService.deleteLicencaObra(idLicenca, empresaDB.getId(), seqLicenca), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteObraLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/caraterCondicionante"})
    @Operation(summary="Consulta os caraters das condicionantes de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<CaraterCondicionante>> findCaraterCondicionantes(HttpServletRequest request) {
        logger.debug("Executando findCaraterCondicionantes");
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List carater = this.licencaService.findCaraters(search);
            return new ResponseEntity((Object)carater, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCaraterCondicionantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCaraterCondicionantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/caraterCondicionante/{idCarater}"})
    @Operation(summary="Exibe o carater de condicionante para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<CaraterCondicionante> getCaraterCondicionante(HttpServletRequest request, @PathVariable(name="idCarater") Integer idCarater) {
        logger.debug("Executando getCaraterCondicionante");
        try {
            CaraterCondicionante carater = this.licencaService.getCaraterCondicionanteById(idCarater);
            return new ResponseEntity((Object)carater, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCaraterCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCaraterCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/caraterCondicionante"})
    @Operation(summary="Salva o carater de condicionante")
    public ResponseEntity<CaraterCondicionante> saveCaraterCondicionante(@RequestBody CaraterCondicionante caraterCondicionante, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveCaraterCondicionante ({}))", (Object)caraterCondicionante);
            return new ResponseEntity((Object)this.licencaService.saveCarater(caraterCondicionante, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCaraterCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/caraterCondicionante/{idCarater}"})
    @Operation(summary="Exclui o carter da condicionante atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteCaraterCondicionante(@PathVariable(name="idCarater") Integer idCarater, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteCaraterCondicionante({})", (Object)idCarater);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteCarater(idCarater), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCaraterCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/planosAcaoCondicionante"})
    @Operation(summary="Consulta os planos de a\u00e7\u00e3o das condicionantes de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<PlanoAcaoCondicionante>> findPlanosAcaoCondicionante(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("Executando findCaraterCondicionantes");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Integer idCondicionante = null;
            String param = request.getParameter("idCondicionante");
            if (param != null && !param.isEmpty()) {
                idCondicionante = Integer.valueOf(param);
            }
            List planoAcao = this.licencaService.findPlanosAcao(empresaDB.getId(), idCondicionante);
            return new ResponseEntity((Object)planoAcao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanosAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPlanosAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/planosAcaoCondicionante/{idPlanoAcao}"})
    @Operation(summary="Exibe o plano de a\u00e7\u00e3o de condicionante para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<PlanoAcaoCondicionante> getPlanoAcaoCondicionante(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao) {
        logger.debug("Executando getPlanoAcaoCondicionante");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            PlanoAcaoCondicionante planoAcao = this.licencaService.getPlanoAcaoById(empresaDB.getId(), idPlanoAcao);
            return new ResponseEntity((Object)planoAcao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/planoAcaoCondicionante"})
    @Operation(summary="Salva o plano de a\u00e7\u00e3o de condicionante")
    public ResponseEntity<PlanoAcaoCondicionante> savePlanoAcaoCondicionante(@RequestBody PlanoAcaoCondicionante planoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePlanoAcaoCondicionante ({}))", (Object)planoAcao);
            return new ResponseEntity((Object)this.licencaService.savePlanoAcao(planoAcao, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/planoAcaoCondicionante/{idPlanoAcao}"})
    @Operation(summary="Exclui o plano de a\u00e7\u00e3o da condicionante atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deletePlanoAcaoCondicionante(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePlanoAcaoCondicionante({})", (Object)idPlanoAcao);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.licencaService.deletePlanoAcao(empresaDB.getId(), idPlanoAcao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/statusCondicionante"})
    @Operation(summary="Consulta os status das condicionantes de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<StatusCondicionante>> findStatusCondicionante(HttpServletRequest request) {
        logger.debug("Executando findStatusCondicionante");
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List status = this.licencaService.findStatusCondicionantes(search);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findStatusCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/statusCondicionante/{idStatus}"})
    @Operation(summary="Exibe o status de condicionante para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<StatusCondicionante> getStatusCondicionante(HttpServletRequest request, @PathVariable(name="idStatus") Integer idStatus) {
        logger.debug("Executando getStatusCondicionante");
        try {
            StatusCondicionante status = this.licencaService.getStatusCondicionanteById(idStatus);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getStatusCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/statusCondicionante"})
    @Operation(summary="Salva o status de condicionante")
    public ResponseEntity<StatusCondicionante> saveStatusCondicionante(@RequestBody StatusCondicionante status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveStatusCondicionante ({}))", (Object)status);
            return new ResponseEntity((Object)this.licencaService.saveStatusCondicionante(status, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/statusCondicionante/{idStatus}"})
    @Operation(summary="Exclui o status da condicionante atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteStatusCondicionante(@PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteStatusCondicionante({})", (Object)idStatus);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteStatusCondicionante(idStatus), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/condicionantes"})
    @Operation(summary="Consulta as condicionantes de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<Condicionante>> findCondcionantes(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("Executando findCondcionantes");
        try {
            Empresa empresaDB;
            String search = null;
            String numero = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            if ((param = request.getParameter("numero")) != null && !param.isEmpty()) {
                numero = param;
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            empresas.add(empresaDB.getId());
            List condicionantes = this.licencaService.findCondicionantes(empresas, search, null, numero, null, null, null, null);
            return new ResponseEntity((Object)condicionantes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondcionantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondcionantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/condicionantes/{idCondicionante}"})
    @Operation(summary="Exibe a condicionante para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<Condicionante> getCondicionanteById(HttpServletRequest request, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        logger.debug("Executando getCondicionanteById");
        try {
            Condicionante condicionante = this.licencaService.getCondicionanteById(idCondicionante);
            return new ResponseEntity((Object)condicionante, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionanteById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionanteById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/condicionante"})
    @Operation(summary="Salva a condicionante")
    public ResponseEntity<Condicionante> saveCondicionante(@RequestBody Condicionante condicionante, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveCondicionante ({}))", (Object)condicionante);
            return new ResponseEntity((Object)this.licencaService.saveCondicionante(condicionante, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/condicionantes/{idCondicionante}"})
    @Operation(summary="Exclui a condicionante atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteCondicionante(@PathVariable(name="idCondicionante") Integer idCondicionante, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteCondicionante({})", (Object)idCondicionante);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteCondicionante(idCondicionante), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/prioridadesPlanoAcao"})
    @Operation(summary="Consulta as prioridades de plano de a\u00e7\u00e3o de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<PrioridadePlanoAcao>> findPrioridadesPlanoAcao(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("Executando findPrioridadesPlanoAcao({})", (Object)empresa);
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List prioridades = this.cadastroService.findPrioridadesPlano(empresa, search);
            return new ResponseEntity((Object)prioridades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPrioridadesPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPrioridadesPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/prioridadePlanoAcao/{idPlanoAcao}"})
    @Operation(summary="Exibe a prioridade de plano de a\u00e7\u00e3o para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<PrioridadePlanoAcao> getPrioridadePlanoACao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao) {
        logger.debug("Executando getPrioridadePlanoACao");
        try {
            PrioridadePlanoAcao prioridade = this.cadastroService.getPrioridadePlanoById(empresa, idPlanoAcao);
            return new ResponseEntity((Object)prioridade, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPrioridadePlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPrioridadePlanoACao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/prioridadePlanoAcao"})
    @Operation(summary="Salva a prioridade de plano de a\u00e7\u00e3o")
    public ResponseEntity<PrioridadePlanoAcao> savePrioridadePlanoACao(@RequestBody PrioridadePlanoAcao prioridade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePrioridadePlanoACao ({}))", (Object)prioridade);
            return new ResponseEntity((Object)this.cadastroService.savePrioridadePlano(prioridade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePrioridadePlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/prioridadePlanoAcao/{idPlanoAcao}"})
    @Operation(summary="Exclui a prioridade de plano de a\u00e7\u00e3o atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deletePrioridadePlanoAcao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePrioridadePlanoAcao({})", (Object)idPlanoAcao);
        try {
            return new ResponseEntity((Object)this.cadastroService.deletePrioridadePlano(empresa, idPlanoAcao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePrioridadePlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposPlanoAcao"})
    @Operation(summary="Consulta os tipos de plano de a\u00e7\u00e3o de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<TipoPlanoAcao>> findTipoPlanoAcao(HttpServletRequest request, @PathVariable(name="empresa") Integer empresa) {
        logger.debug("Executando findTipoPlanoAcao");
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List tipo = this.cadastroService.findTiposPlano(empresa, search);
            return new ResponseEntity((Object)tipo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTiposPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tipoPlanoAcao/{idTipoPlanoAcao}"})
    @Operation(summary="Exibe o tipo de plano de a\u00e7\u00e3o para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<TipoPlanoAcao> getTipoPlanoACao(HttpServletRequest request, @PathVariable(name="empresa") Integer empresa, @PathVariable(name="idTipoPlanoAcao") Integer idTipoPlanoAcao) {
        logger.debug("Executando getTipoPlanoACao");
        try {
            TipoPlanoAcao tipo = this.cadastroService.getTipoPlanoById(empresa, idTipoPlanoAcao);
            return new ResponseEntity((Object)tipo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoPlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getStatusPlanoACao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/tipoPlanoAcao"})
    @Operation(summary="Salva o tipo de plano de a\u00e7\u00e3o")
    public ResponseEntity<TipoPlanoAcao> saveTipoPlanoACao(@RequestBody TipoPlanoAcao tipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTipoPlanoACao ({}))", (Object)tipo);
            return new ResponseEntity((Object)this.cadastroService.saveTipoPlano(tipo, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoPlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/tipoPlanoAcao/{idTipoPlanoAcao}"})
    @Operation(summary="Exclui o tipo de plano de a\u00e7\u00e3o atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteTipoPlanoAcao(@PathVariable(name="empresa") Integer empresa, @PathVariable(name="idTipoPlanoAcao") Integer idTipoPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoPlanoAcao({})", (Object)idTipoPlanoAcao);
        try {
            return new ResponseEntity((Object)this.cadastroService.deleteTipoPlano(empresa, idTipoPlanoAcao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/statusPlanoAcao"})
    @Operation(summary="Consulta o status do plano de a\u00e7\u00e3o de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<StatusPlanoAcao>> findStatusPlanoAcao(HttpServletRequest request, @PathVariable(name="empresa") Integer empresa) {
        logger.debug("Executando findStatusPlanoAcao");
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            List status = this.cadastroService.findStatusPlano(empresa, search);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatusPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findStatusPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/statusPlanoAcao/{idStatusPlanoAcao}"})
    @Operation(summary="Exibe o status do plano de a\u00e7\u00e3o para edi\u00e7\u00e3o conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<StatusPlanoAcao> getStatusPlanoACao(HttpServletRequest request, @PathVariable(name="empresa") Integer empresa, @PathVariable(name="idStatusPlanoAcao") Integer idStatusPlanoAcao) {
        logger.debug("Executando getTipoPlanoACao");
        try {
            StatusPlanoAcao status = this.cadastroService.getStatusPlanoById(empresa, idStatusPlanoAcao);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getStatusPlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getStatusPlanoACao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/statusPlanoAcao"})
    @Operation(summary="Salva o status de plano de a\u00e7\u00e3o")
    public ResponseEntity<StatusPlanoAcao> saveStatusPlanoACao(@RequestBody StatusPlanoAcao status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveStatusPlanoACao ({}))", (Object)status);
            return new ResponseEntity((Object)this.cadastroService.saveStatusPlano(status, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusPlanoACao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/statusPlanoAcao/{idStatusPlanoAcao}"})
    @Operation(summary="Exclui o status do plano de a\u00e7\u00e3o atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteStatusPlanoAcao(@PathVariable(name="empresa") Integer empresa, @PathVariable(name="idStatusPlanoAcao") Integer idStatusPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteStatusPlanoAcao({})", (Object)idStatusPlanoAcao);
        try {
            return new ResponseEntity((Object)this.cadastroService.deleteStatusPlano(empresa, idStatusPlanoAcao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementosArboreos"})
    @Operation(summary="Consulta os Elemento arboreos de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ElementoArboreo>> findElementosArboreos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findElementosArboreos()", (Object)usuario, (Object)empresa);
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List prioridades = this.cadastroAmbientalService.findElementosArboreos(search, lastUpdate);
            return new ResponseEntity((Object)prioridades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findElementosArboreos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findElementosArboreos", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementosArboreos/{idElemento}"})
    @Operation(summary="Exibe o Elemento Arboreo conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<ElementoArboreo> getElementoArboreo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idElemento") Integer idElemento) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getElementoArboreo({})", (Object)usuario, (Object)empresa);
        try {
            ElementoArboreo elemento = this.cadastroAmbientalService.getElementoArboreoById(idElemento);
            return new ResponseEntity((Object)elemento, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getElementoArboreo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getElementoArboreo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/elementosArboreos"})
    @Operation(summary="Salva os Elementos Arb\u00f3reos")
    public ResponseEntity<ElementoArboreo> saveElementoArboreo(@PathVariable(name="empresa") String empresa, @RequestBody ElementoArboreo elemento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveElementoArboreo ({}, {}))", new Object[]{usuario, empresa, elemento});
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveElementoArboreo(elemento, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveElementoArboreo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/elementosArboreos/{idElemento}"})
    @Operation(summary="Exclui a Ocorrencia Florestal atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteElementoArboreo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idElemento") Integer idElemento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteElementoArboreo({}, {})", new Object[]{usuario, empresa, idElemento});
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteElementoArboreo(idElemento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteElementoArboreo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/ocorrenciasFlorestais"})
    @Operation(summary="Consulta as Ocorr\u00eancias Florestais de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<OcorrenciaFlorestal>> findOcorrenciasFlorestais(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findOcorrenciasFlorestais({})", (Object)usuario, (Object)empresa);
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List ocorrencias = this.cadastroAmbientalService.findOcorrenciasFlorestais(search, lastUpdate);
            return new ResponseEntity((Object)ocorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasFlorestais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findOcorrenciasFlorestais", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/ocorrenciasFlorestais/{idOcorrencia}"})
    @Operation(summary="Exibe a Ocorr\u00eancia Florestal conforme seu ID.")
    @ResponseBody
    public ResponseEntity<OcorrenciaFlorestal> getOcorrenciaFlorestal(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idOcorrencia") Integer idOcorrencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getOcorrenciaFlorestal({})", (Object)usuario, (Object)empresa);
        try {
            OcorrenciaFlorestal elemento = this.cadastroAmbientalService.getOcorrenciaFlorestalById(idOcorrencia);
            return new ResponseEntity((Object)elemento, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getOcorrenciaFlorestal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getOcorrenciaFlorestal", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/ocorrenciasFlorestais"})
    @Operation(summary="Salva a Ocorr\u00eancia Florestal")
    public ResponseEntity<OcorrenciaFlorestal> saveOcorrenciaFlorestal(@PathVariable(name="empresa") String empresa, @RequestBody OcorrenciaFlorestal ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveOcorrenciaFlorestal ({}, {}))", new Object[]{usuario, empresa, ocorrencia});
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveOcorrenciaFlorestal(ocorrencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveOcorrenciaFlorestal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/ocorrenciasFlorestais/{idOcorrencia}"})
    @Operation(summary="Exclui a Ocorrencia Florestal atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteOcorrenciaFlorestal(@PathVariable(name="empresa") String empresa, @PathVariable(name="idOcorrencia") Integer idOcorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteOcorrenciaFlorestal({}, {})", new Object[]{usuario, empresa, idOcorrencia});
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteOcorrenciaFlorestal(idOcorrencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrenciaFlorestal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/impactosAmbientais"})
    @Operation(summary="Consulta os Impactos Ambientais de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ImpactoAmbiental>> findImpactosAmbientais(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findImpactosAmbientais({})", (Object)usuario, (Object)empresa);
        try {
            String search = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List impactos = this.cadastroAmbientalService.findImpactosAmbientais(search, lastUpdate);
            return new ResponseEntity((Object)impactos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImpactosAmbientais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findImpactosAmbientais", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/impactosAmbientais/{idImpacto}"})
    @Operation(summary="Exibe o Impacto Ambiental conforme seu ID.")
    @ResponseBody
    public ResponseEntity<ImpactoAmbiental> getImpactoAmbiental(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idImpacto") Integer idImpacto) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getImpactoAmbiental({})", (Object)usuario, (Object)empresa);
        try {
            ImpactoAmbiental impacto = this.cadastroAmbientalService.getImpactoAmbientalById(idImpacto);
            return new ResponseEntity((Object)impacto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImpactoAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getImpactoAmbiental", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/impactosAmbientais"})
    @Operation(summary="Salva o Impacto Ambiental")
    public ResponseEntity<ImpactoAmbiental> saveImpactoAmbiental(@PathVariable(name="empresa") String empresa, @RequestBody ImpactoAmbiental impacto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveOcorrenciaFlorestal ({}, {}))", new Object[]{usuario, empresa, impacto});
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveImpactoAmbiental(impacto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveImpactoAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/impactosAmbientais/{idImpacto}"})
    @Operation(summary="Exclui o Impacto Ambiental atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteImpactoAmbiental(@PathVariable(name="empresa") String empresa, @PathVariable(name="idImpacto") Integer idImpacto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteImpactoAmbiental({}, {})", new Object[]{usuario, empresa, idImpacto});
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteImpactoAmbiental(idImpacto), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteImpactoAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/materiaisApoio"})
    @Operation(summary="Exibe a lista dos Materiais de Apoio")
    public List<MaterialApoio> findMateriaisApoio(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findMateriaisApoio()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findMateriaisApoio(searchTxt);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/materiaisApoio/{idMaterialApoio}"})
    @Operation(summary="Exibe o Material de Apoio conforme seu identificador")
    public MaterialApoio getMaterialApoioById(@PathVariable Integer idMaterialApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getMaterialApoioById ({})...", (Object)usuario.getLogin(), (Object)idMaterialApoio);
            MaterialApoio materialApoio = this.cadastroAmbientalService.getMaterialApoioById(idMaterialApoio);
            return materialApoio;
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/materiaisApoio"})
    @Operation(summary="Registrar ou atualizar o Material de Apoio")
    public ResponseEntity<MaterialApoio> registrarMaterialApoio(@RequestBody MaterialApoio materialApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarMaterialApoio ({}))", (Object)user.getLogin(), (Object)materialApoio);
            MaterialApoio material = this.cadastroAmbientalService.saveMaterialApoio(materialApoio, user.getId());
            return new ResponseEntity((Object)material, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarMaterialApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/materiaisApoio/{idMaterialApoio}"})
    @Operation(summary="Exclui o Material de Apoio conforme seu identificador")
    public Boolean deleteMaterialApoioById(@PathVariable Integer idMaterialApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteMaterialApoio({})", (Object)idMaterialApoio);
        try {
            return this.cadastroAmbientalService.deleteMaterialApoioById(idMaterialApoio);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteMaterialApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/statusAprovacoesAgencia"})
    @Operation(summary="Exibe a lista dos Status de Aprova\u00e7\u00f5es da Ag\u00eancia")
    public List<StatusAprovacaoAgencia> findStatusAprovacoesAgencia(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findStatusAprovacaoAgencia()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findStatusAprovacoesAgencia(searchTxt);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/statusAprovacoesAgencia/{idStatusAprovacaoAgencia}"})
    @Operation(summary="Exibe o Status da Aprova\u00e7\u00e3o da Ag\u00eancia conforme seu identificador")
    public StatusAprovacaoAgencia getStatusAprovacaoAgenciaById(@PathVariable Integer idStatusAprovacaoAgencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getStatusAprovacaoAgenciaById ({})...", (Object)usuario.getLogin(), (Object)idStatusAprovacaoAgencia);
            StatusAprovacaoAgencia statusAprovacaoAgencia = this.cadastroAmbientalService.getStatusAprovacaoAgenciaById(idStatusAprovacaoAgencia);
            return statusAprovacaoAgencia;
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/statusAprovacoesAgencia"})
    @Operation(summary="Registrar ou atualizar o Status da Aprova\u00e7\u00e3o da Ag\u00eancia")
    public ResponseEntity<StatusAprovacaoAgencia> registrarStatusAprovacaoAgencia(@RequestBody StatusAprovacaoAgencia statusAprovacaoAgencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarStatusAprovacaoAgencia ({}))", (Object)user.getLogin(), (Object)statusAprovacaoAgencia);
            StatusAprovacaoAgencia status = this.cadastroAmbientalService.saveStatusAprovacaoAgencia(statusAprovacaoAgencia, user.getId());
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarStatusAprovacaoAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/statusAprovacoesAgencia/{idStatusAprovacaoAgencia}"})
    @Operation(summary="Exclui o Status da Aprova\u00e7\u00e3o da Ag\u00eancia conforme seu identificador")
    public Boolean deleteStatusAprovacaoAgenciaById(@PathVariable Integer idStatusAprovacaoAgencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteStatusAprovacaoAgencia({})", (Object)idStatusAprovacaoAgencia);
        try {
            return this.cadastroAmbientalService.deleteStatusAprovacaoAgenciaById(idStatusAprovacaoAgencia);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusAprovacaoAgencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/statusAprovacoesUso"})
    @Operation(summary="Exibe a lista dos Status das Aprova\u00e7\u00f5es de Uso")
    public List<StatusAprovacaoUso> findStatusAprovacoesUso(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findStatusAprovacaoUso()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findStatusAprovacoesUso(searchTxt);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/statusAprovacoesUso/{idStatusAprovacaoUso}"})
    @Operation(summary="Exibe o Status da Aprova\u00e7\u00e3o de Uso conforme seu identificador")
    public StatusAprovacaoUso getStatusAprovacaoUsoById(@PathVariable Integer idStatusAprovacaoUso, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getStatusAprovacaoUsoById ({})...", (Object)usuario.getLogin(), (Object)idStatusAprovacaoUso);
            StatusAprovacaoUso statusAprovacaoUso = this.cadastroAmbientalService.getStatusAprovacaoUsoById(idStatusAprovacaoUso);
            return statusAprovacaoUso;
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/statusAprovacoesUso"})
    @Operation(summary="Registrar ou atualizar o Status da Aprova\u00e7\u00e3o de Uso")
    public ResponseEntity<StatusAprovacaoUso> registrarStatusAprovacaoUso(@RequestBody StatusAprovacaoUso statusAprovacaoUso, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarStatusAprovacaoUso ({}))", (Object)user.getLogin(), (Object)statusAprovacaoUso);
            StatusAprovacaoUso status = this.cadastroAmbientalService.saveStatusAprovacaoUso(statusAprovacaoUso, user.getId());
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarStatusAprovacaoUso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/statusAprovacoesUso/{idStatusAprovacaoUso}"})
    @Operation(summary="Exclui o Status da Aprova\u00e7\u00e3o de Uso conforme seu identificador")
    public Boolean deleteStatusAprovacaoUsoById(@PathVariable Integer idStatusAprovacaoUso, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteStatusAprovacaoUso({})", (Object)idStatusAprovacaoUso);
        try {
            return this.cadastroAmbientalService.deleteStatusAprovacaoUsoById(idStatusAprovacaoUso);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusAprovacaoUso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposStatus"})
    @Operation(summary="Exibe a lista dos Tipos status da \u00c1rea de Apoio")
    public List<TipoStatusUtilizacao> findTiposStatus(HttpServletRequest request, @RequestParam String tipo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findTiposStatus({})...", (Object)usuario.getLogin(), (Object)tipo);
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findTipoStatusAreasApoio(searchTxt, tipo, null);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/tiposStatus/{idTipo}"})
    @Operation(summary="Exibe o Tipo Status da \u00c1rea de Apoio conforme seu identificador")
    public TipoStatusUtilizacao getTipoStatusById(@PathVariable Integer idTipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getTipoStatusById ({})...", (Object)usuario.getLogin(), (Object)idTipo);
            return this.cadastroAmbientalService.getTipoStatusAreaApoioById(idTipo);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/tiposStatus"})
    @Operation(summary="Registrar o Tipo Status da \u00c1rea de Apoio")
    public ResponseEntity<TipoStatusUtilizacao> registrarTipoStatus(@RequestBody TipoStatusUtilizacao tipoStatusAreaApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarStatusUtilizacao ({}))", (Object)user.getLogin(), (Object)tipoStatusAreaApoio);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveTipoStatusAreaApoio(tipoStatusAreaApoio, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarTipoStatus", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/tiposStatus"})
    @Operation(summary="Atualizar o Tipo Status da \u00c1rea de Apoio")
    public ResponseEntity<TipoStatusUtilizacao> atualizarTipoStatus(@RequestBody TipoStatusUtilizacao tipoStatusAreaApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - atualizarTipoStatus ({}))", (Object)user.getLogin(), (Object)tipoStatusAreaApoio);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveTipoStatusAreaApoio(tipoStatusAreaApoio, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.atualizarTipoStatus", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tiposStatus/{idTipo}"})
    @Operation(summary="Exclui o Tipo Status da \u00c1rea de Apoio conforme seu identificador")
    public Boolean deleteTipoStatusById(@PathVariable Integer idTipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoStatusById({})", (Object)idTipo);
        try {
            return this.cadastroAmbientalService.deleteTipoStatusAreaApoioById(idTipo);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoStatusById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/orgaosAprovadores"})
    @Operation(summary="Exibe a lista de \u00d3rg\u00e3o Aprovador da \u00c1rea de Apoio")
    public List<OrgaoAprovador> findOrgaosAprovadores(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findTiposStatus()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findOrgaosAprovadoresAreasApoio(searchTxt, null);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/orgaosAprovadores/{idOrgao}"})
    @Operation(summary="Exibe o \u00d3rg\u00e3o Aprovador da \u00c1rea de Apoio conforme seu identificador")
    public OrgaoAprovador getOrgaoAprovadorById(@PathVariable Integer idOrgao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getTipoStatusById ({})...", (Object)usuario.getLogin(), (Object)idOrgao);
            return this.cadastroAmbientalService.getOrgaoAprovadorById(idOrgao);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/orgaosAprovadores"})
    @Operation(summary="Registrar um \u00d3rg\u00e3o Aprovador da \u00c1rea de Apoio")
    public ResponseEntity<OrgaoAprovador> registrarOrgaoAprovador(@RequestBody OrgaoAprovador areaApoioOrgao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarOrgaoAprovador ({}))", (Object)user.getLogin(), (Object)areaApoioOrgao);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveOrgaoAprovadorAreaApoio(areaApoioOrgao, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarOrgaoAprovador", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/orgaosAprovadores"})
    @Operation(summary="Atualizar o \u00d3rg\u00e3o Aprovador da \u00c1rea de Apoio")
    public ResponseEntity<OrgaoAprovador> atualizarOrgaoAprovador(@RequestBody OrgaoAprovador areaApoioOrgao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - atualizarOrgaoAprovador ({}))", (Object)user.getLogin(), (Object)areaApoioOrgao);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveOrgaoAprovadorAreaApoio(areaApoioOrgao, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.atualizarOrgaoAprovador", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/orgaosAprovadores/{idOrgao}"})
    @Operation(summary="Exclui o \u00d3rg\u00e3o Aprovador da \u00c1rea de Apoio conforme seu identificador")
    public Boolean deleteOrgaoAprovadorById(@PathVariable Integer idOrgao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteOrgaoAprovadorById({}) - {}", (Object)idOrgao, (Object)usuario);
        try {
            return this.cadastroAmbientalService.deleteOrgaoAprovadorAreaApoioById(idOrgao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOrgaoAprovadorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/pareceres"})
    @Operation(summary="Exibe a lista dos Parecer Autorizativo da \u00c1rea de Apoio")
    public List<ParecerAutorizativo> findPareceres(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findPareceres()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findPareceresAreasApoio(searchTxt, null);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/pareceres/{idParecer}"})
    @Operation(summary="Exibe o Parecer Autorizativo da \u00c1rea de Apoio conforme seu identificador")
    public ParecerAutorizativo getParecerById(@PathVariable Integer idParecer, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getParecerById ({})...", (Object)usuario.getLogin(), (Object)idParecer);
            return this.cadastroAmbientalService.getParecerAreaApoioById(idParecer);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/pareceres"})
    @Operation(summary="Registrar o Parecer Autorizativo da \u00c1rea de Apoio")
    public ResponseEntity<ParecerAutorizativo> registrarParecer(@RequestBody ParecerAutorizativo parecer, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarParecer ({}))", (Object)user.getLogin(), (Object)parecer);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveParecerAreaApoio(parecer, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarParecer", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/pareceres"})
    @Operation(summary="Atualizar o Parecer Autorizativo da \u00c1rea de Apoio")
    public ResponseEntity<ParecerAutorizativo> atualizarParecer(@RequestBody ParecerAutorizativo parecer, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - atualizarParecer ({}))", (Object)user.getLogin(), (Object)parecer);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveParecerAreaApoio(parecer, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.atualizarParecer", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/pareceres/{idParecer}"})
    @Operation(summary="Exclui o Parecer Autorizativo da \u00c1rea de Apoio conforme seu identificador")
    public Boolean deleteParecerById(@PathVariable Integer idParecer, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteParecerById({})", (Object)idParecer);
        try {
            return this.cadastroAmbientalService.deleteParecerAreaApoioById(idParecer);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteParecerById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/areasEspecialmenteProtegidas"})
    @Operation(summary="Exibe a lista de \u00c1reas Especialmente Protegidas")
    public List<AreaEspecialmenteProtegida> findAreasEspecialmenteProtegidas(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findAreasEspecialmenteProtegidas()...", (Object)usuario.getLogin());
            String searchTxt = null;
            String categoria = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("categoria") != null) {
                categoria = request.getParameter("categoria");
            }
            return this.cadastroAmbientalService.findAreasEspecialmenteProtegidas(searchTxt, categoria);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/areasEspecialmenteProtegidas/{idArea}"})
    @Operation(summary="Exibe a \u00c1rea Especialmente Protegida conforme seu identificador")
    public AreaEspecialmenteProtegida getAreaEspecialmenteProtegidaById(@PathVariable Integer idArea, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getAreaEspecialmenteProtegidaById ({})...", (Object)usuario.getLogin(), (Object)idArea);
            return this.cadastroAmbientalService.getAreaEspecialmenteProtegidaById(idArea);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/areasEspecialmenteProtegidas"})
    @Operation(summary="Registrar uma \u00c1rea Especialmente Protegida")
    public ResponseEntity<AreaEspecialmenteProtegida> registrarAreaEspecialmenteProtegida(@RequestBody AreaEspecialmenteProtegida areaEspecialmenteProtegida, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarAreaEspecialmenteProtegida ({}))", (Object)user.getLogin(), (Object)areaEspecialmenteProtegida);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveAreaEspecialmenteProtegida(areaEspecialmenteProtegida, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarAreaEspecialmenteProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/areasEspecialmenteProtegidas/{idArea}"})
    @Operation(summary="Exclui a \u00c1rea Especialmente Protegida conforme seu identificador")
    public Boolean deleteAreaEspecialmenteProtegidaById(@PathVariable Integer idArea, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteAreaEspecialmenteProtegidaById({}) - {}", (Object)idArea, (Object)usuario);
        try {
            return this.cadastroAmbientalService.deleteAreaEspecialmenteProtegidaById(idArea);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaEspecialmenteProtegidaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/grausRiscos"})
    @Operation(summary="Exibe a lista de Grau de Risco")
    public List<GrauRisco> findGrausRiscos(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findGrausRiscos({})...", (Object)usuario.getLogin(), (Object)empresa);
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findGrausRiscos(searchTxt, null);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/grausRiscos/{idRisco}"})
    @Operation(summary="Exibe o Grau de Risco conforme seu identificador")
    public GrauRisco getGrauRiscoById(@PathVariable String empresa, @PathVariable Integer idRisco, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getGrauRiscoById ({}, {})...", new Object[]{usuario.getLogin(), idRisco, empresa});
            return this.cadastroAmbientalService.getGrauRiscoById(idRisco);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/grausRiscos"})
    @Operation(summary="Registrar um Grau de Risco")
    public ResponseEntity<GrauRisco> registrarGrauRisco(@RequestBody GrauRisco grauRisco, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarGrauRisco ({}))", (Object)user.getLogin(), (Object)grauRisco);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveGrauRisco(grauRisco, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarGrauRisco", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/grausRiscos"})
    @Operation(summary="Atualiza um Grau de Risco")
    public ResponseEntity<GrauRisco> updateGrauRisco(@PathVariable String empresa, @RequestBody GrauRisco grauRisco, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - updateGrauRisco ({}))", (Object)user.getLogin(), (Object)grauRisco);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveGrauRisco(grauRisco, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarGrauRisco", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/grausRiscos/{idRisco}"})
    @Operation(summary="Exclui um Grau de Risco conforme seu identificador")
    public Boolean deleteGrauRiscoById(@PathVariable String empresa, @PathVariable Integer idRisco, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteGrauRiscoById({}) - {}", (Object)idRisco, (Object)usuario);
        try {
            return this.cadastroAmbientalService.deleteGrauRiscoById(idRisco);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrauRiscoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposRequisitosLegais"})
    @Operation(summary="Exibe a lista de tipo de Requisito Legal")
    public List<TipoRequisitoLegal> findTiposRequisitosLegais(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findTiposRequisitosLegais()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.cadastroAmbientalService.findTiposRequisitosLegais(searchTxt, null);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposRequisitosLegais/{idTipo}"})
    @Operation(summary="Exibe o Tipo Requisito Legal conforme seu identificador")
    public TipoRequisitoLegal getTipoRequisitoLegalById(@PathVariable Integer idTipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getTipoRequisitoLegalById ({})...", (Object)usuario.getLogin(), (Object)idTipo);
            return this.cadastroAmbientalService.getTipoRequisitoLegalById(idTipo);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/tiposRequisitosLegais"})
    @Operation(summary="Registrar o Tipo Requisito Legal")
    public ResponseEntity<TipoRequisitoLegal> registrarTipoRequisitoLegal(@PathVariable String empresa, @RequestBody TipoRequisitoLegal tipoRequisitoLegal, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarTipoRequisitoLegal ({}))", (Object)user.getLogin(), (Object)tipoRequisitoLegal);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveTipoRequisitoLegal(tipoRequisitoLegal, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarTipoRequisitoLegal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/tiposRequisitosLegais"})
    @Operation(summary="Atualizar o Tipo Requisito Legal")
    public ResponseEntity<TipoRequisitoLegal> atualizarTipoRequisitoLegal(@PathVariable String empresa, @RequestBody TipoRequisitoLegal tipoRequisitoLegal, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - atualizarTipoRequisitoLegal ({}))", (Object)user.getLogin(), (Object)tipoRequisitoLegal);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveTipoRequisitoLegal(tipoRequisitoLegal, user.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.atualizarTipoRequisitoLegal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/tiposRequisitosLegais/{idTipo}"})
    @Operation(summary="Exclui o Tipo Requisito Legal conforme seu identificador")
    public Boolean deleteTipoRequisitoLegalById(@PathVariable String empresa, @PathVariable Integer idTipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoRequisitoLegalById({})", (Object)idTipo);
        try {
            return this.cadastroAmbientalService.deleteTipoRequisitoLegalById(idTipo);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoRequisitoLegalById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

