/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoCanal;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSessao;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para downloads", name="downloads")
@RequestMapping(value={"/api/downloads"})
public class DownloadsRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(DownloadsRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;

    @GetMapping(value={"/{empresa}/anexos/{modulo}/{uuid}"})
    @Operation(summary="Efetua o download do anexo no GED, conforme UUID e M\u00f3dulo")
    @ResponseBody
    public ResponseEntity<Object> downloadAnexo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="uuid") String uuid) {
        PublicUser usuario;
        logger.debug("Downloading anexos (emp={},modulo={},uuid={})...", new Object[]{empresa, modulo, uuid});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        if (modulo == null || modulo.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "M\u00f3dulo do anexo n\u00e3o informado.");
        }
        if (uuid == null || uuid.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Identificador do Anexo n\u00e3o informado.");
        }
        UsuarioSessao sessao = null;
        if (request.getParameter("token") != null) {
            sessao = this.getSessaoUsuarioByToken(request.getParameter("token"));
        }
        if (!(sessao != null && sessao.getUsuario() != null || modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) || modulo.equals(TipoModulo.MEIO_AMBIENTE.getSigla()) || modulo.equals(TipoModulo.ATIVOS.getSigla()) || modulo.equals(TipoModulo.SIGACO.getSigla()) || modulo.equals(TipoModulo.LABORATORIO.getSigla()) || (usuario = this.getUsuarioByJWT(request)) != null)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
        }
        try {
            PublicUser usuario2;
            UploadedFileInfo gedFileInfo = this.gedService.getFileInfoByUuid(emp.getId(), uuid, Boolean.valueOf(false));
            if (gedFileInfo == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Anexo n\u00e3o foi encontrado no reposit\u00f3rio.");
            }
            if (modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) && !gedFileInfo.getItemModulo().equalsIgnoreCase("Assinatura digital") && sessao == null && (usuario2 = this.getUsuarioByJWT(request)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
            }
            byte[] gedBytes = null;
            int imgWidth = 768;
            boolean gedImage = gedFileInfo.getFileName().toLowerCase().matches("(jpg|jpeg|gif|png)");
            if (sessao != null && sessao.getCanal().equals(TipoCanal.MOBILE.getCode()) && gedImage && gedFileInfo.getSize() > 524288L) {
                String repoAdicional = this.coreService.getRepoPathLeitura(emp.getId());
                gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, repoAdicional);
                if (gedBytes == null) {
                    this.gedService.createScaledImage(gedFileInfo.getFullPath(), gedFileInfo.getRepoPath(), Integer.valueOf(imgWidth), repoAdicional);
                    gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, repoAdicional);
                }
            } else {
                gedBytes = this.gedService.getFileBytesByUUID(emp.getId(), uuid, null);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", gedFileInfo.getContentType());
            headers.add("Content-Disposition", "attachment; filename=\"" + gedFileInfo.getFileName() + "\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(gedFileInfo.getSize().longValue()).body((Object)new ByteArrayResource(gedBytes));
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/thumbs/{modulo}/{uuid}"})
    @Operation(summary="Efetua o download do Thumbnail no GED, conforme UUID e M\u00f3dulo. O anexo precisa ser do tipo imagem.")
    @ResponseBody
    public ResponseEntity<Object> downloadThumb(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="uuid") String uuid) {
        ResponseEntity responseEntity;
        block17: {
            logger.debug("Downloading Thumb (emp={},modulo={},uuid={})...", new Object[]{empresa, modulo, uuid});
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (modulo == null || modulo.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo do M\u00f3dulo n\u00e3o foi informado.");
            }
            if (uuid == null || uuid.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "UUID do Anexo n\u00e3o foi informado.");
            }
            PublicUser usuario = null;
            if (request.getParameter("token") != null) {
                usuario = this.getUsuarioByToken(request.getParameter("token"));
            }
            if (!(usuario != null || modulo.equals(TipoModulo.CORRESPONDENCIAS.getSigla()) || modulo.equals(TipoModulo.MEIO_AMBIENTE.getSigla()) || modulo.equals(TipoModulo.ATIVOS.getSigla()) || modulo.equals(TipoModulo.SIGACO.getSigla()) || modulo.equals(TipoModulo.LABORATORIO.getSigla()) || (usuario = this.getUsuarioByJWT(request)) != null)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Token de acesso n\u00e3o dispon\u00edvel.");
            }
            UploadedFileInfo fileInfo = this.gedService.getFileInfoByUuid(emp.getId(), uuid, Boolean.valueOf(false));
            if (fileInfo.getFileName().toLowerCase().matches("(jpg|jpeg|gif|png)")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Anexo n\u00e3o \u00e9 uma imagem.");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", fileInfo.getContentType());
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            InputStream streamThumb = this.gedService.getThumbnailByUUID(emp.getId(), uuid, null);
            try {
                if (streamThumb == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Miniatura n\u00e3o foi encontrada no reposit\u00f3rio.");
                }
                byte[] bytes = streamThumb.readAllBytes();
                ByteArrayResource resThumb = new ByteArrayResource(bytes);
                responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(fileInfo.getSize().longValue()).body((Object)resThumb);
                if (streamThumb == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (streamThumb != null) {
                        try {
                            streamThumb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioExc) {
                    logger.error("ioExc", (Throwable)ioExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
                catch (BusinessException bizExc) {
                    logger.error("bizExc", (Throwable)bizExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
                }
            }
            streamThumb.close();
        }
        return responseEntity;
    }

    @GetMapping(value={"/logomarcas"})
    @Operation(summary="Efetua o download das logomarcas das empresas")
    @ResponseBody
    public ResponseEntity<ArrayNode> downloadLogomarcas() {
        logger.debug("Downloading logomarcas()...");
        List empresas = this.coreService.findEmpresas(null, null);
        ArrayNode logomarcas = JsonNodeFactory.instance.arrayNode();
        for (Empresa empresa : empresas) {
            logger.debug("looping empresa={}", (Object)empresa.getSigla());
            String pathGeral = this.coreService.getRepoPath(empresa.getId());
            String logomarca = null;
            for (RefCode refEmp : this.coreService.findRefCodes(empresa.getId(), "INFRA.")) {
                if (refEmp.getIdEmpresa() == null || !refEmp.getIdEmpresa().equals(empresa.getId()) || !refEmp.getRefName().equals(TipoRefCode.INFRA_LOGOMARCA.getRefName())) continue;
                logomarca = refEmp.getRefValue();
            }
            File logoFile = null;
            String extensao = null;
            byte[] bytes = null;
            if (pathGeral != null && logomarca != null) {
                StringBuilder filePath = new StringBuilder();
                filePath.append(pathGeral);
                filePath.append(File.separator);
                filePath.append("img");
                filePath.append(File.separator);
                filePath.append(logomarca);
                logger.debug("reading logomarca={}", (Object)filePath.toString());
                extensao = FilenameUtils.getExtension((String)filePath.toString());
                logoFile = new File(filePath.toString());
            }
            if (pathGeral == null || logomarca == null || logoFile == null || !logoFile.exists()) {
                try {
                    ClassLoader cl = DownloadsRestServices.class.getClassLoader();
                    URL is = cl.getResource("img/logo_gesconsys.png");
                    if (is == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Logo padr\u00e3o (Gesconsys) n\u00e3o foi encontrada, verifique.");
                    }
                    bytes = IOUtils.toByteArray((URL)is);
                    extensao = "png";
                }
                catch (FileNotFoundException fnfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
                }
                catch (IOException ioExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
            }
            if (logoFile != null && logoFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(logoFile);
                    bytes = new byte[(int)logoFile.length()];
                    fis.read(bytes);
                    fis.close();
                }
                catch (FileNotFoundException fnfExc) {
                    logger.error("fnfExc", (Throwable)fnfExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
                }
                catch (IOException ioExc) {
                    logger.error("ioExc", (Throwable)ioExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
            }
            if (bytes == null || bytes.length <= 0) continue;
            ObjectNode node = JsonNodeFactory.instance.objectNode();
            node.put("empresa", empresa.getSigla());
            node.put("imagem", Base64.encodeBase64String((byte[])bytes));
            node.put("extensao", extensao);
            logomarcas.add((JsonNode)node);
        }
        return new ResponseEntity((Object)logomarcas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/backgrounds"})
    @Operation(summary="Efetua o download do background padr\u00e3o")
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> downloadBackgroundPadrao(HttpServletResponse response) {
        logger.debug("API downloadBackgroundPadrao...");
        Integer empresaGlobal = (Integer)this.coreService.getGlobalRefValueByName(TipoRefCode.INFRA_EMPRESA_PADRAO);
        StreamingResponseBody stream = out -> {
            File backgroundFile = null;
            byte[] bytes = null;
            if (empresaGlobal != null) {
                Object backgroundPath = this.coreService.getRefValueByName(empresaGlobal, TipoRefCode.INFRA_BACKGROUND_EMPRESA);
                if (backgroundPath == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Background padr\u00e3o n\u00e3o informado.");
                }
                if (backgroundPath != null) {
                    Object pathGeral = this.coreService.getRefValueByName(empresaGlobal, TipoRefCode.INFRA_PATH_GERAL);
                    StringBuilder filePath = new StringBuilder();
                    filePath.append(pathGeral);
                    filePath.append(File.separator);
                    filePath.append("img");
                    filePath.append(File.separator);
                    filePath.append(backgroundPath);
                    logger.debug("reading background={}", (Object)filePath.toString());
                    String fileName = FilenameUtils.getName((String)filePath.toString());
                    backgroundFile = new File(filePath.toString());
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                }
            }
            if (backgroundFile != null && backgroundFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(backgroundFile);
                    bytes = new byte[(int)backgroundFile.length()];
                    fis.read(bytes);
                    fis.close();
                }
                catch (FileNotFoundException fnfExc) {
                    logger.error("fnfExc", (Throwable)fnfExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
                }
                catch (IOException ioExc) {
                    logger.error("ioExc", (Throwable)ioExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
                }
            }
            String fileName = "full-background.jpg";
            try {
                ClassLoader cl = DownloadsRestServices.class.getClassLoader();
                URL is = cl.getResource("img/" + fileName);
                if (is == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Logo padr\u00e3o n\u00e3o foi encontrada, verifique.");
                }
                bytes = IOUtils.toByteArray((URL)is);
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            }
            catch (FileNotFoundException fnfExc) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
            }
            catch (IOException ioExc) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
            }
            out.write(bytes);
        };
        logger.info("streaming response({})", (Object)empresaGlobal);
        return new ResponseEntity((Object)stream, (HttpStatusCode)HttpStatus.OK);
    }
}

