/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.i18n.LocaleContextHolder;

@SpringBootApplication
@ConfigurationPropertiesScan(value={"br.com.oti.gesconsys"})
public class GesconAmbientalApplication
implements CommandLineRunner {
    private static Logger LOG = LoggerFactory.getLogger(GesconAmbientalApplication.class);

    public static void main(String[] args) throws IOException {
        LOG.info("STARTING Gesconsys Ambiental Application");
        SpringApplication.run(GesconAmbientalApplication.class, (String[])args);
        Locale locale = LocaleContextHolder.getLocale();
        LOG.info("LOCALE INFO => lang:{}, region:{}", (Object)locale.getLanguage(), (Object)locale.getCountry());
        String version = "0.0.1";
        InputStream streamCustom = GesconAmbientalApplication.class.getClassLoader().getResourceAsStream("custom.properties");
        if (streamCustom != null) {
            Properties props = new Properties();
            props.load(streamCustom);
            version = props.getProperty("versao", "0.0.1");
        }
        LOG.info("FINISHED Gesconsys Ambiental Application {}", (Object)version);
    }

    public void run(String ... args) {
        LOG.info("EXECUTING : command line runner");
        for (int i = 0; i < args.length; ++i) {
            LOG.info("args[{}]: {}", (Object)i, (Object)args[i]);
        }
    }
}

