/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.sso.controllers;

import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.TipoEmpresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSsoLogin;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.utils.MD5Utils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/sso"})
public class SSOController {
    private static final Logger LOG = LoggerFactory.getLogger(SSOController.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/register"})
    public String register(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException, ServletException {
        Usuario user = null;
        String userId = request.getParameter("principalName");
        if (userId == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi informado.");
        }
        try {
            user = this.segurancaService.getUsuarioByLoginOrMail(userId);
        }
        catch (BusinessException bizExc) {
            user = null;
        }
        String[] groups = request.getParameterValues("groups");
        if (groups == null || groups.length == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Grupos do usu\u00e1rio n\u00e3o foram informados.");
        }
        LOG.debug("Groups.size = {}...", (Object)groups.length);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String group : groups) {
            LOG.debug("Add group '{}' to authority...", (Object)group);
            authorities.add(new SimpleGrantedAuthority(group));
        }
        Date sysDate = new Date(System.currentTimeMillis());
        String userName = null;
        String displayName = request.getParameter("displayName");
        LOG.debug("displayName={}", (Object)displayName);
        if (user == null) {
            LOG.debug("Usu\u00e1rio '{}' n\u00e3o foi encontrado, criando...", (Object)userId);
            userName = userId.toLowerCase();
            int idxMail = userId.indexOf("@");
            if (idxMail != -1) {
                userName = userId.substring(0, idxMail);
            }
            List empresas = this.coreService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            Empresa empresa = (Empresa)empresas.get(0);
            Integer idUserAdmin = empresa.getIdUsuarioIns();
            Usuario userDB = this.segurancaService.createUsuario(userName, userId, userId, empresa.getId(), idUserAdmin);
            String userMail = null;
            if (idxMail != -1) {
                userMail = userName;
            }
            String name = userId;
            if (displayName != null) {
                name = displayName;
            }
            if (userDB != null) {
                userDB.setEmail(userId);
                userDB.setTipo(TipoUsuario.ACESSO_SSO.getCode());
                UsuarioPerfil perfil = new UsuarioPerfil();
                perfil.setIdUsuario(userDB.getId());
                perfil.setSenha(MD5Utils.transformToMD5((String)LocalDateTime.now().toString()));
                perfil.setAdministrador(Integer.valueOf(0));
                perfil.setBloqueado(Integer.valueOf(0));
                ArrayList<UsuarioGrupo> gruposId = new ArrayList<UsuarioGrupo>();
                GrupoAcessoUsuario defGrp = null;
                List grupos = this.segurancaService.findGruposAcessoUsuarios(null, null);
                for (String authority : groups) {
                    LOG.debug("group =>{} ", (Object)authority);
                    defGrp = null;
                    for (GrupoAcessoUsuario grupo : grupos) {
                        if (!authority.trim().equalsIgnoreCase(grupo.getDescricao().trim())) continue;
                        defGrp = grupo;
                        break;
                    }
                    if (defGrp == null) continue;
                    LOG.debug("defGroup.1 ({})", (Object)defGrp.getId());
                    UsuarioGrupo grupo = new UsuarioGrupo();
                    grupo.setGrupoAcesso(defGrp);
                    grupo.getId().setIdUsuario(userDB.getId());
                    grupo.getId().setIdGrupoUsuario(defGrp.getId());
                    grupo.setGrupoAcesso(this.segurancaService.getGrupoAcessoUsuarioById(defGrp.getId()));
                    grupo.setDatHorCadastro(sysDate);
                    grupo.setIdUsuarioIns(userDB.getId());
                    gruposId.add(grupo);
                }
                if (defGrp == null && gruposId.isEmpty()) {
                    LOG.debug("defGroup.2 == NULL");
                    Integer defGrpId = (Integer)this.coreService.getRefValueByName((Integer)null, TipoRefCode.INFRA_SSO_GRUPO_ACESSO);
                    if (defGrpId == null) {
                        defGrpId = ((GrupoAcessoUsuario)grupos.get(0)).getId();
                    }
                    UsuarioGrupo grupo = new UsuarioGrupo();
                    grupo.getId().setIdUsuario(userDB.getId());
                    grupo.getId().setIdGrupoUsuario(defGrpId);
                    grupo.setGrupoAcesso(this.segurancaService.getGrupoAcessoUsuarioById(defGrpId));
                    grupo.setDatHorCadastro(sysDate);
                    grupo.setIdUsuarioIns(userDB.getId());
                    gruposId.add(grupo);
                }
                ArrayList<UsuarioEmpresa> empresasUsr = new ArrayList<UsuarioEmpresa>();
                UsuarioEmpresa empresaUsr = new UsuarioEmpresa();
                empresaUsr.getId().setIdUsuario(userDB.getId());
                empresaUsr.getId().setIdEmpresa(empresa.getId());
                empresaUsr.setDatHorCadastro(new Date(System.currentTimeMillis()));
                empresaUsr.setIdUsuarioIns(idUserAdmin);
                empresaUsr.setEmpresa(empresa);
                empresasUsr.add(empresaUsr);
                for (UsuarioGrupo grp : gruposId) {
                    Integer usrAdmin;
                    if (grp.getGrupoAcesso() == null || (usrAdmin = grp.getGrupoAcesso().getAdministrador()) == null || !usrAdmin.equals(1)) continue;
                    LOG.debug("Usu\u00e1rio \u00e9 um ADMIN, definindo como tal.");
                    perfil.setAdministradorBoolean(Boolean.valueOf(true));
                    break;
                }
                this.segurancaService.saveUsuario(userDB, perfil, gruposId, empresasUsr, idUserAdmin, "0.0.0.0");
                this.segurancaService.saveUsuarioEmpresa(empresaUsr);
            }
        } else {
            userName = user.getLogin();
            LOG.debug("Usu\u00e1rio '{}' j\u00e1 encontrado, atualizando grupos...", (Object)user.getLogin());
            List baseGrupos = this.segurancaService.findGruposAcessoUsuarios(null, null);
            List userGrupos = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
            ArrayList<UsuarioGrupo> userGroupsNew = new ArrayList<UsuarioGrupo>();
            block6: for (String authority : groups) {
                boolean flagGrp = false;
                for (UsuarioGrupo userGrupo : userGrupos) {
                    if (!userGrupo.getGrupoAcesso().getDescricao().equalsIgnoreCase(authority)) continue;
                    flagGrp = true;
                    LOG.debug("Grupo acesso '{}' existente, atualizando...", (Object)authority);
                    userGroupsNew.add(userGrupo);
                    break;
                }
                if (flagGrp) continue;
                LOG.debug("Grupo acesso '{}' novo/atribui\u00eddo...", (Object)authority);
                for (GrupoAcessoUsuario grupo : baseGrupos) {
                    if (!authority.trim().equalsIgnoreCase(grupo.getDescricao().trim())) continue;
                    LOG.debug("Grupo '{}' encontrado '{}'", (Object)authority, (Object)grupo.getId());
                    UsuarioGrupo grupoDB = new UsuarioGrupo();
                    grupoDB.getId().setIdUsuario(user.getId());
                    grupoDB.getId().setIdGrupoUsuario(grupo.getId());
                    grupoDB.setGrupoAcesso(grupo);
                    grupoDB.setDatHorCadastro(sysDate);
                    grupoDB.setIdUsuarioIns(user.getId());
                    userGroupsNew.add(grupoDB);
                    continue block6;
                }
            }
            boolean userAdmin = false;
            for (UsuarioGrupo grp : userGroupsNew) {
                Integer usrAdmin;
                if (grp.getGrupoAcesso() == null || (usrAdmin = grp.getGrupoAcesso().getAdministrador()) == null || !usrAdmin.equals(1)) continue;
                LOG.debug("Usu\u00e1rio \u00e9 um ADMIN, definindo como tal.");
                userAdmin = true;
                break;
            }
            this.segurancaService.saveUsuariosGrupos(userGroupsNew, user.getId());
            if (userAdmin) {
                UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
                this.segurancaService.savePerfilUsuario(perfil);
            }
        }
        AuthLogin authLogin = new AuthLogin();
        authLogin.setUserName(userId);
        authLogin.setGroups(List.of(groups));
        UsuarioSsoLogin usuarioSso = this.segurancaService.saveLastSsoLogin(authLogin);
        HttpSession session = request.getSession();
        session.setAttribute("tokenSso", (Object)usuarioSso.getId());
        response.sendRedirect("/index.html");
        return null;
    }
}

