/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.error.handler;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Map<String, Object>> handleResourceNotFoundException(ConstraintViolationException ex) {
        ConstraintViolation violation = (ConstraintViolation)new ArrayList(ex.getConstraintViolations()).get(0);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.customError(HttpStatus.BAD_REQUEST, violation.getMessageTemplate()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        List errors = ex.getBindingResult().getAllErrors();
        ObjectError error = (ObjectError)errors.get(0);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.customError(HttpStatus.BAD_REQUEST, error.getDefaultMessage()));
    }

    public Map<String, Object> customError(HttpStatus status, String message) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("timestamp", new Date());
        body.put("status", status.value());
        body.put("error", status.getReasonPhrase());
        body.put("message", message);
        return body;
    }
}

