/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.Solucao;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para solu\u00e7\u00f5es", name="solucoes")
@RequestMapping(value={"/api/solucoes"})
public class SolucoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(SolucoesRestServices.class);
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping
    @Operation(summary="Lista as Solu\u00e7\u00f5es dispon\u00edveis")
    public ResponseEntity<List<Solucao>> findSolucoes(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findOcorrencias...");
            String searchTxt = null;
            Integer idSolucaoPai = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("idSolucaoPai") != null) {
                idSolucaoPai = Integer.valueOf(request.getParameter("idSolucaoPai"));
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findSolucoes(searchTxt, idSolucaoPai), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findSolucoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idSolucao}"})
    @Operation(summary="Carrega a solu\u00e7\u00e3o pelo seu Identificador")
    public ResponseEntity<Solucao> getSolucaoById(@PathVariable Integer idSolucao) {
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getSolucao(idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getSolucaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a solu\u00e7\u00e3o")
    public ResponseEntity<Solucao> saveSolucao(@RequestBody Solucao solucao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveSolucao ({}))", (Object)solucao);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveSolucao(solucao, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveSolucao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idSolucao}"})
    @Operation(summary="Exclui a solu\u00e7\u00e3o atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteSolucao(@PathVariable Integer idSolucao) throws BusinessException {
        logger.debug("deleteSolucao({})", (Object)idSolucao);
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteSolucao(idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteSolucao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

