/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.RegraOuro;
import br.com.oti.gesconsys.ambiental.beans.rac.RegraOuroUsuario;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para regras de ouro", name="regra-ouro")
@RequestMapping(value={"/api/regrasOuro"})
public class RegrasOuroRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(RegrasOuroRestServices.class);
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping
    @Operation(summary="Lista as Regras de Ouro dispon\u00edveis")
    public ResponseEntity<List<RegraOuro>> findRegrasOuro(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findRegrasOuro...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findRegrasOuro(searchTxt, null), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRegrasOuro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idRegraOuro}"})
    @Operation(summary="Carrega a Regra de ouro pelo seu Identificador")
    public ResponseEntity<RegraOuro> getRegraOuro(@PathVariable Integer idRegraOuro) {
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getRegraOuroById(idRegraOuro), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGravidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a Regra de Ouro e Usu\u00e1rios associados com a mesma")
    public ResponseEntity<RegraOuro> saveRegraOuro(@RequestBody RegraOuro regraOuro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveRegraOuro ({}))", (Object)regraOuro);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveRegraOuro(regraOuro, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRegraOuro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idRegraOuro}"})
    @Operation(summary="Exclui a regra de ouro atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteRegraOuro(@PathVariable Integer idRegraOuro) throws BusinessException {
        logger.debug("deleteRegraOuro({})", (Object)idRegraOuro);
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteRegraOuro(idRegraOuro), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRegraOuro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idRegraOuro}/usuarios"})
    @Operation(summary="Lista os Usu\u00e1rios da Regras de Ouro dispon\u00edveis")
    public ResponseEntity<List<RegraOuroUsuario>> findUsuariosRegrasOuro(@PathVariable Integer idRegraOuro) {
        try {
            logger.debug("Iniciando findUsuariosRegrasOuro({})...", (Object)idRegraOuro);
            return new ResponseEntity((Object)this.cadastroAmbientalService.findUsuariosRegraOuro(idRegraOuro), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRegrasOuro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

