/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.incidente.IncidenteEvento;
import br.com.oti.gesconsys.ambiental.beans.incidente.IncidenteFator;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Incidentes", name="ambiental")
@RequestMapping(value={"/api/incidentes"})
public class IncidentesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(IncidentesRestServices.class);
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/eventos"})
    @Operation(summary="Lista as estruturas de eventos de incidentes dispon\u00edveis")
    public ResponseEntity<List<IncidenteEvento>> findIncidentesEventos(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Iniciando findIncidentesEventos...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findIncidentesEventos(searchTxt), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findIncidentesEventos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fatores"})
    @Operation(summary="Lista as estruturas de fatores de incidentes dispon\u00edveis")
    public ResponseEntity<List<IncidenteFator>> findIncidentesFatores(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findIncidentesFatores...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findIncidentesFatores(searchTxt), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findIncidentesFatores", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/eventos/{idEvento}"})
    @Operation(summary="Carrega a estrutura de um evento de incidente atrav\u00e9s de seu ID")
    public ResponseEntity<IncidenteEvento> getIncidenteEventoById(@PathVariable Integer idEvento) {
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getIncidenteEventoById(idEvento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.getIncidenteEventoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fatores/{idFator}"})
    @Operation(summary="Carrega a estrutura de um fator de incidente atrav\u00e9s de seu ID")
    public ResponseEntity<IncidenteFator> getIncidenteFatorById(@PathVariable Integer idFator) {
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getIncidenteFatorById(idFator), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.getIncidenteFatorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/eventos"})
    @Operation(summary="Salva a estrutura de eventos de Incidentes")
    public ResponseEntity<IncidenteEvento> saveIncidenteEvento(@RequestBody IncidenteEvento evento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveEventoIncidente ({}))", (Object)evento);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveIncidenteEvento(evento, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveIncidenteEvento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/fatores"})
    @Operation(summary="Salva a estrutura de fatores de Incidentes")
    public ResponseEntity<IncidenteFator> saveIncidenteFator(@RequestBody IncidenteFator fator, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveFatorIncidente ({}))", (Object)fator);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveIncidenteFator(fator, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveIncidenteFator", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/eventos/{idEvento}"})
    @Operation(summary="Exclui a estrutura do evento de incidente atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteEventoIncidente(@PathVariable Integer idEvento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteEventoIncidente({})", (Object)idEvento);
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteIncidenteEvento(idEvento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.deleteEventoIncidente", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fatores/{idFator}"})
    @Operation(summary="Exclui a estrutura do fator de incidente atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteEventoFator(@PathVariable Integer idFator, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteEventoFator({})", (Object)idFator);
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteIncidenteFator(idFator), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.deleteEventoFator", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

