/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.AreaProtegida;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para \u00c1reas legalmente protegidas", name="area-protegida")
@RequestMapping(value={"/api/areasProtegidas"})
public class AreasProtegidasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AreasProtegidasRestServices.class);
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CoreService coreService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista as \u00e1reas protegidas")
    public ResponseEntity<List<AreaProtegida>> findAreasProtegidas(@PathVariable String empresa, HttpServletRequest request) {
        Empresa emp = null;
        if (empresa != null) {
            emp = this.coreService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        try {
            logger.debug("Iniciando findAreasProtegidas...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroAmbientalService.findAreasProtegidas(searchTxt, emp.getId(), null), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreasProtegidas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaProtegida}"})
    @Operation(summary="Carrega a \u00e1rea protegida pelo seu Identificador")
    public ResponseEntity<AreaProtegida> getAreaProtegida(@PathVariable String empresa, @PathVariable Integer idAreaProtegida) {
        Empresa emp = null;
        if (empresa != null) {
            emp = this.coreService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.getAreaProtegidaById(idAreaProtegida, emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva a \u00e1rea protegida")
    public ResponseEntity<AreaProtegida> saveAreaProtegida(@PathVariable String empresa, @RequestBody AreaProtegida areaProtegida, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Empresa emp = null;
        if (empresa != null) {
            emp = this.coreService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        try {
            logger.debug("saveAreaProtegida ({}))", (Object)areaProtegida);
            return new ResponseEntity((Object)this.cadastroAmbientalService.saveAreaProtegida(emp.getId(), areaProtegida, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAreaProtegida}"})
    @Operation(summary="Exclui a \u00e1rea protegida atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAreaProtegida(@PathVariable String empresa, @PathVariable Integer idAreaProtegida) throws BusinessException {
        logger.debug("deleteAreaProtegida({})", (Object)idAreaProtegida);
        Empresa emp = null;
        if (empresa != null) {
            emp = this.coreService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        try {
            return new ResponseEntity((Object)this.cadastroAmbientalService.deleteAreaProtegida(idAreaProtegida), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

