/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.licenca;

import br.com.oti.gesconsys.ambiental.beans.licencas.LicencaNota;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.licencas.CondicionanteDocumento;
import br.com.oti.gesconsys.beans.licencas.LicencaDocumento;
import br.com.oti.gesconsys.beans.licencas.LicencaObra;
import br.com.oti.gesconsys.beans.licencas.LicencaObraVO;
import br.com.oti.gesconsys.beans.licencas.PlanoAcaoCondicionante;
import br.com.oti.gesconsys.beans.licencas.PlanoAcaoCondicionanteDocumento;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Condicionante;
import br.com.oti.gesconsys.beans.shared.CondicionanteNota;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para licencas", name="ambiental")
@RequestMapping(value={"/api/licencas"})
public class LicencasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(LicencasRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta as licen\u00e7as de acordo com o filtro")
    public ResponseEntity<List<Licenca>> findLicencas(HttpServletRequest request, @PathVariable String empresa) {
        try {
            DateTimeFormatter dateFmt;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - findLicencas({})", (Object)usuario, (Object)empresa);
            String search = null;
            Integer idClasseLicenca = null;
            Integer idEntidade = null;
            String nroProcesso = null;
            LocalDate datInicial = null;
            LocalDate datFinal = null;
            Integer tipoIntervalo = null;
            Integer status = null;
            Object tipoLicenca = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            if ((param = request.getParameter("idClasseLicenca")) != null && !param.isEmpty()) {
                idClasseLicenca = Integer.valueOf(param);
            }
            if ((param = request.getParameter("idEntidade")) != null && !param.isEmpty()) {
                idEntidade = Integer.valueOf(param);
            }
            if ((param = request.getParameter("nroProcesso")) != null && !param.isEmpty()) {
                nroProcesso = param;
            }
            if ((param = request.getParameter("tipoIntervalo")) != null && !param.isEmpty()) {
                tipoIntervalo = Integer.valueOf(param);
            }
            if ((param = request.getParameter("dataInicial")) != null && !param.isEmpty()) {
                try {
                    dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    datInicial = LocalDate.parse(param, dateFmt);
                }
                catch (DateTimeParseException pseExc) {
                    datInicial = null;
                    logger.error("pseExc", (Throwable)pseExc);
                }
            }
            if ((param = request.getParameter("dataFinal")) != null && !param.isEmpty()) {
                try {
                    dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    datFinal = LocalDate.parse(param, dateFmt);
                }
                catch (DateTimeParseException pseExc) {
                    datFinal = null;
                    logger.error("pseExc", (Throwable)pseExc);
                }
            }
            if ((param = request.getParameter("status")) != null && !param.isEmpty()) {
                status = Integer.valueOf(param);
            }
            ArrayList<Integer> tipoLicencasIdList = new ArrayList<Integer>();
            String[] tipoLicencasIdArray = request.getParameterValues("tipoLicenca");
            if (tipoLicencasIdArray != null && tipoLicencasIdArray.length > 0) {
                for (String string : tipoLicencasIdArray) {
                    tipoLicencasIdList.add(Integer.valueOf(string));
                }
            }
            ArrayList empresasInt = new ArrayList();
            String[] empresasIdArray = request.getParameterValues("concessionarias");
            ArrayList<Integer> empresasIdList = new ArrayList<Integer>();
            if (empresasIdArray != null && empresasIdArray.length > 0) {
                for (String empId : empresasIdArray) {
                    empresasIdList.add(Integer.valueOf(empId));
                }
            }
            if (empresasIdList.size() > 0) {
                empresasInt.addAll(empresasIdList);
            } else {
                empresasInt.add(emp.getId());
            }
            List list = this.licencaService.findLicencas(empresasInt, search, idEntidade, nroProcesso, idClasseLicenca, datInicial, datFinal, tipoIntervalo, status, tipoLicencasIdList);
            return new ResponseEntity((Object)list, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLicencas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findLicencas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}"})
    @Operation(summary="Carrega dados da licen\u00e7a de acordo com o ID da licen\u00e7a")
    public ResponseEntity<Licenca> getLicenca(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca) {
        logger.debug("API getLicenca...");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - getLicenca({})", (Object)usuario, (Object)empresa);
            Licenca lic = this.licencaService.getLicencaById(idLicenca);
            if (lic == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrada.");
            }
            lic.setEmpresa(null);
            return new ResponseEntity((Object)lic, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva a Licen\u00e7a")
    public ResponseEntity<Licenca> saveLicenca(@PathVariable String empresa, @RequestBody Licenca licenca, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveLicenca ({}, {}))", new Object[]{usuario, empresa, licenca});
            return new ResponseEntity((Object)this.licencaService.saveLicenca(licenca, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}"})
    @Operation(summary="Exclui a Licen\u00e7a atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteLicenca({}, {})", new Object[]{usuario, empresa, idLicenca});
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicenca(idLicenca, this.getIpExterno(request)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/documentos"})
    @Operation(summary="Consulta os documentos de acordo com a Licen\u00e7a")
    public ResponseEntity<List<LicencaDocumento>> findDocumentosByLicenca(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findDocumentosByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List documentos = this.licencaService.findDocumentosByLicenca(idLicenca);
            return new ResponseEntity((Object)documentos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDocumentosByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findDocumentosByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idLicenca}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o Documento")
    public ResponseEntity<List<LicencaDocumento>> saveDocumentoByLicenca(@PathVariable String empresa, @PathVariable Integer idLicenca, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveDocumentoByLicenca ({}))", (Object)usuario, (Object)empresa);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<LicencaDocumento> documentos = new ArrayList<LicencaDocumento>();
            for (MultipartFile file : filesMap) {
                LicencaDocumento documento = new LicencaDocumento();
                documento.setAnexo(new Anexo());
                documento.getAnexo().setNome(file.getOriginalFilename());
                documentos.add(documento);
            }
            List response = this.licencaService.registraUploadAnexoLicenca(empresa, idLicenca, documentos, usr.getId(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> removeDocumentoLicenca(@PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer seqArquivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteDocumento({}, {})", new Object[]{usuario, empresa, seqArquivo});
            this.licencaService.removeDocumentoLicenca(idLicenca, emp.getId(), seqArquivo, null, null);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/condicionantes"})
    @Operation(summary="Consulta as condicionantes de acordo com a Licen\u00e7a")
    public ResponseEntity<List<Condicionante>> findCondicionantesByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") List<Integer> idLicenca) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
        if (empresaDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        logger.debug("{} - findCondicionantesByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List condicionantesCache = this.licencaService.findCondicionantesByLicenca(empresaDB.getId(), idLicenca, null);
            return new ResponseEntity((Object)condicionantesCache, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionantesByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionantesByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/condicionantes"})
    @Operation(summary="Consulta as condicionantes de acordo com a Licen\u00e7a")
    public ResponseEntity<List<Condicionante>> findCondicionantes(HttpServletRequest request, @PathVariable String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
        if (empresaDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        logger.debug("{} - findCondicionantes({})", (Object)usuario, (Object)empresa);
        ArrayList<Integer> empresas = new ArrayList<Integer>();
        empresas.add(empresaDB.getId());
        try {
            List condicionantesCache = this.licencaService.findCondicionantes(empresas, null, null, null, null, null, null, null);
            return new ResponseEntity((Object)condicionantesCache, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/condicionantes/{idCondicionante}"})
    @Operation(summary="Carrega dados da condicionante de acordo com o ID")
    public ResponseEntity<Condicionante> getCondicionanteById(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idCondicionante) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            Condicionante con = this.licencaService.getCondicionanteById(idCondicionante);
            if (con == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getCondicionanteById({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)con, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/condicionantes"})
    @Operation(summary="Salva a Condicionante")
    public ResponseEntity<Condicionante> saveCondicionanteByLicenca(@PathVariable String empresa, @PathVariable Integer idLicenca, @RequestBody Condicionante condicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveCondicionanteByLicenca ({}, {}))", new Object[]{usuario, empresa, condicionante});
            return new ResponseEntity((Object)this.licencaService.saveCondicionante(condicionante, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/condicionantes/{idCondicionante}"})
    @Operation(summary="Exclui a Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteCondicionanteByLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCondicionante") Integer idCondicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteCondicionanteByLicenca({}, {})", new Object[]{usuario, empresa, idCondicionante});
        try {
            return new ResponseEntity((Object)this.licencaService.deleteCondicionante(idCondicionante), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas"})
    @Operation(summary="Consulta as notas de acordo com a Condicionante")
    public ResponseEntity<List<CondicionanteNota>> findCondicionanteNota(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante) {
        if (idLicenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o foi encontrada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findCondicionanteNota({})", (Object)usuario, (Object)empresa);
        try {
            List notas = this.licencaService.findCondicionanteNota(idCondicionante, null);
            if (notas == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Notas n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)notas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Carrega dados da nota de acordo com o ID da condicionante")
    public ResponseEntity<CondicionanteNota> getCondicionanteNota(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idNota) {
        logger.debug("API getCondicionanteNota...");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            CondicionanteNota not = this.licencaService.getCondicionanteNota(idCondicionante, idNota);
            if (not == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nota da Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getCondicionanteNota({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)not, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas"})
    @Operation(summary="Salva a Nota")
    public ResponseEntity<CondicionanteNota> saveCondicionanteNota(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @RequestBody CondicionanteNota condicionanteNota, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveCondicionanteNota ({}, {}))", new Object[]{usuario, empresa, condicionanteNota});
            return new ResponseEntity((Object)this.licencaService.saveCondicionanteNota(condicionanteNota, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Exclui a Nota da Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteCondicionanteNota(@PathVariable(name="empresa") String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idNota, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteCondicionanteNota({}, {})", new Object[]{usuario, empresa, idNota});
            this.licencaService.deleteCondicionanteNota(idCondicionante, idNota);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/notas"})
    @Operation(summary="Consulta as notas de acordo com a licen\u00e7a")
    public ResponseEntity<List<LicencaNota>> findLicencaNota(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca) {
        if (idLicenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o foi encontrada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findLicencaNota({})  {}", new Object[]{usuario, empresa, idLicenca});
        try {
            List notas = this.licencaService.findLicencaNota(idLicenca, null);
            if (notas == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Notas n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)notas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Carrega dados da nota de acordo com o ID da licenca")
    public ResponseEntity<LicencaNota> getLicencaNota(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idNota) {
        logger.debug("API getLicencaNota...");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            LicencaNota not = this.licencaService.getLicencaNota(idLicenca, idNota);
            if (not == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nota da Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getLicencaNota({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)not, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/notas"})
    @Operation(summary="Salva a Nota")
    public ResponseEntity<LicencaNota> saveLicencaNota(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @RequestBody LicencaNota licencaNota, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveLicencaNota ({}, {}))", new Object[]{usuario, empresa, licencaNota});
            licencaNota.setIdlicenca(idLicenca);
            return new ResponseEntity((Object)this.licencaService.saveLicencaNota(licencaNota, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.LicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Exclui a Nota da licenca atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteLicencaNota(@PathVariable(name="empresa") String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idNota, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteLicencaNota({}, {})", new Object[]{usuario, empresa, idNota});
            this.licencaService.deleteLicencaNota(idLicenca, idNota);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao"})
    @Operation(summary="Consulta os planos de a\u00e7\u00e3o de acordo com a Condicionante")
    public ResponseEntity<List<PlanoAcaoCondicionante>> findPlanosAcao(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("findPlanosAcao ({})", (Object)idCondicionante);
        try {
            List planosAcao = this.licencaService.findPlanosAcao(emp.getId(), idCondicionante);
            if (planosAcao == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)planosAcao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Carrega dados do Plano de A\u00e7\u00e3o de acordo com o ID da condicionante")
    public ResponseEntity<PlanoAcaoCondicionante> getPlanoAcaoById(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idPlanoAcao) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PlanoAcaoCondicionante plano = this.licencaService.getPlanoAcaoById(emp.getId(), idPlanoAcao);
            if (plano == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)plano, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCondicionante}/planosAcao"})
    @Operation(summary="Salva o Plano de A\u00e7\u00e3o")
    public ResponseEntity<PlanoAcaoCondicionante> savePlanoAcao(@PathVariable String empresa, @PathVariable Integer idCondicionante, @RequestBody PlanoAcaoCondicionante planoAcaoCondicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - savePlanoAcaoCondicionante ({}, {}))", new Object[]{usuario, empresa, planoAcaoCondicionante});
            return new ResponseEntity((Object)this.licencaService.savePlanoAcao(planoAcaoCondicionante, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Exclui o Plano de A\u00e7\u00e3o atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deletePlanoAcao(@PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deletePlanoAcao({}, {})", new Object[]{usuario, empresa, idPlanoAcao});
            this.licencaService.deletePlanoAcao(emp.getId(), idPlanoAcao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o Documento de acordo com o Plano de A\u00e7\u00e3o")
    public ResponseEntity<List<PlanoAcaoCondicionanteDocumento>> savePlanoAcaoCondicionanteDocumento(@PathVariable String empresa, @PathVariable Integer idPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (idPlanoAcao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id do Plano de A\u00e7\u00e3o n\u00e3o pode ser nulo");
        }
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - savePlanoAcaoCondicionanteDocumento ({}))", (Object)usuario, (Object)empresa);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameList = multipartReq.getFileNames();
            while (fileNameList.hasNext()) {
                String fileName = (String)fileNameList.next();
                filesMap.addAll(multipartReq.getFiles(fileName));
            }
            ArrayList<PlanoAcaoCondicionanteDocumento> docs = new ArrayList<PlanoAcaoCondicionanteDocumento>();
            for (MultipartFile file : filesMap) {
                PlanoAcaoCondicionanteDocumento doc = new PlanoAcaoCondicionanteDocumento();
                doc.setAnexo(new Anexo());
                doc.getAnexo().setNome(file.getOriginalFilename());
                docs.add(doc);
            }
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoPlanoAcao(empresa, idPlanoAcao, docs, usr.getId(), filesMap), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"})
    @Operation(summary="Consulta os documentos de acordo com o plano de a\u00e7\u00e3o")
    public ResponseEntity<List<PlanoAcaoCondicionanteDocumento>> findDocumentosByPlanoAcao(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idPlanoAcao) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        if (idCondicionante == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id da Condicionante n\u00e3o pode ser nulo");
        }
        if (idLicenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id da Licen\u00e7a n\u00e3o pode ser nulo");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findDocumentosByPlanoAcao({})", (Object)usuario, (Object)empresa);
        try {
            List documentos = this.licencaService.findDocumentosByPlanoAcao(idPlanoAcao);
            if (documentos == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)documentos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDocumentosByPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findDocumentosByPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos/{seqAnexo}"})
    @Operation(summary="Exclui o Documento atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> removeDocumentoPlanoAcao(@PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer idPlanoAcao, @PathVariable Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (idPlanoAcao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id do Plano a\u00e7\u00e3o da Condicionante n\u00e3o pode ser nulo");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - removeDocumentoPlanoAcao({}, {})", new Object[]{usuario, empresa, seqAnexo});
            this.licencaService.removeDocumentoPlanoAcao(idPlanoAcao, emp.getId(), seqAnexo, usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.removeDocumentoPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos"})
    @Operation(summary="Consulta os documentos de acordo com a Condicionante")
    public ResponseEntity<List<CondicionanteDocumento>> findDocumentosByCondicionante(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante) {
        if (idLicenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id da Licen\u00e7a n\u00e3o pode ser nulo");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findDocumentosByCondicionante({})", (Object)usuario, (Object)empresa);
        try {
            List documentos = this.licencaService.findDocumentosByCondicionante(idCondicionante);
            if (documentos == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)documentos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Carrega dados do documento de acordo com o ID da condicionante")
    public ResponseEntity<CondicionanteDocumento> getDocumentoBySeq(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer seqArquivo) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            CondicionanteDocumento doc = this.licencaService.getCondicionanteDocumentoBySeq(idCondicionante, seqArquivo);
            if (doc == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Documento da Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getDocumentoBySeq({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o Documento de acordo com a Condicionante")
    public ResponseEntity<List<CondicionanteDocumento>> saveCondicionanteDocumento(@PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (idLicenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Id da Licen\u00e7a n\u00e3o pode ser nulo");
        }
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveCondicionanteDocumento ({}))", (Object)usuario, (Object)empresa);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameList = multipartReq.getFileNames();
            while (fileNameList.hasNext()) {
                String fileName = (String)fileNameList.next();
                filesMap.addAll(multipartReq.getFiles(fileName));
            }
            ArrayList<CondicionanteDocumento> docs = new ArrayList<CondicionanteDocumento>();
            for (MultipartFile file : filesMap) {
                CondicionanteDocumento doc = new CondicionanteDocumento();
                doc.setAnexo(new Anexo());
                doc.getAnexo().setNome(file.getOriginalFilename());
                docs.add(doc);
            }
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoCondicionante(empresa, idCondicionante, docs, usr.getId(), filesMap), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento da Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> removeDocumento(@PathVariable String empresa, @PathVariable Integer idLicenca, @PathVariable Integer idCondicionante, @PathVariable Integer seqArquivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteDocumento({}, {})", new Object[]{usuario, empresa, seqArquivo});
            this.licencaService.removeDocumento(idCondicionante, emp.getId(), seqArquivo, null, null);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/obras"})
    @Operation(summary="Consulta as obras de acordo com a Licen\u00e7a")
    public ResponseEntity<List<LicencaObra>> findObrasByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca) {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findObrasByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List obras = this.licencaService.findObrasByLicenca(idLicenca);
            return new ResponseEntity((Object)obras, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObrasByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findObrasByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/obras/{idObra}"})
    @Operation(summary="Carrega dados da obra de acordo com o ID da licen\u00e7a")
    public ResponseEntity<LicencaObra> getLicencaObraById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idObra") Integer idObra) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            LicencaObra doc = this.licencaService.getLicencaObraById(idLicenca, idObra, emp.getId());
            if (doc == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Obra n\u00e3o encontrada.");
            }
            logger.debug("{} - getLicencaObraById({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getObra", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/obras"})
    @Operation(summary="Salva a obra")
    public ResponseEntity<Boolean> saveLicencaObra(@PathVariable String empresa, @RequestBody LicencaObraVO licencaObra, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveLicencaObra ({}, {}))", new Object[]{usuario, empresa, licencaObra});
            return new ResponseEntity((Object)this.licencaService.saveLicencaObra(licencaObra, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/obras/{seqObra}"})
    @Operation(summary="Exclui a obra atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteLicencaObra(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="seqObra") Integer sequencia, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteLicencaObra({}, {})", new Object[]{usuario, empresa, idLicenca});
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicencaObra(idLicenca, emp.getId(), sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicencaObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

