/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.fichas;

import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAmbiental;
import br.com.oti.gesconsys.ambiental.beans.analise.FiltroAnalise;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoDescarte;
import br.com.oti.gesconsys.ambiental.beans.descarte.FiltroDescarte;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroBoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.UpdateFichaAmbientalVO;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AnaliseAmbientalService;
import br.com.oti.gesconsys.business.services.AreaApoioService;
import br.com.oti.gesconsys.business.services.AutorizacaoDescarteService;
import br.com.oti.gesconsys.business.services.AutorizacaoIntervencaoService;
import br.com.oti.gesconsys.business.services.BoaPraticaService;
import br.com.oti.gesconsys.business.services.CheckListService;
import br.com.oti.gesconsys.business.services.InspecaoAmbientalService;
import br.com.oti.gesconsys.business.services.PontoControleService;
import br.com.oti.gesconsys.business.services.RacService;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAnaliseAmbientalPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAreaApoioPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAutorizacaoIntervencaoPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioBoaPraticaPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioCheckListPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioInspecaoPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasAnalisesPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasAreasApoioPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasBoasPraticasPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasChecklistsPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasDescartesPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasInspecoesPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasIntervencoesPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasPontosControlePdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioMultiplasRacsPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioPontoControlePdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRacPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import reactor.netty.http.client.HttpClient;

@RestController
@RequestMapping(value={"/api/ambientais/fichas"})
@Tag(description="REST Services para fichas ambientais", name="ambiental")
public class FichasAmbientaisRestServices
extends BaseRestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FichasAmbientaisRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private RacService racService;
    @Autowired
    private InspecaoAmbientalService inspecaoAmbientalService;
    @Autowired
    private AreaApoioService areaApoioService;
    @Autowired
    private BoaPraticaService boaPraticaService;
    @Autowired
    private AutorizacaoIntervencaoService autorizacaoIntervencaoService;
    @Autowired
    private AutorizacaoDescarteService autorizacaoDescarteService;
    @Autowired
    private AnaliseAmbientalService analiseAmbientalService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    private PontoControleService pontoControleService;
    @Autowired
    private RelatorioMultiplasRacsPdf relatorioMultiplasRacPdf;
    @Autowired
    private RelatorioMultiplasInspecoesPdf relatorioMultiplasInspecoesPdf;
    @Autowired
    private RelatorioMultiplasAnalisesPdf relatorioMultiplasAnalisesPdf;
    @Autowired
    private RelatorioMultiplasChecklistsPdf relatorioMultiplasChecklistsPdf;
    @Autowired
    private RelatorioMultiplasPontosControlePdf relatorioMultiplasPtcPdf;
    @Autowired
    private RelatorioMultiplasAreasApoioPdf relatorioMultiplasAreasApoioPdf;
    @Autowired
    private RelatorioMultiplasIntervencoesPdf relatorioMultiplasIntervencoesPdf;
    @Autowired
    private RelatorioMultiplasDescartesPdf relatorioMultiplasDescartesPdf;
    @Autowired
    private RelatorioMultiplasBoasPraticasPdf relatorioMultiplasBoasPraticasPdf;
    @Autowired
    private RelatorioRacPdf relatorioRacPdf;
    @Autowired
    private RelatorioInspecaoPdf relatorioInspecaoPdf;
    @Autowired
    private RelatorioAnaliseAmbientalPdf relatorioAnaliseAmbientalPdf;
    @Autowired
    private RelatorioCheckListPdf relatorioCheckListPdf;
    @Autowired
    private RelatorioPontoControlePdf relatorioPontoControlePdf;
    @Autowired
    private RelatorioAreaApoioPdf relatorioAreaApoioPdf;
    @Autowired
    private RelatorioAutorizacaoIntervencaoPdf relatorioAutorizacaoIntervencaoPdf;
    @Autowired
    private RelatorioRetiradaMaterialPdf relatorioRetiradaMaterialPdf;
    @Autowired
    private RelatorioBoaPraticaPdf relatorioBoaPraticaPdf;

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                log.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude, longitude), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacoes/{tipoFicha}"})
    @Operation(summary="Efetua o download da racs em PDF integrado")
    public void exportaFichasPdf(HttpServletResponse response, HttpServletRequest request, @PathVariable String tipoFicha, @PathVariable String empresa, @RequestBody UpdateFichaAmbientalVO fichaVO) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        int fichaSize = fichaVO != null ? fichaVO.getIds().size() : 0;
        log.debug("{} - Exportando Fichas em pdf (emp={}, fichas={})...", new Object[]{usuario.getLogin(), empresa, fichaSize});
        try {
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Object responseBody = null;
            boolean joinAnexos = true;
            Boolean separado = fichaVO.getSeparado();
            switch (tipoFicha.toLowerCase()) {
                case "rac": {
                    Page racs;
                    FiltroRac filtroRac = new FiltroRac();
                    filtroRac.getConcessionaria().add(emp.getId());
                    filtroRac.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((racs = this.racService.findRacs(filtroRac, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(joinAnexos), Boolean.valueOf(true))) == null || racs.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Rac n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"relatorios.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (Rac rac : racs) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = rac.getLatitude() != null && rac.getLongitude() != null ? this.getMapaEstatico(rac.getLatitude(), rac.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(rac.getNumero().replace('/', '_'));
                                zipName.append(" - rac-" + String.valueOf(rac.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioRacPdf.executePdf(emp.getId(), rac, mapaGoogle, false, usuario.getLogin());
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasRacPdf.executePdf(emp.getId(), racs.getContent(), false, usuario.getLogin());
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"fichas.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "inspe": {
                    Page inspecoes;
                    FiltroInspecao filtroInspe = new FiltroInspecao();
                    filtroInspe.getConcessionaria().add(emp.getId());
                    filtroInspe.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((inspecoes = this.inspecaoAmbientalService.findInspecoes(filtroInspe, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(joinAnexos))) == null || inspecoes.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Inspe\u00e7\u00e3o n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"inspecoes.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (InspecaoAmbiental i : inspecoes) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = i.getLatitude() != null && i.getLongitude() != null ? this.getMapaEstatico(i.getLatitude(), i.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(i.getNumero().replace('/', '_'));
                                zipName.append(" - inspecao-" + String.valueOf(i.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioInspecaoPdf.executePDF(emp.getId(), i, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasInspecoesPdf.executePdf(emp.getId(), inspecoes.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"fichas.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "anamb": {
                    Page analises;
                    FiltroAnalise filtroAnalise = new FiltroAnalise();
                    filtroAnalise.getConcessionaria().add(emp.getId());
                    filtroAnalise.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((analises = this.analiseAmbientalService.findAnalises(filtroAnalise, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(joinAnexos))) == null || analises.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "An\u00e1lise ambiental n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"analiseAmbiental.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (AnaliseAmbiental a : analises) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = a.getLatitude() != null && a.getLongitude() != null ? this.getMapaEstatico(a.getLatitude(), a.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(a.getNumero().replace('/', '_'));
                                zipName.append(" - analise-" + String.valueOf(a.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioAnaliseAmbientalPdf.executePDF(emp.getId(), a, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasAnalisesPdf.executePdf(emp.getId(), analises.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"analiseAmbiental.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "chk": {
                    FiltroChecklist filtroChk = new FiltroChecklist();
                    filtroChk.getConcessionaria().add(emp.getId());
                    filtroChk.setIds(fichaVO.getIds());
                    filtroChk.setModulo("AMB");
                    Page checklists = this.checkListService.findCheckLists(filtroChk, 1, 100, "numero", Boolean.valueOf(false));
                    if (checklists == null || checklists.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Checklist n\u00e3o encontrad0.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"checkLists.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (CheckList c : checklists) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = c.getLatitude() != null && c.getLongitude() != null ? this.getMapaEstatico(c.getLatitude(), c.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(c.getNumero().replace('/', '_'));
                                zipName.append(" - checklist-" + String.valueOf(c.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioCheckListPdf.executePdf(emp.getId(), c, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasChecklistsPdf.executePdf(emp.getId(), checklists.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"checkLists.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "ptc": {
                    FiltroPontoControle filtroPtc = new FiltroPontoControle();
                    filtroPtc.getConcessionaria().add(emp.getId());
                    filtroPtc.setIds(fichaVO.getIds());
                    Page pontosControle = this.pontoControleService.findPontosControle(filtroPtc, 1, 100, "descricao", Boolean.valueOf(false));
                    if (pontosControle == null || pontosControle.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Ponto controle n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"pontosControle.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (PontoControle p : pontosControle) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = p.getLatitude() != null && p.getLongitude() != null ? this.getMapaEstatico(p.getLatitude(), p.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(p.getDescricao().replace('/', '_'));
                                zipName.append(" - ponto-controle-" + String.valueOf(p.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioPontoControlePdf.executePDF(emp.getId(), p, mapaGoogle);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasPtcPdf.executePdf(emp.getId(), pontosControle.getContent());
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"pontosControle.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "aap": {
                    Page areas;
                    FiltroAreaApoio filtroArea = new FiltroAreaApoio();
                    filtroArea.getConcessionaria().add(emp.getId());
                    filtroArea.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((areas = this.areaApoioService.findAreasApoio(filtroArea, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(joinAnexos), Boolean.valueOf(true), Boolean.valueOf(true))) == null || areas.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c1rea Apoio n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"areasApoio.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (AreaApoio a : areas) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = a.getLatitude() != null && a.getLongitude() != null ? this.getMapaEstatico(a.getLatitude(), a.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(a.getNumero().replace('/', '_'));
                                zipName.append(" - area-" + String.valueOf(a.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioAreaApoioPdf.executePDF(emp.getId(), a, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasAreasApoioPdf.executePdf(emp.getId(), areas.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"areasApoio.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "asv": {
                    Page intervencoes;
                    FiltroIntervencao filtroIntervencao = new FiltroIntervencao();
                    filtroIntervencao.getConcessionaria().add(emp.getId());
                    filtroIntervencao.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((intervencoes = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroIntervencao, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(joinAnexos), Boolean.valueOf(true))) == null || intervencoes.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Interven\u00e7\u00e3o n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"intervencoes.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (AutorizacaoIntervencao a : intervencoes) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = a.getLatitude() != null && a.getLongitude() != null ? this.getMapaEstatico(a.getLatitude(), a.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(a.getNumero().replace('/', '_'));
                                zipName.append(" - intervencao-" + String.valueOf(a.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioAutorizacaoIntervencaoPdf.executePDF(emp.getId(), a, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasIntervencoesPdf.executePdf(emp.getId(), intervencoes.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"intervencoes.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "adr": {
                    Page descartes;
                    FiltroDescarte filtroDescarte = new FiltroDescarte();
                    filtroDescarte.getConcessionaria().add(emp.getId());
                    filtroDescarte.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((descartes = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtroDescarte, 1, 100, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(joinAnexos))) == null || descartes.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Descarte/Retirada n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"descartes.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (AutorizacaoDescarte a : descartes) {
                                String tipoMapa = request.getParameter("tipoMapa");
                                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                                byte[] mapaGoogle = a.getLatitude() != null && a.getLongitude() != null ? this.getMapaEstatico(a.getLatitude(), a.getLongitude(), tipoMapa) : null;
                                StringBuilder zipName = new StringBuilder();
                                zipName.append(a.getNumero().replace('/', '_'));
                                zipName.append(" - descarte-" + String.valueOf(a.getDatCriacao()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioRetiradaMaterialPdf.executePDF(emp.getId(), a, mapaGoogle, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasDescartesPdf.executePdf(emp.getId(), descartes.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"descartes.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "boa": {
                    Page boas;
                    FiltroBoaPratica filtroBoa = new FiltroBoaPratica();
                    filtroBoa.getConcessionaria().add(emp.getId());
                    filtroBoa.setIds(fichaVO.getIds());
                    if (request.getParameter("anexos") != null) {
                        joinAnexos = Boolean.valueOf(request.getParameter("anexos"));
                    }
                    if ((boas = this.boaPraticaService.findBoasPraticas(filtroBoa, 1, 100, "titulo", Boolean.valueOf(false), Boolean.valueOf(joinAnexos))) == null || boas.isEmpty()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Boa pr\u00e1tica n\u00e3o encontrada.");
                    }
                    if (separado.booleanValue()) {
                        log.debug("Iniciando exporta\u00e7\u00e3o PDF um por um...");
                        response.setContentType("application/zip");
                        response.setHeader("Content-Disposition", "attachment; filename=\"boasPraticas.zip\"");
                        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
                            for (BoaPratica b : boas) {
                                StringBuilder zipName = new StringBuilder();
                                zipName.append("boasPraticas-" + String.valueOf(b.getDatHorCadastro().toLocalDate()) + ".pdf");
                                ZipEntry zipEntry = new ZipEntry(zipName.toString());
                                zipOut.putNextEntry(zipEntry);
                                byte[] relatorio = this.relatorioBoaPraticaPdf.executePDF(emp.getId(), b, false);
                                zipOut.write(relatorio);
                                zipOut.closeEntry();
                            }
                            zipOut.finish();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (separado.booleanValue()) break;
                    log.debug("Iniciando exporta\u00e7\u00e3o PDF M\u00faltiplo");
                    byte[] pdf = this.relatorioMultiplasBoasPraticasPdf.executePdf(emp.getId(), boas.getContent(), false);
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"boasPraticas.pdf\"");
                    response.setContentLength(pdf.length);
                    try (ServletOutputStream out = response.getOutputStream();){
                        out.write(pdf);
                        out.flush();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + tipoFicha.toLowerCase());
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }
}

