/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental;

import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAmbiental;
import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAnexo;
import br.com.oti.gesconsys.ambiental.beans.analise.FiltroAnalise;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioAnexo;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioSituacao;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListAnexo;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFicha;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFichaItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoDescarte;
import br.com.oti.gesconsys.ambiental.beans.descarte.AutorizacaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.descarte.FiltroDescarte;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFicha;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPraticaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroBoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.RacAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacCorrecao;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFicha;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFichaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.RacRegraOuro;
import br.com.oti.gesconsys.ambiental.beans.rac.RequisitoLegal;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.licencas.LicencaObra;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresaAreaVO;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AnaliseAmbientalService;
import br.com.oti.gesconsys.business.services.AreaApoioService;
import br.com.oti.gesconsys.business.services.AutorizacaoDescarteService;
import br.com.oti.gesconsys.business.services.AutorizacaoIntervencaoService;
import br.com.oti.gesconsys.business.services.BoaPraticaService;
import br.com.oti.gesconsys.business.services.CadastroAmbientalService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CheckListService;
import br.com.oti.gesconsys.business.services.InspecaoAmbientalService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.PontoControleService;
import br.com.oti.gesconsys.business.services.RacService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.spring.IgnoreHibernatePropertiesInJackson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Endpoints Gerais do Mobile Ambiental", name="ambiental")
@RequestMapping(value={"/api/ambiental/mobile"})
public class AmbientalMobileRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(AmbientalMobileRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CadastroAmbientalService cadastroAmbientalService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private RacService racService;
    @Autowired
    private AreaApoioService areaApoioService;
    @Autowired
    private AnaliseAmbientalService analiseAmbientalService;
    @Autowired
    private InspecaoAmbientalService inspecaoAmbientalService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    private AutorizacaoDescarteService autorizacaoDescarteService;
    @Autowired
    private AutorizacaoIntervencaoService autorizacaoIntervencaoService;
    @Autowired
    private PontoControleService pontoControleService;
    @Autowired
    private BoaPraticaService boaPraticaService;
    @Autowired
    private LicencaService licencaService;

    @GetMapping(value={"/{empresa}/downloadDatas"})
    public ResponseEntity<Resource> downloadData(@PathVariable String empresa, HttpServletRequest request, HttpServletResponse response) {
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        response.setContentType("application/zip");
        String searchTxt = null;
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
            }
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            if (request.getParameter("empresas") != null) {
                String[] param;
                for (String empParm : param = request.getParameterValues("empresas")) {
                    empresas.add(Integer.valueOf(empParm));
                }
            } else {
                empresas.add(emp.getId());
            }
            if (empresas.size() > 1) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel gerar ZIP de mais de uma empresa no momento.");
            }
            LocalDateTime sysDate = LocalDateTime.now();
            StringBuilder fileName = new StringBuilder();
            fileName.append(empresa).append("-");
            int day = sysDate.getDayOfMonth();
            fileName.append(day < 10 ? "0" : "").append(day);
            int month = sysDate.getMonthValue();
            fileName.append(month < 10 ? "0" : "").append(month);
            fileName.append(sysDate.getYear()).append("-");
            int hour = sysDate.getHour();
            fileName.append(hour < 10 ? "0" : "").append(hour);
            fileName.append(".zip");
            Path zipPath = Path.of(System.getProperty("java.io.tmpdir"), fileName.toString());
            logger.debug("zipfile.name={}", (Object)zipPath);
            File zipFile = zipPath.toFile();
            if (zipFile.exists()) {
                LocalDateTime created = Instant.ofEpochMilli(zipFile.lastModified()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                Long createdMinutes = ChronoUnit.MINUTES.between(created, LocalDateTime.now());
                if (createdMinutes.intValue() <= 15) {
                    Long fileLength = zipFile.length();
                    response.setContentLength(fileLength.intValue());
                    response.setHeader("Content-Disposition", "attachment;filename=" + zipFile.getName());
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    Files.copy(zipPath, bytes);
                    logger.debug("{} - Devolvendo zipfile existente: {}", (Object)usuario.getLogin(), (Object)zipFile.getName());
                    InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(zipPath.toFile()));
                    return ResponseEntity.ok().contentLength(fileLength.longValue()).body((Object)resource);
                }
                zipFile.delete();
            }
            String zipDirName = this.serializeData(empresas, empresa, lastUpdate, searchTxt);
            logger.debug("Iniciando compacta\u00e7\u00e3o dos dados serializados");
            this.createZipFile(zipDirName, zipPath);
            Long fileLength = zipFile.length();
            response.setContentLength(fileLength.intValue());
            response.setHeader("Content-Disposition", "attachment;filename=" + zipFile.getName());
            logger.debug("Copiando zip para response output");
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(zipPath.toFile()));
            logger.debug("Removendo diret\u00f3rios e arquivos gerados previamente");
            FileUtils.deleteDirectory((File)Paths.get(zipDirName, new String[0]).toFile());
            logger.info("{} - retornando streaming response", (Object)usuario.getLogin());
            return ResponseEntity.ok().contentLength(fileLength.longValue()).body((Object)resource);
        }
        catch (FileNotFoundException fnfExc) {
            logger.error("fnfExc", (Throwable)fnfExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("ioExc", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public void createZipFile(String sourceDirPath, Path zipFilePath) throws IOException {
        Path p = Files.createFile(zipFilePath, new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException ioExc) {
                    logger.error("IOExc", (Throwable)ioExc);
                }
            });
        }
    }

    private String serializeData(List<Integer> empresas, String empresa, LocalDateTime lastUpdate, String searchTxt) throws IOException {
        Object oco2;
        List requisitosLegais;
        UsuarioEmpresaAreaVO user;
        Integer idEmpresa = empresas.get(0);
        JsonFactory msgFactory = new JsonFactory();
        msgFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ObjectMapper mapper = new ObjectMapper(msgFactory);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.addMixIn(Object.class, IgnoreHibernatePropertiesInJackson.class);
        DateTimeFormatter dateFmt = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        String tmpDir = System.getProperty("java.io.tmpdir");
        Path destPath = Paths.get(tmpDir, empresa + "-" + LocalDateTime.now().format(dateFmt));
        Files.createDirectories(destPath, new FileAttribute[0]);
        String destFilePath = destPath.toFile().getAbsolutePath();
        List ocorrencias = this.cadastroAmbientalService.findOcorrencias(null, lastUpdate);
        this.serializeJson(ocorrencias, mapper, destFilePath, "ocorrencias.json");
        List eixos = this.cadastroAmbientalService.findEixosEstrategicos(searchTxt, lastUpdate);
        this.serializeJson(eixos, mapper, destFilePath, "eixos-estrategicos.json");
        List linhas = this.cadastroAmbientalService.findLinhasNegocio(searchTxt, lastUpdate);
        this.serializeJson(linhas, mapper, destFilePath, "linhas-negocio.json");
        List parecer = this.cadastroAmbientalService.findPareceresAreasApoio(searchTxt, lastUpdate);
        this.serializeJson(parecer, mapper, destFilePath, "parecer-autorizativo.json");
        List orgaoAprovador = this.cadastroAmbientalService.findOrgaosAprovadoresAreasApoio(searchTxt, lastUpdate);
        this.serializeJson(orgaoAprovador, mapper, destFilePath, "orgao-aprovador.json");
        List tipoStatusUtil = this.cadastroAmbientalService.findTipoStatusAreasApoio(searchTxt, null, lastUpdate);
        this.serializeJson(tipoStatusUtil, mapper, destFilePath, "tipo-status.json");
        int pageNbr = 1;
        int pageSize = 10000;
        String sortField = "descricao";
        boolean sortDesc = true;
        FiltroPontoControle filtro = new FiltroPontoControle();
        filtro.setConcessionaria(empresas);
        filtro.setLastUpdate(lastUpdate);
        Page pontos = this.pontoControleService.findPontosControle(filtro, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc));
        Map contagem = this.pontoControleService.getCountFichasByPontoControle(idEmpresa, Boolean.valueOf(false));
        for (PontoControle ponto : pontos) {
            Object idPontoTxt;
            if (ponto.getObra() != null) {
                ponto.getObra().setTipoObra(null);
            }
            if (ponto.getRodovia() != null) {
                ponto.getRodovia().setEmpresa(null);
            }
            if (contagem.containsKey(idPontoTxt = ponto.getId().toString())) {
                ponto.setNroFichas((Integer)contagem.get(idPontoTxt));
            }
            ponto.setRodovia(null);
            ponto.setCidade(null);
            ponto.setObra(null);
            ponto.setTipo(null);
        }
        this.serializeJson(pontos.getContent(), mapper, destFilePath, "pontos-controle.json");
        pageNbr = 1;
        pageSize = 10000;
        sortField = "titulo";
        sortDesc = true;
        FiltroBoaPratica filtroBoaPratica = new FiltroBoaPratica();
        if (filtroBoaPratica.getConcessionaria() == null || filtroBoaPratica.getConcessionaria().isEmpty()) {
            filtroBoaPratica.setConcessionaria(empresas);
        }
        filtroBoaPratica.setLastUpdate(lastUpdate);
        Page boasPraticas = this.boaPraticaService.findBoasPraticas(filtroBoaPratica, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true));
        for (BoaPratica row : boasPraticas) {
            if (row.getAnexos() == null) continue;
            for (BoaPraticaAnexo anx : row.getAnexos()) {
                anx.setUsuario(null);
            }
        }
        this.serializeJson(boasPraticas.getContent(), mapper, destFilePath, "boas-praticas.json");
        List usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, null, null, Boolean.valueOf(false), null, lastUpdate);
        ArrayList<UsuarioEmpresaAreaVO> usuarios = new ArrayList<UsuarioEmpresaAreaVO>();
        if (usuariosEmp != null) {
            for (UsuarioEmpresa usuEmp : usuariosEmp) {
                UsuarioEmpresaAreaVO user2 = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                if (usuarios.contains(user2)) continue;
                usuarios.add(user2);
            }
        }
        this.serializeJson(usuarios, mapper, destFilePath, "usuarios.json");
        ArrayList<String> perfis = new ArrayList<String>();
        GrupoAcessoUsuario perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.GERAL_PERFIL_COORDENACAO_OBRAS);
        perfis.add(perfilCoord.getDescricao());
        usuarios.clear();
        usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, lastUpdate);
        if (usuariosEmp != null) {
            for (Object usuEmp : usuariosEmp) {
                user = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                if (usuarios.contains(user)) continue;
                usuarios.add(user);
            }
        }
        this.serializeJson(usuarios, mapper, destFilePath, "usuarios-cooare.json");
        perfis.clear();
        perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.MEIO_AMBIENTE_PERFIL_COORDENACAO_AMBIENTAL);
        perfis.add(perfilCoord.getDescricao());
        usuarios.clear();
        usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, lastUpdate);
        if (usuariosEmp != null) {
            for (Object usuEmp : usuariosEmp) {
                user = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                if (usuarios.contains(user)) continue;
                usuarios.add(user);
            }
        }
        this.serializeJson(usuarios, mapper, destFilePath, "usuarios-cooamb.json");
        perfis.clear();
        GrupoAcessoUsuario perfilSup = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.MEIO_AMBIENTE_PERFIL_SUPERVISAO_AMBIENTAL);
        perfis.add(perfilSup.getDescricao());
        usuarios.clear();
        usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, lastUpdate);
        if (usuariosEmp != null) {
            for (UsuarioEmpresa usuEmp : usuariosEmp) {
                UsuarioEmpresaAreaVO user3 = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                if (usuarios.contains(user3)) continue;
                usuarios.add(user3);
            }
        }
        this.serializeJson(usuarios, mapper, destFilePath, "usuarios-supamb.json");
        List equipes = this.cadastroService.findEquipes(idEmpresa, null, null, lastUpdate, null);
        this.serializeJson(equipes, mapper, destFilePath, "equipes.json");
        List cidades = this.cadastroService.findCidades(null, lastUpdate);
        for (Cidade cidade : cidades) {
            cidade.setDatHorCadastro(null);
            cidade.setIdUsuarioIns(null);
        }
        this.serializeJson(cidades, mapper, destFilePath, "cidades.json");
        List gravidades = this.cadastroAmbientalService.findGravidades(searchTxt, lastUpdate);
        this.serializeJson(gravidades, mapper, destFilePath, "gravidades.json");
        List obras = this.cadastroService.findObras(idEmpresa, searchTxt, null, null, null, null, lastUpdate);
        this.serializeJson(obras, mapper, destFilePath, "obras.json");
        List regras = this.cadastroAmbientalService.findRegrasOuro(searchTxt, lastUpdate);
        for (Object reg : regras) {
            reg.setUsuarios(null);
        }
        this.serializeJson(regras, mapper, destFilePath, "regras-ouro.json");
        List rodovias = this.cadastroService.findRodovias(searchTxt, idEmpresa, lastUpdate);
        for (Rodovia rdv : rodovias) {
            rdv.setEmpresa(null);
        }
        this.serializeJson(rodovias, mapper, destFilePath, "rodovias.json");
        List tiposRac = this.cadastroAmbientalService.findTiposFicha("RAC", searchTxt, lastUpdate, null);
        this.serializeJson(tiposRac, mapper, destFilePath, "tipos-rac.json");
        List tiposAnalise = this.cadastroAmbientalService.findTiposFicha("ANAMB", searchTxt, lastUpdate, null);
        this.serializeJson(tiposAnalise, mapper, destFilePath, "tipos-analise-ambiental.json");
        List tiposArea = this.cadastroAmbientalService.findTiposFicha("DEPOS", searchTxt, lastUpdate, null);
        this.serializeJson(tiposArea, mapper, destFilePath, "tipos-area-apoio.json");
        List tiposInterv = this.cadastroAmbientalService.findTiposFicha("AUINT", searchTxt, lastUpdate, null);
        this.serializeJson(tiposInterv, mapper, destFilePath, "tipos-autorizacao-intervencao.json");
        List tiposDesc = this.cadastroAmbientalService.findTiposFicha("AURAP", searchTxt, lastUpdate, null);
        this.serializeJson(tiposDesc, mapper, destFilePath, "tipos-autorizacao-descarte.json");
        List tiposInspecao = this.cadastroAmbientalService.findTiposFicha("INSPE", searchTxt, lastUpdate, null);
        this.serializeJson(tiposInspecao, mapper, destFilePath, "tipos-inspecao.json");
        List statusFichas = this.cadastroAmbientalService.findStatusFicha(searchTxt, null, lastUpdate);
        this.serializeJson(statusFichas, mapper, destFilePath, "status-ficha.json");
        List areasProtegidas = this.cadastroAmbientalService.findAreasProtegidas(searchTxt, idEmpresa, lastUpdate);
        if (areasProtegidas != null && !areasProtegidas.isEmpty()) {
            for (Object area : areasProtegidas) {
                if (area.getEmpresa() == null) continue;
                area.setEmpresa(null);
                area.setIdEmpresa(null);
            }
            this.serializeJson(areasProtegidas, mapper, destFilePath, "areas-protegidas.json");
        }
        if ((requisitosLegais = this.cadastroAmbientalService.findRequisitosLegais(searchTxt, lastUpdate)) != null && !requisitosLegais.isEmpty()) {
            for (RequisitoLegal requisito : requisitosLegais) {
                if (requisito.getTipoRequisitoLegal() == null) continue;
                requisito.setTipoRequisitoLegal(null);
            }
            this.serializeJson(requisitosLegais, mapper, destFilePath, "requisitos-legais.json");
        }
        List tiposRequisitosLegais = this.cadastroAmbientalService.findTiposRequisitosLegais(searchTxt, lastUpdate);
        this.serializeJson(tiposRequisitosLegais, mapper, destFilePath, "tipos-requisitos-legais.json");
        List fichasBase = this.checkListService.findCheckListFichas(searchTxt, lastUpdate);
        ArrayList<CheckListFicha> fichas = new ArrayList<CheckListFicha>();
        for (CheckListFicha fch : fichasBase) {
            CheckListFicha ficha = this.checkListService.getCheckListFichaById(fch.getId());
            if (ficha.getItens() != null) {
                for (CheckListFichaItem item : ficha.getItens()) {
                    item.setFicha(null);
                }
            }
            fichas.add(ficha);
        }
        this.serializeJson(fichas, mapper, destFilePath, "checklists-fichas.json");
        List analisesGrupos = this.analiseAmbientalService.findAnaliseGrupos(null, lastUpdate);
        this.serializeJson(analisesGrupos, mapper, destFilePath, "analises-grupos.json");
        List analisesTipos = this.analiseAmbientalService.findAnaliseTipos(null, lastUpdate);
        this.serializeJson(analisesTipos, mapper, destFilePath, "analises-tipos.json");
        pageNbr = 1;
        pageSize = 500;
        sortField = "numero";
        sortDesc = true;
        FiltroChecklist filtroCheck = new FiltroChecklist();
        if (filtroCheck.getConcessionaria() == null || filtroCheck.getConcessionaria().isEmpty()) {
            filtroCheck.setConcessionaria(empresas);
        }
        filtroCheck.setModulo(TipoModulo.AMBIENTAL.getSigla());
        filtroCheck.setLastUpdate(lastUpdate);
        Page firstPageResult = this.checkListService.findCheckListsMobile(filtroCheck, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), lastUpdate);
        int totalPages = firstPageResult.getTotalPages();
        ArrayList checklistLctos = new ArrayList();
        for (CheckList row : firstPageResult.getContent()) {
            this.normalizePayloadChecklist(row);
        }
        checklistLctos.addAll(firstPageResult.getContent());
        for (int i = pageNbr + 1; i <= totalPages; ++i) {
            Page pageResult = this.checkListService.findCheckListsMobile(filtroCheck, i, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), lastUpdate);
            for (Object row : pageResult.getContent()) {
                this.normalizePayloadChecklist((CheckList)row);
            }
            checklistLctos.addAll(pageResult.getContent());
        }
        this.serializeJson(checklistLctos, mapper, destFilePath, "fichas-checklists.json");
        pageNbr = 1;
        pageSize = 500;
        sortField = "numero";
        sortDesc = true;
        FiltroRac filtroRac = new FiltroRac();
        filtroRac.setLastUpdate(lastUpdate);
        Page racs = this.racService.findRacsMobile(filtroRac, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), empresa, Boolean.valueOf(false));
        ArrayList racsLst = new ArrayList();
        totalPages = racs.getTotalPages();
        for (Rac rac : racs) {
            this.normalizePayloadRac(rac);
        }
        racsLst.addAll(racs.getContent());
        while (pageNbr++ <= totalPages) {
            racs = this.racService.findRacsMobile(filtroRac, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), empresa, Boolean.valueOf(false));
            for (Rac rac : racs) {
                this.normalizePayloadRac(rac);
            }
            racsLst.addAll(racs.getContent());
        }
        this.serializeJson(racsLst, mapper, destFilePath, "fichas-racs.json");
        FiltroInspecao filtroInsp = new FiltroInspecao();
        filtroInsp.setLastUpdate(lastUpdate);
        if (filtroInsp.getConcessionaria() == null || filtroInsp.getConcessionaria().isEmpty()) {
            filtroInsp.setConcessionaria(empresas);
        }
        boolean joinFlorestal = true;
        boolean joinAnexos = true;
        pageNbr = 1;
        Page inspecoes = this.inspecaoAmbientalService.findInspecoes(filtroInsp, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(joinFlorestal), Boolean.valueOf(joinAnexos));
        ArrayList inspecoesLst = new ArrayList();
        totalPages = inspecoes.getTotalPages();
        for (InspecaoAmbiental insp : inspecoes) {
            this.normalizePayloadInspecao(insp);
        }
        inspecoesLst.addAll(inspecoes.getContent());
        while (pageNbr++ <= totalPages) {
            inspecoes = this.inspecaoAmbientalService.findInspecoes(filtroInsp, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(joinFlorestal), Boolean.valueOf(joinAnexos));
            for (InspecaoAmbiental insp : inspecoes) {
                this.normalizePayloadInspecao(insp);
            }
            inspecoesLst.addAll(inspecoes.getContent());
        }
        this.serializeJson(inspecoesLst, mapper, destFilePath, "fichas-inspecoes.json");
        FiltroAnalise filtroAnalise = new FiltroAnalise();
        filtroAnalise.setLastUpdate(lastUpdate);
        if (filtroAnalise.getConcessionaria() == null || filtroAnalise.getConcessionaria().isEmpty()) {
            filtroAnalise.setConcessionaria(empresas);
        }
        pageNbr = 1;
        pageSize = 10000;
        Page analises = this.analiseAmbientalService.findAnalises(filtroAnalise, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true));
        for (AnaliseAmbiental analise : analises) {
            Set itens;
            if (analise.getSupervisorAmbiental() != null) {
                analise.getSupervisorAmbiental().setGrupos(null);
            }
            if (analise.getCoordenadorObra() != null) {
                analise.getCoordenadorObra().setGrupos(null);
            }
            analise.setRodovia(null);
            analise.setEmpresa(null);
            analise.setTipoAnalise(null);
            analise.setSupervisorAmbiental(null);
            analise.setCoordenadorObra(null);
            analise.setEquipeConcessao(null);
            analise.setEquipeEmpreiteira(null);
            analise.setEquipeAmbiental(null);
            analise.setCidade(null);
            analise.setObra(null);
            List anexos = analise.getAnexos();
            if (anexos != null) {
                Iterator iterator = anexos.iterator();
                while (iterator.hasNext()) {
                    AnaliseAnexo anx = (AnaliseAnexo)iterator.next();
                    anx.setUsuario(null);
                    if (anx.getAnexo() == null) continue;
                    Anexo anxGed = anx.getAnexo();
                    anxGed.setArea(null);
                    anxGed.setUsuario(null);
                }
            }
            if ((itens = analise.getItens()) == null) continue;
            for (Object itn : itens) {
                itn.setGrupo(null);
                itn.setTipo(null);
            }
        }
        this.serializeJson(analises.getContent(), mapper, destFilePath, "fichas-analises.json");
        FiltroAreaApoio filtroArea = new FiltroAreaApoio();
        filtroArea.setLastUpdate(lastUpdate);
        if (filtroArea.getConcessionaria() == null || filtroArea.getConcessionaria().isEmpty()) {
            filtroArea.setConcessionaria(empresas);
        }
        Page areas = this.areaApoioService.findAreasApoio(filtroArea, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        for (AreaApoio area : areas) {
            List situacoesArea;
            List ocorrenciasArea;
            if (area.getSupervisorAmbiental() != null) {
                area.getSupervisorAmbiental().setGrupos(null);
            }
            if (area.getCoordenadorObra() != null) {
                area.getCoordenadorObra().setGrupos(null);
            }
            area.setRodovia(null);
            area.setEmpresa(null);
            area.setTipoDeposito(null);
            area.setRegraOuro(null);
            area.setSupervisorAmbiental(null);
            area.setCoordenadorObra(null);
            area.setCoordenadorAmbiental(null);
            area.setPontoControle(null);
            area.setEquipeConcessao(null);
            area.setEquipeEmpreiteira(null);
            area.setEquipeAmbiental(null);
            area.setCidade(null);
            area.setObra(null);
            area.setReferencias(null);
            List anexos = area.getAnexos();
            if (anexos != null) {
                Object itn;
                itn = anexos.iterator();
                while (itn.hasNext()) {
                    AreaApoioAnexo anx = (AreaApoioAnexo)itn.next();
                    anx.setUsuario(null);
                    if (anx.getAnexo() == null) continue;
                    Anexo anxGed = anx.getAnexo();
                    anxGed.setArea(null);
                    anxGed.setUsuario(null);
                    anxGed.setEmpresa(null);
                }
            }
            if ((ocorrenciasArea = area.getOcorrencias()) != null) {
                for (Object oco2 : ocorrenciasArea) {
                    oco2.setOcorrencia(null);
                    oco2.setSolucao(null);
                    oco2.setUsuario(null);
                    oco2.setDatHorCadastro(null);
                }
            }
            if ((situacoesArea = area.getSituacoes()) == null) continue;
            oco2 = situacoesArea.iterator();
            while (oco2.hasNext()) {
                AreaApoioSituacao sit = (AreaApoioSituacao)oco2.next();
                sit.setDatHorCadastro(null);
            }
        }
        this.serializeJson(areas.getContent(), mapper, destFilePath, "fichas-areas-apoio.json");
        FiltroIntervencao filtroInte = new FiltroIntervencao();
        filtroInte.setLastUpdate(lastUpdate);
        if (filtroInte.getConcessionaria() == null || filtroInte.getConcessionaria().isEmpty()) {
            filtroInte.setConcessionaria(empresas);
        }
        Page intervencoes = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroInte, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        for (AutorizacaoIntervencao inte : intervencoes) {
            Set ocorrenciasInte;
            if (inte.getSupervisorAmbiental() != null) {
                inte.getSupervisorAmbiental().setGrupos(null);
            }
            if (inte.getCoordenadorObra() != null) {
                inte.getCoordenadorObra().setGrupos(null);
            }
            inte.setRodovia(null);
            inte.setEmpresa(null);
            inte.setTipoAutorizacao(null);
            inte.setRegraOuro(null);
            inte.setSupervisorAmbiental(null);
            inte.setCoordenadorObra(null);
            inte.setEquipeConcessao(null);
            inte.setEquipeEmpreiteira(null);
            inte.setEquipeAmbiental(null);
            inte.setCidade(null);
            inte.setObra(null);
            inte.setPontoControle(null);
            inte.setCoordenadorAmbiental(null);
            List anexos = inte.getAnexos();
            if (anexos != null) {
                oco2 = anexos.iterator();
                while (oco2.hasNext()) {
                    IntervencaoAnexo anx = (IntervencaoAnexo)oco2.next();
                    anx.setUsuario(null);
                    Anexo anxGed = anx.getAnexo();
                    if (anxGed == null) continue;
                    anxGed.setArea(null);
                    anxGed.setUsuario(null);
                    anxGed.setEmpresa(null);
                }
            }
            if ((ocorrenciasInte = inte.getOcorrencias()) == null) continue;
            for (Object oco3 : ocorrenciasInte) {
                oco3.setOcorrencia(null);
                oco3.setSolucao(null);
                oco3.setUsuario(null);
                oco3.setDatHorCadastro(null);
            }
        }
        this.serializeJson(intervencoes.getContent(), mapper, destFilePath, "fichas-autorizacao-intervencao.json");
        FiltroDescarte filtroDesc = new FiltroDescarte();
        filtroDesc.setLastUpdate(lastUpdate);
        if (filtroDesc.getConcessionaria() == null || filtroDesc.getConcessionaria().isEmpty()) {
            filtroDesc.setConcessionaria(empresas);
        }
        Page descartes = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtroDesc, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true));
        for (AutorizacaoDescarte desc : descartes) {
            Set ocorrenciasInsp;
            if (desc.getSupervisorAmbiental() != null) {
                desc.getSupervisorAmbiental().setGrupos(null);
            }
            if (desc.getCoordenadorObra() != null) {
                desc.getCoordenadorObra().setGrupos(null);
            }
            desc.setRodovia(null);
            desc.setEmpresa(null);
            desc.setTipoAutorizacao(null);
            desc.setRegraOuro(null);
            desc.setSupervisorAmbiental(null);
            desc.setCoordenadorObra(null);
            desc.setEquipeConcessao(null);
            desc.setEquipeEmpreiteira(null);
            desc.setEquipeAmbiental(null);
            desc.setCidade(null);
            desc.setObra(null);
            desc.setPontoControle(null);
            desc.setCoordenadorAmbiental(null);
            List anexos = desc.getAnexos();
            if (anexos != null) {
                for (AutorizacaoAnexo anx : anexos) {
                    anx.setUsuario(null);
                    Anexo anxGed = anx.getAnexo();
                    if (anxGed == null) continue;
                    anxGed.setArea(null);
                    anxGed.setUsuario(null);
                    anxGed.setEmpresa(null);
                }
            }
            if ((ocorrenciasInsp = desc.getOcorrencias()) == null) continue;
            for (AutorizacaoOcorrencia oco4 : ocorrenciasInsp) {
                oco4.setOcorrencia(null);
                oco4.setSolucao(null);
            }
        }
        this.serializeJson(descartes.getContent(), mapper, destFilePath, "fichas-autorizacoes-descarte.json");
        List elementosArboreos = this.cadastroAmbientalService.findElementosArboreos(null, lastUpdate);
        this.serializeJson(elementosArboreos, mapper, destFilePath, "elementos-arboreos.json");
        List ocorrenciasFlorestais = this.cadastroAmbientalService.findOcorrenciasFlorestais(null, lastUpdate);
        this.serializeJson(ocorrenciasFlorestais, mapper, destFilePath, "ocorrencias-florestais.json");
        List grausRiscos = this.cadastroAmbientalService.findGrausRiscos(null, lastUpdate);
        this.serializeJson(grausRiscos, mapper, destFilePath, "graus-riscos.json");
        List licObras = this.licencaService.findLicencasByObra(null, empresas);
        if (licObras != null && !licObras.isEmpty()) {
            for (LicencaObra row : licObras) {
                row.setUsuario(null);
                Licenca lic = row.getLicenca();
                if (lic != null) {
                    lic.setSubstituta(null);
                    lic.setEmpresa(null);
                    lic.setArea(null);
                    lic.setTipoCorrespondencia(null);
                }
                row.setObra(null);
            }
            this.serializeJson(licObras, mapper, destFilePath, "licencas.json");
        }
        logger.debug("Processo conclu\u00eddo, arquivo ZIP gerado com sucesso.");
        return destFilePath;
    }

    private void serializeJson(List<?> dados, ObjectMapper mapper, String dirName, String fileName) {
        logger.debug("serializeJson, dir={}, fileName={} ", (Object)dirName, (Object)fileName);
        if (dados == null || dados.isEmpty()) {
            logger.error("Dados vazios => {}", (Object)fileName);
            return;
        }
        try {
            File file = Paths.get(dirName, fileName).toFile();
            mapper.writeValue(file, dados);
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
        }
    }

    private Usuario getUsuarioBase(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        Usuario user = new Usuario();
        user.setLogin(usuario.getLogin());
        user.setNome(usuario.getNome());
        user.setEmail(usuario.getEmail());
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(File file) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                    zipfile = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void normalizePayloadChecklist(CheckList row) {
        if (row.getSupervisorAmbiental() != null) {
            row.getSupervisorAmbiental().setGrupos(null);
        }
        if (row.getCoordenadorObra() != null) {
            row.getCoordenadorObra().setGrupos(null);
        }
        row.setRodovia(null);
        row.setPontoControle(null);
        row.setEmpresa(null);
        row.setSupervisorAmbiental(null);
        row.setCoordenadorObra(null);
        row.setEquipeConcessao(null);
        row.setEquipeEmpreiteira(null);
        row.setEquipeAmbiental(null);
        row.setCidade(null);
        row.setObra(null);
        row.setCoordenadorAmbiental(null);
        row.setFicha(null);
        if (row.getItens() != null) {
            for (CheckListItem item : row.getItens()) {
                item.setCheckList(null);
                if (item.getAnexos() == null) continue;
                for (CheckListAnexo anexo : item.getAnexos()) {
                    anexo.setCheckList(null);
                    anexo.setUsuario(null);
                    Anexo anxRepo = anexo.getAnexo();
                    if (anxRepo == null) continue;
                    anxRepo.setEmpresa(null);
                    anxRepo.setRepoPath(null);
                    anxRepo.setHierarquia(null);
                    anxRepo.setUsuario(null);
                    anxRepo.setStatusGed(null);
                }
            }
        }
        if (row.getAnexos() != null) {
            for (CheckListAnexo anx : row.getAnexos()) {
                anx.setCheckList(null);
                anx.setUsuario(null);
                Anexo anxGed = anx.getAnexo();
                if (anxGed == null) continue;
                anxGed.setEmpresa(null);
            }
        }
    }

    private void normalizePayloadRac(Rac rac) {
        rac.setEvento(null);
        rac.setCidade(null);
        rac.setEmpresa(null);
        rac.setGravidade(null);
        rac.setTipoRac(null);
        rac.setObra(null);
        rac.setSupervisorAmbiental(null);
        rac.setCoordenadorAmbiental(null);
        rac.setCoordenadorObra(null);
        rac.setEquipeConcessao(null);
        rac.setEquipeEmpreiteira(null);
        rac.setEquipeAmbiental(null);
        rac.setEquipeSolucao(null);
        rac.setPontoControle(null);
        rac.setRodovia(null);
        rac.setFichaAtual(null);
        if (rac.getFichasRac() != null) {
            for (RacFicha ficha : rac.getFichasRac()) {
                ficha.setRac(null);
                ficha.setUsuario(null);
                if (ficha.getCorrecoes() == null || !ficha.getCorrecoes().isEmpty()) continue;
                ficha.setCorrecoes(null);
            }
        }
        if (rac.getOcorrencias() != null) {
            for (RacOcorrencia ocorr : rac.getOcorrencias()) {
                ocorr.setRac(null);
                ocorr.setUsuario(null);
                ocorr.setOcorrencia(null);
                ocorr.setSolucao(null);
            }
        }
        if (rac.getCorrecoes() != null) {
            for (RacCorrecao corr : rac.getCorrecoes()) {
                corr.setRac(null);
                if (corr.getUsuario() == null) continue;
                corr.setUsuario(this.getUsuarioBase(corr.getUsuario()));
            }
        }
        if (rac.getRegrasOuro() != null) {
            for (RacRegraOuro regra : rac.getRegrasOuro()) {
                regra.setRac(null);
                regra.setRegraOuro(null);
            }
        }
        if (rac.getAnexos() != null) {
            for (RacAnexo anx : rac.getAnexos()) {
                anx.setRac(null);
                anx.setUsuario(null);
                if (anx.getAnexo() == null) continue;
                Anexo anxRac = anx.getAnexo();
                anxRac.setDescricao(null);
                anxRac.setHierarquia(null);
                anxRac.setRepoPath(null);
                anxRac.setIdProprietario(null);
                anxRac.setStatusGed(null);
                anxRac.setUsuario(null);
                anxRac.setEmpresa(null);
            }
        }
        if (rac.getFichasRacAnexo() != null) {
            for (RacFichaAnexo anxFicha : rac.getFichasRacAnexo()) {
                anxFicha.setRac(null);
                anxFicha.setUsuario(null);
                if (anxFicha.getAnexo() == null) continue;
                Anexo anx = anxFicha.getAnexo();
                anx.setDescricao(null);
                anx.setHierarquia(null);
                anx.setRepoPath(null);
                anx.setStatusGed(null);
                anx.setDatHorUpload(null);
                anx.setIdProprietario(null);
                anx.setUsuario(null);
                anx.setEmpresa(null);
            }
        }
        if (rac.getRequisitosLegais() != null) {
            for (RacRegraOuro regra : rac.getRequisitosLegais()) {
                regra.setRac(null);
                regra.setRequisito(null);
            }
        }
    }

    private void normalizePayloadInspecao(InspecaoAmbiental insp) {
        List fichasInsp;
        Set ocorrenciasInsp;
        insp.setRodovia(null);
        insp.setEmpresa(null);
        insp.setTipoInspecao(null);
        insp.setSupervisorAmbiental(null);
        insp.setCoordenadorObra(null);
        insp.setEquipeConcessao(null);
        insp.setEquipeEmpreiteira(null);
        insp.setEquipeAmbiental(null);
        insp.setCidade(null);
        insp.setObra(null);
        insp.setPontoControle(null);
        insp.setCoordenadorAmbiental(null);
        insp.setFichaAtual(null);
        insp.setAreaProtegida(null);
        List anexos = insp.getAnexos();
        if (anexos != null) {
            for (InspecaoAnexo anx : anexos) {
                anx.setUsuario(null);
                if (anx.getAnexo() == null) continue;
                Anexo anxGed = anx.getAnexo();
                anxGed.setArea(null);
                anxGed.setUsuario(null);
                anxGed.setEmpresa(null);
            }
        }
        if ((ocorrenciasInsp = insp.getOcorrencias()) != null) {
            for (InspecaoOcorrencia oco : ocorrenciasInsp) {
                oco.setOcorrencia(null);
                oco.setSolucao(null);
                oco.setInspecao(null);
                oco.setUsuario(null);
                oco.setDatHorCadastro(null);
            }
        }
        if ((fichasInsp = insp.getFichas()) != null) {
            for (InspecaoFicha fic : fichasInsp) {
                fic.setInspecao(null);
                fic.setUsuario(null);
                fic.setStatus(null);
            }
        }
    }
}

