/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental;

import br.com.oti.gesconsys.ambiental.beans.FichaAmbientalImpl;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListAnexo;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItemVO;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.descarte.FiltroDescarte;
import br.com.oti.gesconsys.ambiental.beans.fichas.CalendarioFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.OcorrenciaFichaVO;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.licencas.FiltroCondicionante;
import br.com.oti.gesconsys.ambiental.beans.licencas.FiltroLicenca;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroBoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroFichaAmbiental;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Entidade;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.shared.CaraterCondicionante;
import br.com.oti.gesconsys.beans.shared.Condicionante;
import br.com.oti.gesconsys.beans.shared.Equipe;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.beans.shared.StatusCondicionante;
import br.com.oti.gesconsys.beans.shared.StatusLicenca;
import br.com.oti.gesconsys.beans.shared.TipoDocumento;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.AreaApoioService;
import br.com.oti.gesconsys.business.services.AutorizacaoDescarteService;
import br.com.oti.gesconsys.business.services.AutorizacaoIntervencaoService;
import br.com.oti.gesconsys.business.services.BoaPraticaService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CheckListService;
import br.com.oti.gesconsys.business.services.FichaAmbientalService;
import br.com.oti.gesconsys.business.services.InspecaoAmbientalService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.PontoControleService;
import br.com.oti.gesconsys.business.services.RacService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.ambiental.AmbientalAnalisesRestServices;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Endpoints para An\u00e1lises Gerenciais, para uso em Dashboards e BI", name="dashboards")
@RequestMapping(value={"/api/ambiental/analises"})
public class AmbientalAnalisesRestServices {
    private static final Logger logger = LoggerFactory.getLogger(AmbientalAnalisesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private FichaAmbientalService fichaAmbientalService;
    @Autowired
    private RacService racService;
    @Autowired
    private CheckListService checkListService;
    @Autowired
    private InspecaoAmbientalService inspecaoAmbientalService;
    @Autowired
    private AreaApoioService areaApoioService;
    @Autowired
    private PontoControleService pontoControleService;
    @Autowired
    private BoaPraticaService boaPraticaService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private AutorizacaoDescarteService autorizacaoDescarteService;
    @Autowired
    private AutorizacaoIntervencaoService autorizacaoIntervencaoService;

    @PostMapping(value={"/fichas/{tipoFicha}"})
    public ResponseEntity<List<FichaAmbientalImpl>> findFichas(@PathVariable(name="tipoFicha") String tipoFicha, @RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request, HttpServletResponse response) {
        try {
            HashMap<Integer, Cidade> cidadesMap = new HashMap<Integer, Cidade>();
            List cidades = this.cadastroService.findCidades(null, null);
            for (Cidade cid : cidades) {
                cidadesMap.put(cid.getId(), cid);
            }
            1 copyBean = new /* Unavailable Anonymous Inner Class!! */;
            ArrayList retorno = new ArrayList();
            if (tipoFicha.equalsIgnoreCase("rac")) {
                FiltroRac filtroRac = new FiltroRac();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                List empresas = this.coreService.findEmpresas(null, null);
                Map empresasMap = empresas.stream().collect(Collectors.toMap(Empresa::getId, Function.identity()));
                Page racs = this.racService.findRacs(filtroRac, 1, 50000, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
                for (Rac rac : racs) {
                    if (rac.getCidade() == null) {
                        rac.setCidade((Cidade)cidadesMap.get(rac.getIdCidade()));
                    }
                    if (rac.getRodovia() != null) {
                        rac.getRodovia().setEmpresa(null);
                    }
                    Empresa empMap = (Empresa)empresasMap.get(rac.getId().getIdEmpresa());
                    Empresa newEmp = new Empresa();
                    if (empMap != null) {
                        newEmp.setSigla(empMap.getSigla());
                        newEmp.setNomeFantasia(empMap.getNomeFantasia());
                    }
                    rac.setEmpresa(newEmp);
                }
                retorno.addAll(racs.getContent());
            } else if (tipoFicha.equalsIgnoreCase("inspe") || tipoFicha.equalsIgnoreCase("inspecoes") || tipoFicha.equalsIgnoreCase("inspecao")) {
                FiltroInspecao filtroRac = new FiltroInspecao();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                boolean joinFlorestal = false;
                boolean joinFichas = false;
                boolean joinAnexos = false;
                boolean joinEventos = false;
                Page inspecoes = this.inspecaoAmbientalService.findInspecoes(filtroRac, 1, 50000, "numero", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(joinFichas), Boolean.valueOf(joinEventos), Boolean.valueOf(joinFlorestal), Boolean.valueOf(joinAnexos));
                for (InspecaoAmbiental inspe : inspecoes) {
                    inspe.setFichas(null);
                }
                retorno.addAll(inspecoes.getContent());
            } else if (tipoFicha.equalsIgnoreCase("areasApoio")) {
                FiltroAreaApoio filtroRac = new FiltroAreaApoio();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                boolean joinOcorrencias = false;
                boolean joinSituacoes = true;
                Page lista = this.areaApoioService.findAreasApoio(filtroRac, 1, 5000, "numero", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinSituacoes));
                retorno.addAll(lista.getContent());
            } else if (tipoFicha.equalsIgnoreCase("autorizaIntervencao") || tipoFicha.equalsIgnoreCase("AINTE")) {
                FiltroIntervencao filtroRac = new FiltroIntervencao();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                boolean joinSortDesc = false;
                boolean joinOcorrencias = false;
                boolean joinAnexos = false;
                boolean joinFlorestais = false;
                Page lista = this.autorizacaoIntervencaoService.findAutorizacoesIntervencao(filtroRac, 1, 5000, "numero", Boolean.valueOf(joinSortDesc), Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinFlorestais));
                retorno.addAll(lista.getContent());
            } else if (tipoFicha.equalsIgnoreCase("autorizaDescarte") || tipoFicha.equalsIgnoreCase("ADESC")) {
                FiltroDescarte filtroRac = new FiltroDescarte();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                boolean joinOcorrencias = false;
                boolean joinAnexos = false;
                Page lista = this.autorizacaoDescarteService.findAutorizacoesDescartes(filtroRac, 1, 5000, "numero", Boolean.valueOf(false), Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinAnexos));
                retorno.addAll(lista.getContent());
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ficha (%s) inv\u00e1lido.", tipoFicha));
            }
            return new ResponseEntity(retorno, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFichas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IllegalAccessException iaeExc) {
            logger.error("IllegalAccessExc.findFichas", (Throwable)iaeExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, iaeExc.getMessage());
        }
        catch (InvocationTargetException iteExc) {
            logger.error("InvocTargExc.findFichas", (Throwable)iteExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, iteExc.getMessage());
        }
    }

    @PostMapping(value={"/licencas"})
    public ResponseEntity<List<Licenca>> findLicencas(@RequestBody FiltroLicenca filtro, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Carregando licen\u00e7as, filtro={}...", (Object)filtro);
        try {
            List rows = this.licencaService.findLicencas(filtro.getConcessionaria(), filtro.getDescricao(), filtro.getIdEntidade(), filtro.getNroProcesso(), filtro.getIdTipo(), filtro.getDatInicial(), filtro.getDatFinal(), filtro.getTipoIntervalo(), filtro.getStatusLicenca(), filtro.getIds());
            for (Licenca row : rows) {
                Empresa emp;
                TipoDocumento tipo;
                StatusLicenca status;
                Entidade entidade = row.getEntidade();
                if (entidade != null) {
                    entidade.setClassificacao(null);
                    entidade.setSetores(null);
                    entidade.setDatHorCadastro(null);
                    entidade.setDatHorAlteracao(null);
                    entidade.setIdUsuarioIns(null);
                    entidade.setIdUsuarioUpd(null);
                }
                if ((status = row.getStatus()) != null) {
                    status.setDatHorCadastro(null);
                    status.setDatHorAlteracao(null);
                    status.setIdUsuarioIns(null);
                    status.setIdUsuarioUpd(null);
                }
                if ((tipo = row.getTipoCorrespondencia()) != null) {
                    tipo.setDatHorCadastro(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setIdUsuarioUpd(null);
                    tipo.setResposta(null);
                }
                if ((emp = row.getEmpresa()) == null) continue;
                Empresa empNew = new Empresa();
                empNew.setSigla(emp.getSigla());
                empNew.setNomeFantasia(emp.getNomeFantasia());
                row.setEmpresa(empNew);
            }
            return new ResponseEntity((Object)rows, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLicencas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/checklists"})
    public ResponseEntity<Page<CheckListItemVO>> findCheckLists(@RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Carregando checklists - dashboards, filtro={}...", (Object)filtroFicha);
        try {
            int pageNbr = 1;
            int pageSize = 150;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            2 copyBean = new /* Unavailable Anonymous Inner Class!! */;
            FiltroChecklist filtroChkLst = new FiltroChecklist();
            copyBean.copyProperties((Object)filtroChkLst, (Object)filtroFicha);
            if (filtroChkLst.getModulo() == null) {
                filtroChkLst.setModulo("AMB");
            }
            List empresasId = filtroChkLst.getConcessionaria();
            ArrayList items = new ArrayList();
            Page checkLists = this.checkListService.findCheckListsItensByFiltro(filtroChkLst, pageNbr, pageSize, "ckl.nro_checklist", Boolean.valueOf(false));
            int menorId = 0;
            int maiorId = 0;
            Integer idEmpresa = null;
            HashMap<Integer, List<Integer>> minMaxMap = new HashMap<Integer, List<Integer>>();
            for (CheckListItemVO rowItem : checkLists) {
                if (idEmpresa == null) {
                    idEmpresa = rowItem.getIdEmpresa();
                }
                if (!idEmpresa.equals(rowItem.getIdEmpresa())) {
                    minMaxMap.put(idEmpresa, List.of(Integer.valueOf(menorId), Integer.valueOf(maiorId)));
                    logger.debug("IDEmpresa={}, menorId={}, maiorId={}", new Object[]{idEmpresa, menorId, maiorId});
                    idEmpresa = rowItem.getIdEmpresa();
                    menorId = 0;
                    maiorId = 0;
                }
                if (menorId == 0 || rowItem.getIdCheckList() < menorId) {
                    menorId = rowItem.getIdCheckList();
                }
                if (maiorId != 0 && rowItem.getIdCheckList() < maiorId) continue;
                maiorId = rowItem.getIdCheckList();
            }
            minMaxMap.put(idEmpresa, List.of(Integer.valueOf(menorId), Integer.valueOf(maiorId)));
            logger.debug("IDEmpresa={}, menorId={}, maiorId={}", new Object[]{idEmpresa, menorId, maiorId});
            List assinaturas = null;
            idEmpresa = null;
            int idxSign = 0;
            for (CheckListItemVO rowItem : checkLists) {
                if (idEmpresa == null || !idEmpresa.equals(rowItem.getIdEmpresa())) {
                    idEmpresa = rowItem.getIdEmpresa();
                    List minMaxVal = (List)minMaxMap.get(idEmpresa);
                    menorId = (Integer)minMaxVal.get(0);
                    maiorId = (Integer)minMaxVal.get(1);
                    assinaturas = this.checkListService.findAssinaturasCheckListByIntervalo(idEmpresa, Integer.valueOf(menorId), Integer.valueOf(maiorId));
                    logger.debug("assinaturas.size={}", (Object)assinaturas.size());
                }
                rowItem.setAssinatura1Nome(null);
                rowItem.setAssinatura1Cargo(null);
                rowItem.setAssinatura2Nome(null);
                rowItem.setAssinatura2Cargo(null);
                idxSign = 0;
                Iterator iterator = assinaturas.iterator();
                while (iterator.hasNext()) {
                    CheckListAnexo sign = (CheckListAnexo)iterator.next();
                    if (!sign.getId().getIdEmpresa().equals(rowItem.getIdEmpresa()) || !sign.getId().getIdCheckList().equals(rowItem.getIdCheckList()) || sign.getAssinaturaNome() == null || sign.getAssinaturaNome().isEmpty()) continue;
                    if (idxSign == 0) {
                        rowItem.setAssinatura1Nome(sign.getAssinaturaNome());
                        rowItem.setAssinatura1Cargo(sign.getAssinaturaCargo());
                    } else if (idxSign == 1) {
                        rowItem.setAssinatura2Nome(sign.getAssinaturaNome());
                        rowItem.setAssinatura2Cargo(sign.getAssinaturaCargo());
                    }
                    ++idxSign;
                    iterator.remove();
                }
            }
            logger.debug("Retornando itens.checklists, pagina={}, pageSize={}, total = {}", new Object[]{pageNbr, pageSize, checkLists.getTotalElements()});
            return new ResponseEntity((Object)checkLists, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCheckLists", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IllegalAccessException iaeExc) {
            logger.error("IllegalAccessExc.findCheckLists", (Throwable)iaeExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, iaeExc.getMessage());
        }
        catch (InvocationTargetException iteExc) {
            logger.error("InvocTargExc.findCheckLists", (Throwable)iteExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, iteExc.getMessage());
        }
    }

    @PostMapping(value={"/condicionantes"})
    public ResponseEntity<List<Condicionante>> findCondicionantes(@RequestBody FiltroCondicionante filtro, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Carregando condicionantes, filtro={}...", (Object)filtro);
        try {
            List rows = this.licencaService.findCondicionantes(filtro.getConcessionaria(), filtro.getDescricao(), filtro.getIdEntidade(), filtro.getNroProcesso(), filtro.getIdTipo(), filtro.getDatInicial(), filtro.getDatFinal(), filtro.getTipoIntervalo());
            for (Condicionante row : rows) {
                Empresa emp;
                StatusCondicionante statusCond;
                Licenca lic = new Licenca();
                lic.setId(row.getIdLicenca());
                if (row.getLicenca() != null) {
                    lic.setNroLicenca(row.getLicenca().getNroLicenca());
                }
                row.setLicenca(lic);
                CaraterCondicionante carater = row.getCarater();
                if (carater != null) {
                    carater.setDatHorCadastro(null);
                    carater.setDatHorAlteracao(null);
                    carater.setIdUsuarioIns(null);
                    carater.setIdUsuarioUpd(null);
                }
                if ((statusCond = row.getStatusCondicionante()) != null) {
                    statusCond.setDatHorCadastro(null);
                    statusCond.setDatHorAlteracao(null);
                    statusCond.setIdUsuarioIns(null);
                    statusCond.setIdUsuarioUpd(null);
                }
                if ((emp = row.getEmpresa()) == null) {
                    emp = lic.getEmpresa();
                }
                if (emp == null) continue;
                Empresa empNew = new Empresa();
                empNew.setSigla(emp.getSigla());
                empNew.setNomeFantasia(emp.getNomeFantasia());
                row.setEmpresa(empNew);
            }
            return new ResponseEntity((Object)rows, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionantes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/cadastros/{tipo}"})
    public ResponseEntity<List<KeyValue>> findCadastros(@PathVariable(name="tipo") String tipo, HttpServletRequest request) {
        try {
            ArrayList<KeyValue> retorno = new ArrayList<KeyValue>();
            if (tipo.equalsIgnoreCase("cidade")) {
                List cidades = this.cadastroService.findCidades(null, null);
                for (Cidade cid : cidades) {
                    retorno.add(new KeyValue((Object)cid.getId(), cid.getDescricao()));
                }
            } else if (tipo.equalsIgnoreCase("rodovia")) {
                List rodovias = this.cadastroService.findRodovias(null, null, null);
                for (Rodovia rdv : rodovias) {
                    retorno.add(new KeyValue((Object)rdv.getId(), rdv.getDescricao()));
                }
            }
            return new ResponseEntity(retorno, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/calendario/{tipoFicha}"})
    public ResponseEntity<List<CalendarioFichaVO>> findCalendario(@PathVariable(name="tipoFicha") String tipoFicha, @RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request) {
        try {
            List calendario = this.fichaAmbientalService.findResumoMensalStatusByFicha(tipoFicha, filtroFicha);
            return new ResponseEntity((Object)calendario, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCalendario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/equipes/{tipoEquipe}"})
    @Operation(summary="Retorna uma listagem das equipes, de acordo com tipo (E - Empreiteira; C - Concession\u00e1ria; A - Ambiental)")
    @ResponseBody
    public ResponseEntity<List<Equipe>> findEquipes(@PathVariable(name="tipoEquipe") String tipoEquipe, HttpServletRequest request) {
        try {
            logger.debug("findEquipes, dashboard Ambiental...");
            List equipes = this.cadastroService.findEquipes(null, null, tipoEquipe, null, null);
            for (Equipe eqp : equipes) {
                eqp.setTipo(null);
            }
            return new ResponseEntity((Object)equipes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ocorrencias/{tipoFicha}"})
    @Operation(summary="Retorna uma listagem das ocorr\u00eancias, para todas as empresas")
    @ResponseBody
    public ResponseEntity<List<OcorrenciaFichaVO>> findOcorrencias(@PathVariable String tipoFicha, HttpServletRequest request) {
        try {
            logger.debug("findOcorrencias({}), dashboard Ambiental...", (Object)tipoFicha);
            List ocorrencias = this.fichaAmbientalService.findOcorrenciasByFicha(tipoFicha);
            return new ResponseEntity((Object)ocorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/boasPraticas"})
    @Operation(summary="Retorna uma listagem das ocorr\u00eancias, para todas as empresas")
    @ResponseBody
    public ResponseEntity<List<BoaPratica>> findBoasPraticas(@RequestBody FiltroBoaPratica filtroFicha, HttpServletRequest request) {
        try {
            Page lista = this.boaPraticaService.findBoasPraticas(filtroFicha, 1, 5000, "titulo", Boolean.valueOf(false), Boolean.valueOf(false));
            return new ResponseEntity((Object)lista.getContent(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/inspecoes/fichas"})
    @Operation(summary="Retorna uma listagem das fichas de inspe\u00e7\u00e3o, agrupadas por data de inspe\u00e7\u00e3o e situa\u00e7\u00e3o")
    @ResponseBody
    public ResponseEntity<List<InspecaoFichaVO>> findFichasInspecao(@RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request) {
        try {
            List fichas = this.inspecaoAmbientalService.findSumFichasByPeriodo(filtroFicha);
            return new ResponseEntity((Object)fichas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFichasInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/pontosControle"})
    @Operation(summary="Retorna uma listagem das fichas de Pontos de Controle")
    @ResponseBody
    public ResponseEntity<Page<PontoControle>> findPontosControle(@RequestBody FiltroPontoControle filtroFicha, HttpServletRequest request) {
        try {
            int pageNbr = 1;
            int pageSize = 150;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            List empresas = this.coreService.findEmpresas(null, null);
            HashMap<Integer, Empresa> empresasMap = new HashMap<Integer, Empresa>();
            for (Object emp : empresas) {
                if (empresasMap.containsKey(emp.getId())) continue;
                Empresa newEmp = new Empresa();
                newEmp.setId(emp.getId());
                newEmp.setRazaoSocial(emp.getRazaoSocial());
                newEmp.setNomeFantasia(emp.getNomeFantasia());
                newEmp.setSigla(emp.getSigla());
                empresasMap.put(emp.getId(), newEmp);
            }
            Page listaPtc = this.pontoControleService.findPontosControle(filtroFicha, pageNbr, pageSize, "descricao", Boolean.valueOf(false));
            for (PontoControle ponto : listaPtc.getContent()) {
                if (ponto.getRodovia() != null) {
                    ponto.getRodovia().setEmpresa(null);
                }
                if (ponto.getEmpresa() != null) continue;
                ponto.setEmpresa((Empresa)empresasMap.get(ponto.getIdEmpresa()));
            }
            List pontos = listaPtc.getContent();
            return new ResponseEntity((Object)listaPtc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPontosControle", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

