/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.sso.controllers;

import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.TipoEmpresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSsoLogin;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.utils.MD5Utils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/sso"})
public class SSOController {
    private static final Logger LOG = LoggerFactory.getLogger(SSOController.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/register"})
    public String register(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException, ServletException {
        Usuario user = null;
        String userId = request.getParameter("principalName");
        if (userId == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi informado.");
        }
        String displayName = request.getParameter("displayName");
        try {
            user = this.segurancaService.getUsuarioByLoginOrMail(userId);
        }
        catch (BusinessException bizExc) {
            user = null;
        }
        String[] groups = request.getParameterValues("groups");
        if (groups == null || groups.length == 0) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Grupos do usu\u00e1rio n\u00e3o foram informados.");
        }
        LOG.debug("Groups.size = {}...", (Object)groups.length);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String group : groups) {
            LOG.debug("Add group '{}' to authority...", (Object)group);
            authorities.add(new SimpleGrantedAuthority(group));
        }
        Date sysDate = new Date(System.currentTimeMillis());
        String userName = null;
        if (user == null) {
            Usuario userDB;
            LOG.debug("Usu\u00e1rio '{}' n\u00e3o encontrado, criando...", (Object)userId);
            userName = userId.toLowerCase();
            int idxMail = userId.indexOf("@");
            if (idxMail != -1) {
                userName = userId.substring(0, idxMail);
            }
            List empresas = this.cadastroService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            Empresa empresa = (Empresa)empresas.get(0);
            Integer idUserAdmin = empresa.getIdUsuarioIns();
            if (displayName == null || displayName.isEmpty()) {
                displayName = userId;
            }
            if ((userDB = this.segurancaService.createUsuario(userName, displayName, userId, empresa.getId(), idUserAdmin)) != null) {
                userDB.setEmail(userId);
                userDB.setTipo(TipoUsuario.ACESSO_SSO.getCode());
                UsuarioPerfil perfil = new UsuarioPerfil();
                perfil.setIdUsuario(userDB.getId());
                perfil.setSenha(MD5Utils.transformToMD5((String)LocalDateTime.now().toString()));
                perfil.setAdministrador(Integer.valueOf(0));
                perfil.setBloqueado(Integer.valueOf(0));
                ArrayList<UsuarioGrupo> gruposId = new ArrayList<UsuarioGrupo>();
                Integer defGrpId = null;
                List grupos = this.segurancaService.findGruposAcessoUsuarios(null, null);
                for (String authority : groups) {
                    LOG.debug("group =>{} ", (Object)authority);
                    defGrpId = null;
                    for (GrupoAcessoUsuario grupo : grupos) {
                        if (!authority.trim().equalsIgnoreCase(grupo.getDescricao().trim())) continue;
                        defGrpId = grupo.getId();
                        break;
                    }
                    if (defGrpId == null) continue;
                    LOG.debug("defGroupId.1 ({})", (Object)defGrpId);
                    UsuarioGrupo grupo = new UsuarioGrupo();
                    grupo.getId().setIdUsuario(userDB.getId());
                    grupo.getId().setIdGrupoUsuario(defGrpId);
                    grupo.setDatHorCadastro(sysDate);
                    grupo.setIdUsuarioIns(userDB.getId());
                    gruposId.add(grupo);
                }
                if (defGrpId == null && gruposId.isEmpty()) {
                    LOG.debug("defGroupId.2 == NULL");
                    defGrpId = (Integer)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_SSO_GRUPO_ACESSO);
                    if (defGrpId == null) {
                        defGrpId = ((GrupoAcessoUsuario)grupos.get(0)).getId();
                    }
                    UsuarioGrupo grupo = new UsuarioGrupo();
                    grupo.getId().setIdUsuario(userDB.getId());
                    grupo.getId().setIdGrupoUsuario(defGrpId);
                    grupo.setDatHorCadastro(sysDate);
                    grupo.setIdUsuarioIns(userDB.getId());
                    gruposId.add(grupo);
                }
                ArrayList<UsuarioEmpresa> empresasUsr = new ArrayList<UsuarioEmpresa>();
                UsuarioEmpresa empresaUsr = new UsuarioEmpresa();
                empresaUsr.getId().setIdUsuario(userDB.getId());
                empresaUsr.getId().setIdEmpresa(empresa.getId());
                empresaUsr.setDatHorCadastro(new Date(System.currentTimeMillis()));
                empresaUsr.setIdUsuarioIns(idUserAdmin);
                empresaUsr.setEmpresa(empresa);
                empresasUsr.add(empresaUsr);
                this.segurancaService.saveUsuario(userDB, perfil, gruposId, empresasUsr, idUserAdmin, "0.0.0.0");
                this.segurancaService.saveUsuarioEmpresa(empresaUsr);
            }
        } else {
            userName = user.getLogin();
            LOG.debug("Usu\u00e1rio '({},{})' j\u00e1 encontrado, atualizando grupos...", (Object)user.getLogin(), (Object)displayName);
            if (displayName != null && !displayName.isEmpty() && !displayName.equals(user.getNome())) {
                this.segurancaService.saveNomeUsuario(user.getId(), displayName);
            }
            List baseGrupos = this.segurancaService.findGruposAcessoUsuarios(null, null);
            List userGrupos = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
            ArrayList<UsuarioGrupo> userGroupsNew = new ArrayList<UsuarioGrupo>();
            block5: for (String authority : groups) {
                boolean flagGrp = false;
                for (UsuarioGrupo userGrupo : userGrupos) {
                    if (!userGrupo.getGrupoAcesso().getDescricao().equalsIgnoreCase(authority)) continue;
                    flagGrp = true;
                    LOG.debug("Grupo acesso '{}' existente, atualizando...", (Object)authority);
                    userGroupsNew.add(userGrupo);
                    break;
                }
                if (flagGrp) continue;
                LOG.debug("Grupo acesso '{}' novo/atribui\u00eddo...", (Object)authority);
                for (GrupoAcessoUsuario grupo : baseGrupos) {
                    if (!authority.trim().equalsIgnoreCase(grupo.getDescricao().trim())) continue;
                    LOG.debug("Grupo '{}' encontrado '{}'", (Object)authority, (Object)grupo.getId());
                    UsuarioGrupo grupoDB = new UsuarioGrupo();
                    grupoDB.getId().setIdUsuario(user.getId());
                    grupoDB.getId().setIdGrupoUsuario(grupo.getId());
                    grupoDB.setDatHorCadastro(sysDate);
                    grupoDB.setIdUsuarioIns(user.getId());
                    userGroupsNew.add(grupoDB);
                    continue block5;
                }
            }
            if (userGroupsNew != null && !userGroupsNew.isEmpty()) {
                this.segurancaService.saveUsuariosGrupos(userGroupsNew, user.getId());
            }
        }
        AuthLogin authLogin = new AuthLogin();
        authLogin.setUserName(userId);
        authLogin.setGroups(List.of(groups));
        UsuarioSsoLogin usuarioSso = this.segurancaService.saveLastSsoLogin(authLogin);
        HttpSession session = request.getSession();
        session.setAttribute("tokenSso", (Object)usuarioSso.getId());
        response.sendRedirect("/index.html");
        return null;
    }
}

