/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class SamlExtensionUrlForwardingFilter
extends OncePerRequestFilter {
    private static final Map<String, String> urlMapping = Map.of("/saml/SSO", "/login/saml2/sso/one", "/saml/login", "/saml2/authenticate/one", "/saml/logout", "/logout/saml2/slo", "/saml/SingleLogout", "/logout/saml2/slo", "/saml/metadata", "/saml2/service-provider-metadata/one");
    private final RequestMatcher matcher = this.createRequestMatcher();

    private RequestMatcher createRequestMatcher() {
        Set urls = urlMapping.keySet();
        LinkedList matchers = new LinkedList();
        urls.forEach(url -> matchers.add(new AntPathRequestMatcher(url)));
        return new OrRequestMatcher(matchers);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean match = this.matcher.matches(request);
        if (!match) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String forwardUrl = (String)urlMapping.get(request.getRequestURI());
        RequestDispatcher dispatcher = request.getRequestDispatcher(forwardUrl);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

