/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.TipoObra;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para tipos de obras", name="tiposObras")
@RequestMapping(value={"/api/tiposObras"})
public class TiposObraRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(TiposObraRestServices.class);
    @Autowired
    private CadastroService cadastroService;

    @GetMapping
    @Operation(summary="Retorna uma listagem com os tipos de obras, conforme filtro")
    @ResponseBody
    public ResponseEntity<List<TipoObra>> findTiposObras(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Iniciando findTiposObras({})...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroService.findTiposObras(searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposObras", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idTipoObra}"})
    @Operation(summary="Retorna os dados do Tipo de Obra solicitada")
    @ResponseBody
    public ResponseEntity<TipoObra> getTipoObraById(@PathVariable(name="idTipoObra") Integer idTipoObra, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.cadastroService.getTipoObraById(idTipoObra), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoObraById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Atualiza os dados do Tipo de Obra")
    @ResponseBody
    public ResponseEntity<TipoObra> saveTipoObra(@RequestBody TipoObra tipoObra, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveTipoObra ({}))", (Object)tipoObra);
            return new ResponseEntity((Object)this.cadastroService.saveTipoObra(tipoObra, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoObra", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idTipoObra}"})
    @Operation(summary="Exclui o tipo de obra, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteTipoObra(@PathVariable(name="idTipoObra") Integer idTipoObra, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoObra({})", (Object)idTipoObra);
        try {
            return new ResponseEntity((Object)this.cadastroService.deleteTipoObra(idTipoObra), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoObra", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

