/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.lab;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.LaboratorioService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.lab.beans.controle.ControleEstatistico;
import br.com.oti.gesconsys.lab.beans.controle.ControleEstatisticoDetalhamentoVO;
import br.com.oti.gesconsys.lab.beans.controle.ControleEstatisticoItem;
import br.com.oti.gesconsys.lab.beans.controle.FatorPagamento;
import br.com.oti.gesconsys.lab.beans.controle.FatorPagamentoItem;
import br.com.oti.gesconsys.lab.beans.controle.FatorPagamentoItemVO;
import br.com.oti.gesconsys.lab.beans.controle.PlanoAuditoriaLcto;
import br.com.oti.gesconsys.reports.lab.RelatorioControleEstatisticoExcel;
import br.com.oti.gesconsys.reports.lab.RelatorioFatorPagamentoExcel;
import br.com.oti.gesconsys.reports.lab.RelatorioFatorPagamentoPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para cadastros do m\u00f3dulo laborat\u00f3rio", name="laboratorio")
@RequestMapping(value={"/api/controles/lab"})
public class ControlesLaboratorioRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ControlesLaboratorioRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private LaboratorioService laboratorioService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private RelatorioFatorPagamentoPdf relatorioFatorPagamentoPdf;
    @Autowired
    private RelatorioFatorPagamentoExcel relatorioFatorPagamentoExcel;
    @Autowired
    private RelatorioControleEstatisticoExcel relatorioControleEstatisticoExcel;

    @GetMapping(value={"/{empresa}/planosAuditoria"})
    @Operation(summary="Lista os lan\u00e7amentos dos Planos de Auditoria de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<PlanoAuditoriaLcto>> findPlanosAuditoria(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate datInicial, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate datFinal, @RequestParam(required=false) String tipoEnsaio, @RequestParam(required=false) Integer idFornecedor, @RequestParam(required=false) String contrato, @RequestParam(required=false) Integer idGrupoServicoPai, @RequestParam(required=false) Integer idGrupoServico) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("API findPlanosAuditoria (empresa={})...", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONSULTAR_LANCAMENTOS_PLANOS_AUDITORIAS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_CONSULTAR_LANCAMENTOS_PLANOS_AUDITORIAS");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi informada.");
            }
            ArrayList<String> empresas = new ArrayList<String>();
            empresas.add(empresa);
            List planos = this.laboratorioService.findLancamentosPlanosAuditoria(empresas, datInicial, datFinal, tipoEnsaio, idFornecedor, contrato, idGrupoServicoPai, idGrupoServico);
            return new ResponseEntity((Object)planos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanosAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPlanosAuditoria", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/planosAuditoria/{idLancamento}"})
    @Operation(summary="Lista o plano de auditoria de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<PlanoAuditoriaLcto> getPlanoAuditoriaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLancamento") Integer idLancamento) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("API getPlanoAuditoriaById (empresa={}, idLancamento={})...", (Object)empresa, (Object)idLancamento);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_VISUALIZAR_LANCAMENTO_PLANO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_VISUALIZAR_LANCAMENTO_PLANO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PlanoAuditoriaLcto plano = this.laboratorioService.getLancamentoPlanoAuditoriaById(empresa, idLancamento);
            return new ResponseEntity((Object)plano, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAuditoriaById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPlanoAuditoriaById", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/planosAuditoria"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro dos planos de auditoria e seus itens")
    public ResponseEntity<PlanoAuditoriaLcto> registraLancamentoPlanoAuditoria(@PathVariable(name="empresa") String empresa, @RequestBody PlanoAuditoriaLcto lancamento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("registraLancamentoPlanoAuditoria = {})", (Object)lancamento);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_LANCAMENTO_PLANO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_LANCAMENTO_PLANO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PlanoAuditoriaLcto planoDB = this.laboratorioService.registraLancamentoPlanoAuditoria(empresa, lancamento, usuario.getLogin());
            return new ResponseEntity((Object)planoDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePlanoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/planosAuditoria/{idLancamento}"})
    @Operation(summary="Exclui o plano de auditoria atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deletePlanoAuditoria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLancamento") Integer idLancamento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePlanoAuditoria({}, {})", (Object)empresa, (Object)idLancamento);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_EXCLUIR_LANCAMENTO_PLANO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_EXCLUIR_LANCAMENTO_PLANO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteLancamentoPlanoAuditoria(empresa, idLancamento), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/controlesEstatisticos"})
    @Operation(summary="Consulta os controles estatisticos de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ControleEstatistico>> findControlesEstatisticos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findControlesEstatisticos({})", (Object)usuario, (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONSULTAR_CONTROLES_ESTATISTICOS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_CONSULTAR_CONTROLES_ESTATISTICOS");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            Map params = request.getParameterMap();
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findControlesEstatisticos", (Throwable)dtpExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String empreiteira = request.getParameter("empreiteira");
            String contrato = request.getParameter("contrato");
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            List controles = this.laboratorioService.findControlesEstatisticos(empresas, empreiteira, contrato, projeto, dataInicial, dataFinal);
            return new ResponseEntity((Object)controles, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findControlesEstatisticos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findControlesEstatisticos", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/controlesEstatisticos/{idControleEstatistico}"})
    @Operation(summary="Exibe o fator de pagamento conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<ControleEstatistico> getControleEstatistico(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idControleEstatistico") Integer idControleEstatistico) {
        logger.debug("Executando getFatorPagamento");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getControleEstatistico ({}))", (Object)usuario, (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_VISUALIZAR_CONTROLE_ESTATISTICO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_VISUALIZAR_CONTROLE_ESTATISTICO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ControleEstatistico controle = this.laboratorioService.getControleEstatisticoById(idControleEstatistico);
            return new ResponseEntity((Object)controle, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getControleEstatistico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getControleEstatistico", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/controlesEstatisticos"})
    @Operation(summary="Gera o fator de pagamento.")
    public ResponseEntity<ControleEstatistico> saveControleEstatistico(@PathVariable(name="empresa") String empresa, @RequestBody ControleEstatistico controle, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveControleEstatistico ({}))", (Object)usuario, (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_CONTROLE_ESTATISTICO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_CONTROLE_ESTATISTICO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.gerarControleEstatistico(empresa, controle, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveControleEstatistico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/controlesEstatisticos/{idControleEstatistico}"})
    @Operation(summary="Exclui o fator de pagamento atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteControleEstatistico(@PathVariable(name="empresa") String empresa, @PathVariable(name="idControleEstatistico") Integer idControleEstatistico, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteControleEstatistico({})", (Object)usuario, (Object)idControleEstatistico);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_EXCLUIR_CONTROLE_ESTATISTICO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_EXCLUIR_CONTROLE_ESTATISTICO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteControleEstatistico(idControleEstatistico), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteControleEstatistico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/controlesEstatistico/{idControle}/exportExcel"})
    @Operation(summary="Exporta o controle estat\u00edstico em formato Excel")
    public ResponseEntity<StreamingResponseBody> exportControleEstatiscoExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idControle") Integer idControle) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("{} - exportControleEstatiscoExcel(emp={}, idControle={})...", new Object[]{usuario.getLogin(), empresa, idControle});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_VISUALIZAR_CONTROLE_ESTATISTICO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_VISUALIZAR_CONTROLE_ESTATISTICO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StreamingResponseBody responseBody = response -> response.write(this.relatorioControleEstatisticoExcel.executeXLS(emp, idControle));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"controle-" + idControle + ".xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fatoresPagamento"})
    @Operation(summary="Consulta os fatores de pagamento de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<FatorPagamento>> findFatoresPagamento(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("Executando findFatoresPagamento({}, {})", (Object)usuario, (Object)empresa);
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            Map params = request.getParameterMap();
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findFatoresPagamento", (Throwable)dtpExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String empreiteira = request.getParameter("empreiteira");
            String contrato = request.getParameter("contrato");
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            List fatoresPagamento = this.laboratorioService.findFatoresPagamento(empresas, empreiteira, contrato, projeto, dataInicial, dataFinal);
            return new ResponseEntity((Object)fatoresPagamento, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFatoresPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findFatoresPagamento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fatoresPagamento/{idFatorPagamento}"})
    @Operation(summary="Exibe o fator de pagamento conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<FatorPagamento> getFatorPagamento(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFatorPagamento") Integer idFatorPagamento) {
        logger.debug("Executando getFatorPagamento");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getFatorPagamento ({},{}))", (Object)usuario, (Object)empresa);
            FatorPagamento fatorPagamento = this.laboratorioService.getFatorPagamentoById(idFatorPagamento);
            return new ResponseEntity((Object)fatorPagamento, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFatorPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getFatorPagamento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fatoresPagamento/{idFatorPagamento}/itens"})
    @Operation(summary="Exibe o fator de pagamento conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<List<FatorPagamentoItemVO>> findItensFatorPagamento(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFatorPagamento") Integer idFatorPagamento) {
        logger.debug("Executando findItensFatorPagamento");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getFatorPagamento ({},{}))", (Object)usuario, (Object)empresa);
            List itens = this.laboratorioService.findItensFatorPagamento(idFatorPagamento);
            return new ResponseEntity((Object)itens, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findItensFatorPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findItensFatorPagamento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fatoresPagamento"})
    @Operation(summary="Gera o fator de pagamento.")
    public ResponseEntity<FatorPagamento> saveFatorPagamento(@PathVariable(name="empresa") String empresa, @RequestBody FatorPagamento fatorPagamento, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("saveFatorPagamento ({},{}))", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)this.laboratorioService.gerarFatorPagamento(empresa, fatorPagamento, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFatorPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fatoresPagamento/{idFatorPagamento}/itens"})
    @Operation(summary="Atualiza o lan\u00e7amento manual dos fatores de pagamento, do tipo Dados de Empreiteira.")
    public ResponseEntity<List<FatorPagamentoItem>> saveFatorPagamentoItemLcto(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFatorPagamento") Integer idFatorPagamento, @RequestBody List<FatorPagamentoItemVO> itens, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("saveFatorPagamentoItem ({}, {}, {}))", new Object[]{usuario, empresa, idFatorPagamento});
            List itensDB = this.laboratorioService.saveFatorPagamentoItem(empresa, idFatorPagamento, itens, usuario.getLogin());
            return new ResponseEntity((Object)itensDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFatorPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/fatoresPagamento/{idFatorPagamento}"})
    @Operation(summary="Exclui o fator de pagamento atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteFatorPagamento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFatorPagamento") Integer idFatorPagamento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteFatorPagamento({}, {})", (Object)usuario, (Object)idFatorPagamento);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteFatorPagamento(idFatorPagamento), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFatorPagamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/fatoresPagamento/{idFatorPagamento}/itens/{nroLancamento}"})
    @Operation(summary="Exclui os itens do fator de pagamento atrav\u00e9s de seu ID e N\u00famero de Lan\u00e7amento Manual")
    public ResponseEntity<Boolean> deleteFatorPagamentoItemManual(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFatorPagamento") Integer idFatorPagamento, @PathVariable(name="nroLancamento") Integer nroLancamento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteFatorPagamentoItemManual({}, {})", (Object)usuario, (Object)idFatorPagamento);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteFatorPagamentoItemManual(idFatorPagamento, "M", nroLancamento, usuario.getLogin()), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFatorPagamentoItemManual", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/fatoresPagamento/{idFator}/exportPdf"})
    @Operation(summary="Exporta o fator de pagamento em formato PDF")
    public ResponseEntity<byte[]> exportFatorPagamentoPdf(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFator") Integer idFator) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("{} - exportFatorPagamentoPdf(emp={}, idFator={})...", new Object[]{usuario.getLogin(), empresa, idFator});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            byte[] bytes = this.relatorioFatorPagamentoPdf.executePDF(emp, idFator, usuario.getNome());
            if (bytes == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"fator_pagto.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizoExc) {
            logger.error("bizExc", (Throwable)bizoExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizoExc.getMessage());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException nseExc) {
            logger.error("nseExc", (Throwable)nseExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, nseExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/fatoresPagamento/{idFator}/exportExcel"})
    @Operation(summary="Exporta o fator de pagamento em formato Excel")
    public ResponseEntity<StreamingResponseBody> exportFatorPagamentoExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFator") Integer idFator) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("{} - exportFatorPagamentoExcel(emp={}, idFator={})...", new Object[]{usuario.getLogin(), empresa, idFator});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FATOR_PAGTO_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FATOR_PAGTO_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StreamingResponseBody responseBody = response -> response.write(this.relatorioFatorPagamentoExcel.executeXls(emp, idFator));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"fator-" + idFator + ".xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/controlesEstatisticos/{idControle}/kilometros"})
    @Operation(summary="Detalha o controle estat\u00edstico, exibindo por KM a estrutura")
    @ResponseBody
    public ResponseEntity<Map<String, Map<String, ArrayList<ControleEstatisticoDetalhamentoVO>>>> findControlesEstatisticosDetalhamento(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idControle") Integer idControle) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findControlesEstatisticosDetalhamento({})", (Object)usuario, (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONSULTAR_CONTROLES_ESTATISTICOS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"LAB_CONSULTAR_CONTROLES_ESTATISTICOS");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            Map params = request.getParameterMap();
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findControlesEstatisticos", (Throwable)dtpExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String empreiteira = request.getParameter("empreiteira");
            String contrato = request.getParameter("contrato");
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            LinkedHashMap controles = new LinkedHashMap();
            ArrayList<ControleEstatisticoDetalhamentoVO> items = new ArrayList<ControleEstatisticoDetalhamentoVO>();
            ArrayList<String> ignoreProps = new ArrayList<String>();
            ignoreProps.add("id");
            ignoreProps.add("idEnsaio");
            ignoreProps.add("nroEnsaio");
            ignoreProps.add("grupo");
            ignoreProps.add("datReferencia");
            ignoreProps.add("datEnsaio");
            ignoreProps.add("camada");
            ignoreProps.add("espessura");
            ignoreProps.add("energiaCompactacao");
            ignoreProps.add("pista");
            ignoreProps.add("estaca");
            ignoreProps.add("estacaColeta");
            ignoreProps.add("material");
            ignoreProps.add("procedencia");
            ignoreProps.add("ensaio");
            ignoreProps.add("tipoLigante");
            ControleEstatistico controle = this.laboratorioService.getControleEstatisticoById(idControle);
            String titulo = "";
            if (controle.getItens() != null) {
                for (ControleEstatisticoItem item : controle.getItens()) {
                    String grupoItem = item.getGrupo();
                    if (!grupoItem.equals("ITENS") && !grupoItem.equals("VALOR_MAXIMO_CARACTERISTICO") && !grupoItem.equals("VALOR_MINIMO_CARACTERISTICO") && !grupoItem.equals("VALOR_MINIMO_ESPECIFICADO") && !grupoItem.equals("VALOR_MAXIMO_ESPECIFICADO")) continue;
                    Map beanMap = PropertyUtils.describe((Object)item);
                    for (String keyName : beanMap.keySet()) {
                        String propName;
                        Object propVal;
                        if (ignoreProps.contains(keyName) || keyName.toLowerCase().startsWith("abertura")) continue;
                        titulo = keyName;
                        if (keyName.toLowerCase().startsWith("granulometria") && (propVal = PropertyUtils.getProperty((Object)item, (String)(propName = keyName.replace("granulometria", "abertura")))) != null) {
                            titulo = propVal.toString();
                        }
                        if (item.getGrupo().equals("ITENS") && item.getEstaca() == null) {
                            logger.debug("Item sem Estaca: {}", (Object)keyName);
                            continue;
                        }
                        Object propVal2 = PropertyUtils.getProperty((Object)item, (String)keyName);
                        if (propVal2 == null) continue;
                        logger.debug("Iterando prop: {}", (Object)keyName);
                        HashMap controleItem = (HashMap)controles.get(keyName);
                        if (controleItem == null) {
                            controleItem = new HashMap();
                            items = new ArrayList<ControleEstatisticoDetalhamentoVO>();
                            controleItem.put("ensaios", items);
                            controles.put(keyName, controleItem);
                        } else {
                            items = (ArrayList<ControleEstatisticoDetalhamentoVO>)controleItem.get("ensaios");
                        }
                        Double kmVal = this.getKilometro(item.getEstaca());
                        if (!(propVal2 instanceof BigDecimal)) continue;
                        BigDecimal valDec = (BigDecimal)propVal2;
                        String grupoTxt = "????";
                        if (item.getGrupo().equals("ITENS")) {
                            grupoTxt = "ENSAIOS";
                        } else if (item.getGrupo().equals("VALOR_MINIMO_CARACTERISTICO")) {
                            grupoTxt = "LIE";
                        } else if (item.getGrupo().equals("VALOR_MAXIMO_CARACTERISTICO")) {
                            grupoTxt = "LSE";
                        } else if (item.getGrupo().equals("VALOR_MINIMO_ESPECIFICADO")) {
                            grupoTxt = "FXTINI";
                        } else if (item.getGrupo().equals("VALOR_MAXIMO_ESPECIFICADO")) {
                            grupoTxt = "FXTFIM";
                        }
                        items.add(new ControleEstatisticoDetalhamentoVO(item.getId().getIdControle(), item.getIdEnsaio(), grupoTxt, titulo, item.getEstaca(), kmVal, Double.valueOf(valDec.doubleValue())));
                    }
                }
            }
            LinkedHashMap<String, Map> destMap = new LinkedHashMap<String, Map>();
            for (String keyMap : controles.keySet()) {
                ArrayList itens = (ArrayList)((Map)controles.get(keyMap)).get("ensaios");
                boolean flagCtr = false;
                for (ControleEstatisticoDetalhamentoVO item : itens) {
                    if (!item.getGrupo().equals("ENSAIOS")) continue;
                    flagCtr = true;
                }
                if (!flagCtr) continue;
                destMap.put(keyMap, (Map)controles.get(keyMap));
            }
            Comparator kmsCompare = (a1, a2) -> {
                if (a1.getKm() == null || a2.getKm() == null) {
                    return -1;
                }
                return a1.getKm().compareTo(a2.getKm());
            };
            for (String keyMap : destMap.keySet()) {
                ArrayList itens = (ArrayList)((Map)destMap.get(keyMap)).get("ensaios");
                if (itens == null || itens.isEmpty()) continue;
                Collections.sort(itens, kmsCompare);
            }
            return new ResponseEntity(controles, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findControlesEstatisticosDetalhamento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findControlesEstatisticosDetalhamento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    private Double getKilometro(String estaca) {
        if (estaca == null || estaca.isEmpty()) {
            return null;
        }
        String[] kms = estaca.split("\\+");
        if (kms.length > 1) {
            return Double.valueOf(kms[0].trim() + "." + kms[1].trim());
        }
        return Double.valueOf(kms[0].trim());
    }
}

