/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.lab;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.LaboratorioService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.lab.beans.ClassificacaoPeneira;
import br.com.oti.gesconsys.lab.beans.ClassificacaoPeneiraItem;
import br.com.oti.gesconsys.lab.beans.GrupoServicoAuditoria;
import br.com.oti.gesconsys.lab.beans.Ligante;
import br.com.oti.gesconsys.lab.beans.ProjetoEnsaio;
import br.com.oti.gesconsys.lab.beans.ProjetoEnsaioAnexo;
import br.com.oti.gesconsys.lab.beans.ProjetoEnsaioItem;
import br.com.oti.gesconsys.lab.beans.controle.PlanoAuditoriaItem;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para cadastros do m\u00f3dulo laborat\u00f3rio", name="laboratorio")
@RequestMapping(value={"/api/cadastros/lab"})
public class CadastrosLaboratorioRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosLaboratorioRestServices.class);
    @Autowired
    private LaboratorioService laboratorioService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/peneiras"})
    @Operation(summary="Lista as peneiras de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ClassificacaoPeneira>> findPeneiras(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={})...", (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List peneiras = this.laboratorioService.findClassificacaoPeneiras(null, null);
            return new ResponseEntity((Object)peneiras, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPeneiras", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPeneiras", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/peneiras/{idPeneira}"})
    @Operation(summary="Lista a peneira de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<ClassificacaoPeneira> getPeneiraById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPeneira") Integer idPeneira) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={})...", (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ClassificacaoPeneira peneira = this.laboratorioService.getClassificacaoPeneiraById(idPeneira);
            return new ResponseEntity((Object)peneira, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPeneiraById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPeneiraById", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/peneiras"}, consumes={"multipart/form-data"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro das peneiras e seus itens")
    public ResponseEntity<ClassificacaoPeneira> savePeneira(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String itensTxt;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            ClassificacaoPeneira peneira = (ClassificacaoPeneira)mapper.readValue(((String[])formData.get("peneira"))[0], ClassificacaoPeneira.class);
            List itens = null;
            if (formData.containsKey("itens") && (itensTxt = ((String[])formData.get("itens"))[0]).length() > 0) {
                itens = (List)mapper.readValue(itensTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            logger.debug("savePeneira ({}, items={})", (Object)peneira, itens);
            ClassificacaoPeneira peneiraDB = this.laboratorioService.saveClassificacaoPeneira(peneira, itens, usuario.getLogin());
            return new ResponseEntity((Object)peneiraDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarPeneira", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarPeneira", (Throwable)jsmExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarPeneira", (Throwable)jspExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/peneiras/{idPeneira}"})
    @Operation(summary="Exclui a peneira atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deletePeneira(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPeneira") Integer idPeneira, HttpServletRequest request) throws BusinessException {
        logger.debug("deletePeneira({})", (Object)idPeneira);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deletePeneira(idPeneira), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePeneira", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/peneiras/{idClassificacao}/itens"})
    @Operation(summary="Lista os itens presentes na classifica\u00e7\u00e3o de peneiras")
    public ResponseEntity<List<ClassificacaoPeneiraItem>> findPeneirasItens(@PathVariable(name="empresa") String empresa, @PathVariable(name="idClassificacao") Integer idClassificacao, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.laboratorioService.findPeneirasItem(idClassificacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPeneirasItens", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/peneiras/{idClassificacao}/itens"})
    @Operation(summary="Salva o item de peneira, criando ou atualizando de acordo com o payload informado")
    @ResponseBody
    public ResponseEntity<ClassificacaoPeneiraItem> updatePeneiraItem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idClassificacao") Integer idClassificacao, @RequestBody ClassificacaoPeneiraItem item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_ALTERAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_ALTERAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("updatePeneiraItem({},{})", (Object)idClassificacao, (Object)item);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ClassificacaoPeneiraItem response = this.laboratorioService.saveClassificacao(item, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updatePeneiraItem", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/peneiras/{idClassificacao}/itens/{sequencia}"})
    @Operation(summary="Exclui o item de peneira a partir de seu identificador")
    public ResponseEntity<Boolean> deletePeneiraItem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idClassificacao") Integer idClassificacao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePeneiraItem({}, {}, {})", new Object[]{empresa, idClassificacao, sequencia});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PENEIRAS_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PENEIRAS_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deletePeneiraItem(sequencia, idClassificacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePeneiraItem", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ligantes"})
    @Operation(summary="Consulta os ligantes")
    public ResponseEntity<List<Ligante>> findLigantes(HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONSULTAR_LIGANTES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CONSULTAR_LIGANTES");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("Iniciando findLigantes...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.laboratorioService.findLigantes(searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLigantes", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ligantes/{idLigante}"})
    @Operation(summary="Carrega o ligante pelo seu identificador")
    public ResponseEntity<Ligante> getLiganteById(@PathVariable(name="idLigante") Integer idLigante, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_VISUALIZAR_LIGANTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_VISUALIZAR_LIGANTE");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getLiganteById({})", (Object)idLigante);
            return new ResponseEntity((Object)this.laboratorioService.getLiganteById(idLigante), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getLiganteById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/ligantes"})
    @Operation(summary="Salva o ligante a partir de seu payload")
    public ResponseEntity<Ligante> saveLigante(@RequestBody Ligante cidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_LIGANTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_LIGANTE");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("saveLigante({})", (Object)cidade);
            return new ResponseEntity((Object)this.laboratorioService.saveLigante(cidade, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveLigante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/ligantes/{idLigante}"})
    @Operation(summary="Exclui o ligante a partir de seu identificador")
    public ResponseEntity<Boolean> deleteLigante(@PathVariable(name="idLigante") Integer idLigante, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_EXCLUIR_LIGANTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_EXCLUIR_LIGANTE");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("deleteLigante({})", (Object)idLigante);
            return new ResponseEntity((Object)this.laboratorioService.deleteLigante(idLigante), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLigante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos"})
    @Operation(summary="Lista os projetos de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ProjetoEnsaio>> findProjetos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - API findProjetos (empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi informada.");
            }
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            List projetos = this.laboratorioService.findProjetos(empresa, searchTxt);
            return new ResponseEntity((Object)projetos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findProjetos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findProjetos", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos/{idProjeto}"})
    @Operation(summary="Lista o projeto de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<ProjetoEnsaio> getProjetoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getProjetoById (empresa={}, idProj={})...", (Object)empresa, (Object)idProjeto);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ProjetoEnsaio projeto = this.laboratorioService.getProjetoById(empresa, idProjeto);
            return new ResponseEntity((Object)projeto, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getProjetoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getProjetoById", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/projetos"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro dos projetos e seus itens")
    public ResponseEntity<ProjetoEnsaio> saveProjeto(@PathVariable(name="empresa") String empresa, @RequestBody ProjetoEnsaio projeto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("saveProjeto = {})", (Object)projeto);
            ProjetoEnsaio projetoDB = this.laboratorioService.saveProjeto(empresa, projeto, usuario.getLogin());
            return new ResponseEntity((Object)projetoDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveProjeto", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/projetos/{idProjeto}"})
    @Operation(summary="Exclui o projeto atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteProjeto(@PathVariable String empresa, @PathVariable Integer idProjeto, HttpServletRequest request) throws BusinessException {
        logger.debug("deleteProjeto({}, {})", (Object)empresa, (Object)idProjeto);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String ipExterno = this.getIpExterno(request);
            return new ResponseEntity((Object)this.laboratorioService.deleteProjeto(empresa, idProjeto, usuario.getLogin(), ipExterno), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteProjeto", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos/{idProjeto}/itens"})
    @Operation(summary="Lista os itens presentes no projeto.")
    public ResponseEntity<List<ProjetoEnsaioItem>> findProjetosItens(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.laboratorioService.findGranulometriaProjeto(idProjeto), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findProjetosItens", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/projetos/{idProjeto}/itens"})
    @Operation(summary="Salva o item de projeto, criando ou atualizando de acordo com o payload informado")
    @ResponseBody
    public ResponseEntity<ProjetoEnsaioItem> updateProjetoItem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, @RequestBody ProjetoEnsaioItem item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_ALTERAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_ALTERAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("updateProjetoItem({},{})", (Object)idProjeto, (Object)item);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (item.getIdEmpresa() == null) {
                item.setIdEmpresa(emp.getId());
            }
            ProjetoEnsaioItem response = this.laboratorioService.saveProjetosItens(item, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateProjetoItem", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos/{idProjeto}/anexos"})
    @Operation(summary="Lista os anexos a partir do identificador do projeto")
    public ResponseEntity<List<ProjetoEnsaioAnexo>> findAnexosProjeto(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findAnexos({})", (Object)empresa);
            return ResponseEntity.ok().body((Object)this.laboratorioService.findAnexosProjeto(empresa, idProjeto));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos/{idProjeto}/anexos/{sequencia}"})
    @Operation(summary="Lista o anexo a partir de seu id")
    public ResponseEntity<ProjetoEnsaioAnexo> getAnexoProjetoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getAnexoById({}, {})", (Object)empresa, (Object)idProjeto);
            return ResponseEntity.ok().body((Object)this.laboratorioService.getAnexoProjetoById(empresa, idProjeto, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/projetos/{idProjeto}/anexos"})
    @ResponseBody
    @Operation(summary="Salva o anexo de projeto")
    public ResponseEntity<ProjetoEnsaioAnexo> saveAnexoProjeto(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando saveAnexo(emp={},idProjeto={})...", (Object)empresa, (Object)idProjeto);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            ProjetoEnsaioAnexo imagemDB = this.laboratorioService.saveAnexoProjeto(empresa, idProjeto, "Projetos", fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/projetos/{idProjeto}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo do projeto a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoProjeto(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, @PathVariable(name="seqAnexo") Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        logger.debug("deleteAnexoProjeto({},{},{})", new Object[]{empresa, idProjeto, seqAnexo});
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PROJETOS_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PROJETOS_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteAnexoProjeto(empresa, idProjeto, seqAnexo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoProjeto", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/planosAuditoria"})
    @Operation(summary="Lista os planos de auditoria de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<PlanoAuditoriaItem>> findPlanosAuditoria(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(required=false) String especificacao, @RequestParam(required=false) List<String> tipoEnsaio, @RequestParam(required=false) Integer idGrupoServicoPai, @RequestParam(required=false) Integer idGrupoServico) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findPlanosAuditoria (empresa={})...", (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PLANO_AUDITORIA_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PLANO_AUDITORIA_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi informada.");
            }
            ArrayList<String> empresas = new ArrayList<String>();
            empresas.add(empresa);
            List planos = this.laboratorioService.findPlanosAuditoria(empresas, tipoEnsaio, idGrupoServico, especificacao, idGrupoServicoPai);
            return new ResponseEntity((Object)planos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanosAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPlanosAuditoria", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/planosAuditoria/{idPlano}"})
    @Operation(summary="Lista o plano de auditoria de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<PlanoAuditoriaItem> getPlanoAuditoriaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPlano") Integer idPlano) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getPlanoAuditoriaById (empresa={}, idPlano={})...", (Object)empresa, (Object)idPlano);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PLANO_AUDITORIA_LISTAR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PLANO_AUDITORIA_LISTAR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PlanoAuditoriaItem plano = this.laboratorioService.getPlanoAuditoriaById(empresa, idPlano);
            return new ResponseEntity((Object)plano, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAuditoriaById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPlanoAuditoriaById", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/planosAuditoria"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro dos planos de auditoria e seus itens")
    public ResponseEntity<PlanoAuditoriaItem> savePlanoAuditoria(@PathVariable(name="empresa") String empresa, @RequestBody PlanoAuditoriaItem plano, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PLANO_AUDITORIA_INCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PLANO_AUDITORIA_INCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("savePlanoAuditoria = {})", (Object)plano);
            PlanoAuditoriaItem planoDB = this.laboratorioService.savePlanoAuditoria(empresa, plano, usuario.getLogin());
            return new ResponseEntity((Object)planoDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePlanoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/planosAuditoria/{idPlano}"})
    @Operation(summary="Exclui o plano de auditoria atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deletePlanoAuditoria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPlano") Integer idPlano, HttpServletRequest request) throws BusinessException {
        logger.debug("deletePlanoAuditoria({}, {})", (Object)empresa, (Object)idPlano);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PLANO_AUDITORIA_EXCLUIR");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PLANO_AUDITORIA_EXCLUIR");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deletePlanoAuditoria(empresa, idPlano), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/gruposServicos"})
    @Operation(summary="Lista os grupos de servi\u00e7o de auditoria de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<GrupoServicoAuditoria>> findGruposServicoAuditoria(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findGruposServicoAuditoria (empresa={})...", (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONSULTAR_GRUPOS_SERVICO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CONSULTAR_GRUPOS_SERVICO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (empresa == null || empresa.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi informada.");
            }
            List planos = this.laboratorioService.findGruposServicoAuditoria();
            return new ResponseEntity((Object)planos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findGruposServicoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findGruposServicoAuditoria", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/gruposServicos/{idGrupo}"})
    @Operation(summary="Lista o grupo do servi\u00e7o de auditoria de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<GrupoServicoAuditoria> getGrupoServicoAuditoriaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idGrupo") Integer idGrupo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getGrupoServicoAuditoriaById (emp={}, idPlano={})...", new Object[]{usuario, empresa, idGrupo});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_VISUALIZAR_GRUPO_SERVICO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_VISUALIZAR_GRUPO_SERVICO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            GrupoServicoAuditoria plano = this.laboratorioService.getGrupoServicoAuditoriaById(idGrupo);
            return new ResponseEntity((Object)plano, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoServicoAuditoriaById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getGrupoServicoAuditoriaById", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/gruposServicos"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro dos grupos de servi\u00e7o e seus itens")
    public ResponseEntity<GrupoServicoAuditoria> saveGrupoServicoAuditoria(@PathVariable(name="empresa") String empresa, @RequestBody GrupoServicoAuditoria grupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_GRUPO_SERVICO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_GRUPO_SERVICO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - saveGrupoServicoAuditoria = {})", (Object)usuario, (Object)grupo);
            GrupoServicoAuditoria grupoSvcDB = this.laboratorioService.saveGrupoServicoAuditoria(empresa, grupo, usuario.getLogin());
            return new ResponseEntity((Object)grupoSvcDB, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoServicoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/gruposServicos/{idGrupo}"})
    @Operation(summary="Exclui o plano de auditoria atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteGrupoServicoAuditoria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idGrupo") Integer idGrupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteGrupoServicoAuditoria({}, {})", new Object[]{usuario, empresa, idGrupo});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_EXCLUIR_GRUPO_SERVICO_AUDITORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_EXCLUIR_GRUPO_SERVICO_AUDITORIA");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.deleteGrupoServicoAuditoria(empresa, idGrupo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupoServicoAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

