/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAmbiental;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAmbientalVO;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControleDesativado;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControleHistorico;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoPontoControle;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoRap;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.helper.ImportacaoPontoControleHelper;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAnaliseAmbientalPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAreaApoioPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAutorizacaoIntervencaoPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioCheckListPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioInspecaoPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioPontoControlePdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioPontosControleExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRacPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para Pontos de controle", name="ambiental")
@RequestMapping(value={"/api/pontosControle"})
public class PontosControlesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(PontosControlesRestServices.class);
    @Autowired
    private RelatorioPontosControleExcel relatorioPontoControleXls;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private RelatorioPontoControlePdf relatorioPontoControlePdf;
    @Autowired
    private RelatorioRacPdf relatorioRacPdf;
    @Autowired
    private RelatorioCheckListPdf relatorioCheckListPdf;
    @Autowired
    private RelatorioInspecaoPdf relatorioInspecaoPdf;
    @Autowired
    private RelatorioAnaliseAmbientalPdf relatorioAnaliseAmbientalPdf;
    @Autowired
    private RelatorioAreaApoioPdf relatorioDepositoPdf;
    @Autowired
    private RelatorioAutorizacaoIntervencaoPdf relatorioAutorizacaoIntervencaoPdf;
    @Autowired
    private RelatorioRetiradaMaterialPdf relatorioRetiradaMaterialPdf;
    @Autowired
    private ImportacaoPontoControleHelper importacaoPontoControle;

    @GetMapping(value={"/{empresa}/find"})
    @Operation(summary="Lista as estruturas de pontos de controle dispon\u00edveis")
    public ResponseEntity<List<PontoControle>> findPontosControle(@PathVariable String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Iniciando findPontosControle({}, {})...", (Object)empresa, (Object)usuario.getLogin());
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            String numero = null;
            String descricao = null;
            Integer tipo = null;
            LocalDate datCriacaoIni = null;
            LocalDate datCriacaoFim = null;
            LocalDate datEncerraIni = null;
            LocalDate datEncerraFim = null;
            Integer obra = null;
            Character status = null;
            Integer rodovia = null;
            String quilometro = null;
            String metros = null;
            String direcao = null;
            String uf = null;
            ArrayList<Integer> cidades = null;
            if (request.getParameter("numero") != null) {
                numero = request.getParameter("numero");
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            if (request.getParameter("empresas") != null) {
                String[] param;
                for (String empParm : param = request.getParameterValues("empresas")) {
                    empresas.add(Integer.valueOf(empParm));
                }
            } else {
                empresas.add(emp.getId());
            }
            if (request.getParameter("descricao") != null) {
                descricao = request.getParameter("descricao");
            }
            if (request.getParameter("idTipo") != null) {
                tipo = Integer.valueOf(request.getParameter("idTipo"));
            }
            if (request.getParameter("datCriacaoIni") != null && request.getParameter("datCriacaoFim") != null) {
                try {
                    datCriacaoIni = LocalDate.parse(request.getParameter("datCriacaoIni"), dateFmt);
                    datCriacaoFim = LocalDate.parse(request.getParameter("datCriacaoFim"), dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datCriacaoIni = null;
                    datCriacaoFim = null;
                }
            }
            if (request.getParameter("datEncerraIni") != null && request.getParameter("datEncerraFim") != null) {
                try {
                    datEncerraIni = LocalDate.parse(request.getParameter("datEncerraIni"), dateFmt);
                    datEncerraFim = LocalDate.parse(request.getParameter("datEncerraFim"), dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datEncerraIni = null;
                    datEncerraFim = null;
                }
            }
            if (request.getParameter("idObra") != null) {
                obra = Integer.valueOf(request.getParameter("idObra"));
            }
            if (request.getParameter("status") != null) {
                status = Character.valueOf(request.getParameter("status").charAt(0));
            }
            if (request.getParameter("idRodovia") != null) {
                rodovia = Integer.valueOf(request.getParameter("idRodovia"));
            }
            if (request.getParameter("quilometro") != null) {
                quilometro = request.getParameter("quilometro");
            }
            if (request.getParameter("metros") != null) {
                metros = request.getParameter("metros");
            }
            if (request.getParameter("direcao") != null) {
                direcao = request.getParameter("direcao");
            }
            if (request.getParameter("uf") != null) {
                uf = request.getParameter("uf");
            }
            if (request.getParameter("cidades") != null) {
                String[] params = request.getParameterValues("cidades");
                cidades = new ArrayList<Integer>();
                for (String cid : params) {
                    cidades.add(Integer.valueOf(cid));
                }
            }
            FiltroPontoControle filtro = new FiltroPontoControle();
            filtro.setNumero(numero);
            filtro.setConcessionaria(empresas);
            filtro.setDescricao(descricao);
            filtro.setIdTipo(tipo);
            filtro.setDatCriacaoIni(datCriacaoIni);
            filtro.setDatCriacaoFim(datCriacaoFim);
            filtro.setDatEncerraIni(datEncerraIni);
            filtro.setDatEncerraFim(datEncerraFim);
            filtro.setIdObra(obra);
            filtro.setStatus(status);
            filtro.setUf(uf);
            filtro.setCidades(cidades);
            filtro.setIdRodovia(rodovia);
            filtro.setQuilometro(quilometro);
            filtro.setMetro(metros);
            filtro.setDirecao(direcao);
            if (request.getParameter("lastUpdate") != null) {
                LocalDateTime lastUpdate;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dataHoraFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dataHoraFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                filtro.setLastUpdate(lastUpdate);
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List pontos = this.meioAmbienteService.findPontosControle(filtro);
            Map contagem = this.meioAmbienteService.getCountFichasByPontoControle(emp.getId(), Boolean.valueOf(false));
            for (PontoControle ponto : pontos) {
                String idPontoTxt;
                if (ponto.getRodovia() != null) {
                    ponto.getRodovia().setEmpresa(null);
                }
                if (!contagem.containsKey(idPontoTxt = ponto.getId().toString())) continue;
                ponto.setNroFichas((Integer)contagem.get(idPontoTxt));
            }
            return new ResponseEntity((Object)pontos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findPontosControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idPonto}"})
    @Operation(summary="Carrega a estrutura de um ponto de controle atrav\u00e9s de seu ID")
    public ResponseEntity<PontoControle> getPontoControleById(@PathVariable Integer idPonto, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getPontoControleById(idPonto), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva o Ponto de controle")
    public ResponseEntity<PontoControle> savePontoControle(@PathVariable(name="empresa") String empresa, @RequestBody PontoControle ponto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePontoControle ({}))", (Object)ponto);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (ponto.getIdEmpresa() == null) {
                    ponto.setIdEmpresa(emp.getId());
                }
            }
            return new ResponseEntity((Object)this.meioAmbienteService.savePontoControle(ponto, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.savePontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idPonto}"})
    @Operation(summary="Exclui a estrutura do ponto de controle atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deletePontoControle(@PathVariable(name="idPonto") Integer idPonto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePontoControle({})", (Object)idPonto);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deletePontoControle(idPonto), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.deletePontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idPontoControle}/desativacoes"})
    @Operation(summary="Desativa o ponto de controle atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> desativarPontoControle(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPontoControle") Integer idPonto, @RequestBody PontoControle ponto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (ponto == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Ponto de Controle n\u00e3o foi encontrado.");
        }
        logger.debug("{} - desativarPontoControle({}, {})", new Object[]{usuario.getLogin(), empresa, idPonto});
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.desativarPontoControle(idPonto, ponto.getDatDesativacao(), ponto.getObservacaoDesativacao()), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.desativarPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipos"})
    @Operation(summary="Lista as estruturas de tipos de pontos de controle dispon\u00edveis")
    public ResponseEntity<List<TipoPontoControle>> findTiposPontosControle(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findTiposPontosControle...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findTiposPontosControle(searchTxt, lastUpdate), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findTiposPontosControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipos/{idTipo}"})
    @Operation(summary="Carrega a estrutura de um tipo ponto de controle atrav\u00e9s de seu ID")
    public ResponseEntity<TipoPontoControle> getTipoPontoControleById(@PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getTipoPontoControleById(idTipo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.getTipoPontoControleById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tipos"})
    @Operation(summary="Salva a estrutura do tipo de ponto de controle")
    public ResponseEntity<TipoPontoControle> saveTipoPontoControle(@RequestBody TipoPontoControle tipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTipoPontoControle ({}))", (Object)tipo);
            return new ResponseEntity((Object)this.meioAmbienteService.saveTipoPontoControle(tipo, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveTipoPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tipos/{idTipo}"})
    @Operation(summary="Exclui a estrutura do tipo ponto de controle atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteTipoPontoControle(@PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteTipoPontoControle({})", (Object)idTipo);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteTipoPontoControle(idTipo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.deleteTipoPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/desativados/{empresa}/find"})
    @Operation(summary="Lista as estruturas de Pontos de Controle Desativados")
    public ResponseEntity<List<PontoControleDesativado>> findPontosDesativados(@PathVariable(name="empresa") String empresa, @RequestParam(name="dataInicial", required=false) LocalDate dataInicial, @RequestParam(name="dataFinal", required=false) LocalDate dataFinal, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findPontosDesativados({},{},{})...", new Object[]{empresa, dataInicial, dataFinal});
            Empresa emp = null;
            if (empresa != null && (emp = this.cadastroService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findPontosDesativados(emp.getId(), dataInicial, dataFinal), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findTiposPontosControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/desativados/{idDesativacao}"})
    @Operation(summary="Carrega o lan\u00e7amento de desativa\u00e7\u00e3o atrav\u00e9s de seu ID")
    public ResponseEntity<PontoControleDesativado> getPontoDesativado(@PathVariable(name="idDesativacao") Integer idDesativacao) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getPontoDesativadoById(idDesativacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.getPontoDesativado", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/desativados/{empresa}"})
    @Operation(summary="Registra a desativa\u00e7\u00e3o do ponto de controle")
    public ResponseEntity<PontoControleDesativado> registraDesativacao(@PathVariable(name="empresa") String empresa, @RequestBody PontoControleDesativado desativacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("registraDesativacao ({}))", (Object)desativacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (desativacao.getIdEmpresa() == null) {
                    desativacao.setIdEmpresa(emp.getId());
                }
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.meioAmbienteService.registrarPontoDesativado(desativacao, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.registraDesativacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/desativados/{idDesativacao}"})
    @Operation(summary="Exclui o lan\u00e7amento de desativa\u00e7\u00e3o, devolvendo o ponto de controle para status operacional")
    public ResponseEntity<Boolean> deletePontoDesativacao(@PathVariable(name="idDesativacao") Integer idDesativacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deletePontoDesativacao({})", (Object)idDesativacao);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deletePontoDesativado(idDesativacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.deletePontoDesativacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPontoControle}/fichas"})
    @Operation(summary="Lista as fichas ambientais relacionadas ao Ponto de Controle")
    public ResponseEntity<List<FichaAmbientalVO>> findFichas(@PathVariable String empresa, @PathVariable Integer idPontoControle, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findFichas({},{})...", new Object[]{usuario.getLogin(), empresa, idPontoControle});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List fichas = this.meioAmbienteService.findFichasByPontoControle(emp.getId(), idPontoControle);
            return new ResponseEntity((Object)fichas, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findFichas", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download da Lista de Pontos de Controle em Excel")
    public ResponseEntity<byte[]> exportaPontosControleExcel(@PathVariable(name="empresa") String empresa, @RequestBody FiltroPontoControle filtro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Exportando excel, Ponto de Controle (emp={})...", (Object)usuario, (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtro == null) {
            filtro = new FiltroPontoControle();
        }
        try {
            Map countFichasByPontoControle;
            if (filtro.getConcessionaria().isEmpty()) {
                filtro.getConcessionaria().add(emp.getId());
            }
            List rows = this.meioAmbienteService.findPontosControle(filtro);
            Map contagem = countFichasByPontoControle = this.meioAmbienteService.getCountFichasByPontoControle(emp.getId(), Boolean.valueOf(true));
            for (PontoControle ponto : rows) {
                String idPontoTxt = ponto.getId().toString() + ":RAC";
                ponto.setNroFichasRac((Integer)contagem.get(idPontoTxt));
                idPontoTxt = ponto.getId().toString() + ":CHKLST";
                ponto.setNroFichasChecklist((Integer)contagem.get(idPontoTxt));
                idPontoTxt = ponto.getId().toString() + ":INSPE";
                int count = 0;
                if (contagem.containsKey("INSPE")) {
                    count += ((Integer)contagem.get("INSPE")).intValue();
                }
                logger.debug("{}", (Object)count);
                ponto.setNroFichasInspecao((Integer)contagem.get(idPontoTxt));
            }
            byte[] bytes = this.relatorioPontoControleXls.executeXLS(rows);
            if (bytes == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"pontoControle.xlsx\"");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idPonto}"})
    @Operation(summary="Efetua o download do Ponto de Controle em PDF")
    public ResponseEntity<byte[]> exportaDepositoPdf(@PathVariable String empresa, @PathVariable Integer idPonto, HttpServletRequest request) throws IOException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Exportando PDF, Ponto (emp={}, {})...", new Object[]{usuario.getLogin(), empresa, idPonto});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            PontoControle ponto = this.meioAmbienteService.getPontoControleById(idPonto);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (ponto.getLatitude() != null && ponto.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(ponto.getLatitude(), ponto.getLongitude(), tipoMapa);
            }
            List fichas = this.meioAmbienteService.findAllFichasByPontoControle(emp.getId(), idPonto);
            PDFMergerUtility pdfMerger = new PDFMergerUtility();
            byte[] bytes = this.relatorioPontoControlePdf.executePDF(emp.getId(), ponto, mapaGoogle);
            byte[] mergedBytes = null;
            if (!fichas.isEmpty()) {
                pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytes));
                for (Object ficha : fichas) {
                    if (ficha instanceof Rac) {
                        Rac rac = (Rac)ficha;
                        byte[] bytesRac = this.relatorioRacPdf.executePdf(rac.getEmpresa().getId(), rac, mapaGoogle, true, usuario.getLogin());
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesRac));
                        continue;
                    }
                    if (ficha instanceof InspecaoAmbiental) {
                        InspecaoAmbiental insp = (InspecaoAmbiental)ficha;
                        byte[] bytesInsp = this.relatorioInspecaoPdf.executePDF(insp.getEmpresa().getId(), insp, mapaGoogle, true);
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesInsp));
                        continue;
                    }
                    if (ficha instanceof CheckList) {
                        CheckList check = (CheckList)ficha;
                        byte[] bytesCheck = this.relatorioCheckListPdf.executePdf(check.getEmpresa().getId(), check, mapaGoogle, true);
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesCheck));
                        continue;
                    }
                    if (ficha instanceof AnaliseAmbiental) {
                        AnaliseAmbiental analise = (AnaliseAmbiental)ficha;
                        byte[] bytesAnalise = this.relatorioAnaliseAmbientalPdf.executePDF(analise.getEmpresa().getId(), analise, mapaGoogle, true);
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesAnalise));
                        continue;
                    }
                    if (ficha instanceof AreaApoio) {
                        AreaApoio depo = (AreaApoio)ficha;
                        byte[] bytesDepo = this.relatorioDepositoPdf.executePDF(depo.getEmpresa().getId(), depo, mapaGoogle, true);
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesDepo));
                        continue;
                    }
                    if (ficha instanceof AutorizacaoIntervencao) {
                        AutorizacaoIntervencao autoriza = (AutorizacaoIntervencao)ficha;
                        byte[] bytesAutoriza = this.relatorioAutorizacaoIntervencaoPdf.executePDF(autoriza.getEmpresa().getId(), autoriza, mapaGoogle, true);
                        pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesAutoriza));
                        continue;
                    }
                    if (!(ficha instanceof AutorizacaoRap)) continue;
                    AutorizacaoRap rap = (AutorizacaoRap)ficha;
                    byte[] bytesRap = this.relatorioRetiradaMaterialPdf.executePDF(rap.getEmpresa().getId(), rap, mapaGoogle, true);
                    pdfMerger.addSource((InputStream)new ByteArrayInputStream(bytesRap));
                }
                ByteArrayOutputStream mergedBytesStream = new ByteArrayOutputStream();
                pdfMerger.setDestinationStream((OutputStream)mergedBytesStream);
                pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
                mergedBytes = mergedBytesStream.toByteArray();
            }
            if (bytes == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            if (mergedBytes != null) {
                logger.debug("Merged.Bytes.length gerados==> {}", (Object)(mergedBytes.length > 0 ? mergedBytes.length / 1024 : 0));
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"ponto-controle.pdf\"");
            headers.add("Content-Type", "application/pdf");
            if (mergedBytes != null) {
                return new ResponseEntity((Object)mergedBytes, (MultiValueMap)headers, HttpStatus.OK);
            }
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/importacaoExcel"})
    @Operation(summary="Efetua a importa\u00e7\u00e3o da planilha para o ponto de controle.")
    public ResponseEntity<String> importarPontoControle(@PathVariable String empresa, @RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("Iniciando importa\u00e7\u00e3o do Ponto de Controle, usu\u00e1rio={}, empresa={}", (Object)usuario.getLogin(), (Object)empresa);
            this.importacaoPontoControle.importPontoControle(empresaDB, usuario.getId(), file);
            return ResponseEntity.ok((Object)"Planilha importada com sucesso.");
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.importarPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idPontoControle}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados no Ponto de Controle")
    public ResponseEntity<List<PontoControleHistorico>> findHistoricosPontoControle(@PathVariable(name="idPontoControle") Integer idPontoControle, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("{} - findHistoricos({})", (Object)usuario.getLogin(), (Object)idPontoControle);
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosPontoControle(idPontoControle), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idPontoControle}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico do Ponto de Controle de acordo com o payload informado")
    public ResponseEntity<PontoControleHistorico> createHistoricoPontoControle(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPontoControle") Integer idPontoControle, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistoricoPontoControle({},{})", (Object)empresa, (Object)idPontoControle);
            Map formData = request.getParameterMap();
            PontoControleHistorico anexo = new PontoControleHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PontoControleHistorico response = this.meioAmbienteService.saveHistoricoPontoControle(emp.getId(), idPontoControle, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistoricoPontoControle", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

