/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.LinhaNegocio;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/cadastros/linhasNegocios"})
@Tag(description="REST Services para linhas de neg\u00f3cios", name="ambiental")
public class LinhasNegociosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(LinhasNegociosRestServices.class);
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping
    @Operation(summary="Registrar uma Linha de Neg\u00f3cio")
    public ResponseEntity<LinhaNegocio> registrarLinha(@RequestBody LinhaNegocio linhaNegocio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarLinha ({}))", (Object)user.getLogin(), (Object)linhaNegocio);
            LinhaNegocio linha = this.meioAmbienteService.saveLinhaNegocio(linhaNegocio, user.getId());
            return new ResponseEntity((Object)linha, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarEixo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLinha}"})
    @Operation(summary="Atualiza uma Linha de Neg\u00f3cio")
    public ResponseEntity<LinhaNegocio> atualizarLinha(@RequestBody LinhaNegocio linhaNegocio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - atualizarLinha ({}))", (Object)user.getLogin(), (Object)linhaNegocio);
            LinhaNegocio linha = this.meioAmbienteService.saveLinhaNegocio(linhaNegocio, user.getId());
            return new ResponseEntity((Object)linha, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarEixo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLinha}"})
    @Operation(summary="Devolve uma Linha de Neg\u00f3cio")
    public LinhaNegocio getLinhaById(@PathVariable Integer idLinha, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getLinhaById ({})...", (Object)usuario.getLogin(), (Object)idLinha);
            return this.meioAmbienteService.getLinhaById(idLinha);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping
    @Operation(summary="Devolve uma lista de Linhas de Neg\u00f3cio")
    public List<LinhaNegocio> findLinhasNegocios(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findLinhasNegocios()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.meioAmbienteService.findLinhas(searchTxt);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLinha}"})
    @Operation(summary="Exclui a Linha de Neg\u00f3cio")
    public Boolean deleteLinhaNegocio(@PathVariable Integer idLinha, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteLinhaNegocio({})", (Object)idLinha);
        try {
            return this.meioAmbienteService.deleteLinhaById(idLinha);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLinhaNegocio", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

