/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.EixoEstrategico;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/cadastros/eixoEstrategicos"})
@Tag(description="REST Services para eixos estrat\u00e9gicos", name="ambiental")
public class EixosEstrategicosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(EixosEstrategicosRestServices.class);
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping
    @Operation(summary="Registrar ou Atualizar um Eixo Estrat\u00e9gico")
    public ResponseEntity<EixoEstrategico> registrarEixo(@RequestBody EixoEstrategico eixoEstrategico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (user == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("[{}] - registrarEixo ({}))", (Object)user.getLogin(), (Object)eixoEstrategico);
            EixoEstrategico eixo = this.meioAmbienteService.saveEixoEstrategico(eixoEstrategico, user.getId());
            return new ResponseEntity((Object)eixo, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarEixo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idEixo}"})
    @Operation(summary="Devolve um Eixo Estrat\u00e9gico")
    public EixoEstrategico getEixoById(@PathVariable Integer idEixo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - getEixoById ({})...", (Object)usuario.getLogin(), (Object)idEixo);
            EixoEstrategico eixo = this.meioAmbienteService.getEixoById(idEixo);
            return eixo;
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @GetMapping
    @Operation(summary="Devolve uma lista de Eixos Estrat\u00e9gicos")
    public List<EixoEstrategico> findEixosEstrategicos(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - findEixosEstrategicos()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return this.meioAmbienteService.findEixos(searchTxt);
        }
        catch (BusinessException ex) {
            logger.error("BizExc ", (Throwable)ex);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ex.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEixo}"})
    @Operation(summary="Exclui a Eixo Estrat\u00e9gico")
    public Boolean deleteEixoEstrategico(@PathVariable Integer idEixo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteEixoEstrategico({})", (Object)idEixo);
        try {
            return this.meioAmbienteService.deleteEixoById(idEixo);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEixoEstrategico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

