/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPraticaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPraticaHistorico;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioBoaPraticaExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioBoaPraticaPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para Boas Pr\u00e1ticas Ambientais", name="boas-praticas")
@RequestMapping(value={"/api/boasPraticas"})
public class BoasPraticasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(BoasPraticasRestServices.class);
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelatorioBoaPraticaPdf relatorioBoaPraticaPdf;

    @GetMapping
    @Operation(summary="Lista as boas pr\u00e1ticas")
    public ResponseEntity<List<BoaPratica>> findBoasPraticas(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findBoasPraticas...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findBoasPraticas(searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findBoasPraticas", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idBoaPratica}"})
    @Operation(summary="Carrega a boa pr\u00e1tica pelo seu Identificador")
    public ResponseEntity<BoaPratica> getBoaPratica(@PathVariable(name="idBoaPratica") Integer idBoaPratica) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getBoaPraticaById(idBoaPratica), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizE\t1xc.getBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a Boa Pr\u00e1tica")
    public ResponseEntity<BoaPratica> saveBoaPratica(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            String anexosTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            BoaPratica boa = (BoaPratica)mapper.readValue(((String[])formData.get("boaPratica"))[0], BoaPratica.class);
            if (boa == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Boa pr\u00e1tica n\u00e3o foi informada.");
            }
            logger.debug("{} - saveBoaPratica ({}))", (Object)usuario.getLogin(), (Object)boa.getTitulo());
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (boa.getIdEmpresa() == null) {
                    boa.setIdEmpresa(emp.getId());
                }
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            BoaPratica boaDb = this.meioAmbienteService.saveBoaPratica(boa, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)boaDb, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarBoaPratica", (Throwable)jsmExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarBoaPratica", (Throwable)jspExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download da Boa pr\u00e1tica em Excel")
    public ResponseEntity<StreamingResponseBody> exportaBoaPraticaExcel(@PathVariable String empresa, @RequestParam(required=false) List<String> configCampos) {
        logger.debug("Exportando excel, boaPratica (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        List boaPratica = this.meioAmbienteService.findBoasPraticas("");
        try {
            StreamingResponseBody responseBody = response -> response.write(new RelatorioBoaPraticaExcel().executeXLS(boaPratica, configCampos));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"boaPratica.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idBoaPratica}"})
    @Operation(summary="Exclui a boa pratica atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteBoaPratica(@PathVariable(name="idBoaPratica") Integer idBoaPratica) throws BusinessException {
        logger.debug("deleteBoaPratica({})", (Object)idBoaPratica);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteBoaPratica(idBoaPratica), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idBoaPratica}/anexos"})
    @Operation(summary="Lista os anexos presentes na Boa Pr\u00e1tica")
    public ResponseEntity<List<BoaPraticaAnexo>> findAnexosBoaPratica(HttpServletRequest request, @PathVariable(name="idBoaPratica") Integer idBoaPratica) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findAnexosBoaPratica({})", (Object)usuario);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.findAnexosBoaPratica(idBoaPratica), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosDeposito", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idBoaPratica}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<BoaPraticaAnexo>> createAnexoBoaPratica(@PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - createAnexoBoaPratica ({}, {}))", new Object[]{usuario, empresa, idBoaPratica});
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<BoaPraticaAnexo> anexos = new ArrayList<BoaPraticaAnexo>();
            for (MultipartFile file : filesMap) {
                BoaPraticaAnexo anexo = new BoaPraticaAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.meioAmbienteService.createAnexoBoaPratica(emp.getId(), idBoaPratica, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexoBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idBoaPratica}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Boa Pr\u00e1tica a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoBoaPratica(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteAnexo({}, {})", new Object[]{empresa, idBoaPratica, seqAnexo});
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoBoaPratica(emp.getId(), idBoaPratica, seqAnexo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idBoaPratica}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idBoaPratica});
            this.meioAmbienteService.saveComentarioAnexoBoaPratica(empresa, idBoaPratica, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idBoaPratica}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idBoaPratica, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveGirarImagem", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idBoaPratica}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na Boa Pr\u00e1tica")
    public ResponseEntity<List<BoaPraticaHistorico>> findHistoricosBoaPratica(@PathVariable(name="idBoaPratica") Integer idBoaPratica) {
        try {
            logger.debug("findHistoricos({},{})", (Object)idBoaPratica);
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosBoaPratica(idBoaPratica), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idBoaPratica}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da Boa Pr\u00e1tica de acordo com o payload informado")
    public ResponseEntity<BoaPraticaHistorico> createHistoricoBoaPratica(@PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistoricoBoaPratica({},{})", (Object)empresa, (Object)idBoaPratica);
            Map formData = request.getParameterMap();
            BoaPraticaHistorico anexo = new BoaPraticaHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            BoaPraticaHistorico response = this.meioAmbienteService.saveHistoricoBoaPratica(emp.getId(), idBoaPratica, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistoricoBoaPratica", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idBoaPratica}"})
    @Operation(summary="Efetua o download da Boa Pr\u00e1tica em PDF")
    public ResponseEntity<byte[]> exportaBoaPraticaPdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idBoaPratica") Integer idBoaPratica, HttpServletRequest request) throws IOException {
        logger.debug("Exportando PDF, Boa Pr\u00e1tica (emp={}, {})...", (Object)empresa, (Object)idBoaPratica);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            BoaPratica boaPratica = this.meioAmbienteService.getBoaPraticaById(idBoaPratica);
            byte[] bytes = this.relatorioBoaPraticaPdf.executePDF(emp.getId(), boaPratica, false);
            if (bytes == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"boa-pratica.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

