/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaEvento;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoHistorico;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoRap;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoRapPK;
import br.com.oti.gesconsys.ambiental.beans.rap.FiltroRap;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioRetiradaMaterialPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para Autoriza\u00e7\u00f5es Rap", name="ambiental")
@RequestMapping(value={"/api/autorizacoesRap"})
public class AutorizacoesRapRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AutorizacoesRapRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelatorioRetiradaMaterialPdf relatorioRetiradaMaterialPdf;

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as autoriza\u00e7\u00f5es dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<List<AutorizacaoRap>> findAutorizacoes(@PathVariable(name="empresa") String empresa, @RequestBody FiltroRap filtro, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAutorizacoes...");
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtro == null) {
                filtro = new FiltroRap();
            }
            if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtro.setConcessionaria(empList);
            }
            boolean joinAnexos = true;
            boolean joinOcorrencias = true;
            List autorizacoes = this.meioAmbienteService.findAutorizacoesRap(filtro, Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias));
            for (AutorizacaoRap autoriz : autorizacoes) {
                if (autoriz.getRodovia() == null) continue;
                Rodovia rdv = autoriz.getRodovia();
                rdv.setEmpresa(null);
                autoriz.setRodovia(rdv);
            }
            return new ResponseEntity((Object)autorizacoes, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAutorizacoes", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Carrega a Autoriza\u00e7\u00e3o de acordo com seu identificador")
    public ResponseEntity<AutorizacaoRap> getAutorizacaoRap(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AutorizacaoRap autoriz = this.meioAmbienteService.getAutorizacaoRapById(emp.getId(), idAutorizacao);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setDatHorAlteracao(null);
            autoriz.getRodovia().setDatHorCadastro(null);
            autoriz.getRodovia().setEmpresa(null);
            autoriz.getRodovia().setIdUsuarioIns(null);
            autoriz.getRodovia().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setDatHorAlteracao(null);
            autoriz.getCoordenadorObra().setDatHorCadastro(null);
            autoriz.getCoordenadorObra().setDatHorUltimoLogin(null);
            autoriz.getCoordenadorObra().setGrupos(null);
            autoriz.getCoordenadorObra().setIdPoderConcedente(null);
            autoriz.getCoordenadorObra().setIdUsuarioIns(null);
            autoriz.getCoordenadorObra().setIdUsuarioUpd(null);
            autoriz.getCoordenadorObra().setSessionUUID(null);
            autoriz.getEquipeAmbiental().setDatHorAlteracao(null);
            autoriz.getEquipeAmbiental().setDatHorCadastro(null);
            autoriz.getEquipeAmbiental().setIdEmpresa(null);
            autoriz.getEquipeAmbiental().setIdUsuarioIns(null);
            autoriz.getEquipeAmbiental().setIdUsuarioUpd(null);
            autoriz.getEquipeConcessao().setDatHorAlteracao(null);
            autoriz.getEquipeConcessao().setDatHorCadastro(null);
            autoriz.getEquipeConcessao().setIdEmpresa(null);
            autoriz.getEquipeConcessao().setIdUsuarioIns(null);
            autoriz.getEquipeConcessao().setIdUsuarioUpd(null);
            autoriz.getEquipeEmpreiteira().setDatHorAlteracao(null);
            autoriz.getEquipeEmpreiteira().setDatHorCadastro(null);
            autoriz.getEquipeEmpreiteira().setIdEmpresa(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioIns(null);
            autoriz.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            return new ResponseEntity((Object)autoriz, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAutorizacaoIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a Autoriza\u00e7\u00e3o RAP")
    public ResponseEntity<AutorizacaoRap> registrarAutorizacao(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            AutorizacaoRap autoriz = (AutorizacaoRap)mapper.readValue(((String[])formData.get("autorizacao"))[0], AutorizacaoRap.class);
            if (autoriz.getId() == null) {
                autoriz.setId(new AutorizacaoRapPK());
            }
            logger.debug("registrarAutorizacao({}))", (Object)autoriz);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (autoriz.getId().getIdEmpresa() == null) {
                    autoriz.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && (ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).length() > 0) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            AutorizacaoRap autorizDb = this.meioAmbienteService.registrarAutorizacaoRap(autoriz, ocorrencias, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)autorizDb, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarAutorizacao", (Throwable)jsmExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarAutorizacao", (Throwable)jspExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}"})
    @Operation(summary="Exclui a Autoriza\u00e7\u00e3o RAP atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) throws BusinessException {
        logger.debug("deleteAutorizacao({}, {})", (Object)empresa, (Object)idAutorizacao);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAutorizacaoRap(emp.getId(), idAutorizacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<AutorizacaoAnexo>> createAnexoAutorizacaoRap(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexo({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<AutorizacaoAnexo> anexos = new ArrayList<AutorizacaoAnexo>();
            for (MultipartFile file : filesMap) {
                AutorizacaoAnexo anexo = new AutorizacaoAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.meioAmbienteService.createAnexoAutorizacaoRap(emp.getId(), idAutorizacao, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/anexos"})
    @Operation(summary="Lista os anexos presentes na Autoriza\u00e7\u00e3o")
    public ResponseEntity<List<AutorizacaoAnexo>> findAnexosAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnexosAutorizacaoRap(emp.getId(), idAutorizacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAutorizacao}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idAutorizacao, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Autoriza\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idAutorizacao, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoAutorizacaoRap(emp.getId(), idAutorizacao, seqAnexo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacaoRap}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas ao Deposito")
    public ResponseEntity<Map<String, Object>> findOcorrenciasDeposito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacaoRap") Integer idAutorizacaoRap) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.meioAmbienteService.findOcorrencias(null, null);
            List AutorizacoesRapOcorrencias = this.meioAmbienteService.findOcorrenciasAutorizacaoRap(emp.getId(), idAutorizacaoRap);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<AutorizacaoOcorrenciaPK> soluAssocList = new ArrayList<AutorizacaoOcorrenciaPK>();
            for (AutorizacaoOcorrencia rapOcorre : AutorizacoesRapOcorrencias) {
                if (!mapSoluOcorre.containsKey(rapOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(rapOcorre.getId().getIdOcorrencia(), rapOcorre.getOcorrencia());
                }
                soluAssocList.add(rapOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasDeposito", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<IntervencaoOcorrencia> updateOcorrenciaAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @RequestBody IntervencaoOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrenciaAutorizacao({},{})", (Object)idAutorizacao, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdEmpresa() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            IntervencaoOcorrencia response = this.meioAmbienteService.saveOcorrenciaAutorizacaoIntervencao(emp.getId(), idAutorizacao, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrenciaAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAutorizacao}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo da Autoriza\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, @PathVariable(name="idOcorrencia") Integer idOcorrencia, @PathVariable(name="idSolucao") Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrenciaAutorizacao({}, {}, {}, {})", new Object[]{empresa, idAutorizacao, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteOcorrenciaAutorizacaoRap(emp.getId(), idAutorizacao, idOcorrencia, idSolucao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrenciaAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na Autoriza\u00e7\u00e3o")
    public ResponseEntity<List<AutorizacaoHistorico>> findHistoricosAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosAutorizacaoRap(emp.getId(), idAutorizacao), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da Autoriza\u00e7\u00e3o de acordo com o payload informado")
    public ResponseEntity<AutorizacaoHistorico> createHistoricoAutorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistoricoAutorizacao({},{})", (Object)empresa, (Object)idAutorizacao);
            Map formData = request.getParameterMap();
            AutorizacaoHistorico anexo = new AutorizacaoHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AutorizacaoHistorico response = this.meioAmbienteService.saveHistoricoAutorizacaoRap(emp.getId(), idAutorizacao, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistoricoAutorizacao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idAutorizacaoRap}"})
    @Operation(summary="Efetua o download da Autoriza\u00e7\u00e3o de Interven\u00e7\u00e3o em PDF")
    public ResponseEntity<byte[]> exportaAutorizacaoRapPdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacaoRap") Integer idAutorizacaoRap, HttpServletRequest request) throws IOException {
        logger.debug("Exportando PDF, Autoriza\u00e7\u00e3o (emp={}, {})...", (Object)empresa, (Object)idAutorizacaoRap);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            byte[] bytes;
            AutorizacaoRap autorizacao = this.meioAmbienteService.getAutorizacaoRapById(emp.getId(), idAutorizacaoRap);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (autorizacao.getLatitude() != null && autorizacao.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(autorizacao.getLatitude(), autorizacao.getLongitude(), tipoMapa);
            }
            if ((bytes = this.relatorioRetiradaMaterialPdf.executePDF(emp.getId(), autorizacao, mapaGoogle, false)) == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"autorizacao-intervencao.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download de Autoriza\u00e7\u00f5es Descarte e/ou Retirada de Material em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable(name="empresa") String empresa, @RequestBody FiltroRap filtro, HttpServletRequest request) {
        logger.debug("Exportando excel, autoriza\u00e7\u00f5es descarte/retirada de material (emp={})...", (Object)empresa);
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtro == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtro.setConcessionaria(empList);
        }
        try {
            List autorizacoes = this.meioAmbienteService.findAutorizacoesRap(filtro, Boolean.valueOf(true), Boolean.valueOf(true));
            StreamingResponseBody responseBody = response -> response.write(new RelatorioRetiradaMaterialExcel(this.meioAmbienteService).executeXLS(autorizacoes, filtro.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"autoriza\u00e7\u00e3o-retirada-descarte.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idDescarte}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo de Autoriza\u00e7\u00e3o de Descarte")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idDescarte") Integer idAutorizacao, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idAutorizacao});
            this.meioAmbienteService.saveComentarioAnexoDescarte(empresa, idAutorizacao, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAutorizacao}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados na Autoriza\u00e7\u00e3o de Descarte/Retirada")
    public ResponseEntity<List<FichaAprovacao>> findAprovacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAutorizacao") Integer idAutorizacao) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idAutorizacao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.meioAmbienteService.findAprovacoesById(emp.getId(), idAutorizacao, "ADR");
            return new ResponseEntity((Object)aprovacoes, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoes", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAutorizacao}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da Autoriza\u00e7\u00e3o de Descarte/Retirada (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar, Reabrir)")
    @ResponseBody
    public ResponseEntity<FichaEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idAutorizacao, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            FichaEvento evento;
            logger.debug("executeEvento({},{},{})", new Object[]{empresa, idAutorizacao, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer seqAprovacao = null;
            if (request.getParameter("seqAprovacao") != null) {
                try {
                    seqAprovacao = Integer.valueOf(request.getParameter("seqAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    seqAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.meioAmbienteService.enviarAprovacaoAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.meioAmbienteService.aprovarAutorizacaoDescarte(empresa, idAutorizacao, seqAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.meioAmbienteService.reprovarAutorizacaoDescarte(empresa, idAutorizacao, seqAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.meioAmbienteService.encerrarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.finalizarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.naoFinalizarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.meioAmbienteService.reabrirAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.meioAmbienteService.cancelarAutorizacaoDescarte(empresa, idAutorizacao, usuario.getLogin(), perfilReprovar);
            } else {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateExecuteEventoAutorizacaoDescarteRetirada", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

