/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAmbiental;
import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAnexo;
import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseHistorico;
import br.com.oti.gesconsys.ambiental.beans.analise.FiltroAnalise;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaEvento;
import br.com.oti.gesconsys.ambiental.beans.rac.AnaliseAmbientalGrupo;
import br.com.oti.gesconsys.ambiental.beans.rac.AnaliseAmbientalTipo;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAnaliseAmbientalExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAnaliseAmbientalPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para An\u00e1lises Ambientais", name="ambiental")
@RequestMapping(value={"/api/analises"})
public class AnalisesAmbientaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AnalisesAmbientaisRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private RelatorioAnaliseAmbientalPdf relatorioAnaliseAmbientalPdf;

    @GetMapping(value={"/grupos"})
    @Operation(summary="Lista da analises - grupos dispon\u00edveis")
    public ResponseEntity<List<AnaliseAmbientalGrupo>> findAnaliseGrupos(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAnaliseGrupos...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnaliseGrupos(searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnaliseGrupos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/grupos/{idGrupo}"})
    @Operation(summary="Carrega a analise ambiental de grupo atrav\u00e9s de seu ID")
    public ResponseEntity<AnaliseAmbientalGrupo> getAnaliseGrupoById(@PathVariable Integer idGrupo) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getAnaliseGrupoById(idGrupo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnaliseGrupoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/grupos"})
    @Operation(summary="Salva o grupo da an\u00e1lise ambiental")
    public ResponseEntity<AnaliseAmbientalGrupo> saveAnaliseGrupo(@RequestBody AnaliseAmbientalGrupo analiseGrupo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveAnaliseGrupo ({}))", (Object)analiseGrupo);
            return new ResponseEntity((Object)this.meioAmbienteService.saveAnaliseGrupo(analiseGrupo, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnaliseGrupo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/grupos/{idGrupo}"})
    @Operation(summary="Exclui o grupo de an\u00e1lise ambiental atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteAnaliseGrupo(@PathVariable(name="idGrupo") Integer idGrupo) throws BusinessException {
        logger.debug("deleteAnaliseGrupo({})", (Object)idGrupo);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnaliseGrupo(idGrupo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnaliseGrupo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipos"})
    @Operation(summary="Lista dos tipos de an\u00e1lises ambientais")
    public ResponseEntity<List<AnaliseAmbientalTipo>> findAnaliseTipos(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAnaliseTipos...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnaliseTipos(searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnaliseTipos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipos/{idTipo}"})
    @Operation(summary="Carrega o tipo tipo de an\u00e1lise ambiental atrav\u00e9s de seu ID")
    public ResponseEntity<AnaliseAmbientalTipo> getAnaliseTipo(@PathVariable(name="idTipo") Integer idTipo) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getAnaliseTipoById(idTipo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnaliseTipoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tipos"})
    @Operation(summary="Salva o tipo da An\u00e1lise ambiental")
    public ResponseEntity<AnaliseAmbientalTipo> saveAnaliseTipo(@RequestBody AnaliseAmbientalTipo analiseTipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveAnaliseTipo ({}))", (Object)analiseTipo);
            return new ResponseEntity((Object)this.meioAmbienteService.saveAnaliseTipo(analiseTipo, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnaliseTipo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tipos/{idTipo}"})
    @Operation(summary="Exclui o Tipo de an\u00e1lise ambiental, atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteAnaliseTipo(@PathVariable(name="idTipo") Integer idTipo) throws BusinessException {
        logger.debug("deleteAnaliseTipo({})", (Object)idTipo);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnaliseTipo(idTipo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnaliseTipo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as inspe\u00e7\u00f5es dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<List<AnaliseAmbiental>> findAnalises(@PathVariable(name="empresa") String empresa, @RequestBody FiltroAnalise filtroAnalise, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAnalises...");
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroAnalise == null) {
                filtroAnalise = new FiltroAnalise();
            }
            if (filtroAnalise.getConcessionaria() == null || filtroAnalise.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroAnalise.setConcessionaria(empList);
            }
            boolean joinItens = false;
            boolean joinAnexos = false;
            List analises = this.meioAmbienteService.findAnalises(filtroAnalise, Boolean.valueOf(joinItens), Boolean.valueOf(joinAnexos));
            for (AnaliseAmbiental analise : analises) {
                if (analise.getRodovia() == null) continue;
                Rodovia rdv = analise.getRodovia();
                rdv.setEmpresa(null);
                analise.setRodovia(rdv);
            }
            return new ResponseEntity((Object)analises, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnalises", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAnalise}"})
    @Operation(summary="Carrega a An\u00e1lise Ambiental de acordo com seu identificador")
    public ResponseEntity<AnaliseAmbiental> getAnaliseAmbiental(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AnaliseAmbiental insp = this.meioAmbienteService.getAnaliseById(emp.getId(), idAnalise);
            insp.getRodovia().setIdUsuarioIns(null);
            insp.getRodovia().setDatHorAlteracao(null);
            insp.getRodovia().setDatHorCadastro(null);
            insp.getRodovia().setEmpresa(null);
            insp.getRodovia().setIdUsuarioIns(null);
            insp.getRodovia().setIdUsuarioUpd(null);
            insp.getCoordenadorObra().setDatHorAlteracao(null);
            insp.getCoordenadorObra().setDatHorCadastro(null);
            insp.getCoordenadorObra().setDatHorUltimoLogin(null);
            insp.getCoordenadorObra().setGrupos(null);
            insp.getCoordenadorObra().setIdPoderConcedente(null);
            insp.getCoordenadorObra().setIdUsuarioIns(null);
            insp.getCoordenadorObra().setIdUsuarioUpd(null);
            insp.getCoordenadorObra().setSessionUUID(null);
            insp.getEquipeAmbiental().setDatHorAlteracao(null);
            insp.getEquipeAmbiental().setDatHorCadastro(null);
            insp.getEquipeAmbiental().setIdEmpresa(null);
            insp.getEquipeAmbiental().setIdUsuarioIns(null);
            insp.getEquipeAmbiental().setIdUsuarioUpd(null);
            insp.getEquipeConcessao().setDatHorAlteracao(null);
            insp.getEquipeConcessao().setDatHorCadastro(null);
            insp.getEquipeConcessao().setIdEmpresa(null);
            insp.getEquipeConcessao().setIdUsuarioIns(null);
            insp.getEquipeConcessao().setIdUsuarioUpd(null);
            insp.getEquipeEmpreiteira().setDatHorAlteracao(null);
            insp.getEquipeEmpreiteira().setDatHorCadastro(null);
            insp.getEquipeEmpreiteira().setIdEmpresa(null);
            insp.getEquipeEmpreiteira().setIdUsuarioIns(null);
            insp.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            return new ResponseEntity((Object)insp, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnaliseAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra/Atualiza a An\u00e1lise Ambiental")
    public ResponseEntity<AnaliseAmbiental> registrarAnalise(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            AnaliseAmbiental analise = (AnaliseAmbiental)mapper.readValue(((String[])formData.get("analise"))[0], (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            logger.debug("{} - registrarAnalise({}, {}))", new Object[]{usuario, empresa, analise});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (analise.getId().getIdEmpresa() == null) {
                    analise.getId().setIdEmpresa(emp.getId());
                }
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            AnaliseAmbiental inspDb = this.meioAmbienteService.registrarAnalise(analise, usuario.getLogin());
            if (anexos != null) {
                for (AnaliseAnexo anexo : anexos) {
                    this.internalSaveAnexo(inspDb.getId().getIdEmpresa(), inspDb.getId().getIdAnalise(), anexo, usuario.getLogin(), request);
                }
            }
            return new ResponseEntity((Object)inspDb, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarAnalise", (Throwable)jsmExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarAnalise", (Throwable)jspExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAnalise}"})
    @Operation(summary="Exclui a An\u00e1lise atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise) throws BusinessException {
        logger.debug("deleteAnalise({}, {})", (Object)empresa, (Object)idAnalise);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnalise(emp.getId(), idAnalise), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAnalise}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<AnaliseAnexo> createAnexoAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexo({},{})", (Object)empresa, (Object)idAnalise);
            Map formData = request.getParameterMap();
            AnaliseAnexo anexo = new AnaliseAnexo();
            if (formData.containsKey("comentario")) {
                anexo.setComentario(((String[])formData.get("comentario"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AnaliseAnexo response = this.internalSaveAnexo(emp.getId(), idAnalise, anexo, usuario.getLogin(), request);
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private AnaliseAnexo internalSaveAnexo(Integer idEmpresa, Integer idAnalise, AnaliseAnexo anexoAnalise, String usuario, HttpServletRequest request) {
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        Map filesMap = multipartReq.getFileMap();
        if (filesMap != null && !filesMap.isEmpty()) {
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            for (String fileReqName : filesMap.keySet()) {
                MultipartFile file = multipartReq.getFile(fileReqName);
                logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                Anexo anexoGed = this.gedService.createAnexo(idEmpresa, TipoModulo.MEIO_AMBIENTE.getSigla(), "An\u00e1lise", file.getOriginalFilename(), "Anexos", null, file, user.getId(), LocalDateTime.now());
                anexoAnalise.getId().setIdEmpresa(idEmpresa);
                anexoAnalise.setIdAnexo(anexoGed.getId().getIdAnexo());
                anexoAnalise.setAnexo(anexoGed);
            }
        }
        AnaliseAnexo anexoDB = this.meioAmbienteService.saveAnexoAnalise(idEmpresa, idAnalise, anexoAnalise, usuario);
        return anexoDB;
    }

    @GetMapping(value={"/{empresa}/{idAnalise}/anexos"})
    @Operation(summary="Lista os anexos presentes na An\u00e1lise Ambiental")
    public ResponseEntity<List<AnaliseAnexo>> findAnexosAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnexosAnalise(emp.getId(), idAnalise), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAnalise}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da An\u00e1lise Ambiental a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idAnalise, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoAnalise(emp.getId(), idAnalise, seqAnexo), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAnalise}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na An\u00e1lise Ambiental")
    public ResponseEntity<List<AnaliseHistorico>> findHistoricosAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idAnalise);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosAnalise(emp.getId(), idAnalise), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAnalise}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da An\u00e1lise Ambiental de acordo com o payload informado")
    public ResponseEntity<AnaliseHistorico> createHistoricoAnalise(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistorico({},{})", (Object)empresa, (Object)idAnalise);
            Map formData = request.getParameterMap();
            AnaliseHistorico anexo = new AnaliseHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AnaliseHistorico response = this.meioAmbienteService.saveHistoricoAnalise(emp.getId(), idAnalise, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistorico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idAnalise}"})
    @Operation(summary="Efetua o download da An\u00e1lise Ambiental em PDF")
    public ResponseEntity<byte[]> exportaAnalisePdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnalise") Integer idAnalise, HttpServletRequest request) throws IOException {
        logger.debug("Exportando PDF, Dep\u00f3sito (emp={}, {})...", (Object)empresa, (Object)idAnalise);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            byte[] bytes;
            AnaliseAmbiental analise = this.meioAmbienteService.getAnaliseById(emp.getId(), idAnalise);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (analise.getLatitude() != null && analise.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(analise.getLatitude(), analise.getLongitude(), tipoMapa);
            }
            if ((bytes = this.relatorioAnaliseAmbientalPdf.executePDF(emp.getId(), analise, mapaGoogle, false)) == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"deposito-materiais.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download de An\u00e1lises Ambientais em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable(name="empresa") String empresa, @RequestBody FiltroAnalise filtroAnalise, HttpServletRequest request) {
        logger.debug("Exportando excel, an\u00e1lises ambientais (emp={})...", (Object)empresa);
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroAnalise == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtroAnalise.getConcessionaria() == null || filtroAnalise.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtroAnalise.setConcessionaria(empList);
        }
        try {
            boolean joinItens = true;
            boolean joinAnexos = true;
            List analises = this.meioAmbienteService.findAnalises(filtroAnalise, Boolean.valueOf(joinItens), Boolean.valueOf(joinAnexos));
            List todosTiposAnalise = this.meioAmbienteService.findAnaliseTipos("");
            StreamingResponseBody responseBody = response -> response.write(new RelatorioAnaliseAmbientalExcel(this.meioAmbienteService).executeXLS(analises, todosTiposAnalise, filtroAnalise.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"an\u00e1lise-ambiental.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAnalise}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da An\u00e1lise Ambiental (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar, Encerrar, Finalizar, Reabrir)")
    public ResponseEntity<FichaEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idAnalise, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            FichaEvento evento;
            logger.debug("{} - executeEvento({},{},{})", new Object[]{usuario.getLogin(), empresa, idAnalise, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer seqAprovacao = null;
            if (request.getParameter("seqAprovacao") != null) {
                try {
                    seqAprovacao = Integer.valueOf(request.getParameter("seqAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    seqAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.meioAmbienteService.enviarAprovacaoAnalise(empresa, idAnalise, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.meioAmbienteService.aprovarAnalise(empresa, idAnalise, seqAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.meioAmbienteService.reprovarAnalise(empresa, idAnalise, seqAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.meioAmbienteService.encerrarAnalise(empresa, idAnalise, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.finalizarAnalise(empresa, idAnalise, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.naoFinalizarAnalise(empresa, idAnalise, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.meioAmbienteService.reabrirAnalise(empresa, idAnalise, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.meioAmbienteService.cancelarAnalise(empresa, idAnalise, usuario.getLogin(), descricao, perfilReprovar);
            } else {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAnalise}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados no Analise")
    public List<FichaAprovacao> findAprovacoesAnalise(@PathVariable String empresa, @PathVariable Integer idAnalise) {
        try {
            logger.debug("findAprovacoesAnalise({},{})", (Object)empresa, (Object)idAnalise);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            return this.meioAmbienteService.findAprovacoesById(emp.getId(), idAnalise, "ANA");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoesAnalise", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

