/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.licenca;

import br.com.oti.gesconsys.ambiental.beans.licenca.CondicionanteDocumento;
import br.com.oti.gesconsys.ambiental.beans.licenca.LicencaDocumento;
import br.com.oti.gesconsys.ambiental.beans.licenca.LicencaObra;
import br.com.oti.gesconsys.ambiental.beans.licenca.PlanoAcaoCondicionante;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Condicionante;
import br.com.oti.gesconsys.beans.shared.CondicionanteNota;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para licencas", name="ambiental")
@RequestMapping(value={"/api/licencas"})
public class LicencasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(LicencasRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta as licen\u00e7as de acordo com o filtro")
    public ResponseEntity<List<Licenca>> findLicencas(HttpServletRequest request, @PathVariable String empresa) {
        try {
            SimpleDateFormat dateFormat;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - findLicencas({})", (Object)usuario, (Object)empresa);
            String search = null;
            Integer idClasseLicenca = null;
            Integer idEntidade = null;
            String nroProcesso = null;
            Date datInicial = null;
            Date datFinal = null;
            Integer tipoIntervalo = null;
            Integer status = null;
            Object tipoLicenca = null;
            String param = request.getParameter("search");
            if (param != null && !param.isEmpty()) {
                search = param;
            }
            if ((param = request.getParameter("idClasseLicenca")) != null && !param.isEmpty()) {
                idClasseLicenca = Integer.valueOf(param);
            }
            if ((param = request.getParameter("idEntidade")) != null && !param.isEmpty()) {
                idEntidade = Integer.valueOf(param);
            }
            if ((param = request.getParameter("nroProcesso")) != null && !param.isEmpty()) {
                nroProcesso = param;
            }
            if ((param = request.getParameter("tipoIntervalo")) != null && !param.isEmpty()) {
                tipoIntervalo = Integer.valueOf(param);
            }
            if ((param = request.getParameter("dataInicial")) != null && !param.isEmpty()) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    dateFormat.setLenient(false);
                    datInicial = dateFormat.parse(param);
                }
                catch (ParseException pseExc) {
                    logger.error("pseExc", (Throwable)pseExc);
                }
            }
            if ((param = request.getParameter("dataFinal")) != null && !param.isEmpty()) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    dateFormat.setLenient(false);
                    datFinal = dateFormat.parse(param);
                }
                catch (ParseException pseExc) {
                    logger.error("pseExc", (Throwable)pseExc);
                }
            }
            if ((param = request.getParameter("status")) != null && !param.isEmpty()) {
                status = Integer.valueOf(param);
            }
            String[] empresasIdArray = request.getParameterValues("concessionarias");
            ArrayList<String> empresasIdList = new ArrayList<String>();
            if (empresasIdArray != null && empresasIdArray.length > 0) {
                for (String empId : empresasIdArray) {
                    empresasIdList.add(empId);
                }
            }
            ArrayList<Integer> tipoLicencasIdList = new ArrayList<Integer>();
            String[] tipoLicencasIdArray = request.getParameterValues("tipoLicenca");
            if (tipoLicencasIdArray != null && tipoLicencasIdArray.length > 0) {
                for (String licenca : tipoLicencasIdArray) {
                    tipoLicencasIdList.add(Integer.valueOf(licenca));
                }
            }
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            List licencas = this.meioAmbienteService.findLicencas(empresasInt, search, idEntidade, nroProcesso, idClasseLicenca, datInicial, datFinal, tipoIntervalo, status, empresasIdList, tipoLicencasIdList);
            return new ResponseEntity((Object)licencas, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLicencas", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findLicencas", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}"})
    @Operation(summary="Carrega dados da licen\u00e7a de acordo com o ID da licen\u00e7a")
    @ResponseBody
    public ResponseEntity<Licenca> getLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca) {
        logger.debug("API getLicenca...");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - getLicenca({})", (Object)usuario, (Object)empresa);
            Licenca lic = this.meioAmbienteService.getLicencaById(idLicenca);
            if (lic == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrada.");
            }
            lic.setEmpresa(null);
            return new ResponseEntity((Object)lic, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getLicenca", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva a Licen\u00e7a")
    public ResponseEntity<Licenca> saveLicenca(@PathVariable(name="empresa") String empresa, @RequestBody Licenca licenca, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveLicenca ({}, {}))", new Object[]{usuario, empresa, licenca});
            return new ResponseEntity((Object)this.meioAmbienteService.saveLicenca(licenca, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}"})
    @Operation(summary="Exclui a Licen\u00e7a atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteLicenca({}, {})", new Object[]{usuario, empresa, idLicenca});
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteLicenca(idLicenca, this.getIpExterno(request)), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/documentos"})
    @Operation(summary="Consulta os documentos de acordo com a Licen\u00e7a")
    @ResponseBody
    public ResponseEntity<List<LicencaDocumento>> findDocumentosByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findDocumentosByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List documentos = this.meioAmbienteService.findDocumentosByLicenca(idLicenca);
            return new ResponseEntity((Object)documentos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDocumentosByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findDocumentosByLicenca", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/documentos/{seqArquivo}"})
    @Operation(summary="Carrega dados do documento de acordo com o ID da licen\u00e7a")
    @ResponseBody
    public ResponseEntity<LicencaDocumento> getDocumentoByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="seqArquivo") Integer seqArquivo) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            LicencaDocumento doc = this.meioAmbienteService.getDocumentoLicencaBySeq(idLicenca, seqArquivo);
            if (doc == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Documento n\u00e3o encontrado.");
            }
            logger.debug("{} - getDocumentoByLicenca({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)doc, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getDocumento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idLicenca}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o Documento")
    public ResponseEntity<List<LicencaDocumento>> saveDocumentoByLicenca(@PathVariable(name="empresa") String empresa, @RequestBody LicencaDocumento licencaDocumento, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveDocumentoByLicenca ({}, {}))", new Object[]{usuario, empresa, licencaDocumento});
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<LicencaDocumento> documentos = new ArrayList<LicencaDocumento>();
            for (MultipartFile file : filesMap) {
                LicencaDocumento documento = new LicencaDocumento();
                documento.setAnexo(new Anexo());
                documento.getAnexo().setNome(file.getOriginalFilename());
                documentos.add(documento);
            }
            LicencaDocumento response = this.meioAmbienteService.registraUploadAnexoLicenca(licencaDocumento, usr.getId());
            List<LicencaDocumento> responseList = Collections.singletonList(response);
            return new ResponseEntity(responseList, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> removeDocumentoLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="seqArquivo") Integer seqArquivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteDocumento({}, {})", new Object[]{usuario, empresa, seqArquivo});
            this.meioAmbienteService.removeDocumentoLicenca(idLicenca, emp.getId(), seqArquivo, null, null);
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/condicionantes"})
    @Operation(summary="Consulta as condicionantes de acordo com a Licen\u00e7a")
    @ResponseBody
    public ResponseEntity<List<Condicionante>> findCondicionantesByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") List<Integer> idLicenca) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
        if (empresaDB == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        logger.debug("{} - findCondicionantesByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List condicionantesCache = this.meioAmbienteService.findCondicionantesByLicenca(empresaDB.getId(), idLicenca, null);
            return new ResponseEntity((Object)condicionantesCache, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionantesByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionantesByLicenca", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/condicionantes/{idCondicionante}"})
    @Operation(summary="Carrega dados da condicionante de acordo com o ID")
    @ResponseBody
    public ResponseEntity<Condicionante> getCondicionanteById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            Condicionante con = this.meioAmbienteService.getCondicionanteById(idCondicionante);
            if (con == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getCondicionanteById({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)con, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionante", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/condicionantes"})
    @Operation(summary="Salva a Condicionante")
    public ResponseEntity<Condicionante> saveCondicionanteByLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @RequestBody Condicionante condicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveCondicionanteByLicenca ({}, {}))", new Object[]{usuario, empresa, condicionante});
            return new ResponseEntity((Object)this.meioAmbienteService.saveCondicionante(condicionante, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/condicionantes/{idCondicionante}"})
    @Operation(summary="Exclui a Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteCondicionanteByLicenca(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCondicionante") Integer idCondicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteCondicionanteByLicenca({}, {})", new Object[]{usuario, empresa, idCondicionante});
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCondicionante(idCondicionante), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas"})
    @Operation(summary="Consulta as notas de acordo com a Condicionante")
    @ResponseBody
    public ResponseEntity<List<CondicionanteNota>> findCondicionanteNota(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idEmpresa, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findCondicionanteNota({})", (Object)usuario, (Object)empresa);
        try {
            List condicionantes = this.meioAmbienteService.findCondicionanteNota(idCondicionante, null);
            if (condicionantes.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)condicionantes, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Carrega dados da nota de acordo com o ID da condicionante")
    @ResponseBody
    public ResponseEntity<CondicionanteNota> getCondicionanteNota(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="idNota") Integer idNota) {
        logger.debug("API getCondicionanteNota...");
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            CondicionanteNota not = this.meioAmbienteService.getCondicionanteNota(idCondicionante, idNota);
            if (not == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Nota da Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getCondicionanteNota({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)not, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas"})
    @Operation(summary="Salva a Nota")
    public ResponseEntity<CondicionanteNota> saveCondicionanteNota(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @RequestBody CondicionanteNota condicionanteNota, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveCondicionanteNota ({}, {}))", new Object[]{usuario, empresa, condicionanteNota});
            return new ResponseEntity((Object)this.meioAmbienteService.saveCondicionanteNota(condicionanteNota, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Exclui a Nota da Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteCondicionanteNota(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="idNota") Integer idNota, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteCondicionanteNota({}, {})", new Object[]{usuario, empresa, idNota});
            this.meioAmbienteService.deleteCondicionanteNota(idCondicionante, idNota);
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao"})
    @Operation(summary="Consulta os planos de a\u00e7\u00e3o de acordo com a Condicionante")
    @ResponseBody
    public ResponseEntity<List<PlanoAcaoCondicionante>> findPlanosAcao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("findCondicionanteNota ({})", (Object)idCondicionante);
        try {
            List planosAcao = this.meioAmbienteService.findPlanosAcao(emp.getId(), idCondicionante);
            if (planosAcao.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)planosAcao, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Carrega dados do Plano de A\u00e7\u00e3o de acordo com o ID da condicionante")
    @ResponseBody
    public ResponseEntity<PlanoAcaoCondicionante> getPlanoAcaoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PlanoAcaoCondicionante plano = this.meioAmbienteService.getPlanoAcaoById(emp.getId(), idPlanoAcao);
            if (plano == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrada.");
            }
            logger.debug("{} - getCondicionanteNota({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)plano, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCondicionante}/planosAcao"})
    @Operation(summary="Salva o Plano de A\u00e7\u00e3o")
    public ResponseEntity<PlanoAcaoCondicionante> savePlanoAcao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCondicionante") Integer idCondicionante, @RequestBody PlanoAcaoCondicionante planoAcaoCondicionante, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - savePlanoAcaoCondicionante ({}, {}))", new Object[]{usuario, empresa, planoAcaoCondicionante});
            return new ResponseEntity((Object)this.meioAmbienteService.savePlanoAcao(planoAcaoCondicionante, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Exclui o Plano de A\u00e7\u00e3o atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deletePlanoAcao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="idPlanoAcao") Integer idPlanoAcao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deletePlanoAcao({}, {})", new Object[]{usuario, empresa, idPlanoAcao});
            this.meioAmbienteService.deletePlanoAcao(emp.getId(), idPlanoAcao);
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos"})
    @Operation(summary="Consulta os documentos de acordo com a Condicionante")
    @ResponseBody
    public ResponseEntity<List<CondicionanteDocumento>> findDocumentosByCondicionante(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findDocumentosByCondicionante({})", (Object)usuario, (Object)empresa);
        try {
            List documentos = this.meioAmbienteService.findDocumentosByCondicionante(idCondicionante);
            if (documentos.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)documentos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Carrega dados do documento de acordo com o ID da condicionante")
    @ResponseBody
    public ResponseEntity<CondicionanteDocumento> getDocumentoBySeq(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="seqArquivo") Integer seqArquivo) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            CondicionanteDocumento doc = this.meioAmbienteService.getDocumentoBySeq(idCondicionante, seqArquivo);
            if (doc == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Documento da Condicionante n\u00e3o encontrada.");
            }
            logger.debug("{} - getDocumentoBySeq({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)doc, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos"})
    @Operation(summary="Salva o Documento de acordo com a Condicionante")
    public ResponseEntity<CondicionanteDocumento> saveCondicionanteDocumento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @RequestBody CondicionanteDocumento condicionanteDocumento, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveCondicionanteDocumento ({}, {}))", new Object[]{usuario, empresa, condicionanteDocumento});
            return new ResponseEntity((Object)this.meioAmbienteService.registraUploadAnexo(condicionanteDocumento, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento da Condicionante atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> removeDocumento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idCondicionante") Integer idCondicionante, @PathVariable(name="seqArquivo") Integer seqArquivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - deleteDocumento({}, {})", new Object[]{usuario, empresa, seqArquivo});
            this.meioAmbienteService.removeDocumento(idCondicionante, emp.getId(), seqArquivo, null, null);
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/obras"})
    @Operation(summary="Consulta as obras de acordo com a Licen\u00e7a")
    @ResponseBody
    public ResponseEntity<List<LicencaObra>> findObrasByLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findObrasByLicenca({})", (Object)usuario, (Object)empresa);
        try {
            List obras = this.meioAmbienteService.findObrasByLicenca(idLicenca);
            return new ResponseEntity((Object)obras, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObrasByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findObrasByLicenca", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idLicenca}/obras/{idObra}"})
    @Operation(summary="Carrega dados da obra de acordo com o ID da licen\u00e7a")
    @ResponseBody
    public ResponseEntity<LicencaObra> getLicencaObraById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="idObra") Integer idObra) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            LicencaObra doc = this.meioAmbienteService.getLicencaObraById(idLicenca, idObra, emp.getId());
            if (doc == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Obra n\u00e3o encontrada.");
            }
            logger.debug("{} - getLicencaObraById({})", (Object)usuario, (Object)empresa);
            return new ResponseEntity((Object)doc, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getObra", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getObra", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idLicenca}/obras"})
    @Operation(summary="Salva a obra")
    public ResponseEntity<LicencaObra> saveLicencaObra(@PathVariable(name="empresa") String empresa, @RequestBody LicencaObra licencaObra, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveLicencaObra ({}, {}))", new Object[]{usuario, empresa, licencaObra});
            return new ResponseEntity((Object)this.meioAmbienteService.saveLicencaObra(licencaObra, usr.getId()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveObra", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idLicenca}/obras/{seqObra}"})
    @Operation(summary="Exclui a obra atrav\u00e9s de seu identificador")
    public ResponseEntity<Boolean> deleteLicencaObra(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLicenca") Integer idLicenca, @PathVariable(name="seqObra") Integer sequencia, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteLicencaObra({}, {})", new Object[]{usuario, empresa, idLicenca});
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteLicencaObra(idLicenca, emp.getId(), sequencia), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLicencaObra", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

