/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental;

import br.com.oti.gesconsys.ambiental.beans.FichaAmbiental;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListEstrutura;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItemVO;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListVO;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.fichas.CalendarioFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.OcorrenciaFichaVO;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroFichaAmbiental;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.shared.Equipe;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.ambiental.AmbientalAnalisesRestServices;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Endpoints para An\u00e1lises do Ambiental, para uso em Dashboards e BI", name="ambiental")
@RequestMapping(value={"/api/ambiental/analises"})
public class AmbientalAnalisesRestServices {
    private static Logger logger = LoggerFactory.getLogger(AmbientalAnalisesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService ambientalService;

    @PostMapping(value={"/fichas/{tipoFicha}"})
    public ResponseEntity<List<FichaAmbiental>> findFichas(@PathVariable(name="tipoFicha") String tipoFicha, @RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request, HttpServletResponse response) {
        try {
            HashMap<Integer, Cidade> cidadesMap = new HashMap<Integer, Cidade>();
            List cidades = this.cadastroService.findCidades(null, null);
            for (Cidade cid : cidades) {
                cidadesMap.put(cid.getId(), cid);
            }
            1 copyBean = new /* Unavailable Anonymous Inner Class!! */;
            ArrayList retorno = new ArrayList();
            if (tipoFicha.equalsIgnoreCase("rac")) {
                FiltroRac filtroRac = new FiltroRac();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                List empresas = this.cadastroService.findEmpresas(null, null);
                Map empresasMap = empresas.stream().collect(Collectors.toMap(Empresa::getId, Function.identity()));
                Page racs = this.ambientalService.findRacs(filtroRac, 1, 50000, "numero", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
                for (Rac rac : racs) {
                    if (rac.getCidade() == null) {
                        rac.setCidade((Cidade)cidadesMap.get(rac.getIdCidade()));
                    }
                    if (rac.getRodovia() != null) {
                        rac.getRodovia().setEmpresa(null);
                    }
                    Empresa empMap = (Empresa)empresasMap.get(rac.getId().getIdEmpresa());
                    Empresa newEmp = new Empresa();
                    if (empMap != null) {
                        newEmp.setSigla(empMap.getSigla());
                        newEmp.setNomeFantasia(empMap.getNomeFantasia());
                    }
                    rac.setEmpresa(newEmp);
                }
                retorno.addAll(racs.getContent());
            } else if (tipoFicha.equalsIgnoreCase("inspe") || tipoFicha.equalsIgnoreCase("inspecoes") || tipoFicha.equalsIgnoreCase("inspecao")) {
                FiltroInspecao filtroRac = new FiltroInspecao();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                Page lista = this.ambientalService.findInspecoes(filtroRac, 1, 50000, "numero", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
                retorno.addAll(lista.getContent());
            } else if (tipoFicha.equalsIgnoreCase("areasApoio")) {
                FiltroAreaApoio filtroRac = new FiltroAreaApoio();
                copyBean.copyProperties((Object)filtroRac, (Object)filtroFicha);
                List lista = this.ambientalService.findAreasApoio(filtroRac, Boolean.valueOf(false), Boolean.valueOf(false));
                retorno.addAll(lista);
            }
            return new ResponseEntity(retorno, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IllegalAccessException iaeExc) {
            logger.error("IllegalAccessExc.findRacs", (Throwable)iaeExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, iaeExc.getMessage());
        }
        catch (InvocationTargetException iteExc) {
            logger.error("InvocTargExc.findRacs", (Throwable)iteExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, iteExc.getMessage());
        }
    }

    @PostMapping(value={"/checklists"})
    public ResponseEntity<Page<CheckListVO>> findCheckLists(@RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Carregando checklists - dashboards, filtro={}...", (Object)filtroFicha);
        try {
            int pageNbr = 1;
            int pageSize = 15;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            HashMap<Integer, Cidade> cidadesMap = new HashMap<Integer, Cidade>();
            List cidades = this.cadastroService.findCidades(null, null);
            for (Cidade cid : cidades) {
                cidadesMap.put(cid.getId(), cid);
            }
            2 copyBean = new /* Unavailable Anonymous Inner Class!! */;
            FiltroChecklist filtroChkLst = new FiltroChecklist();
            copyBean.copyProperties((Object)filtroChkLst, (Object)filtroFicha);
            if (filtroChkLst.getModulo() == null) {
                filtroChkLst.setModulo("AMB");
            }
            ArrayList<CheckListVO> checkLists = new ArrayList<CheckListVO>();
            Page lista = this.ambientalService.findCheckListsMobile(filtroChkLst, pageNbr, pageSize, "numero", Boolean.valueOf(false), Boolean.valueOf(false), null);
            for (CheckList item : lista) {
                Object emp;
                Cidade cid;
                item.setDatHorCadastro(null);
                item.setDatHorAlteracao(null);
                Rodovia rdv = item.getRodovia();
                if (rdv != null) {
                    rdv.setEmpresa(null);
                    rdv.setDatHorCadastro(null);
                    rdv.setDatHorAlteracao(null);
                }
                if ((cid = item.getCidade()) != null) {
                    cid.setDatHorAlteracao(null);
                    cid.setDatHorCadastro(null);
                }
                if ((emp = item.getEmpresa()) != null) {
                    emp.setDatHorAlteracao(null);
                    emp.setDatHorCadastro(null);
                    emp.setCidade(null);
                    emp.setPoderConcedente(null);
                }
                CheckListVO checkLst = new CheckListVO();
                checkLst.setIdCheckList(item.getId().getIdCheckList());
                checkLst.setNumero(item.getNumero());
                checkLst.setDatInspecao(item.getDatInspecao());
                checkLists.add(checkLst);
            }
            PageImpl pages = new PageImpl(checkLists, lista.getPageable(), (long)checkLists.size());
            for (CheckList row : lista) {
                ArrayList<CheckListItemVO> items;
                CheckListVO chkLst = null;
                for (CheckListVO item : checkLists) {
                    if (!item.getIdCheckList().equals(row.getId().getIdCheckList())) continue;
                    chkLst = item;
                    break;
                }
                if ((items = chkLst.getItens()) == null) {
                    items = new ArrayList<CheckListItemVO>();
                    chkLst.setItens(items);
                }
                for (CheckListItem item : row.getItens()) {
                    PontoControle ptc;
                    CheckListItemVO itemVO = new CheckListItemVO();
                    itemVO.setIdEmpresa(item.getId().getIdEmpresa());
                    itemVO.setIdCheckList(item.getId().getIdCheckList());
                    itemVO.setModulo(item.getId().getModulo());
                    itemVO.setSequencia(item.getId().getSequencia());
                    itemVO.setIdEstrutura(item.getIdEstrutura());
                    CheckListEstrutura estr = item.getEstrutura();
                    if (estr != null) {
                        itemVO.setNumeroItem(estr.getNumero());
                        itemVO.setItemVerificavel(estr.getDescricao());
                    }
                    itemVO.setData(item.getData());
                    itemVO.setValor(item.getValor());
                    itemVO.setObservacao(item.getObservacao());
                    itemVO.setIqmaCalc(item.getIqmaCalc());
                    itemVO.setNumero(chkLst.getNumero());
                    itemVO.setDatCriacao(row.getDatCriacao());
                    itemVO.setDescricao(row.getDescricao());
                    itemVO.setContrato(row.getContrato());
                    itemVO.setKilometro(row.getKilometro());
                    itemVO.setMetros(row.getMetros());
                    itemVO.setLocal(row.getLocal());
                    itemVO.setDirecao(row.getDirecao());
                    itemVO.setZona(row.getZona());
                    itemVO.setCoordenadaX(row.getCoordenadaX());
                    itemVO.setCoordenadaY(row.getCoordenadaY());
                    itemVO.setLatitude(row.getLatitude());
                    itemVO.setLongitude(row.getLongitude());
                    itemVO.setStatus(row.getStatus());
                    itemVO.setCidade(row.getCidade());
                    itemVO.setObra(row.getObra());
                    Rodovia rdv = row.getRodovia();
                    if (rdv != null) {
                        rdv.setEmpresa(null);
                        rdv.setDatHorCadastro(null);
                        rdv.setDatHorAlteracao(null);
                    }
                    itemVO.setRodovia(rdv);
                    itemVO.setSupervisorAmbiental(row.getSupervisorAmbiental());
                    itemVO.setCoordenadorObra(row.getCoordenadorObra());
                    itemVO.setCoordenadorAmbiental(row.getCoordenadorAmbiental());
                    itemVO.setEquipeConcessao(row.getEquipeConcessao());
                    itemVO.setEquipeEmpreiteira(row.getEquipeEmpreiteira());
                    itemVO.setEquipeAmbiental(row.getEquipeAmbiental());
                    if (row.getFicha() != null) {
                        itemVO.setTipoFicha(row.getFicha().getDescricao());
                    }
                    if ((ptc = row.getPontoControle()) != null) {
                        ptc.setRodovia(null);
                        ptc.setCidade(null);
                        ptc.setObra(null);
                    }
                    itemVO.setPontoControle(ptc);
                    items.add(itemVO);
                }
            }
            logger.debug("Retornando itens.checklists, total = {}", (Object)pages.getTotalElements());
            return new ResponseEntity((Object)pages, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCheckLists", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IllegalAccessException iaeExc) {
            logger.error("IllegalAccessExc.findCheckLists", (Throwable)iaeExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, iaeExc.getMessage());
        }
        catch (InvocationTargetException iteExc) {
            logger.error("InvocTargExc.findCheckLists", (Throwable)iteExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, iteExc.getMessage());
        }
    }

    @GetMapping(value={"/cadastros/{tipo}"})
    public ResponseEntity<List<KeyValue>> findCadastros(@PathVariable(name="tipo") String tipo, HttpServletRequest request) {
        try {
            ArrayList<KeyValue> retorno = new ArrayList<KeyValue>();
            if (tipo.equalsIgnoreCase("cidade")) {
                List cidades = this.cadastroService.findCidades(null, null);
                for (Cidade cid : cidades) {
                    retorno.add(new KeyValue((Object)cid.getId(), cid.getDescricao()));
                }
            } else if (tipo.equalsIgnoreCase("rodovia")) {
                List rodovias = this.cadastroService.findRodovias(null, null, null);
                for (Rodovia rdv : rodovias) {
                    retorno.add(new KeyValue((Object)rdv.getId(), rdv.getDescricao()));
                }
            }
            return new ResponseEntity(retorno, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacs", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/calendario/{tipoFicha}"})
    public ResponseEntity<List<CalendarioFichaVO>> findCalendario(@PathVariable(name="tipoFicha") String tipoFicha, @RequestBody FiltroFichaAmbiental filtroFicha, HttpServletRequest request) {
        try {
            List calendario = this.ambientalService.findResumoMensalStatusByFicha(tipoFicha, filtroFicha);
            return new ResponseEntity((Object)calendario, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCalendario", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/equipes/{tipoEquipe}"})
    @Operation(summary="Retorna uma listagem das equipes, de acordo com tipo (E - Empreiteira; C - Concession\u00e1ria; A - Ambiental)")
    @ResponseBody
    public ResponseEntity<List<Equipe>> findEquipes(@PathVariable(name="tipoEquipe") String tipoEquipe, HttpServletRequest request) {
        try {
            logger.debug("findEquipes, dashboard Ambiental...");
            List equipes = this.cadastroService.findEquipes(null, null, tipoEquipe, null, null);
            for (Equipe eqp : equipes) {
                eqp.setTipo(null);
            }
            return new ResponseEntity((Object)equipes, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ocorrencias/{tipoFicha}"})
    @Operation(summary="Retorna uma listagem das ocorr\u00eancias, para todas as empresas")
    @ResponseBody
    public ResponseEntity<List<OcorrenciaFichaVO>> findOcorrencias(@PathVariable(name="tipoFicha") String tipoFicha, HttpServletRequest request) {
        try {
            logger.debug("findOcorrencias({}), dashboard Ambiental...", (Object)tipoFicha);
            List ocorrencias = this.ambientalService.findOcorrenciasByFicha(tipoFicha);
            return new ResponseEntity((Object)ocorrencias, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

