/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.GrupoServico;
import br.com.oti.gesconsys.beans.shared.Parametro;
import br.com.oti.gesconsys.beans.shared.Servico;
import br.com.oti.gesconsys.beans.shared.ServicoParametro;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.beans.ServicoJson;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Cadastro de servi\u00e7os da Engenharia", name="servi\u00e7os")
@RequestMapping(value={"/api/servicos"})
public class ServicosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ServicosRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;

    @GetMapping(value={"/{empresa}"})
    @ResponseBody
    public ResponseEntity<List<Servico>> findServicos(HttpServletRequest request, @PathVariable(value="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Long lastUpdateVal = null;
        if (request.getParameter("lastUpdate") != null) {
            lastUpdateVal = Long.valueOf(request.getParameter("lastUpdate"));
        }
        try {
            List servicos;
            logger.debug("findServicos({})", (Object)empresa);
            LocalDateTime lastUpdt = null;
            if (lastUpdateVal != null) {
                lastUpdt = Instant.ofEpochMilli(lastUpdateVal).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            if ((servicos = this.cadastroService.findServicos(empresa, null, lastUpdt)) != null) {
                for (Servico servico : servicos) {
                    servico.setParametros(null);
                    if (servico.getGrupoServico() != null) {
                        GrupoServico grupo = servico.getGrupoServico();
                        grupo.setDatHorCadastro(null);
                        grupo.setDatHorAlteracao(null);
                        grupo.setIdUsuarioIns(null);
                        grupo.setIdUsuarioUpd(null);
                    }
                    servico.setDatHorCadastro(null);
                    servico.setDatHorAlteracao(null);
                    servico.setIdUsuarioIns(null);
                    servico.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)servicos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveServico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idServico}"})
    @ResponseBody
    public ResponseEntity<Servico> getServico(@PathVariable(value="empresa") String empresa, @PathVariable(value="idServico") Integer idServico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getServico({},{})", (Object)empresa, (Object)idServico);
            Servico servico = this.cadastroService.getServicoById(empresa, idServico);
            if (servico != null) {
                servico.setDatHorAlteracao(null);
                servico.setDatHorCadastro(null);
                servico.setIdUsuarioIns(null);
                servico.setIdUsuarioUpd(null);
                servico.setParametros(new HashSet(this.cadastroService.findParametrosServico(servico.getId().getIdEmpresa(), servico.getId().getIdServico())));
                if (servico.getParametros() != null) {
                    for (ServicoParametro servParm : servico.getParametros()) {
                        servParm.setServico(null);
                        servParm.setDatHorCadastro(null);
                        servParm.setIdUsuarioIns(null);
                        Parametro parm = servParm.getParametro();
                        parm.setDatHorCadastro(null);
                        parm.setDatHorAlteracao(null);
                    }
                }
            }
            return new ResponseEntity((Object)servico, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getServico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/resumo"})
    @ResponseBody
    public List<ServicoJson> findResumoServicos(@PathVariable(value="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("findResumoServicos({})", (Object)empresa);
        ArrayList<ServicoJson> svcs = new ArrayList<ServicoJson>();
        for (Servico tipoLoop : this.cadastroService.findServicos(empresa, null, null)) {
            ServicoJson svcJson = new ServicoJson(tipoLoop);
            svcs.add(svcJson);
        }
        logger.debug("Leitura dos tipos de ocorr\u00eancia finalizada.");
        return svcs;
    }

    @GetMapping(value={"/{empresa}/pixmaps"})
    @ResponseBody
    public ResponseEntity<List<ServicoJson>> findPixmapImage(@PathVariable(value="empresa") String empresa, @RequestParam(value="tipos") List<Integer> servicosId, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (servicosId == null || servicosId.isEmpty()) {
            return null;
        }
        logger.debug("findPixmapImage({},{})", (Object)empresa, servicosId);
        logger.debug("Iniciando carga dos pixmaps de ocorr\u00eancias...");
        ArrayList<ServicoJson> svcs = new ArrayList<ServicoJson>();
        for (Servico tipoLoop : this.cadastroService.findServicos(empresa, null, null)) {
            if (tipoLoop.getNomeImagem() == null || tipoLoop.getNomeImagem().isEmpty()) continue;
            for (Integer idTipoOcorrencia : servicosId) {
                File fileImage;
                if (!tipoLoop.getId().getIdServico().equals(idTipoOcorrencia)) continue;
                ServicoJson servicoJson = new ServicoJson(tipoLoop);
                String nomeImagem = this.getPixmapImagePath(empresa, tipoLoop);
                if (nomeImagem != null && (fileImage = new File(nomeImagem)).exists()) {
                    try {
                        byte[] imgData = Files.readAllBytes(Paths.get(nomeImagem, new String[0]));
                        servicoJson.setImagemBase64(Base64.getEncoder().encodeToString(imgData));
                    }
                    catch (IOException ioExc) {
                        logger.error("IOExc", (Throwable)ioExc);
                    }
                }
                svcs.add(servicoJson);
            }
        }
        logger.debug("Leitura dos pixmaps finalizada, retornando JSON do TipoOcorrenciaJSON.");
        return new ResponseEntity(svcs, HttpStatus.OK);
    }

    private String getPixmapPath(String siglaEmpresa, Servico tipoOcorrencia, String defPath) {
        if (tipoOcorrencia == null) {
            return null;
        }
        if (defPath == null || defPath.isEmpty()) {
            return null;
        }
        StringBuilder fullPixmapPath = new StringBuilder();
        fullPixmapPath.append(defPath);
        fullPixmapPath.append(File.separator);
        fullPixmapPath.append(siglaEmpresa);
        fullPixmapPath.append(File.separator);
        fullPixmapPath.append("pix");
        fullPixmapPath.append(File.separator);
        return fullPixmapPath.toString();
    }

    private String getPixmapImagePath(String siglaEmpresa, Servico tipoOcorrencia) {
        if (tipoOcorrencia == null || tipoOcorrencia.getNomeImagem() == null || tipoOcorrencia.getNomeImagem().isEmpty()) {
            return null;
        }
        String defPath = this.coreService.getRepoPath(siglaEmpresa);
        return String.format("%s%s%s", this.getPixmapPath(siglaEmpresa, tipoOcorrencia, defPath), File.separator, tipoOcorrencia.getNomeImagem());
    }

    @PostMapping
    @ResponseBody
    public ResponseEntity<Servico> saveServico(@RequestBody Servico servico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveServico({})", (Object)servico);
            return new ResponseEntity((Object)this.cadastroService.saveServico(servico, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveServico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idServico}"})
    @ResponseBody
    public ResponseEntity<Boolean> deleteServico(@PathVariable(value="empresa") String empresa, @PathVariable(value="idServico") Integer idServico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteServico({},{})", (Object)empresa, (Object)idServico);
            Boolean deleted = false;
            this.cadastroService.deleteServico(empresa, idServico);
            deleted = true;
            return new ResponseEntity((Object)deleted, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteServico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idServico}/parametro"})
    @ResponseBody
    public ResponseEntity<Boolean> saveParametro(@PathVariable(value="empresa") String empresa, @PathVariable(value="idServico") Integer idServico, @RequestBody List<Parametro> parametros, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveParametro({})", parametros);
            Boolean saved = false;
            if (parametros != null) {
                for (Parametro prm : parametros) {
                    ServicoParametro svc = new ServicoParametro();
                    svc.getId().setIdServico(idServico);
                    svc.getId().setIdEmpresa(prm.getId());
                    svc.setDatHorCadastro(new Date(System.currentTimeMillis()));
                    this.cadastroService.saveParametro(prm, usuario.getLogin());
                    saved = true;
                }
            }
            return new ResponseEntity((Object)saved, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveParametro", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

