/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.obrigacao.TipoPeriodicidade;
import br.com.oti.gesconsys.beans.obrigacao.TipoStatusLancamentoObrigacao;
import br.com.oti.gesconsys.beans.relacoes.RegistroInformacao;
import br.com.oti.gesconsys.beans.relacoes.RegistroReuniao;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.CalendarioEvento;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.beans.shared.ObrigacaoContratual;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.business.services.RelacaoInstitucionalService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services dos Calend\u00e1rios", name="calendario")
@RequestMapping(value={"/api/calendarios"})
public class CalendariosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CalendariosRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private RelacaoInstitucionalService relacaoInstitucionalService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/eventos"})
    @Operation(summary="Retorna os eventos do(s) m\u00f3dulo(s) selecionado(s).")
    @ResponseBody
    public ResponseEntity<List<CalendarioEvento>> findEventosCalendario(@PathVariable(value="empresa") String empresa, @RequestParam(name="modulos", required=false) String modulos, @RequestParam(name="areas", required=false) String areas, @RequestParam(name="idTipoDocumento", required=false) Integer idTipoDocumento, @RequestParam(name="dataInicial", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(name="dataFinal", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal, @RequestParam(name="entidades", required=false) String entidades, @RequestParam(name="statusObrigacoes", required=false) Integer statusObrigacoes, @RequestParam(name="periodicidade", required=false) String periodicidade, @RequestParam(name="statusLancamentos", required=false) String statusLancamentos, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            ArrayList eventos = new ArrayList();
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (modulos == null || modulos.isEmpty()) {
                String modulosDB = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_MODULOS_ATIVOS);
                modulos = modulosDB.replaceAll(";", ",");
            }
            ArrayList<Integer> areasId = new ArrayList<Integer>();
            if (areas != null && !areas.isEmpty()) {
                String[] areasTxt = areas.split(",");
                List areasLst = this.cadastroService.findAreasByEmpresa(emp.getId(), Boolean.valueOf(false));
                block2: for (String areaId : areasTxt) {
                    for (EmpresaArea area : areasLst) {
                        if (!areaId.trim().equals(area.getId().toString())) continue;
                        areasId.add(area.getId());
                        continue block2;
                    }
                }
            }
            if (modulos.contains(TipoModulo.MEIO_AMBIENTE.getSigla())) {
                eventos.addAll(this.loadEventosLicencas(emp.getId(), dataInicial, dataFinal));
            }
            if (modulos.contains(TipoModulo.OBRIGACOES.getSigla())) {
                eventos.addAll(this.loadEventosObrigacoes(emp.getId(), idTipoDocumento, dataInicial, dataFinal, areasId, statusObrigacoes, statusLancamentos, periodicidade));
            }
            if (modulos.contains(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla())) {
                eventos.addAll(this.loadEventosRelacoes(emp.getId(), dataInicial, dataFinal, entidades));
            }
            return new ResponseEntity(eventos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findEventos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private List<CalendarioEvento> loadEventosLicencas(Integer idEmpresa, LocalDate dataInicial, LocalDate dataFinal) {
        List licencasDB;
        ArrayList<Integer> empresasInt = new ArrayList<Integer>();
        empresasInt.add(idEmpresa);
        Object idArea = null;
        Object status = null;
        Object idResponsavel = null;
        ArrayList<CalendarioEvento> eventos = new ArrayList<CalendarioEvento>();
        Date datInicial = null;
        Date datFinal = null;
        if (dataInicial != null) {
            datInicial = Date.from(dataInicial.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (dataFinal != null) {
            datFinal = Date.from(dataFinal.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if ((licencasDB = this.meioAmbienteService.findLicencas(empresasInt, null, null, null, null, datInicial, datFinal, null, null, null, null)) != null) {
            Calendar calVencimento = GregorianCalendar.getInstance();
            for (Licenca licenca : licencasDB) {
                if (licenca.getDataVencimento() == null) continue;
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(licenca.getId().toString());
                evento.setIdEmpresa(licenca.getIdEmpresa());
                evento.setTitulo(licenca.getDescricao());
                evento.setDescricao(licenca.getObservacao());
                calVencimento.setTime(licenca.getDataVencimento());
                evento.setData(calVencimento.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (licenca.getResponsavelArea() != null) {
                    evento.setNome(licenca.getResponsavelArea().getNome());
                }
                evento.setModulo(TipoModulo.MEIO_AMBIENTE.getSigla());
                evento.setModuloItem("Licen\u00e7as");
                eventos.add(evento);
            }
        }
        return eventos;
    }

    private List<CalendarioEvento> loadEventosObrigacoes(Integer idEmpresa, Integer idTipoDocumento, LocalDate dataInicial, LocalDate dataFinal, List<Integer> areasId, Integer statusObrigacao, String statusLancamento, String periodicidade) {
        ArrayList<Integer> empresasInt = new ArrayList<Integer>();
        empresasInt.add(idEmpresa);
        LocalDate hoje = LocalDate.now();
        if (statusLancamento != null) {
            if (statusLancamento.equals("P")) {
                statusObrigacao = TipoStatusLancamentoObrigacao.PENDENTE.getCode();
            } else if (statusLancamento.equals("A")) {
                statusObrigacao = TipoStatusLancamentoObrigacao.INTEGRADO.getCode();
            } else if (statusLancamento.equals("E")) {
                statusObrigacao = TipoStatusLancamentoObrigacao.ENCERRADO.getCode();
            }
        }
        List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, null, areasId, idTipoDocumento, statusObrigacao, null, null, dataInicial, dataFinal, periodicidade, null, null, Boolean.valueOf(false));
        ArrayList<CalendarioEvento> eventos = new ArrayList<CalendarioEvento>();
        if (obrigacoesDB != null) {
            for (ObrigacaoLancamento lcto : obrigacoesDB) {
                ObrigacaoContratual obrigacao = lcto.getObrigacao();
                if (obrigacao.getPeriodicidade().equals(TipoPeriodicidade.EVENTUAL.getCode())) continue;
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(lcto.getId().getIdObrigacao().toString());
                evento.setIdEmpresa(lcto.getId().getIdEmpresa());
                evento.setSequencia(lcto.getId().getSequencia());
                evento.setTitulo(obrigacao.getNome());
                evento.setDescricao(obrigacao.getDescricao());
                if (obrigacao.getClassificacao() != null) {
                    evento.setTipoDocumento(obrigacao.getClassificacao().getDescricao());
                }
                evento.setData(lcto.getDatObrigacao());
                if (lcto.getDatEncerramento() != null) {
                    evento.setDatConclusao(lcto.getDatEncerramento().toLocalDate());
                }
                evento.setStatus(lcto.getStatus());
                evento.setStatusDesc(lcto.getStatusDesc());
                if (lcto.getDatExecucao() == null) {
                    evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(hoje)));
                } else {
                    evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(lcto.getDatExecucao())));
                }
                if (lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PENDENTE.getCode()) && evento.getPrazo() == 0) {
                    evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o na data atual");
                } else if (!lcto.getStatus().equals(TipoStatusLancamentoObrigacao.ENCERRADO.getCode()) && !lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode())) {
                    if (evento.getPrazo() >= 0) {
                        if (lcto.getStatus().equals(TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o inclu\u00edda em correspond\u00eancia");
                        } else {
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em aberto, pendente");
                        }
                    } else {
                        evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em atraso");
                    }
                } else if (evento.getPrazo() >= 0) {
                    evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada no prazo");
                } else {
                    evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada com atraso");
                }
                if (lcto.getIdCorrespondencia() != null) {
                    evento.setReferencia(lcto.getIdCorrespondencia().toString());
                    evento.setReferenciaDesc(lcto.getCorrespondencia().getAssunto());
                }
                eventos.add(evento);
            }
        }
        return eventos;
    }

    private List<CalendarioEvento> loadEventosRelacoes(Integer idEmpresa, LocalDate dataInicial, LocalDate dataFinal, String entidades) {
        List informacoesDB;
        ArrayList<Integer> empresasInt = new ArrayList<Integer>();
        empresasInt.add(idEmpresa);
        Integer idArea = null;
        Integer status = null;
        Integer idResponsavel = null;
        ArrayList<Integer> entidadesLst = null;
        if (entidades != null && !entidades.isEmpty()) {
            entidadesLst = new ArrayList<Integer>();
            for (String entidade : entidades.split(",")) {
                entidadesLst.add(Integer.valueOf(entidade.trim()));
            }
        }
        ArrayList<CalendarioEvento> eventos = new ArrayList<CalendarioEvento>();
        List reunioesDB = this.relacaoInstitucionalService.findRegistrosReunioes(null, empresasInt, idArea, entidadesLst, status, dataInicial, dataFinal, idResponsavel);
        if (reunioesDB != null) {
            for (RegistroReuniao reuniao : reunioesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(reuniao.getId().getIdRegistro().toString());
                evento.setIdEmpresa(reuniao.getId().getIdEmpresa());
                evento.setTitulo(reuniao.getAssunto());
                evento.setDescricao(reuniao.getObservacao());
                evento.setData(reuniao.getDataInteracao());
                evento.setHoraInicial(reuniao.getInicio());
                evento.setHoraFinal(reuniao.getTermino());
                if (reuniao.getUsuario() != null) {
                    evento.setNome(reuniao.getUsuario().getNome());
                }
                evento.setLocal(reuniao.getLocal());
                evento.setStatus(reuniao.getStatus());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Reuni\u00e3o");
                eventos.add(evento);
            }
        }
        if ((informacoesDB = this.relacaoInstitucionalService.findRegistrosInformacoes(null, empresasInt, idArea, entidadesLst, status, dataInicial, dataFinal, idResponsavel)) != null) {
            for (RegistroInformacao informacao : informacoesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(informacao.getId().toString());
                evento.setIdEmpresa(informacao.getIdEmpresa());
                evento.setNome(informacao.getNomeStakeholder());
                evento.setTitulo(informacao.getAssunto());
                evento.setDescricao(informacao.getObservacao());
                evento.setData(informacao.getDataInformacao());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Informa\u00e7\u00e3o");
                eventos.add(evento);
            }
        }
        return eventos;
    }

    @GetMapping(value={"/{empresa}/diaUtil/{numeroDias}"})
    @Operation(summary="Calcula o dia \u00fatil a partir de uma data refer\u00eancia e quantidade de dias informados. Se a data refer\u00eancia n\u00e3o informada, considera a data atual do sistema.")
    public ResponseEntity<LocalDate> calcularDiaUtil(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="numeroDias") Integer numeroDias) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - Iniciando calcularDiaUtil...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CALENDARIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CALENDARIO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map params = request.getParameterMap();
            LocalDate dataReferencia = null;
            if (params.containsKey("datReferencia")) {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                dataReferencia = LocalDate.parse(((String[])params.get("datReferencia"))[0], fmt);
            }
            LocalDate diaUtil = this.coreService.calcularDiarUtil(empresaDB.getId(), dataReferencia, numeroDias);
            return new ResponseEntity((Object)diaUtil, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.calcularDiaUtil", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/diasUteis/"})
    @Operation(summary="Calcula a quantidade de dias \u00fateis entre 2 datas. A data inicial, se n\u00e3o informada ser\u00e1 a data do sistema. A data final deve ser informada, ")
    public ResponseEntity<Integer> calcularDiasUteis(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - Iniciando calcularDiasUteis...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CALENDARIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CALENDARIO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map params = request.getParameterMap();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            LocalDate dataInicial = null;
            if (params.containsKey("datInicial")) {
                dataInicial = LocalDate.parse(((String[])params.get("datInicial"))[0], fmt);
            }
            LocalDate dataFinal = null;
            if (params.containsKey("datFinal")) {
                dataFinal = LocalDate.parse(((String[])params.get("datFinal"))[0], fmt);
            }
            if (dataFinal == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Par\u00e2metro 'datFinal' n\u00e3o informado ou com formato inv\u00e1lido.");
            }
            int diasUteis = 0;
            if (!dataInicial.equals(dataFinal)) {
                diasUteis = this.coreService.calcularDiasUteis(empresaDB.getId(), dataInicial, dataFinal);
            }
            return new ResponseEntity((Object)diasUteis, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.calcularDiaUtil", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

