/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.correspondencia.Correspondencia;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaAnexo;
import br.com.oti.gesconsys.beans.correspondencia.TipoAnexoCorrespondencia;
import br.com.oti.gesconsys.beans.documentos.AssinaturaDigital;
import br.com.oti.gesconsys.beans.documentos.AssinaturaDigitalItem;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.DocumentoService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.ResponseMessage;
import br.com.oti.gesconsys.rest.beans.CaptchaVO;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import br.com.oti.gesconsys.vos.VerificaAssinaturaVO;
import com.octo.captcha.engine.image.gimpy.DefaultGimpyEngine;
import com.octo.captcha.engine.image.utils.ImageToFile;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.service.CaptchaServiceException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Assinaturas Digitais", name="assinaturas-digitais")
@RequestMapping(value={"/api/assinaturas"})
public class AssinaturasDigitaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AssinaturasDigitaisRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private DocumentoService documentoService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;
    private static DateTimeFormatter tmrFormat = DateTimeFormatter.ofPattern("HHmm");

    @GetMapping(value={"/{empresa}/{uuid}"})
    @Operation(summary="Efetua o download da Minuta de Resposta, para Assinatura Digital")
    @ResponseBody
    public ResponseEntity<Object> downloadMinuta(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="uuid") String uuid) {
        logger.debug("Downloading anexos da Correspond\u00eancia (emp={},uuid={})...", (Object)empresa, (Object)uuid);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        if (uuid == null || uuid.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Identificador do Anexo n\u00e3o informado.");
        }
        try {
            UploadedFileInfo gedFileInfo = this.gedService.getFileInfoByUuid(emp.getId(), uuid, Boolean.valueOf(true));
            if (gedFileInfo == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Anexo n\u00e3o foi encontrado no reposit\u00f3rio.");
            }
            InputStreamResource resource = new InputStreamResource(gedFileInfo.getInputStream());
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", gedFileInfo.getContentType());
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(gedFileInfo.getSize().longValue()).body((Object)resource);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/{idCorrespondencia}"})
    @Operation(summary="Realiza o upload da Minuta de Resposta, Assinada Digitalmente")
    @ResponseBody
    public ResponseEntity<ResponseMessage> uploadMinutaAssinada(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        logger.debug("Upload minuta assinada, da Correspond\u00eancia (emp={},idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi informada.");
        }
        if (idCorrespondencia == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "ID da correspond\u00eancia n\u00e3o informado.");
        }
        try {
            String usuario = request.getParameter("usuario");
            if (usuario == null || usuario.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi informado.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List anexosResp = this.correspondenciaService.findAnexosByTipo(idCorrespondencia, emp.getId(), TipoAnexoCorrespondencia.TIPO_CARTA_RESPOSTA.getCode());
            CorrespondenciaAnexo anexoResp = null;
            for (CorrespondenciaAnexo anexo : anexosResp) {
                if (!anexo.getId().getSequencia().equals(anexo.getCorrespondencia().getSeqAnexoMinuta())) continue;
                anexoResp = anexo;
                break;
            }
            if (anexoResp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Anexo da resposta n\u00e3o foi encontrado, processo cancelado.");
            }
            Correspondencia corresp = anexoResp.getCorrespondencia();
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap files = multipartReq.getMultiFileMap();
            if (files != null && !files.isEmpty()) {
                for (String fileName : files.keySet()) {
                    for (MultipartFile file : (List)files.get((Object)fileName)) {
                        UploadedFileInfo fileInfo = new UploadedFileInfo(file.getName(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
                        if (file.getContentType() == null) {
                            fileInfo.setContentType("application/pdf");
                        }
                        List anexosPdf = this.correspondenciaService.findAnexosByTipo(emp.getId(), idCorrespondencia, TipoAnexoCorrespondencia.TIPO_ASSINATURA_SG1.getCode());
                        CorrespondenciaAnexo anexoPdf = null;
                        if (anexosPdf != null && !anexosPdf.isEmpty()) {
                            anexoPdf = (CorrespondenciaAnexo)anexosPdf.get(0);
                        }
                        if (anexoPdf == null) {
                            anexoPdf = new CorrespondenciaAnexo();
                            anexoPdf.getId().setIdEmpresa(emp.getId());
                            anexoPdf.getId().setIdCorrespondencia(idCorrespondencia);
                            anexoPdf.setTipoAnexo(TipoAnexoCorrespondencia.TIPO_ASSINATURA_SG1.getCode());
                            anexoPdf.setIdUsuarioIns(user.getId());
                        }
                        anexoPdf.setCorrespondencia(anexoResp.getCorrespondencia());
                        anexoPdf.setEmpresa(anexoResp.getEmpresa());
                        this.correspondenciaService.registraUploadAnexo(anexoPdf, fileInfo, corresp.getIdArea(), user.getId());
                        this.correspondenciaService.saveAnexo(anexoPdf, corresp, user.getId());
                    }
                }
            } else {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Upload de documento inv\u00e1lido, verifique os par\u00e2metros encaminhados.");
            }
            return ResponseEntity.ok().body((Object)new ResponseMessage("Upload conclu\u00eddo com sucesso."));
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("ioExc", (Throwable)ioExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @GetMapping(value={"/captcha"})
    @Operation(summary="Gera o captcha, persiste em disco a imagem, e retorna ao usu\u00e1rio o n\u00famero gerado em objeto JSON, com a imagem do Captcha em formato Base64.")
    public ResponseEntity<CaptchaVO> gerarCaptcha(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            try {
                DefaultGimpyEngine bge = new DefaultGimpyEngine();
                ImageCaptchaFactory factory = bge.getImageCaptchaFactory();
                ImageCaptcha pixCaptcha = factory.getImageCaptcha();
                LocalDateTime now = LocalDateTime.now();
                BufferedImage bi = pixCaptcha.getImageChallenge();
                StringBuilder captchaFileName = new StringBuilder();
                captchaFileName.append("captcha-").append(tmrFormat.format(now));
                String captchaId = captchaFileName.toString();
                captchaFileName.append(".txt");
                Files.writeString(Paths.get(System.getProperty("java.io.tmpdir"), captchaFileName.toString()), (CharSequence)pixCaptcha.getTextChallenge(), StandardCharsets.UTF_8, new OpenOption[0]);
                captchaFileName = new StringBuilder();
                captchaFileName.append(System.getProperty("java.io.tmpdir")).append(File.separator);
                captchaFileName.append("captcha-").append(tmrFormat.format(now)).append(".jpg");
                File f = new File(captchaFileName.toString());
                ImageToFile.serialize((BufferedImage)bi, (File)f);
                FileInputStream bais = new FileInputStream(f);
                byte[] captchaBytes = bais.readAllBytes();
                bais.close();
                CaptchaVO captcha = new CaptchaVO();
                captcha.setId(captchaId);
                captcha.setTexto(pixCaptcha.getTextChallenge());
                captcha.setImagemBase64(Base64.toBase64String((byte[])captchaBytes));
                return ResponseEntity.ok().body((Object)captcha);
            }
            catch (IllegalArgumentException argExc) {
                logger.error("ArgExc", (Throwable)argExc);
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Erro inesperado de argumentos/par\u00e2metros.");
            }
            catch (CaptchaServiceException cptExc) {
                logger.error("CaptchaExc", (Throwable)cptExc);
                throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro na gera\u00e7\u00e3o do captcha.");
            }
        }
        catch (IOException ioExc) {
            logger.error("ioExc", (Throwable)ioExc);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro de I/O.");
        }
    }

    @GetMapping(value={"/verificar"})
    @Operation(summary="Verifica captcha, CRC e C\u00f3digo verificador da Assinatura. Retorna informa\u00e7\u00f5es para carregar o documento da assinatura relacionado.")
    public ResponseEntity<VerificaAssinaturaVO> verificarAssinatura(HttpServletRequest request) {
        try {
            Map params = request.getParameterMap();
            String captchaId = null;
            String captchaText = null;
            Integer codigoVerificador = null;
            String codigoCrc = null;
            String origCaptcha = "";
            if (params.containsKey("captchaText")) {
                captchaText = ((String[])params.get("captchaText"))[0];
            }
            if (params.containsKey("captchaText")) {
                captchaId = ((String[])params.get("captchaText"))[0];
            }
            if (params.containsKey("codigoVerificador")) {
                codigoVerificador = Integer.valueOf(((String[])params.get("codigoVerificador"))[0]);
            }
            if (params.containsKey("codigoCrc")) {
                codigoCrc = ((String[])params.get("codigoCrc"))[0];
            }
            if (captchaId == null || captchaId.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Dados do captcha n\u00e3o informados.");
            }
            if (captchaText == null || captchaText.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Texto de valida\u00e7\u00e3o do captcha n\u00e3o informado.");
            }
            if (codigoVerificador == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "C\u00f3digo Verificador n\u00e3o informado.");
            }
            if (codigoCrc == null || codigoCrc.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "C\u00f3digo CRC n\u00e3o informado.");
            }
            try {
                origCaptcha = Files.readString(Paths.get(System.getProperty("java.io.tmpdir"), captchaId + ".txt"), StandardCharsets.UTF_8);
            }
            catch (IOException ioExc) {
                logger.error("ioExc.verificar", (Throwable)ioExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Erro no Captcha, tente novamente.");
            }
            if (origCaptcha == null || !captchaText.equals(origCaptcha)) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Capcha incorreto.");
            }
            AssinaturaDigitalItem assinaturaItem = this.documentoService.getAssinaturaDigitalByCrc(codigoVerificador, codigoCrc);
            if (assinaturaItem != null) {
                AssinaturaDigital assinatura = assinaturaItem.getAssinatura();
                Empresa empresaDB = this.cadastroService.getEmpresaById(assinatura.getIdEmpresa());
                if (empresaDB == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
                }
                CorrespondenciaAnexo anexo = this.correspondenciaService.getAnexoCorrespondenciaByAssinatura(assinatura.getId(), assinatura.getIdEmpresa());
                if (anexo != null) {
                    List itens = this.documentoService.findItensByAssinatura(assinatura.getId());
                    VerificaAssinaturaVO verificaVO = new VerificaAssinaturaVO();
                    verificaVO.setEmpresa(empresaDB.getSigla());
                    verificaVO.setModulo(anexo.getAnexo().getModulo());
                    verificaVO.setItemModulo(anexo.getAnexo().getItemModulo());
                    verificaVO.setNomeArquivo(anexo.getAnexo().getNome());
                    verificaVO.setDescricaoArquivo(anexo.getAnexo().getDescricao());
                    verificaVO.setTipoArquivo(anexo.getAnexo().getTipo());
                    verificaVO.setExtensaoArquivo(anexo.getAnexo().getExtensao());
                    verificaVO.setTamanho(anexo.getAnexo().getTamanho());
                    verificaVO.setUuid(anexo.getAnexo().getUuid());
                    verificaVO.setDatHorAssinatura(((AssinaturaDigitalItem)itens.get(itens.size() - 1)).getDatHorAssinatura());
                    return ResponseEntity.ok().body((Object)verificaVO);
                }
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Documento n\u00e3o foi encontrada para este ID de Assinatura.");
            }
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Assinatura digital n\u00e3o encontrada para este ID e CRC.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.verificar", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (NumberFormatException nmfExc) {
            logger.error("NmfExc.verificar", (Throwable)nmfExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, nmfExc.getMessage());
        }
    }
}

