/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.clients;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@EnableScheduling
@Component
public class SchedulerClientService {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerClientService.class);
    private static final String API_KEY_HEADER = "X-API-KEY";
    private final WebClient webClient;

    public SchedulerClientService(@Value(value="${sigescantt.server.api-url}") String apiUrl, @Value(value="${sigescantt.scheduler.api-key}") String apiKey) throws SSLException {
        LOG.debug("Inicializando SchedulerClientService...");
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = WebClient.builder().baseUrl(apiUrl + "/schedulers").defaultHeader(API_KEY_HEADER, new String[]{apiKey}).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    @Scheduled(cron="0 0/3 * * * *")
    public void processEmails() {
        LOG.debug("executando processEmails...");
        ((WebClient.RequestBodySpec)this.webClient.post().uri("/emails/process", new Object[0])).retrieve().toBodilessEntity().block();
        LOG.debug("processEmails executado...");
    }

    @Scheduled(cron="0 0 0/1 * * *")
    public void syncSirDados() {
        LOG.debug("executando syncSirDados...");
        ((WebClient.RequestBodySpec)this.webClient.post().uri("/sir/sync", new Object[0])).retrieve().toBodilessEntity().block();
        LOG.debug("syncSirDados executado...");
    }
}

