/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.business;

import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.sso.AccessTokenVO;
import br.com.oti.gesconsys.beans.sso.UserAzureVO;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Component
public class SchedulerClientService {
    private Logger logger = LoggerFactory.getLogger(SchedulerClientService.class);
    WebClient webClient;
    private List<RefCode> refCodes;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() throws SSLException {
        this.logger.debug("Inicializando SchedulerClientService...");
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = WebClient.builder().baseUrl(this.env.getProperty("gescon.server.api-url")).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public String refreshToken() {
        Map authData;
        this.logger.debug("executando refreshToken...");
        AuthLogin authPayload = new AuthLogin();
        authPayload.setUserName(this.env.getProperty("gescon.scheduler.user-name"));
        authPayload.setPassword("scheduler.passwd#[NOOP]");
        WebClient.ResponseSpec response = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/auth", new Object[0])).header("X-FROM-MICROSERVICE", new String[]{"SCHEDULER"})).bodyValue((Object)authPayload).retrieve();
        if (response != null && (authData = (Map)response.bodyToMono(Map.class).block()) != null && authData.containsKey("token")) {
            return (String)authData.get("token");
        }
        return null;
    }

    public Mono<Boolean> deleteBloqueiosAntigos(String tokenJwt) {
        this.logger.debug("executando deleteBloqueiosAntigos...");
        LocalDateTime timeSpan = LocalDateTime.now().minusSeconds(90L);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/bloqueios/{untilTime}", new Object[]{timeSpan.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()})).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> deleteEnsaiosVazios(String tokenJwt) {
        this.logger.debug("executando deleteEnsaiosVazios...");
        return this.webClient.delete().uri("/schedulers/ensaiosVazios", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> deleteCachedAnexos(String tokenJwt) {
        this.logger.debug("executando deleteCachedAnexos...");
        return this.webClient.delete().uri("/ged/deleteCachedAnexos", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> sendMails(String tokenJwt) {
        this.logger.debug("executando sendMails...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoCorrespondencia(String tokenJwt) {
        this.logger.debug("executando updatePrazoCorrespondencia...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/correspondencias/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoObrigacao(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando updatePrazoObrigacao...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/obrigacoes/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoRacs(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando updatePrazoRacs...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/racs/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoRenovacaoLicenca(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando updatePrazoRenovacaoLicenca...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/licencas/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> fillGedFiles(String tokenJwt) {
        this.logger.debug("executando fillGedFiles...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/ged/fillFiles", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Integer> fillResumoCorresp(String tokenJwt) {
        this.logger.debug("executando fillResumoCorresp...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/correspondencias/resumos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Integer.class);
    }

    public Mono<Boolean> generateUuid(String tokenJwt) {
        this.logger.debug("executando generateUuid...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/ged/uuid", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> cleanupCachedMail(String tokenJwt) {
        this.logger.debug("executando cleanupCachedMail...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/cached", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> cleanupOpenSessions(String tokenJwt) {
        this.logger.debug("executando cleanupOpenSessions...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/core/sessions", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    private void fillRefCodesGlobals(String tokenJwt) {
        this.refCodes = (List)this.webClient.get().uri("/core/refCodes/globals", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToFlux(RefCode.class).collectList().block(Duration.ofSeconds(10L));
    }

    private String getRefCodeByName(Integer idEmpresa, TipoRefCode tipoRefCode) {
        for (RefCode refCode : this.refCodes) {
            if (idEmpresa == null && refCode.getIdEmpresa() != null || idEmpresa != null && refCode.getIdEmpresa() == null || !refCode.getRefName().equals(tipoRefCode.getRefName())) continue;
            return refCode.getRefValue();
        }
        return null;
    }

    public void updateDadosIbge(String tokenJwt) {
        this.logger.info("[IBGE] Iniciando atualiza\u00e7\u00e3o de dados IBGE...");
        this.fillRefCodesGlobals(tokenJwt);
        String apiPib = this.getRefCodeByName(null, TipoRefCode.IBGE_API_PIB);
        String apiPop = this.getRefCodeByName(null, TipoRefCode.IBGE_API_POPULACAO);
        this.logger.info("[IBGE] Configura\u00e7\u00e3o - API PIB: {}, API Popula\u00e7\u00e3o: {}", (Object)(apiPib != null ? "Configurada" : "N\u00e3o configurada"), (Object)(apiPop != null ? "Configurada" : "N\u00e3o configurada"));
        List cidadesDb = (List)this.webClient.get().uri("/cidades", new Object[0]).header("Authorization", new String[]{"Bearer " + tokenJwt}).retrieve().bodyToFlux(Cidade.class).collectList().block(Duration.ofSeconds(10L));
        if (cidadesDb == null || cidadesDb.isEmpty()) {
            this.logger.warn("[IBGE] Nenhuma cidade encontrada no banco de dados");
            return;
        }
        this.logger.info("[IBGE] Total de cidades encontradas: {}", (Object)cidadesDb.size());
        this.logger.info("[IBGE] Processando cidades existentes...");
        this.processarCidadesExistentes(cidadesDb, tokenJwt);
        this.logger.info("[IBGE] Adicionando novas cidades do IBGE...");
        this.adicionarTodasCidadesBrasileiras(tokenJwt);
        this.logger.info("[IBGE] Processamento conclu\u00eddo com sucesso!");
    }

    private void processarCidadesExistentes(List<Cidade> cidades, String tokenJwt) {
        int completas = 0;
        int processadas = 0;
        for (Cidade cidade : cidades) {
            boolean temPop;
            boolean temIbge = cidade.getCodigoIbge() != null;
            boolean temPib = cidade.getPib() != null && cidade.getPib().compareTo(BigDecimal.ZERO) > 0;
            boolean bl = temPop = cidade.getHabitantes() != null && cidade.getHabitantes() > 0;
            if (temIbge && temPib && temPop) {
                ++completas;
                this.logger.debug("[IBGE] Cidade {} j\u00e1 completa - pulando", (Object)cidade.getDescricao());
                continue;
            }
            this.logger.info("[IBGE] Processando {}: IBGE={}, PIB={}, Popula\u00e7\u00e3o={}", new Object[]{cidade.getDescricao(), temIbge ? cidade.getCodigoIbge() : "null", temPib ? cidade.getPib() : "null", temPop ? cidade.getHabitantes() : "null"});
            if (!temIbge) {
                this.buscarCodigoIbgePorNomeCidade(cidade, this.obterMunicipiosDoEstado(cidade.getUf(), tokenJwt), tokenJwt);
            }
            if (cidade.getCodigoIbge() != null) {
                this.buscarPibPopulacaoParaCidade(cidade, tokenJwt);
            }
            this.persistirCidade(cidade, tokenJwt);
            ++processadas;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.logger.info("[IBGE] Resultado: {} cidades j\u00e1 completas, {} processadas", (Object)completas, (Object)processadas);
    }

    private List<Object> obterMunicipiosDoEstado(String uf, String tokenJwt) {
        String codigoEstado = this.getCodigoEstadoIBGE(uf);
        if (codigoEstado == null) {
            this.logger.warn("[IBGE] C\u00f3digo do estado {} n\u00e3o encontrado", (Object)uf);
            return new ArrayList<Object>();
        }
        String apiUrl = "https://servicodados.ibge.gov.br/api/v1/localidades/estados/" + codigoEstado + "/municipios";
        WebClient wcIbge = WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x100000)).baseUrl(apiUrl).build();
        try {
            List municipios = (List)wcIbge.get().retrieve().bodyToMono(List.class).block(Duration.ofSeconds(15L));
            return municipios != null ? municipios : new ArrayList();
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao buscar munic\u00edpios do estado {}: {}", (Object)uf, (Object)e.getMessage());
            return new ArrayList<Object>();
        }
    }

    private void buscarCodigoIbgePorNomeCidade(Cidade cidade, List<Object> municipios, String tokenJwt) {
        String nomeCidade = this.normalizarNomeCidade(cidade.getDescricao());
        for (Object municipio : municipios) {
            HashMap municipioMap = (HashMap)municipio;
            String nomeMunicipioOriginal = (String)municipioMap.get("nome");
            String nomeMunicipio = this.normalizarNomeCidade(nomeMunicipioOriginal);
            if (!nomeCidade.equals(nomeMunicipio)) continue;
            Object codigoIbge = municipioMap.get("id");
            Integer codigoIbgeInt = null;
            if (codigoIbge instanceof Integer) {
                codigoIbgeInt = (Integer)codigoIbge;
            } else if (codigoIbge instanceof String) {
                codigoIbgeInt = Integer.valueOf((String)codigoIbge);
            }
            if (codigoIbgeInt == null) continue;
            cidade.setCodigoIbge(codigoIbgeInt);
            this.logger.info("[IBGE] C\u00f3digo IBGE encontrado para {}: {}", (Object)cidade.getDescricao(), (Object)codigoIbgeInt);
            this.buscarPibPopulacaoParaCidade(cidade, tokenJwt);
            return;
        }
        this.logger.warn("[IBGE] C\u00f3digo IBGE n\u00e3o encontrado para {} ({})", (Object)cidade.getDescricao(), (Object)cidade.getUf());
    }

    private Integer converterParaInteger(Object codigoIbge) {
        if (codigoIbge instanceof Integer) {
            return (Integer)codigoIbge;
        }
        if (codigoIbge instanceof String) {
            try {
                return Integer.valueOf((String)codigoIbge);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private boolean cidadeExisteNoSistema(List<Cidade> cidadesDb, Integer codigoIbge) {
        return cidadesDb.stream().anyMatch(cid -> cid.getCodigoIbge() != null && cid.getCodigoIbge().equals(codigoIbge));
    }

    private Cidade criarNovaCidade(String nome, String uf, Integer codigoIbge) {
        Cidade novaCidade = new Cidade();
        novaCidade.setDescricao(nome);
        novaCidade.setUf(uf);
        novaCidade.setCodigoIbge(codigoIbge);
        novaCidade.setPib(BigDecimal.ZERO);
        novaCidade.setHabitantes(Integer.valueOf(0));
        novaCidade.setDatHorCadastro(new Date());
        novaCidade.setIdUsuarioIns(Integer.valueOf(1));
        return novaCidade;
    }

    private boolean validarDadosCidade(Cidade cidade) {
        boolean cidadeValida;
        boolean temCodigoIbge = cidade.getCodigoIbge() != null;
        boolean temPibValido = cidade.getPib() != null && cidade.getPib().compareTo(BigDecimal.ZERO) > 0;
        boolean temPopulacaoValida = cidade.getHabitantes() != null && cidade.getHabitantes() > 0;
        this.logger.info("[IBGE] Valida\u00e7\u00e3o para {} (IBGE {}): C\u00f3digo IBGE={}, PIB v\u00e1lido={} (valor={}), Popula\u00e7\u00e3o v\u00e1lida={} (valor={})", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge() != null ? cidade.getCodigoIbge() : "null", temCodigoIbge, temPibValido, cidade.getPib() != null ? cidade.getPib() : "null", temPopulacaoValida, cidade.getHabitantes() != null ? cidade.getHabitantes() : "null"});
        boolean bl = cidadeValida = temCodigoIbge && temPibValido && temPopulacaoValida;
        if (cidadeValida) {
            this.logger.info("[IBGE] Cidade {} (IBGE {}) \u00e9 v\u00e1lida para persist\u00eancia", (Object)cidade.getDescricao(), (Object)cidade.getCodigoIbge());
        } else {
            this.logger.warn("[IBGE] Cidade {} (IBGE {}) N\u00c3O \u00e9 v\u00e1lida para persist\u00eancia - dados incompletos", (Object)cidade.getDescricao(), cidade.getCodigoIbge() != null ? cidade.getCodigoIbge() : "null");
        }
        return cidadeValida;
    }

    private boolean adicionarCidadeNoSistema(Cidade cidade, String tokenJwt) {
        try {
            ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/cidades", new Object[0])).header("Authorization", new String[]{"Bearer " + tokenJwt})).bodyValue((Object)cidade).retrieve().bodyToMono(Cidade.class).block();
            return true;
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao adicionar cidade {} (IBGE {}): {}", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge(), e.getMessage()});
            return false;
        }
    }

    private void adicionarTodasCidadesBrasileiras(String tokenJwt) {
        try {
            List cidadesDb = (List)this.webClient.get().uri("/cidades", new Object[0]).header("Authorization", new String[]{"Bearer " + tokenJwt}).retrieve().bodyToFlux(Cidade.class).collectList().block(Duration.ofSeconds(10L));
            if (cidadesDb == null) {
                this.logger.warn("[IBGE] N\u00e3o foi poss\u00edvel buscar cidades existentes no banco");
                return;
            }
            Map estados = this.obterEstadosBrasileiros();
            int totalNovasCidades = 0;
            for (Map.Entry entry : estados.entrySet()) {
                String uf = (String)entry.getKey();
                String nomeEstado = (String)entry.getValue();
                this.logger.info("[IBGE] Processando estado {} ({}) para adicionar cidades", (Object)nomeEstado, (Object)uf);
                String codigoEstado = this.getCodigoEstadoIBGE(uf);
                if (codigoEstado == null) {
                    this.logger.warn("[IBGE] C\u00f3digo do estado {} n\u00e3o encontrado", (Object)uf);
                    continue;
                }
                int novasCidadesEstado = this.processarEstadoParaAdicionarCidades(uf, codigoEstado, cidadesDb, tokenJwt);
                totalNovasCidades += novasCidadesEstado;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this.logger.info("[IBGE] Processo de adi\u00e7\u00e3o de cidades conclu\u00eddo. Total: {}", (Object)totalNovasCidades);
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao processar adi\u00e7\u00e3o de todas as cidades brasileiras: {}", (Object)e.getMessage());
        }
    }

    private Map<String, String> obterEstadosBrasileiros() {
        HashMap<String, String> estados = new HashMap<String, String>();
        estados.put("AC", "Acre");
        estados.put("AL", "Alagoas");
        estados.put("AP", "Amap\u00e1");
        estados.put("AM", "Amazonas");
        estados.put("BA", "Bahia");
        estados.put("CE", "Cear\u00e1");
        estados.put("DF", "Distrito Federal");
        estados.put("ES", "Esp\u00edrito Santo");
        estados.put("GO", "Goi\u00e1s");
        estados.put("MA", "Maranh\u00e3o");
        estados.put("MT", "Mato Grosso");
        estados.put("MS", "Mato Grosso do Sul");
        estados.put("MG", "Minas Gerais");
        estados.put("PA", "Par\u00e1");
        estados.put("PB", "Para\u00edba");
        estados.put("PR", "Paran\u00e1");
        estados.put("PE", "Pernambuco");
        estados.put("PI", "Piau\u00ed");
        estados.put("RJ", "Rio de Janeiro");
        estados.put("RN", "Rio Grande do Norte");
        estados.put("RS", "Rio Grande do Sul");
        estados.put("RO", "Rond\u00f4nia");
        estados.put("RR", "Roraima");
        estados.put("SC", "Santa Catarina");
        estados.put("SP", "S\u00e3o Paulo");
        estados.put("SE", "Sergipe");
        estados.put("TO", "Tocantins");
        return estados;
    }

    private int processarEstadoParaAdicionarCidades(String uf, String codigoEstado, List<Cidade> cidadesDb, String tokenJwt) {
        String apiUrl = "https://servicodados.ibge.gov.br/api/v1/localidades/estados/" + codigoEstado + "/municipios";
        this.logger.debug("[IBGE] Buscando munic\u00edpios do estado {}: {}", (Object)uf, (Object)apiUrl);
        WebClient wcIbge = WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x100000)).baseUrl(apiUrl).build();
        try {
            List municipios = (List)wcIbge.get().retrieve().bodyToMono(List.class).block(Duration.ofSeconds(15L));
            if (municipios == null) {
                return 0;
            }
            int novasCidadesEstado = 0;
            for (Object municipio : municipios) {
                HashMap municipioMap = (HashMap)municipio;
                String nomeMunicipio = (String)municipioMap.get("nome");
                Object codigoIbge = municipioMap.get("id");
                Integer codigoIbgeInt = this.converterParaInteger(codigoIbge);
                if (codigoIbgeInt == null) {
                    this.logger.warn("[IBGE] C\u00f3digo IBGE inv\u00e1lido para munic\u00edpio {}: {}", (Object)nomeMunicipio, codigoIbge);
                    continue;
                }
                if (this.cidadeExisteNoSistema(cidadesDb, codigoIbgeInt)) continue;
                this.logger.info("[IBGE] Nova cidade encontrada no IBGE: {} (IBGE {}) - UF: {}", new Object[]{nomeMunicipio, codigoIbgeInt, uf});
                Cidade novaCidade = this.criarNovaCidade(nomeMunicipio, uf, codigoIbgeInt);
                this.buscarPibPopulacaoParaCidade(novaCidade, tokenJwt);
                if (this.validarDadosCidade(novaCidade)) {
                    if (this.adicionarCidadeNoSistema(novaCidade, tokenJwt)) {
                        ++novasCidadesEstado;
                        this.logger.info("[IBGE] Cidade {} (IBGE {}) adicionada com sucesso", (Object)nomeMunicipio, (Object)codigoIbgeInt);
                    }
                } else {
                    this.logger.warn("[IBGE] Cidade {} (IBGE {}) n\u00e3o foi adicionada - dados incompletos", (Object)nomeMunicipio, (Object)codigoIbgeInt);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (novasCidadesEstado > 0) {
                this.logger.info("[IBGE] Estado {} ({}) - {} novas cidades adicionadas", new Object[]{uf, uf, novasCidadesEstado});
            }
            return novasCidadesEstado;
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao buscar munic\u00edpios do estado {}: {}", (Object)uf, (Object)e.getMessage());
            return 0;
        }
    }

    private String normalizarNomeCidade(String nome) {
        if (nome == null) {
            return "";
        }
        return nome.toLowerCase().replace("\u00e1", "a").replace("\u00e0", "a").replace("\u00e3", "a").replace("\u00e2", "a").replace("\u00e4", "a").replace("\u00e9", "e").replace("\u00ea", "e").replace("\u00e8", "e").replace("\u00eb", "e").replace("\u00ed", "i").replace("\u00ee", "i").replace("\u00ec", "i").replace("\u00ef", "i").replace("\u00f3", "o").replace("\u00f4", "o").replace("\u00f5", "o").replace("\u00f2", "o").replace("\u00f6", "o").replace("\u00fa", "u").replace("\u00fb", "u").replace("\u00f9", "u").replace("\u00fc", "u").replace("\u00e7", "c").replace("\u00f1", "n").replace("\u00b6", "o").replace("\u00be", "o").replace("\u00da", "u").replace("\u00df", "a").replaceAll("[^a-z0-9]", "").trim();
    }

    private String getCodigoEstadoIBGE(String uf) {
        HashMap<String, String> codigosEstados = new HashMap<String, String>();
        codigosEstados.put("AC", "12");
        codigosEstados.put("AL", "27");
        codigosEstados.put("AP", "16");
        codigosEstados.put("AM", "13");
        codigosEstados.put("BA", "29");
        codigosEstados.put("CE", "23");
        codigosEstados.put("DF", "53");
        codigosEstados.put("ES", "32");
        codigosEstados.put("GO", "52");
        codigosEstados.put("MA", "21");
        codigosEstados.put("MT", "51");
        codigosEstados.put("MS", "50");
        codigosEstados.put("MG", "31");
        codigosEstados.put("PA", "15");
        codigosEstados.put("PB", "25");
        codigosEstados.put("PR", "41");
        codigosEstados.put("PE", "26");
        codigosEstados.put("PI", "22");
        codigosEstados.put("RJ", "33");
        codigosEstados.put("RN", "24");
        codigosEstados.put("RS", "43");
        codigosEstados.put("RO", "11");
        codigosEstados.put("RR", "14");
        codigosEstados.put("SC", "42");
        codigosEstados.put("SP", "35");
        codigosEstados.put("SE", "28");
        codigosEstados.put("TO", "17");
        return (String)codigosEstados.get(uf);
    }

    private void buscarPibPopulacaoParaCidade(Cidade cidade, String tokenJwt) {
        boolean precisaPopulacao;
        if (cidade.getCodigoIbge() == null) {
            this.logger.warn("[IBGE] N\u00e3o \u00e9 poss\u00edvel buscar PIB/popula\u00e7\u00e3o para cidade sem c\u00f3digo IBGE: {}", (Object)cidade.getDescricao());
            return;
        }
        boolean precisaPib = cidade.getPib() == null || cidade.getPib().compareTo(BigDecimal.ZERO) == 0;
        boolean bl = precisaPopulacao = cidade.getHabitantes() == null || cidade.getHabitantes() == 0;
        if (!precisaPib && !precisaPopulacao) {
            this.logger.info("[IBGE] Cidade {} j\u00e1 completa", (Object)cidade.getDescricao());
            return;
        }
        if (precisaPib && this.buscarPibCidade(cidade, tokenJwt)) {
            this.logger.info("[IBGE] PIB encontrado para {}: {}", (Object)cidade.getDescricao(), (Object)cidade.getPib());
        }
        if (precisaPopulacao && this.buscarPopulacaoCidade(cidade, tokenJwt)) {
            this.logger.info("[IBGE] Popula\u00e7\u00e3o encontrada para {}: {}", (Object)cidade.getDescricao(), (Object)cidade.getHabitantes());
        }
    }

    private List<Integer> obterAnosTentativaPIB() {
        ArrayList<Integer> anos = new ArrayList<Integer>();
        String refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_ANO_PIB);
        if (refTxt != null) {
            try {
                anos.add(Integer.valueOf(refTxt));
            }
            catch (NumberFormatException e) {
                this.logger.warn("[IBGE] Ano PIB configurado inv\u00e1lido: {}", (Object)refTxt);
            }
        }
        anos.addAll(Arrays.asList(2025, 2024, 2023, 2022, 2021, 2020, 2019, 2018));
        return anos.stream().distinct().collect(Collectors.toList());
    }

    private List<Integer> obterAnosTentativaPopulacao() {
        ArrayList<Integer> anos = new ArrayList<Integer>();
        String refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_ANO_POPULACAO);
        if (refTxt != null) {
            try {
                anos.add(Integer.valueOf(refTxt));
            }
            catch (NumberFormatException e) {
                this.logger.warn("[IBGE] Ano popula\u00e7\u00e3o configurado inv\u00e1lido: {}", (Object)refTxt);
            }
        }
        anos.addAll(Arrays.asList(2025, 2024, 2023, 2022, 2021, 2020, 2019, 2018));
        return anos.stream().distinct().collect(Collectors.toList());
    }

    private String construirUrlPib(String baseUrl, Integer ano, String codigosIbge) {
        return baseUrl.trim() + "/" + ano + "/variaveis/37?localidades=N6[" + codigosIbge + "]";
    }

    private String construirUrlPopulacao(String baseUrl, Integer ano, String codigosIbge) {
        return baseUrl.trim() + "/" + ano + "/variaveis/9324?localidades=N6[" + codigosIbge + "]";
    }

    private String obterAnoMaisRecente(Map<String, Object> serieAno) {
        String anoMaisRecente = null;
        for (String ano : serieAno.keySet()) {
            if (anoMaisRecente != null && ano.toString().compareTo(anoMaisRecente) <= 0) continue;
            anoMaisRecente = ano.toString();
        }
        return anoMaisRecente;
    }

    private boolean buscarPibCidade(Cidade cidade, String tokenJwt) {
        List anos = this.obterAnosTentativaPIB();
        for (Integer ano : anos) {
            if (!this.buscarPibCidade(cidade, ano, tokenJwt)) continue;
            return true;
        }
        return false;
    }

    private boolean buscarPibCidade(Cidade cidade, Integer ano, String tokenJwt) {
        String refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_API_PIB);
        if (refTxt == null) {
            this.logger.warn("[IBGE] URL da API PIB n\u00e3o configurada no RefCode");
            return false;
        }
        String apiUrl = this.construirUrlPib(refTxt, ano, cidade.getCodigoIbge().toString());
        this.logger.info("[IBGE] Consultando PIB individual: {}", (Object)apiUrl);
        WebClient wcIbge = WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x100000)).baseUrl(apiUrl).build();
        try {
            List apiResponse = (List)wcIbge.get().retrieve().bodyToMono(List.class).block(Duration.ofSeconds(15L));
            return this.processarRespostaPibIndividual(apiResponse, cidade, ano);
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao buscar PIB para {} (IBGE {}) ano {}: {}", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge(), ano, e.getMessage()});
            return false;
        }
    }

    private boolean processarRespostaPibIndividual(List<Object> apiResponse, Cidade cidade, Integer ano) {
        if (apiResponse == null || apiResponse.isEmpty()) {
            return false;
        }
        for (Object item : apiResponse) {
            Object valor;
            Map serie;
            HashMap serieAno;
            String anoMaisRecente;
            Map resultadosMap;
            List series;
            HashMap row = (HashMap)item;
            List resultados = (List)row.get("resultados");
            if (resultados == null || resultados.isEmpty() || (series = (List)(resultadosMap = (Map)resultados.get(0)).get("series")) == null || series.isEmpty() || (anoMaisRecente = this.obterAnoMaisRecente((Map)(serieAno = (HashMap)(serie = (Map)series.get(0)).get("serie")))) == null || (valor = serieAno.get(anoMaisRecente)) == null || valor.toString().isEmpty() || valor.toString().equalsIgnoreCase("...")) continue;
            cidade.setPib(new BigDecimal(valor.toString()));
            this.logger.info("[IBGE] PIB atualizado para {} (IBGE {}): Ano {} = {}", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge(), anoMaisRecente, valor});
            return true;
        }
        return false;
    }

    private boolean buscarPopulacaoCidade(Cidade cidade, String tokenJwt) {
        List anos = this.obterAnosTentativaPopulacao();
        for (Integer ano : anos) {
            if (!this.buscarPopulacaoCidade(cidade, ano, tokenJwt)) continue;
            return true;
        }
        return false;
    }

    private boolean buscarPopulacaoCidade(Cidade cidade, Integer ano, String tokenJwt) {
        String refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_API_POPULACAO);
        if (refTxt == null) {
            this.logger.warn("[IBGE] URL da API Popula\u00e7\u00e3o n\u00e3o configurada no RefCode");
            return false;
        }
        String apiUrl = this.construirUrlPopulacao(refTxt, ano, cidade.getCodigoIbge().toString());
        this.logger.info("[IBGE] Consultando popula\u00e7\u00e3o individual: {}", (Object)apiUrl);
        WebClient wcIbge = WebClient.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x100000)).baseUrl(apiUrl).build();
        try {
            List apiResponse = (List)wcIbge.get().retrieve().bodyToMono(List.class).block(Duration.ofSeconds(15L));
            return this.processarRespostaPopulacaoIndividual(apiResponse, cidade, ano);
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao buscar popula\u00e7\u00e3o para {} (IBGE {}) ano {}: {}", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge(), ano, e.getMessage()});
            return false;
        }
    }

    private boolean processarRespostaPopulacaoIndividual(List<Object> apiResponse, Cidade cidade, Integer ano) {
        if (apiResponse == null || apiResponse.isEmpty()) {
            return false;
        }
        for (Object item : apiResponse) {
            Object valor;
            Map serie;
            HashMap serieAno;
            String anoMaisRecente;
            Map resultadosMap;
            List series;
            HashMap row = (HashMap)item;
            List resultados = (List)row.get("resultados");
            if (resultados == null || resultados.isEmpty() || (series = (List)(resultadosMap = (Map)resultados.get(0)).get("series")) == null || series.isEmpty() || (anoMaisRecente = this.obterAnoMaisRecente((Map)(serieAno = (HashMap)(serie = (Map)series.get(0)).get("serie")))) == null || (valor = serieAno.get(anoMaisRecente)) == null || valor.toString().isEmpty() || valor.toString().equalsIgnoreCase("...")) continue;
            cidade.setHabitantes(Integer.valueOf(valor.toString()));
            this.logger.info("[IBGE] Popula\u00e7\u00e3o atualizada para {} (IBGE {}): Ano {} = {}", new Object[]{cidade.getDescricao(), cidade.getCodigoIbge(), anoMaisRecente, valor});
            return true;
        }
        return false;
    }

    private void persistirCidade(Cidade cidade, String tokenJwt) {
        try {
            Cidade cidadeRetornada = (Cidade)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/cidades", new Object[0])).header("Authorization", new String[]{"Bearer " + tokenJwt})).bodyValue((Object)cidade).retrieve().bodyToMono(Cidade.class).block();
            if (cidadeRetornada != null) {
                if (cidade.getId() == null) {
                    cidade.setId(cidadeRetornada.getId());
                }
                String operacao = cidade.getId() != null ? "Atualizada" : "Criada";
                this.logger.info("[IBGE] Cidade {} com sucesso: {} (ID: {}, IBGE: {}) - PIB: {}, Popula\u00e7\u00e3o: {}", new Object[]{operacao, cidade.getDescricao(), cidade.getId(), cidade.getCodigoIbge(), cidade.getPib() != null ? cidade.getPib() : "null", cidade.getHabitantes() != null ? cidade.getHabitantes() : "null"});
            } else {
                this.logger.error("[IBGE] Resposta nula ao salvar cidade: {}", (Object)cidade.getDescricao());
            }
        }
        catch (Exception e) {
            this.logger.error("[IBGE] Erro ao persistir cidade {} (ID: {}, IBGE: {}): {}", new Object[]{cidade.getDescricao(), cidade.getId(), cidade.getCodigoIbge(), e.getMessage()});
        }
    }

    public Mono<Boolean> executeDailyMailCorresp(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/corresp", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeDailyMailLicencas(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/licencas", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeDailyMailObrigacoes(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/obrigacoes", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeDailyRegistroUsuarioEquipe(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/usuarios/equipes/registros", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeMonthlyMailObrigacoes(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/monthly/obrigacoes", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public void updateIndicadoresRodovias(String tokenJwt) {
        String[] datas;
        LocalDate sysDate = LocalDate.now();
        LocalDate datIni = sysDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate datFim = datIni.with(TemporalAdjusters.lastDayOfMonth());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
        String ultimaIntegracao = this.getRefCodeByName(null, TipoRefCode.SISDEMANDA_ULT_INTEGRACAO_API_OPERACAO);
        if (ultimaIntegracao != null && !ultimaIntegracao.isEmpty() && (datas = ultimaIntegracao.split(":")) != null & datas.length == 2) {
            LocalDate datIniDB = LocalDate.parse(datas[0].toString(), formatter);
            LocalDate datFimDB = LocalDate.parse(datas[1].toString(), formatter);
            if (datIniDB.getMonthValue() >= sysDate.getMonthValue() - 1 && datFimDB.getMonthValue() >= sysDate.getMonthValue() - 1) {
                this.logger.debug("Meses j\u00e1 integrados previamente '{}', desnecess\u00e1rio atualiza\u00e7\u00e3o.", (Object)ultimaIntegracao);
                return;
            }
        }
        ArrayList indicadores = new ArrayList();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String apiIntegracao = this.getRefCodeByName(null, TipoRefCode.SISDEMANDA_URL_API_OPERACAO);
        if (apiIntegracao == null || apiIntegracao.isEmpty()) {
            return;
        }
        String datIniTxt = datIni.format(formatter);
        String datFimTxt = datFim.format(formatter);
        StringBuilder urlIntegracao = new StringBuilder();
        urlIntegracao.append(apiIntegracao).append("/Acidente/Consultar?");
        urlIntegracao.append("dt_inicio=").append(datIniTxt).append("&");
        urlIntegracao.append("dt_fim=").append(datFimTxt);
        this.logger.debug("Integrando API SisDemanda (Acidentes)={}", (Object)urlIntegracao.toString());
        WebClient wcDemanda = WebClient.builder().baseUrl(urlIntegracao.toString()).build();
        Map rawData = (Map)wcDemanda.get().header("Content-Type", new String[]{"application/json"}).retrieve().bodyToFlux(String.class).collectMap(item -> item.split(",")[0], item -> item.split(",")[1]).block(Duration.ofSeconds(15L));
        this.logger.debug("rawData==> {}", (Object)rawData);
    }

    public void updateUsuariosInativosSSO(String tokenJwt) throws Exception {
        this.fillRefCodesGlobals(tokenJwt);
        String clientId = null;
        String clientSecret = null;
        String tenantId = null;
        clientId = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_CLIENT_ID);
        clientSecret = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_CLIENT_SECRET);
        tenantId = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_TENANT_ID);
        if (clientId == null || clientSecret == null || tenantId == null) {
            this.logger.debug("ClientId, ClientSecret ou TenantId == NULL, atualiza\u00e7\u00e3o cancelada.");
            return;
        }
        StringBuilder tokenUrl = new StringBuilder();
        tokenUrl.append("https://login.microsoftonline.com/");
        tokenUrl.append(tenantId);
        tokenUrl.append("/oauth2/v2.0/token");
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)clientId);
        map.add((Object)"scope", (Object)"https://graph.microsoft.com/.default");
        map.add((Object)"client_secret", (Object)clientSecret);
        map.add((Object)"grant_type", (Object)"client_credentials");
        WebClient httpClient = WebClient.builder().baseUrl(tokenUrl.toString()).build();
        AccessTokenVO accessToken = (AccessTokenVO)((WebClient.RequestBodySpec)httpClient.post().header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)map)).retrieve().bodyToMono(AccessTokenVO.class).block(Duration.ofSeconds(10L));
        if (accessToken == null || accessToken.getAccessToken() == null || accessToken.getAccessToken().isEmpty()) {
            throw new Exception("Access Token n\u00e3o concedido, verifique.");
        }
        StringBuilder userUrl = new StringBuilder();
        userUrl.append("https://graph.microsoft.com/v1.0/users");
        userUrl.append("?$select=id,displayName,givenname,mail,emailaddress,accountEnabled");
        WebClient userClient = WebClient.builder().baseUrl(userUrl.toString()).build();
        List response = (List)userClient.get().headers(h -> h.setBearerAuth(accessToken.getAccessToken())).retrieve().bodyToFlux(Map.class).collectList().block(Duration.ofSeconds(15L));
        List usuarios = (List)((Map)response.get(0)).get("value");
        ArrayList<UserAzureVO> usersAzure = new ArrayList<UserAzureVO>();
        this.logger.debug("usuarios.size({})...", (Object)usuarios.size());
        for (Map user : usuarios) {
            this.logger.debug("users=> {}", (Object)user);
            UserAzureVO azureUser = new UserAzureVO();
            azureUser.setId((String)user.get("id"));
            azureUser.setDisplayName((String)user.get("givenname"));
            azureUser.setUserPrincipalName((String)user.get("name"));
            azureUser.setMail((String)user.get("emailaddress"));
            azureUser.setAccountEnabled((Boolean)user.get("accountEnabled"));
            usersAzure.add(azureUser);
        }
        String processed = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri("/usuarios/informacoesSSO", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).bodyValue(usersAzure).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(15L));
        if (processed != null) {
            this.logger.debug("Usu\u00e1rios atualizados na Plataforma.");
        }
    }

    public Mono<String> checkDocusignStatus(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando checkDocusignStatus...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/docusign/status", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(String.class);
    }

    public Mono<String> checkDocusignDocumentTask(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando checkDocusignDocumentTask...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/docusign/docs", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(String.class);
    }
}

