/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.business;

import br.com.oti.gesconsys.beans.core.RefCode;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.UnidadeFederacao;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.sso.AccessTokenVO;
import br.com.oti.gesconsys.beans.sso.UserAzureVO;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@Component
public class SchedulerClientService {
    private Logger logger = LoggerFactory.getLogger(SchedulerClientService.class);
    WebClient webClient;
    private List<RefCode> refCodes;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() throws SSLException {
        this.logger.debug("Inicializando SchedulerClientService...");
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = HttpClient.create().secure(t -> t.sslContext(sslContext));
        this.webClient = WebClient.builder().baseUrl(this.env.getProperty("gescon.server.api-url")).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public String refreshToken() {
        Map authData;
        this.logger.debug("executando refreshToken...");
        AuthLogin authPayload = new AuthLogin();
        authPayload.setUserName(this.env.getProperty("gescon.scheduler.user-name"));
        authPayload.setPassword("scheduler.passwd#[NOOP]");
        WebClient.ResponseSpec response = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/auth", new Object[0])).header("X-FROM-MICROSERVICE", new String[]{"SCHEDULER"})).bodyValue((Object)authPayload).retrieve();
        if (response != null && (authData = (Map)response.bodyToMono(Map.class).block()) != null && authData.containsKey("token")) {
            return (String)authData.get("token");
        }
        return null;
    }

    public Mono<Boolean> deleteBloqueiosAntigos(String tokenJwt) {
        this.logger.debug("executando deleteBloqueiosAntigos...");
        LocalDateTime timeSpan = LocalDateTime.now().minusSeconds(90L);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/bloqueios/{untilTime}", new Object[]{timeSpan.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()})).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> deleteEnsaiosVazios(String tokenJwt) {
        this.logger.debug("executando deleteEnsaiosVazios...");
        return this.webClient.delete().uri("/schedulers/ensaiosVazios", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> deleteCachedAnexos(String tokenJwt) {
        this.logger.debug("executando deleteCachedAnexos...");
        return this.webClient.delete().uri("/ged/deleteCachedAnexos", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> sendMails(String tokenJwt) {
        this.logger.debug("executando sendMails...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoCorrespondencia(String tokenJwt) {
        this.logger.debug("executando updatePrazoCorrespondencia...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/correspondencias/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoObrigacao(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando updatePrazoObrigacao...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/obrigacoes/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> updatePrazoRacs(String tokenJwt) throws SchedulerException {
        this.logger.debug("executando updatePrazoRacs...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/racs/prazos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> fillGedFiles(String tokenJwt) {
        this.logger.debug("executando fillGedFiles...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/ged/fillFiles", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Integer> fillResumoCorresp(String tokenJwt) {
        this.logger.debug("executando fillResumoCorresp...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/correspondencias/resumos", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Integer.class);
    }

    public Mono<Boolean> generateUuid(String tokenJwt) {
        this.logger.debug("executando generateUuid...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/ged/uuid", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> cleanupCachedMail(String tokenJwt) {
        this.logger.debug("executando cleanupCachedMail...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/cached", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> cleanupOpenSessions(String tokenJwt) {
        this.logger.debug("executando cleanupOpenSessions...");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/core/sessions", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    private void fillRefCodes(String tokenJwt) {
        this.refCodes = (List)this.webClient.get().uri("/core/refCodes", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToFlux(RefCode.class).collectList().block(Duration.ofSeconds(10L));
    }

    private void fillRefCodesGlobals(String tokenJwt) {
        this.refCodes = (List)this.webClient.get().uri("/core/refCodes/globals", new Object[0]).headers(h -> h.setBearerAuth(tokenJwt)).retrieve().bodyToFlux(RefCode.class).collectList().block(Duration.ofSeconds(10L));
    }

    private String getRefCodeByName(Integer idEmpresa, TipoRefCode tipoRefCode) {
        for (RefCode refCode : this.refCodes) {
            if (idEmpresa == null && refCode.getIdEmpresa() != null || idEmpresa != null && refCode.getIdEmpresa() == null || !refCode.getRefName().equals(tipoRefCode.getRefName())) continue;
            return refCode.getRefValue();
        }
        return null;
    }

    public void updateDadosIbge(String tokenJwt) {
        List cidades = (List)this.webClient.get().uri("/cidades/pib", new Object[0]).header("Authorization", new String[]{"Bearer " + tokenJwt}).retrieve().bodyToFlux(Cidade.class).collectList().block(Duration.ofSeconds(10L));
        ArrayList<Cidade> cidadesUpdate = new ArrayList<Cidade>();
        if (cidades != null && !cidades.isEmpty()) {
            Cidade cid;
            HashMap serieAno;
            HashMap localidade;
            Map serie;
            Iterator iterator;
            List series;
            Map resultadosMap;
            List resultados;
            HashMap row;
            List apiResponse;
            WebClient wcIbge;
            ArrayList<String> ufLst = new ArrayList<String>();
            for (Cidade cidade : cidades) {
                if (cidade.getCodigoIbge() != null || ufLst.contains(cidade.getUf())) continue;
                ufLst.add(cidade.getUf());
            }
            if (ufLst.size() > 0) {
                for (String ufTxt : ufLst) {
                    UnidadeFederacao infoUf = UnidadeFederacao.valueOf((String)ufTxt);
                    if (infoUf == null) continue;
                    StringBuilder apiMunic = new StringBuilder("https://servicodados.ibge.gov.br/api/v1/localidades/estados");
                    apiMunic.append("/").append(infoUf.getCodigoIbge());
                    apiMunic.append("/municipios");
                    WebClient wcIbge2 = WebClient.builder().baseUrl(apiMunic.toString()).build();
                    List response = (List)wcIbge2.get().retrieve().bodyToFlux(List.class).collectList().block();
                    block2: for (List item : response) {
                        HashMap row2 = (HashMap)((Object)item);
                        for (Cidade cidade : cidades) {
                            if (!cidade.getUf().equals(ufTxt) || cidade.getCodigoIbge() != null || !row2.get("nome").toString().equalsIgnoreCase(cidade.getDescricao().trim())) continue;
                            cidade.setCodigoIbge(Integer.valueOf(row2.get("id").toString()));
                            cidadesUpdate.add(cidade);
                            continue block2;
                        }
                    }
                }
            }
            ((WebClient.RequestBodySpec)this.webClient.post().uri("/cidades", new Object[0])).bodyValue(cidadesUpdate).retrieve();
            this.fillRefCodes(tokenJwt);
            int idx = 0;
            StringBuilder cidadesTxt = new StringBuilder();
            HashMap<String, Cidade> cidadesMap = new HashMap<String, Cidade>();
            for (Cidade cidade : cidades) {
                if (cidade.getCodigoIbge() == null) continue;
                if (cidadesTxt.length() > 0) {
                    cidadesTxt.append(",");
                }
                cidadesTxt.append(cidade.getCodigoIbge());
                cidadesMap.put(cidade.getCodigoIbge().toString(), cidade);
                if (idx++ <= 10) continue;
                break;
            }
            String refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_ANO_PIB);
            Integer anoPIB = null;
            Integer anoPopulacao = null;
            StringBuilder apiPIB = null;
            StringBuilder apiPopulacao = null;
            if (refTxt != null) {
                anoPIB = Integer.valueOf(refTxt);
            }
            if ((refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_ANO_POPULACAO)) != null) {
                anoPopulacao = Integer.valueOf(refTxt);
            }
            if ((refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_API_PIB)) != null && cidadesTxt.length() > 0) {
                apiPIB = new StringBuilder(refTxt.trim());
                apiPIB.append("/periodos/").append(anoPIB);
                apiPIB.append("/variaveis/").append("37");
                apiPIB.append("?localidades=N6[").append((CharSequence)cidadesTxt);
                apiPIB.append("]");
                this.logger.debug("Executando API IBGE [pib] ={}", (Object)apiPIB);
                wcIbge = WebClient.builder().baseUrl(apiPIB.toString()).build();
                apiResponse = (List)wcIbge.get().retrieve().bodyToFlux(List.class).collectList().block(Duration.ofSeconds(15L));
                for (List item : apiResponse) {
                    row = (HashMap)((Object)item);
                    resultados = (List)row.get("resultados");
                    resultadosMap = (Map)resultados.get(0);
                    series = (List)resultadosMap.get("series");
                    if (series == null) continue;
                    iterator = series.iterator();
                    while (iterator.hasNext()) {
                        Map seriePIB = serie = (Map)iterator.next();
                        localidade = (HashMap)seriePIB.get("localidade");
                        serieAno = (HashMap)seriePIB.get("serie");
                        cid = (Cidade)cidadesMap.get(localidade.get("id"));
                        if (cid == null) continue;
                        cid.setPib(new BigDecimal(serieAno.get(anoPIB.toString()).toString()));
                    }
                }
            }
            if ((refTxt = this.getRefCodeByName(null, TipoRefCode.IBGE_API_POPULACAO)) != null && cidadesTxt.length() > 0) {
                apiPopulacao = new StringBuilder(refTxt.trim());
                apiPopulacao.append("/periodos/").append(anoPopulacao);
                apiPopulacao.append("/variaveis/").append("9324");
                apiPopulacao.append("?localidades=N6[").append((CharSequence)cidadesTxt);
                apiPopulacao.append("]");
                this.logger.debug("Executando API IBGE [populacao] ={}", (Object)apiPopulacao);
                wcIbge = WebClient.builder().baseUrl(apiPopulacao.toString()).build();
                apiResponse = (List)wcIbge.get().retrieve().bodyToFlux(List.class).collectList().block(Duration.ofSeconds(15L));
                for (List item : apiResponse) {
                    row = (HashMap)((Object)item);
                    resultados = (List)row.get("resultados");
                    resultadosMap = (Map)resultados.get(0);
                    series = (List)resultadosMap.get("series");
                    if (series == null) continue;
                    iterator = series.iterator();
                    while (iterator.hasNext()) {
                        Map seriePop = serie = (Map)iterator.next();
                        localidade = (HashMap)seriePop.get("localidade");
                        serieAno = (HashMap)seriePop.get("serie");
                        cid = (Cidade)cidadesMap.get(localidade.get("id"));
                        if (cid == null) continue;
                        cid.setHabitantes(Integer.valueOf(serieAno.get(anoPopulacao.toString()).toString()));
                    }
                }
            }
            if (cidadesMap.size() > 0) {
                ((WebClient.RequestBodySpec)this.webClient.post().uri("/cidades", new Object[0])).bodyValue(cidadesMap.values()).retrieve();
            }
        }
    }

    public Mono<Boolean> executeDailyMailCorresp(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/corresp", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeDailyMailObrigacoes(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/daily/obrigacoes", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public Mono<Boolean> executeMonthlyMailObrigacoes(String tokenJwt) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/schedulers/mails/monthly/obrigacoes", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).retrieve().bodyToMono(Boolean.class);
    }

    public void updateIndicadoresRodovias(String tokenJwt) {
        String[] datas;
        LocalDate sysDate = LocalDate.now();
        LocalDate datIni = sysDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate datFim = datIni.with(TemporalAdjusters.lastDayOfMonth());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
        String ultimaIntegracao = this.getRefCodeByName(null, TipoRefCode.SISDEMANDA_ULT_INTEGRACAO_API_OPERACAO);
        if (ultimaIntegracao != null && !ultimaIntegracao.isEmpty() && (datas = ultimaIntegracao.split(":")) != null & datas.length == 2) {
            LocalDate datIniDB = LocalDate.parse(datas[0].toString(), formatter);
            LocalDate datFimDB = LocalDate.parse(datas[1].toString(), formatter);
            if (datIniDB.getMonthValue() >= sysDate.getMonthValue() - 1 && datFimDB.getMonthValue() >= sysDate.getMonthValue() - 1) {
                this.logger.debug("Meses j\u00e1 integrados previamente '{}', desnecess\u00e1rio atualiza\u00e7\u00e3o.", (Object)ultimaIntegracao);
                return;
            }
        }
        ArrayList indicadores = new ArrayList();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String apiIntegracao = this.getRefCodeByName(null, TipoRefCode.SISDEMANDA_URL_API_OPERACAO);
        if (apiIntegracao == null || apiIntegracao.isEmpty()) {
            return;
        }
        String datIniTxt = datIni.format(formatter);
        String datFimTxt = datFim.format(formatter);
        StringBuilder urlIntegracao = new StringBuilder();
        urlIntegracao.append(apiIntegracao).append("/Acidente/Consultar?");
        urlIntegracao.append("dt_inicio=").append(datIniTxt).append("&");
        urlIntegracao.append("dt_fim=").append(datFimTxt);
        this.logger.debug("Integrando API SisDemanda (Acidentes)={}", (Object)urlIntegracao.toString());
        WebClient wcDemanda = WebClient.builder().baseUrl(urlIntegracao.toString()).build();
        Map rawData = (Map)wcDemanda.get().header("Content-Type", new String[]{"application/json"}).retrieve().bodyToFlux(String.class).collectMap(item -> item.split(",")[0], item -> item.split(",")[1]).block(Duration.ofSeconds(15L));
        this.logger.debug("rawData==> {}", (Object)rawData);
    }

    public void updateUsuariosInativosSSO(String tokenJwt) throws Exception {
        this.fillRefCodesGlobals(tokenJwt);
        String clientId = null;
        String clientSecret = null;
        String tenantId = null;
        clientId = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_CLIENT_ID);
        clientSecret = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_CLIENT_SECRET);
        tenantId = this.getRefCodeByName(null, TipoRefCode.INFRA_SSO_TENANT_ID);
        if (clientId == null || clientSecret == null || tenantId == null) {
            this.logger.debug("ClientId, ClientSecret ou TenantId == NULL, atualiza\u00e7\u00e3o cancelada.");
            return;
        }
        StringBuilder tokenUrl = new StringBuilder();
        tokenUrl.append("https://login.microsoftonline.com/");
        tokenUrl.append(tenantId);
        tokenUrl.append("/oauth2/v2.0/token");
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)clientId);
        map.add((Object)"scope", (Object)"https://graph.microsoft.com/.default");
        map.add((Object)"client_secret", (Object)clientSecret);
        map.add((Object)"grant_type", (Object)"client_credentials");
        WebClient httpClient = WebClient.builder().baseUrl(tokenUrl.toString()).build();
        AccessTokenVO accessToken = (AccessTokenVO)((WebClient.RequestBodySpec)httpClient.post().header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)map)).retrieve().bodyToMono(AccessTokenVO.class).block(Duration.ofSeconds(10L));
        if (accessToken == null || accessToken.getAccessToken() == null || accessToken.getAccessToken().isEmpty()) {
            throw new Exception("Access Token n\u00e3o concedido, verifique.");
        }
        StringBuilder userUrl = new StringBuilder();
        userUrl.append("https://graph.microsoft.com/v1.0/users");
        userUrl.append("?$select=id,displayName,userPrincipalName,mail,accountEnabled");
        WebClient userClient = WebClient.builder().baseUrl(userUrl.toString()).build();
        List response = (List)userClient.get().headers(h -> h.setBearerAuth(accessToken.getAccessToken())).retrieve().bodyToFlux(Map.class).collectList().block(Duration.ofSeconds(15L));
        List usuarios = (List)((Map)response.get(0)).get("value");
        ArrayList<UserAzureVO> usersAzure = new ArrayList<UserAzureVO>();
        this.logger.debug("usuarios.size({})...", (Object)usuarios.size());
        for (Map user : usuarios) {
            UserAzureVO azureUser = new UserAzureVO();
            azureUser.setId((String)user.get("id"));
            azureUser.setDisplayName((String)user.get("displayName"));
            azureUser.setUserPrincipalName((String)user.get("userPrincipalName"));
            azureUser.setMail((String)user.get("mail"));
            azureUser.setAccountEnabled((Boolean)user.get("accountEnabled"));
            usersAzure.add(azureUser);
        }
        String processed = (String)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri("/usuarios/informacoesSSO", new Object[0])).headers(h -> h.setBearerAuth(tokenJwt))).bodyValue(usersAzure).retrieve().bodyToMono(String.class).block(Duration.ofSeconds(15L));
        if (processed != null) {
            this.logger.debug("Usu\u00e1rios atualizados na Plataforma.");
        }
    }
}

